<?

class State {

	/* key is,
		o : ordered
		r : reverse ordered
		c : created time order.
	*/

	var $sort_key_checker = array("o" => "r", "r" => "c", "c" => "o");

	var $SQL_UPDATE_SORT_STATE =
			"update user_priv set save_sort = '%s' where id = '%s'";

	function save_state () {
		$sort = $this->save_sort();
		$sort_key = $this->save_sort_key();

		$data_sort = "";
		$data_sort_key = "";

		if ($sort and count($sort) > 0) $data_sort = implode(";", $sort);
		if ($sort_key and count($sort_key) > 0) $data_sort_key = implode(";", $sort_key);

		if (count($sort) > 0 or count($sort_key) > 0) {
			$DB = new MySQLdb;

			$data = sprintf("%s;%s", $data_sort, $data_sort_key);

			$DB->query(sprintf($this->SQL_UPDATE_SORT_STATE,
				$data, $_SESSION["config_id"]));
		}
	}

	function save_sort () {

		if (array_key_exists("user_card_group_sort_state", $_SESSION)) {
			$s = $_SESSION["user_card_group_sort_state"];
			while (list($i, $j) = each($s)) {
				if (! $j) continue;
				$b["card_group"][] = sprintf("%s:%s", $i, $j);
			}
		}

		if (array_key_exists("user_sort_state", $_SESSION)) {
			$s = $_SESSION["user_sort_state"];
			while (list($i, $j) = each($s)) {
				if (! $j) continue;
				$b["item"][] = sprintf("%s:%s", $i, $j);
			}
		}

		while (list($i, $j) = each($b)) {
			$a[] = sprintf("%s|%s", $i, implode(",", $j));
		}

		return $a;
	}

	function save_sort_key () {
		if (array_key_exists("user_card_group_sort_state_key", $_SESSION)) {
			$s = $_SESSION["user_card_group_sort_state_key"];
			while (list($i, $j) = each($s)) {
				if (! $j) continue;
				$b["card_group_key"][] = sprintf("%s:%s", $i, $j);
			}
		}

		if (array_key_exists("user_sort_state_key", $_SESSION)) {
			$s = $_SESSION["user_sort_state_key"];
			while (list($i, $j) = each($s)) {
				if (! $j) continue;
				$b["item_key"][] = sprintf("%s:%s", $i, $j);
			}
		}

		if (count($b) < 1) {
			$retval = false;
		} else {
			while (list($i, $j) = each($b)) {
				$a[] = sprintf("%s|%s", $i, implode(",", $j));
			}
			$retval = $a;
		}

		return $retval;
	}

	function parse_save_sort () {
		$a = explode(";", $_SESSION["config_save_sort"]);

		if (count($a) < 1) {
			$retval = false;
		} else {
			while (list($i, $j) = each($a)) {
				$b = explode("|", $j);
				if (count($b) < 2) continue;

				$c[$b[0]] = $b[1];
			}

			$retval = $c;
		}

		return $retval;
	}

	function assign_saved_sort () {
		// sort method: title, author, createdTime
		// assign rule: $_SESSION[directory number] = sort method.

		// save_sort field handles 2 category, item & card.

		$p = $this->parse_save_sort();

		if (array_key_exists("item", $p)) {
			$a = explode(",", $p["item"]);
			$b = count($a);

			if ($b > 0) {
				// remove old setting.
				unset($_SESSION["user_sort_state"]);

				for ($i = 0; $i < $b; $i++) {
					$c = explode(":",$a[$i]);

					if ($c[1] == "title") continue;
					$_SESSION["user_sort_state"][$c[0]] = $c[1];
				}
			}
		}

		if (array_key_exists("card_group", $p)) {
			$a = explode(",", $p["card_group"]);
			$b = count($a);

			if ($b > 0) {
				// remove old setting.
				unset($_SESSION["user_card_group_sort_state"]);

				for ($i = 0; $i < $b; $i++) {
					$c = explode(":",$a[$i]);

					if ($c[1] == "title") continue;
					$_SESSION["user_card_group_sort_state"][$c[0]] = $c[1];
				}
			}
		}

	}

	function assign_sort_of_card_group ($no, $state) {
		// assign sort state info and store it.

		if (array_key_exists($no, $_SESSION["user_card_group_sort_state"])) {

			// check whether sort state is changed or not.
			if ($_SESSION["user_card_group_sort_state"][$no] != $state) {
				$_SESSION["user_card_group_sort_state"][$no] = $state;
			}
		} else {
			$_SESSION["user_card_group_sort_state"][$no] = $state;
		}

		$this->toggle_sort_key_of_card_group($no);

		$this->save_state();
	}

	function assign_sort_of_item ($no, $state) {
		// assign sort state info and store it.

		if (array_key_exists($no, $_SESSION["user_sort_state"])) {

			// check whether sort state is changed or not.
			if ($_SESSION["user_sort_state"][$no] != $state) {
				$_SESSION["user_sort_state"][$no] = $state;
			}
		} else {
			$_SESSION["user_sort_state"][$no] = $state;

		}

		$this->toggle_sort_key_of_item($no);

		$this->save_state();
	}

	function toggle_sort_key_of_item ($no) {
		if (array_key_exists("user_sort_state_key", $_SESSION)) {
			if (! array_key_exists($no, $_SESSION["user_sort_state_key"])) {
				$_SESSION["user_sort_state_key"][$no] = "o";
			} else {
				$_SESSION["user_sort_state_key"][$no] =
					$this->sort_key_checker[$_SESSION["user_sort_state_key"][$no]];
			}
		} else {
			$_SESSION["user_sort_state_key"][$no] = "o";
		}
	}

	function toggle_sort_key_of_card_group ($no) {

		if (array_key_exists("user_card_group_sort_state_key", $_SESSION)) {
			if (! array_key_exists($no, $_SESSION["user_card_group_sort_state_key"])) {
				$_SESSION["user_card_group_sort_state_key"][$no] = "o";
			} else {
				$_SESSION["user_card_group_sort_state_key"][$no] =
					$this->sort_key_checker[$_SESSION["user_card_group_sort_state_key"][$no]];
			}
		} else {
			$_SESSION["user_card_group_sort_state_key"][$no] = "o";
		}
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
