<?
include_once $global["root"] . "/lib/Module.php";
include_once $global["root"] . "/lib/Directory.php";

class Item {

	var $no;
	var $item_num;
	var $item_type;

	var $DB;
	var $Module;

	//--------------------------------------------------------------------------------
	// SQL
	var $SQL_GET_ITEM_INFO =
		"select SQL_CACHE item_num, item_type from item_%s where no = '%s'";

	var $SQL_INSERT_ITEM =
		"insert into item_%s (item_num,item_type, directory_num)
			values ('%s','%s','%s')";
	var $SQL_UPDATE_ITEM = "update item_%s set %s where no = '%s'";
	var $SQL_DELETE_ITEM = "delete from item_%s where no = '%s'";
	var $SQL_GET_ITEM_TYPE = "select SQL_CACHE * from item_type_%s";
	var $SQL_GET_NO =
		"select SQL_CACHE no from item_%s where item_num = '%s' and item_type = '%s'";

	var $SQL_GET_TRASH_ITEM =
		"select SQL_CACHE no,item_type,item_num from item_%s
			where directory_num = '%s' %s";

	//--------------------------------------------------------------------------------
	function Item ($no="", $item_num="", $item_type="") {

		if ($no and $item_num and $item_type) {
			$this->set($no, $item_num, $item_type);
		} else if ($no) {
			$this->set($no);
		}
	}

	function set_DB () {
		$this->DB = new MySQLdb;
	}

	function set ($no, $item_num="", $item_type="") {

		$this->no = $no;

		if ($item_num and $item_type) {
			$this->item_num = $item_num;
			$this->item_type = $item_type;
		} else {
			$this->set_DB();

			$a = $this->DB->fetch_one(sprintf($this->SQL_GET_ITEM_INFO,
				$_SESSION["config_id"], $this->no));

			$this->item_num = $a["item_num"];
			$this->item_type = $a["item_type"];

		}

		$this->set_module();

		return $retval;
	}

	function set_module ($item_type="") {
		// set module class to be init.

		if ($item_type) $this->item_type = $item_type;

		$this->Module = new Module($this->item_type);
	}

	//-------------------------------------------------- action

	function info () {
		global $global, $string;

		$this->set_DB();

		$retval = $this->Module->execute1("info", $this->item_num);

		return $retval;
	}

	function print_view () {
		global $global, $string;

		$this->set_DB();

		$retval = $this->Module->execute1("print_view", $this->item_num);
		return $retval;
	}

	function view () {
		global $global, $string;

		$this->set_DB();

		$retval = $this->Module->execute2("view", $this->item_num, $this->no);
		return $retval;
	}

	function edit () {
		global $global, $string;

		$this->set_DB();

		$retval = $this->Module->execute1("edit", $this->item_num);
		return $retval;
	}

	function add () {
		global $global, $string;

		$this->set_DB();

		// directory check.
		$Directory = new myDirectory($_SESSION["user_directory"]);

		// check whether dest directory is system directory or not.
		if ($Directory->is_system()) {
			$directory_num = $global["directory"]["mydirectory"];
		} else {
			$directory_num = $_SESSION["user_directory"];
		}

		$retval = $this->Module->execute1("add", $directory_num);
		return $retval;
	}

	// insert item to item_<id>.
	function insert ($item_num, $item_type, $directory_num) {

		$this->set_DB();

		$this->DB->query(sprintf($this->SQL_INSERT_ITEM,
				$_SESSION["config_id"], $item_num, $item_type, $directory_num));

		$retval = $this->DB->retval;

		return $retval;
	}

	function update ($var) {

		if (! is_array($var)) {
			$retval = false;
		} else {
			while (list($i, $j) = each($var)) {
				$a[] = sprintf("%s = '%s'", $i, $j);
			}

			$b = implode(", ", $a);

		$this->set_DB();

			$this->DB->query(sprintf($this->SQL_UPDATE_ITEM,
				$_SESSION["config_id"], $b, $this->no));

			$retval = $this->DB->retval;
		}

		return $retval;
	}

	function delete () {

		$this->set_DB();

		$this->DB->query(sprintf($this->SQL_DELETE_ITEM,
			$_SESSION["config_id"], $this->no));

		$retval = $this->DB->retval;

		return $retval;
	}

	// $no is original item no.
	function copy ($directory_num) {
		global $global, $string;

		$this->set_DB();

		$item_num = $this->Module->execute1("copy", $this->item_num);

		if ($item_num) {
			$this->insert($this->item_num, $this->item_type, $directory_num);
			$retval = $this->DB->retval;
		} else {
			$retval = false;
		}

		return $retval;
	}

	function move ($directory_num) {
		global $global, $string;

		$this->set_DB();

		//$this->Module->execute1("move", $this->no);

		$a["directory_num"] = $directory_num;

		$this->update($a);

		$retval = $this->DB->retval;

		return $retval;
	}

	// argument $force make item to delete without going to TRASH.
	function remove ($force=false) {
		global $global, $string;

		if ($force != true) $force = false;

		$this->set_DB();

		if ($force == true) {
			if ($this->Module->execute2("remove", $this->item_num, $force)) {
				$retval = $this->delete();
			} else {
				$retval = false;
			}
		} else {
			$a["directory_num"] = $global["directory"]["trash"];
			$retval = $this->update($a);
		}
		
		return $retval;
	}

	//-------------------------------------------------- get.
	function get_no ($item_num, $item_type) {

		$this->set_DB();

		$o = $this->DB->fetch_one(
			sprintf($this->SQL_GET_NO, $_SESSION["config_id"], $item_num, $item_type));

		if ($o["no"]) {
			$retval = $o["no"];
		} else {
			$retval = false;
		}

		return $retval;
	}

	function get_size ($item_num="", $item_type="") {
		global $global, $string;

		$this->set_DB();

		if ($item_type and $item_num) {
			$this->item_num = $item_num;
			$this->item_type = $item_type;

			$this->set_module($this->item_type);
		}

		$retval = $this->Module->execute1("size", $this->item_num);

		return $retval;
	}

	function set_item_type () {

		$this->set_DB();

		$this->DB->query(sprintf($this->SQL_GET_ITEM_TYPE,
			$_SESSION["config_id"]), true);

		for ($i = 0; $i < $this->DB->num_rows; $i++) {
			$o = $this->DB->fetch();
			$_SESSION["user_item_type"][$o["no"]] = $o["name"];
			$_SESSION["user_item_type_label"][$o["no"]] = $o["label"];

			$_SESSION["user_item_type_rv"][$o["name"]] = $o["no"];
		}

		return true;
	}

	function get_in_trash ($item_type) {
		global $global;

		$add_query = sprintf("and item_type = '%s'", $item_type);

		$DB = new MySQLdb;
		
		$DB->query(sprintf(
			$this->SQL_GET_TRASH_ITEM, $_SESSION["config_id"],
				$global["directory"]["trash"], $add_query), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();
			$no[] = $o["item_num"];
		}

		return $no;
	}

}


/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Thu May 22 03:25:56 KST 2003
- created.

Usage
-----

*/

?>
