<?

class Image {

	var $filepath;
	var $info;

	function Image ($filepath=false) {
		/*
		* info :
			width			0			548
			height		1			619
			image type	2			2
			text string	3			width="548" height="619"
							bits		8
							channels	3
							mime		image/jpeg
		*/

		if ($filepath) {
			$this->filepath = $filepath;
			$this->info = getimagesize($this->filepath);
		}

	}

	function load_image () {
		/*
		1 = GIF
		2 = JPG
		3 = PNG
		4 = SWF
		5 = PSD
		6 = BMP
		7 = TIFF(intel byte order)
		8 = TIFF(motorola byte order)
		9 = JPC
		10 = JP2
		11 = JPX
		12 = JB2
		13 = SWC
		14 = IFF. 
		*/

		switch ($this->info["2"]) {
			case ("1"):
				$im = ImageCreateFromGIF ($this->filepath);
			break;
			case ("2") :
				$im = ImageCreateFromJPEG ($this->filepath);
			break;
			case ("3"):
				$im = ImageCreateFromPNG ($this->filepath);
			break;
			default :
				$im = false;
		}

		return $im;
	}

	## Image thumbnail_jpg(String $filepath, int $width, int $height);

	function set_size ($width=false, $height=false) {

		if ($width and $height) {
			$new_w = $width;
			$new_h = $height;
		} else if ($width and ! $height) {
			$new_w = $width;
			$new_h = intval(($this->info["1"] / $this->info["0"]) * $width);
		} else if (! $width and $height) {
			$new_w = $width;
			$new_h = intval(($this->info["0"] / $this->info["1"]) * $height);
		} else {
			$non_size = true;
		}

		if ($non_size) {
			$retval = false;
		} else {
			$retval["0"] = $new_w;
			$retval["1"] = $new_h;
		}

		return $retval;
	}

	function thumbnail ($width=100, $height=100, $thumb_name) {

		if ($this->info["2"] > 3) {
			$retval = false;
		} else {
			$size = $this->set_size($width, $height);

			if (! $size) {
				$retval = false;
			} else {
				$src_im = $this->load_image();

				if (! $src_im) {
					$retval = false;
				} else {
					$dst_im = imagecreatetruecolor($size[0], $size[1]);

					imagecopyresampled(
						$dst_im, $src_im,
						0, 0, 0, 0,
						$size[0], $size[1],
						imagesx($src_im), imagesy($src_im)
					);

					imagepng($dst_im, $thumb_name);

					$retval = $dst_im;

					ImageDestroy($dst_im);
				}
			}
		}

		return $retval;

	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
