<?

include_once $global["root"] . "/lib/Domain.php";
include_once $global["root"] . "/lib/User.php";
include_once $global["root"] . "/lib/Directories.php";
include_once $global["root"] . "/include/print_byte.php";

class Domains {

	var $info;

	var $Template;

	var $SQL_GET_USER_ALIAS_IN_DOMAIN =
		"select SQL_CACHE no, name, valid, user_no from user_alias_priv
			where domain = '%s'";
	var $SQL_GET_USER_IN_DOMAIN =
		"select SQL_CACHE no, name, id, valid from user_priv where domain = '%s'";

	var $SQL_GET_USER_INFO = "select SQL_CACHE * from user_priv where no = '%s'";
	var $SQL_GET_DOMAIN_FILTER = "select SQL_CACHE * from mail_filter_%s";

	var $total_user_number = "0";

	function Domains () {

		// get domain info
		$DM = new Domain;
		$this->info = $DM->get_info();

		$this->Template = new Template;

	}

	// return user list.
	function return_user_alias_list () {
		global $string;

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_USER_ALIAS_IN_DOMAIN,
			$_SESSION["config_domain"]), true);

		$User = new User;
		for ($i = 0; $i < $DB->num_rows; $i++) {
			unset($a);

			$o = $DB->fetch();
			$a["username"]= $o["name"];
			$a["no"]= $o["no"];

			$User->get_info_by_no($o["user_no"]);
			$a["real_name"]= $User->info["name"];
			$a["user_no"]= $User->info["no"];

			if ($o["valid"] == "1") {
				$a["is_valid"] = "selected";
			} else {
				$a["not_valid"] = "selected";
			}

			$main["content"] .=
				$this->Template->generate("/template/domain/user_alias_list_one", $a);
		}

		$this->total_user_number += $DB->num_rows;

		$retval =
			$this->Template->generate("/template/domain/user_alias_list", $main);

		return $retval;
	}

	function return_user_list () {
		global $string;

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_USER_IN_DOMAIN,
			$_SESSION["config_domain"]), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			unset($a);

			$o = $DB->fetch();
			$a["username"]= $o["name"];
			$a["user_no"]= $o["no"];
			$a["user_id"]= $o["id"];

			if ($o["valid"] == "1") {
				$a["is_valid"] = "selected";
			} else {
				$a["not_valid"] = "selected";
			}

			$main["content"] .=
				$this->Template->generate("/template/domain/user_list_one", $a);
		}

		$this->total_user_number += $DB->num_rows;

		$main["user_limit"] = sprintf($string["admin24"],
			$this->info["user_limit"]);

		// user alias list.
		$main["alias_user_list"] = $this->return_user_alias_list();

		if ($this->info["user_limit"] > $this->total_user_number) {
			$main["create_user_form"] =
				$this->Template->generate(
					"/template/domain/user_list_create_user_form");
		}

		$retval =
			$this->Template->generate("/template/domain/user_list", $main);

		return $retval;
	}

	function return_user_info ($user_no) {
		global $global, $string;

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_USER_INFO, $user_no), true);

		$o = $DB->fetch();

		$main["user_address"] = sprintf("%s@%s", $o["name"], $o["domain"]);
		$main["username"] = $o["name"];
		$main["user_id"] = $o["id"];
		$main["user_no"] = $o["no"];
		$main["domain_quota"] = print_byte(intval($this->info["quota"]));

		$main["password"] = $o["password_plain"];

		$main["quota"] = intval($o["quota"] / 1000000);

		$main["message_size_limit"] =
			intval($o["message_size_limit"] / 1000000);
		$main["document_size_limit"] =
			intval($o["document_size_limit"] / 1000000);

		$main["domain_message_size_limit"] =
			print_byte(intval($o["message_size_limit"]));
		$main["domain_document_size_limit"] =
			print_byte(intval($o["document_size_limit"]));

		// block address
		$main["block_address"] = $o["block_address"];
		$main["msg_block_address"] = sprintf($string["admin44"],
			$_SESSION["config_block_address"]);

		// filter
		$main["filter"] = $o["filter"];
		$main["msg_filter"] =
			sprintf($string["admin44"], $_SESSION["config_filter"]);

		$retval =
			$this->Template->generate("/template/domain/user_info", $main);

		return $retval;
	}

	function return_filter () {
		global $global;

		$Directories = new Directories;

		// directory
		$var_directory = $Directories->return_select_options(
					array($global["directory"]["sent"]),
						$global["directory"]["spam"], true);

		$DB = new MySQLdb;
		$DB->query(
			sprintf($this->SQL_GET_DOMAIN_FILTER, $this->info["id"]), true);

		for ($i = 0; $i < $this->info["filter"]; $i++) {
			$one["no"] = ($i + 1);

			$o = @$DB->fetch();
			if (! is_array($o)) {
				$one["directory"] = $var_directory;

				$rules["content"] .= $this->Template->generate(
					"/template/domain/filter_one_empty", $one);
				continue;
			}

			unset($exp);

			// expression
			if ($o["expression"] == "1") {
				$exp["and"] = "checked";
			} else {
				$exp["or"] = "checked";
			}

			$one["expression"] = sprintf(
				"<input type=\"radio\" name=\"%s[expression]\" value=\"%s\" %s>%s\n
				<input type=\"radio\" name=\"%s[expression]\" value=\"%s\" %s>%s",
						$one["no"], "0", $exp["or"], $string["item55"],
						$one["no"], "1", $exp["and"], $string["item54"]);

			// string
			$one["From_string"] = $o["f"];
			$one["To_string"] = $o["t"];
			$one["Subject_string"] = $o["s"];
			$one["payload_name_string"] = $o["payload_name"];

			if ($o["message_size"] != "0") {
				$one["message_size_string"] = $o["message_size"];
			}

			// option
			$one["Subject_option"] =
				$this->__return_expression_select_box($o["s_o"]);
			$one["payload_name_option"] =
				$this->__return_expression_select_box($o["p_o"]);
			$one["message_size_option"] =
				$this->__return__size_select_box($o["m_o"]);

			// case sensitive
			if ($o["s_c"]) $one["Subject_case"] = "checked";
			if ($o["p_c"]) $one["payload_name_case"] = "checked";

			// directory
			if ($o["directory_num"] == "0") {
				$one["directory"] = $Directories->return_select_options(
						array($global["directory"]["sent"]),
							$global["directory"]["spam"], true);
			} else {
				$one["directory"] = $Directories->return_select_options(
						array($global["directory"]["sent"]),
							$o["directory_num"], "", true);
			}

			// return
			$rules["content"] .= $this->Template->generate(
				"/template/domain/filter_one", $one);

			// remove old value.
			unset($o);
			unset($one);
		}

		$rules["domain_id"] = $this->info["id"];

		$retval = $this->Template->generate("/template/domain/filter", $rules);

		return $retval;
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
