<?

include_once $global["root"] . "/lib/Authentication.php";
include_once $global["root"] . "/lib/MySQLdb.php";
include_once $global["root"] . "/lib/Domain.php";
include_once $global["root"] . "/lib/Forum_Priv.php";

class Authentication_Domain extends Authentication {

	function Authentication ($address="") {
		if ($address) $this->set_address($address);
	}

	function check () {
		if (! $_SESSION["config_domain_admin"]) {
			$this->logout();
		}

		$this->set_keepalive();
	}

	function assign () {
		global $global;

		$var_global = $this->get_global_value();
		$var_domain = $this->get_domain_value();

		// start session.
		$Session = new Session;

		$this->remove();

		// assign user value to $_SESSION.
		while (list($i, $j) = each($var_domain)) {
			if (ereg("^[0-9][0-9]*$", $i)) continue;
			if ($i == "id") {
				$_SESSION["config_domain_id"] = $j;
				continue;
			}

			$_SESSION[sprintf("config_%s", $i)] = $j;
		}

		$_SESSION["config_name"] = "postmaster";
		$_SESSION["config_domain"] = $this->domain;

		// forum
		$Forum = new Forum_Priv;

		if ($Forum->return_valid_forum()) {
			$_SESSION["config_forum"] = $Forum->valid_forum;
		}

		// user's email address
		$_SESSION["config_address"] = sprintf("postmaster@%s",
			$_SESSION["config_domain"]);

		// language
		if (! $_SESSION["config_lang"]) $_SESSION["config_lang"] = "korean";

		// set domain id
		$_SESSION["config_domain_admin"] = true;

		$_SESSION["config_timeout"] = 1800;
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
