import smtplib, os, time

class mySMTP :

	def __init__ (self, config) :

		if not config.has_key("port") : config["port"] = smtplib.SMTP_PORT

		try :
			self.server = smtplib.SMTP(config["server"], config["port"])
		except :
			raise IOError, "Can not connect the smtp server, '%s', port, '%s'" \
				% (config["server"], config["port"])
		else :
			self.setDebugLevel(0)

	def setDebugLevel (self, level=0) :

		self.server.set_debuglevel(level)

	def sendmail (self, **kwargs) :
		"""
		Send mail

		If multiple reciever, To is list, and if not, just string.
		"""

		if type(kwargs["To"]) == list :
			toaddr = kwargs["To"]
		elif type(kwargs["To"]) == str :
			toaddr = kwargs["To"].split()

		fromaddr = kwargs["From"]
		msg = kwargs["msg"]

		try :
			self.server.sendmail(fromaddr, toaddr, msg)
		except :
			retval = False
		else :
			retval = True

		return retval

	def quit (self) :

		try :
			self.server.quit()
		except :
			retval = False
		else :
			retval = True

		return retval

"""
Description
-----------
The abstraction of smtplib module

ChangeLog
---------
Sat Mar  1 21:03:07 KST 2003
- created.

Sun Jun 15 04:34:10 KST 2003
- new design style applied

Sun Jun 15 04:34:18 KST 2003
- logwrite removed.

Reference
---------

	def prompt(prompt):
		 return raw_input(prompt).strip()

	fromaddr = prompt("From: ")
	toaddrs  = prompt("To: ").split()
	print "Enter message, end with ^D:"

	# Add the From: and To: headers at the start!
	msg = ("From: %s\r\nTo: %s\r\n\r\n"
			 % (fromaddr, string.join(toaddrs, ", ")))
	while 1:
		 try:
			  line = raw_input()
		 except EOFError:
			  break
		 if not line:
			  break
		 msg = msg + line

	print "Message length is " + `len(msg)`

	server = smtplib.SMTP('localhost')
	server.set_debuglevel(1)
	server.sendmail(fromaddr, toaddrs, msg)
	server.quit()

Usage
-----

"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "mySMTP.py"

