# -*- coding: utf-8 -*-
import myMySQLdb, sql

class Statistics :

	__db = None

	def __init__ (self, **kwd) :

		self.__db = kwd["db"]

	def insert_incoming (self, **kwd) :
		"""
		type is,
			spam
			virus
			normal
		"""

		retval = False

		# check argument
		user_id = ""
		domain_id = ""

		if not kwd.has_key("date") : retval = -2
		if not kwd.has_key("size") : retval = -2
		if not kwd.has_key("type") : retval = -2
		if not kwd.has_key("Toaddr") : retval = -2

		if retval != -2 :
			# make db instance
			DB = myMySQLdb.myMySQLdb(self.__db, True)

			# insert into db
			DB.query(sql.SQL_INSERT_STATISTICS_INCOMING % \
				(kwd["date"], kwd["size"], kwd["type"], kwd["Toaddr"]))

			retval = DB.retval
			DB.close()

		return retval

	def insert_outgoing (self, **kwd) :

		retval = False

		# check argument
		if not kwd.has_key("date") : retval = -2
		if not kwd.has_key("size") : retval = -2
		if not kwd.has_key("user_id") : retval = -2
		if not kwd.has_key("Toaddr") : retval = -2

		if retval != -2 :
			# make db instance
			DB = myMySQLdb.myMySQLdb(self.__db, True)

			# insert into db
			DB.query(sql.SQL_INSERT_STATISTICS_INCOMING % \
				(kwd["date"], kwd["size"], kwd["type"], kwd["user_id"], kwd["Toaddr"]))

			retval = DB.retval
			DB.close()

		return retval

"""
Description
-----------
mysql> desc statistics_incoming;
+-----------+-------------+------+-----+---------+----------------+
| Field     | Type        | Null | Key | Default | Extra          |
+-----------+-------------+------+-----+---------+----------------+
| no        | int(6)      |      | PRI | NULL    | auto_increment |
| date      | varchar(11) |      |     |         |                |
| size      | int(11)     |      |     | 0       |                |
| type      | varchar(10) |      |     | 0       |                |
| Toaddr  | tinytext    | YES  |     | NULL    |                |
+-----------+-------------+------+-----+---------+----------------+
5 rows in set (0.05 sec)

mysql> desc statistics_outgoing;
+---------+-------------+------+-----+---------+----------------+
| Field   | Type        | Null | Key | Default | Extra          |
+---------+-------------+------+-----+---------+----------------+
| no      | int(6)      |      | PRI | NULL    | auto_increment |
| date    | varchar(11) |      |     |         |                |
| size    | int(11)     |      |     | 0       |                |
| user_id | varchar(10) | YES  |     | NULL    |                |
| Toaddr  | tinytext    | YES  |     | NULL    |                |
+---------+-------------+------+-----+---------+----------------+
5 rows in set (0.05 sec)

mysql> 


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Statistics.py"

