import sys, time, getopt
import config

import myMySQLdb, Domain, sql, message

#---------------------------------------------- argument handling

# 	id
# 	name
# 	quota
# 	valid
# 	createdTime
# 	message_size_limit
# 	document_size_limit
# 	filter
# 	user_limit
# 	password
# 	password_plain

USAGE = \
"""Usage : %s <domain name>

   -a, --add                : Add new domain
   -r, --remove             : Remove new domain

   --quota                  : quota (Megabyte).                     default 70(M)
   --message_size_limit     : message size limit (Megabyte).        default 5(M)
   --document_size_limit    : document size limit (Megabyte).       default 5(M)
   --filter                 : the total number of filter.           default 10
   --block_address          : the total number of address to block. default 7
   --user                   : the total number of users.            default 5
   --password               : password
   --www                    : www domain name
"""

MSG_CONFIGURATION = \
	"""Your Configuration is,
--------------------------------------------
          Domain Name : %s
               Action : %s
                Quota : %5s
   Message Size Limit : %5s
  Document Size Limit : %5s
        Filter number : %5s
 Block Address number : %5s
          User number : %5s
             Password : %s
      WWW Domain Name : %s
--------------------------------------------
	"""
MSG_SUCCESS_REMOVE = """Successfully removed."""
MSG_SUCCESS_ADD = """Successfully added.

====================================
Please restart your QMAIL server.
====================================
"""

ERROR_NOT_MB = \
"""
ERROR : '%s' must be integer value.
        Don't append 'MB', 'KB', 'K' or 'M'
"""

try :
	optlist, args = getopt.getopt(sys.argv[1:], "har", \
		["add", "remove", "quota=", "message_size_limit=", \
		"document_size_limit=", "www=", "filter=", \
		"block_address=", "user=", "password="])
except :
	print USAGE % sys.argv[0]
	sys.exit(1)

action = None

domain = sys.argv[-1]

if not message.is_valid_domain(domain) :
	print "(***) \"%s\" is not valid domain name. Try agian." % domain
	print USAGE % sys.argv[0]
	sys.exit(1)

options = {}
options["quota"] = 70
options["document_size_limit"] = 5
options["message_size_limit"] = 5
options["filter"] = 10
options["block_address"] = 7
options["user"] = 5
www_default_prefix = "mesian"

for i in optlist :
	if i[0] in ("--add", "-a") :
		action = "add"
	elif i[0] in ("--remove", "-r") :
		action = "remove"

	# option
	elif i[0] == "--quota" :
		try :
			a = int(i[1])
		except :
			print ERROR_NOT_MB % "--quota"
			sys.exit(1)
		else :
			options["quota"] = i[1]

	elif i[0] == "--message_size_limit" :
		try :
			a = int(i[1])
		except :
			print ERROR_NOT_MB % "--message_size_limit"
			sys.exit(1)
		else :
			options["message_size_limit"] = i[1]

	elif i[0] == "--document_size_limit" :
		try :
			a = int(i[1])
		except :
			print ERROR_NOT_MB % "--document_size_limit"
			sys.exit(1)
		else :
			options["document_size_limit"] = i[1]

	elif i[0] == "--filter" :
		options["filter"] = i[1]

	elif i[0] == "--block_address" :
		options["block_address"] = i[1]

	elif i[0] == "--user" :
		options["user"] = i[1]

	elif i[0] == "--password" :
		options["password"] = i[1]

	elif i[0] == "--www" :
		options["www"] = i[1]

if not action :
	print "Add or Remove? What?"
	print USAGE % sys.argv[0]
	sys.exit(1)

# value check
if action == "add" and \
		("password" not in options.keys() or options["password"].strip() == "") :
	print "(***) YOu must insert password!"
	print USAGE % sys.argv[0]
	sys.exit(1)

if "www" not in options.keys() or options["www"].strip() == "" :
	www_domain_name = "%s.%s" % (www_default_prefix, domain)
else :
	www_domain_name = options["www"]

if action == "add" :
	print MSG_CONFIGURATION % \
		(domain, action, \
		options["quota"], options["message_size_limit"], \
		options["document_size_limit"], options["filter"], \
		options["block_address"], options["user"], \
		options["password"], www_domain_name)

#----------------------------- db connection
DB = myMySQLdb.myMySQLdb()

try :
	DB.connect(config.db)
except ValueError :
	print "** Can not connect DB."
	sys.exit(1)

DM = Domain.Domain()

if action == "add" :
	retval = DM.add(domain)
elif action == "remove" :
	retval = DM.remove(domain)

if retval == False :
	DB.quit()

	print "(***) Failed to %s %s" % (action, domain)
	sys.exit(1)
elif retval == -3 :
	DB.quit()
	print "(***) It's not a vaild domain name, %s" % (domain)
	sys.exit(1)

elif action == "add" and retval == -2 :
	DB.quit()
	print "(***) It already exists, %s" % (domain)
	sys.exit(1)

elif action == "remove" and retval == -2 :
	DB.quit()
	print "(***) It does not exists, %s" % (domain)
	sys.exit(1)

else :
	# add domain info to domain_priv.
	DM.set_db(DB)
	DB.start_transaction(True)

	options["www_domain_name"] = www_domain_name

	try :
		retval = DM.do_table(action, domain, **options)
	except :
		retval = False

	if retval and action == "remove" :
		print MSG_SUCCESS_REMOVE
	elif retval and action == "add" :
		print MSG_SUCCESS_ADD
	else :
		DB.retval = False

		if action == "add" :
			DM.remove(domain)
		elif action == "remove" :
			DM.add(domain)

		print "(***) Failed to %s %s." % (action, domain)

	DB.close()
	DB.quit()

sys.exit(0)

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "make_domain.py"

