<?

include_once $global["root"] . "/lib/User.php";
include_once $global["root"] . "/lib/Page.php";
include_once $global["root"] . "/lib/Forum.php";
include_once $global["root"] . "/lib/Forum_Priv.php";
include_once $global["root"] . "/lib/Authentication_Forum.php";

include_once $global["root"] . "/include/print_time.php";

class Forum {

	var $Template;
	var $current_page;
	var $id;
	var $forum_id;

	var $page_limit;

	var $message_size_limit;
	var $name;
	var $createdTime;

	// sql
	var $SQL_GET_INFO = "select SQL_CACHE * from forum_priv where id = '%s'";

	var $SQL_GET_ITEM = "select SQL_CACHE * from forum_%s order by date desc %s";
	var $SQL_GET_ITEM_SUBJECT = "select SQL_CACHE * from forum_%s order by date desc %s";
	var $SQL_GET_ITEM_NO = "select SQL_CACHE * from forum_%s where no = '%s'";
	var $SQL_UPDATE_NO = "update forum_%s set hit = hit + 1 where no = '%s'";
	var $SQL_GET_COMMENT_NUM =
		"select SQL_CACHE count(no) as num from forum_comment_%s where message = '%s'";
	var $SQL_GET_COMMENT =
		"select SQL_CACHE * from forum_comment_%s where message = '%s'";

	function Forum ($id=false, $current_page=false) {
		global $global;

		if ($id) {
			$this->set_id($id);
		}

		$this->Template = new Template;

		if ($current_page) {
			$this->current_page = $current_page;
		} else {
			$this->current_page = "0";
		}

		if (array_key_exists("config_pageLimit", $_SESSION)) {
			$this->page_limit = $_SESSION["config_pageLimit"];
		} else {
			$this->page_limit = $global["pagelimit"];
		}

	}

	function set_id ($id) {

		$this->id = $id;

		$this->get_info();
	}

	function get_info_by_id ($id) {
		$DB = new MySQLdb;
		$retval = $DB->fetch_one(sprintf($this->SQL_GET_INFO, $id));

		return $retval;
	}

	function get_info ($id=false) {

		if ($id) $this->set_id($id);

		$o = $this->get_info_by_id($this->id);

		$this->message_size_limit = $o["message_size_limit"];
		$this->name = $o["name"];
		$this->createdTime = $o["createdTime"];
	}

	function return_latest_subject_one ($id) {
		global $global, $string;

		$this->set_id($id);
		$this->get_info();

		$DB = new MySQLdb;

		$add_query = sprintf("limit 0, %s", $global["config_latest_forum_number"]);
		$DB->query(sprintf($this->SQL_GET_ITEM_SUBJECT, $this->id, $add_query), true);

		$User = new User;

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			if (trim($o["subject"])) {
				$var["subject"] = htmlspecialchars($o["subject"]);
			} else {
				$var["subject"] = $string["forum15"];
			}

			$var["date"] = print_time($o["date"]);

			if ($o["id"]) {
				//$User = new User(false, $o["id"]);
				$User->get_info_by_id($o["id"]);

				if ($User->info["full_name"]) {
					$var["username"] = $User->info["full_name"];
				} else {
					$var["username"] = $User->info["name"];
				}

			} else {
				$email =
					sprintf("&lt;<a class=\"forum\"
						href=\"%s/forum?mode=add&no=1&address=%s\">%s</a>&gt;",
							$_SESSION["user_forum_url"], $o["address"],
							ereg_replace("@",
								"&nbsp;" .$string["forum"] . "&nbsp;", $o["address"]));

				$var["name"] = $o["username"];
				$var["email"] = $email;
			}

			$var["id"] = $this->id;
			$var["no"] = $o["no"];

			$main["content"] .= $this->Template->generate(
				"/module/forum/template/subject_list_one", $var);
		}

		if ($DB->num_rows < 1) {
			$main["id"] = $this->id;
			$main["name"] = $this->name;

			$retval = $this->Template->generate(
					"/module/forum/template/subject_list_empty", $main);

		} else {
			$main["id"] = $this->id;
			$main["name"] = $this->name;

			$retval = $this->Template->generate(
					"/module/forum/template/subject_list", $main);
		}

		return $retval;
	}

	function return_latest_subject_list () {
		global $global, $string;

		if (is_array($_SESSION["config_forum"])) {
			reset($_SESSION["config_forum"]);

			while (list($i, $j) = each($_SESSION["config_forum"])) {
				$retval .= $this->return_latest_subject_one($i);
			}
		}

		return $retval;
	}

	// action
	function add () {
		global $global, $string;

		$main["id"] = $this->id;
		$main["name"] = $this->name;

		if (! $_SESSION["user_authenticated"]) {
			$main["form_name"] =
				$this->Template->generate("/module/forum/template/add_form_name");
			$main["form_password"] =
				$this->Template->generate("/module/forum/template/add_form_password");
		}

		$retval = $this->Template->generate("/module/forum/template/add_form", $main);

		return $retval;
	}

	function edit ($no) {
		global $string;

		$DB = new MySQLdb;
		$o = $DB->fetch_one(sprintf($this->SQL_GET_ITEM_NO, $this->id, $no));

		$var["no"] = $no;
		$var["id"] = $this->id;

		// check authentication.
		if (! $o["id"] or $o["id"] == "") {
			$var["form_password"] =
				$this->Template->generate("/module/forum/template/edit_form_password");
		} else {
			if ($o["id"] != $_SESSION["config_id"]) {
				$_SESSION["tmp"]["msg"]["content"] = $string["forum20"];
				goprev();
			}
		}

		// payload check and print
		if ($o["payload_header"]) {
			$a = split(";", $o["payload_header"]);

			if ($a[1]) {
				$payload_name = $a[1];
			} else {
				$payload_name = $string["forum21"];
			}

			$var["payloaded"] = sprintf("<li>%s", $payload_name);
		}

		// user name form.
		if (! $_SESSION["user_authenticated"]) {
			$var_edit["name"] = htmlspecialchars($o["username"]);
			$var["form_name"] =
				$this->Template->generate("/module/forum/template/edit_form_name", $var_edit);
		}

		$var["subject"] = htmlspecialchars($o["subject"]);

		$var["content"] = $o["content"];

		$retval = $this->Template->generate("/module/forum/template/edit_form", $var);
		return $retval;
	}

	function info ($no) {
		$DB = new MySQLdb;

		$o = $DB->fetch_one(sprintf($this->SQL_GET_ITEM_NO, $this->id, $no));

		if ($DB->retval) {
			$retval = $o;
		} else {
			$retval = false;
		}

		return $retval;
	}

	function print_view () {
		global $global, $string;

	}

	function remove () {
	}

	function search () {
	}

	function update_item ($no) {
		$DB = new MySQLdb(true);
		$DB->query(sprintf($this->SQL_UPDATE_NO, $this->id, $no));
		$DB->close();
	}

	function view ($no) {
		global $global, $string;

		$DB = new MySQLdb;
		$o = $DB->fetch_one(sprintf($this->SQL_GET_ITEM_NO, $this->id, $no));

		$var["date"] = print_time($o["date"]);
		$var["subject"] = htmlspecialchars($o["subject"]);

		$var["content"] = $o["content"];

		//comment
		if ($o["id"]) {
			$User = new User(false, $o["id"]);

			$address = sprintf("%s@%s", $User->info["name"], $User->info["domain"]);
			$email =
				sprintf("<a class=\"forum\"
					href=\"%s/forum?mode=add&no=1&address=%s\">%s</a>",
						$_SESSION["user_forum_url"], $address, sprintf("%s",
							$User->info["domain"]));

			if ($User->info["full_name"]) {
				$var["name"] = $User->info["full_name"];
			} else {
				$var["name"] = $User->info["name"];
			}
			$var["email"] = $email;

		} else {
			$email =
				sprintf("&lt;<a class=\"forum\"
					href=\"%s/forum?mode=add&no=1&address=%s\">%s</a>&gt;",
						$_SESSION["user_forum_url"], $o["address"],
						ereg_replace("@",
							"&nbsp;" .$string["forum"] . "&nbsp;", $o["address"]));

			$var["name"] = $o["username"];
			$var["email"] = $email;
		}

		
		//comment
		$var["comment"] =
			sprintf(
				"<a href=\"%s/forum?mode=comment&id=%s&no=%s\">%s (%s)</a>",
				$_SESSION["user_forum_url"], $this->id, $o["no"], $string["forum1"],
				$this->get_comment_num($no));

		$var["id"] = $this->id;

		$main["content"]=
			$this->Template->generate("/module/forum/template/item_one", $var);

		$main["name"] = $this->name;
		$main["id"] = $this->id;

		$retval = $this->Template->generate("/module/forum/template/view", $main);

		// update hit.
		//$this->update_item($no);

		return $retval;
	}

	function get_comment_num ($no) {
		$DB = new MySQLdb;
		$o = $DB->fetch_one(sprintf($this->SQL_GET_COMMENT_NUM, $this->id, $no));

		return $o["num"];
	}

	function comment ($id=false, $no) {

		if ($id) {
			$this->set_id($id);
			$this->get_info($id);
		}

		// message
		$main["message"] = $this->view($no);

		$DB = new MySQLdb;

		// comment
		$DB->query(sprintf($this->SQL_GET_COMMENT, $this->id, $no), true);

		$var["id"] = $this->id;
		$var["no"] = $no;

		// if authenticated user, does not print name input form.
		if (! $_SESSION["config_id"]) {
			$var["form_name"] =
				$this->Template->generate("/module/forum/template/comment_list_form_name");
		}

		if ($DB->num_rows < 1) {
			$main["comment"] =
				$this->Template->generate("/module/forum/template/comment_list_empty", $var);
		} else {
			for ($i = 0; $i < $DB->num_rows; $i++) {
				$o = $DB->fetch();

				$var1["username"] = $o["username"];
				$var1["content"] = $o["content"];

				$var1["date"] = print_time($o["date"]);

				$var["content"] .= 
					$this->Template->generate("/module/forum/template/comment_list_one", $var1);
			}

			$main["comment"] =
				$this->Template->generate("/module/forum/template/comment_list", $var);
		}

		$main["name"] = $this->name;
		$main["id"] = $this->id;

		$retval = $this->Template->generate("/module/forum/template/comment", $main);

		return $retval;
	}

	function return_list ($id=false, $current_page="") {
		global $global, $string;

		if ($id) {
			$this->set_id($id);
			$this->get_info($id);
		}

		if ($current_page != "") {
			$this->current_page = "$current_page";
			$_SESSION["user_forum_page"][$this->id] = "$current_page";
		} else {
			if (array_key_exists("user_forum_page", $_SESSION)) {
				if (array_key_exists($this->id, $_SESSION["user_forum_page"])) {
					$this->current_page = $_SESSION["user_forum_page"][$this->id];
				} else {
					$this->current_page = "0";
					$_SESSION["user_forum_page"][$this->id] = "0";
				}
			}
		}

		/////////////////////////////////////////////////////////////
		// page
		$Page = new Page_Forum($this->id, $this->current_page);

		if ($Page->page_total > 1) {
			$main["page_list"] = $Page->print_list();
		}

		$add_query = sprintf("limit %s, %s",
			($this->current_page) * $this->page_limit, $this->page_limit);
		/////////////////////////////////////////////////////////////

		$main["name"] = $this->name;

		$DB = new MySQLdb;
		$DB->query(sprintf($this->SQL_GET_ITEM, $this->id, $add_query), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			unset($var);

			$var["id"] = $this->id;
			$var["no"] = $o["no"];
			$var["date"] = print_time($o["date"]);
			$var["subject"] = htmlspecialchars($o["subject"]);

			// handling content.
			$g = eregi_replace("<a ", "<a target=awindow ", $o["content"]); // altering link.
			$data = eregi_replace("<script", "<span", $g); // preventing script kiddy.

			//$var["content"] = nl2br($data);
			$var["content"] = $data;

			// image paylaod printing.
			if (eregi("^image", $o["payload_header"])) {

				$org_image_url =
					sprintf("%s/module/forum/action/getContent?method=image&id=%s&no=%s",
					$_SESSION["user_forum_url"], $this->id, $o["no"]);

				$thumbnail_url =
					sprintf("%s/module/forum/action/getContent?method=thumb&id=%s&no=%s",
					$_SESSION["user_forum_url"], $this->id, $o["no"]);

				$var["image"] =
					sprintf(
						"<a href=\"#\" onClick=\"javascript:openNew('%s')\">
							<img class=\"mesian\" src=\"%s\"></a><br><br>",
						$org_image_url, $thumbnail_url);
			} else if ($o["payload_header"]) {
				$a = explode(";", $o["payload_header"]);

				$filename =
					sprintf("<a
						href=\"%s/module/forum/action/getContent?method=payload&id=%s&no=%s\"
						>%s</a>",
					$_SESSION["user_forum_url"], $this->id, $o["no"], $a[1]);

				$var["payload"] = sprintf($string["forum13"],$filename);
			}

			//comment
			$a = $this->get_comment_num($o["no"]);
			if ($a == "0") $a = $string["forum8"];
			$var["comment"] = sprintf(
					"<a href=\"%s/forum?mode=comment&id=%s&no=%s#comment\"
						>%s (%s)</a>",
					$_SESSION["user_forum_url"], $this->id, $o["no"], $string["forum1"], $a);

			$var["comment_it"] = sprintf(
					"<a href=\"%s/forum?mode=comment&id=%s&no=%s\">%s</a>",
					$_SESSION["user_forum_url"], $this->id, $o["no"], $string["forum14"], $a);

			// find user.
			if ($o["id"]) {
				$User = new User(false, $o["id"]);
				$address = sprintf("%s@%s", $User->info["name"], $User->info["domain"]);
				$email =
					sprintf("<a class=\"forum\"
						href=\"%s/forum?mode=add&no=1&address=%s\">%s</a>",
							$_SESSION["user_forum_url"], $address, sprintf("%s&nbsp;%s",
								$string["forum"], $User->info["domain"]));

				if ($User->info["full_name"]) {
					$var["name"] = $User->info["full_name"];
				} else {
					$var["name"] = $User->info["name"];
				}
				$var["email"] = $email;

			} else {
				$email =
					sprintf("&lt;<a class=\"forum\"
						href=\"%s/forum?mode=add&no=1&address=%s\">%s</a>&gt;",
							$_SESSION["user_forum_url"], $o["address"],
							ereg_replace("@",
								"&nbsp;" .$string["forum"] . "&nbsp;", $o["address"]));

				$var["name"] = $o["username"];
				$var["email"] = $email;
			}

			$main["content"] .=
				$this->Template->generate("/module/forum/template/list_one", $var);
		}

		while (list($i, $j) = each($_SESSION["config_forum"])) {
			$Forum = new Forum($i);

			$var1["name"] = $Forum->name;
			$var1["id"] = $i;
			$main["forum_list"] .=
				$this->Template->generate("/module/forum/template/forum_one", $var1);
		}

		$main["id"] = $this->id;

		$retval = $this->Template->generate("/module/forum/template/list", $main);

		return $retval;
	}

	function add_forum ($name, $type="0") {
		global $insert, $table;

		$DB = new MySQLdb;

		$DB->transaction_start(true);

		$this->forum_id = mktime();

		// add forum
		$DB->query(sprintf($insert["domain_value"]["forum"], 
				$this->forum_id, addslashes($name),
				$this->forum_id, $this->message_size_limit,
				$type, $_SESSION["config_domain_id"]));

		// add forum table.
		if ($DB->retval) {
			$DB->query(sprintf($table["forum"]["content"], $this->forum_id));
		}

		// add forum comment table.
		if ($DB->retval) {
			$DB->query(sprintf($table["forum"]["comment"], $this->forum_id));
		}

		$DB->close();

		return $retval;
	}

	// Configuration & management.
	function return_config () {
		global $global;

		$main["forum_list"] = $this->return_forum_list();

		$retval = $this->Template->generate("/template/domain/forum", $main);

		return $retval;
	}

	function return_forum_info ($id=false) {
		global $global;

		if ($id) $this->set_id($id);

		$o = $this->get_info_by_id($this->id);

		// data handling
		$var["name"] = $o["name"];
		$var["no"] = $o["no"];
		$var["id"] = $o["id"];
		$var["message_size_limit"] = intval($o["message_size_limit"]) / 1000000 ;
		$var["domain_message_size_limit"] =
			intval($_SESSION["config_message_size_limit"]) / 1000000 ;

		if ($o["forum_type"] == "1") {
			$var["selected_1"] = "selected";
		} else {
			$var["selected_0"] = "selected";
		}

		$retval = $this->Template->generate("/template/domain/forum_info", $var);

		return $retval;
	}

	function return_forum_list () {
		global $global;

		$Forum_Priv = new Forum_Priv;
		$Forum_Priv->return_valid_forum();

		if (! is_array($Forum_Priv->valid_forum)) {
			$retval = false;
		} else {
			while (list($i, $j) = each($Forum_Priv->valid_forum)) {

				unset($var);
				$o = $this->get_info_by_id($i);

				$var["name"] = $o["name"];
				$var["id"] = $o["id"];

				if ($o["forum_type"] == "1") {
					$var["selected_1"] = "selected";
				} else {
					$var["selected_0"] = "selected";
				}

				$retval .= $this->Template->generate("/template/domain/forum_list_one", $var);
			}
		}

		return $retval;
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
