<?

include_once $global["root"] . "/lib/Template.php";
include_once $global["root"] . "/lib/Address.php";
include_once $global["root"] . "/lib/Directory.php";
include_once $global["root"] . "/lib/Item.php";

include_once $global["root"] . "/module/message/function/etc.php";

class card {

	var $Template;

	// SQL
	var $SQL_GET_ITEM = "select SQL_CACHE * from card_%s where no = '%s'";
	var $SQL_INSERT_ITEMS_TO_MODULE = "insert into card_%s
			(name, email, work_phone, home_phone, fax,
			mobile, zip_work, country_work, city_work,
			add_work, title_work, department_work,
			organization_work, zip_home, country_home,
			city_home, add_home, homepage, comment)
		values('%s', '%s', '%s', '%s', '%s', '%s', '%s',
			'%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s',
			'%s', '%s', '%s', '%s')";
	var $SQL_GET_CARD =
		"select SQL_CACHE
			name, email, work_phone, home_phone, fax, mobile, zip_work, country_work,
			city_work, add_work, title_work, department_work, organization_work,
			zip_home, country_home, city_home, add_home, homepage, comment, date
			from card_%s where no = '%s'";
	var $SQL_GET_CARD =
		"select SQL_CACHE
			name, email, work_phone, home_phone, fax, mobile, date
			from card_%s where no = '%s'";
	var $SQL_GET_CARD = "select SQL_CACHE
				name, email, work_phone, home_phone, fax, mobile, zip_work, country_work,
				city_work, add_work, title_work, department_work, organization_work,
				zip_home, country_home, city_home, add_home, homepage, comment, date
				from card_%s where no = '%s'";
	var $SQL_REMOVE_CARD_ITEM = "delete from card_%s where no = '%s'";
	var $SQL_SEARCH_CARD = "select SQL_CACHE no from card_%s where no = '%s' and (%s)";
	var $SQL_GET_SIZE =
		"select SQL_CACHE sum(length(name) + length(email) +
					length(work_phone) + length(home_phone) +
					length(fax) + length(mobile) +
					length(zip_work) + length(country_work) +
					length(city_work) + length(add_work) +
					length(title_work) + length(department_work) +
					length(organization_work) + length(zip_home) +
					length(country_home) + length(city_home) +
					length(add_home) + length(homepage) +
					length(comment)) as size from card_%s where %s";
	var $SQL_GET_CARD =
			"select SQL_CACHE
				name, email, work_phone, home_phone, fax, mobile, zip_work, country_work,
				city_work, add_work, title_work, department_work, organization_work,
				zip_home, country_home, city_home, add_home, homepage, comment, date
				from card_%s where no = '%s'";

	var $SQL_GET_CARD_LIST = "select SQL_CACHE
			no, name, email, work_phone, home_phone, mobile
			from card_%s %s %s";

	var $SQL_GET_CARD_LIST_BY_GROUP = "select SQL_CACHE
			no, name, email, work_phone, home_phone, mobile
			from card_%s where group_no = '%s'";

	var $card_key_alphabet = array("a", "b", "c", "d", "e", "f", "g", "h", "i", "j",
				"k", "l", "m", "n", "o", "p", "q", "r", "s", "t",
				"u", "v", "w", "x", "y", "z");

	var $card_key_hangul = array("b0a1" => "", "b3aa" => "",
		"b4d9" => "", "b6f3" => "", "b8b6" => "",
		"b9d9" => "", "bbe7" => "", "bec6" => "",
		"c0da" => "", "c2f7" => "", "c4ab" => "ī",
		"c5b8" => "Ÿ", "c6c4" => "", "c7cf" => "",
		"c8ff" => "");

	function Card () {
		$this->Template = new Template;
	}

	//-------------------------------------------------- action
	// $no is directory number.
	function add ($directory_num) {
		global $global, $string;

		$a["directory_num"] = $directory_num;

		if ($_GET["email"]) $a["email"] = $_GET["email"];
		if ($_GET["name"]) $a["name"] = $_GET["name"];

		$retval = $this->Template->generate("/module/card/template/add", $a);

		return $retval;
	}

	function copy ($no) {

		$DB = new MySQLdb;

		//------------ fetch from original data.
		$a = $DB->fetch_one(sprintf($this->SQL_GET_ITEM, $_SESSION["config_id"], $no));

		if (! $a["name"]) {
			$retval = false;
		} else {
			//------------ insert same data into doc_%s.
			$DB->query(sprintf($this->SQL_INSERT_ITEMS_TO_MODULE,
				$_SESSION["config_id"],
					addslashes($a["name"]), addslashes($a["email"]),
					addslashes($a["work_phone"]), addslashes($a["home_phone"]),
					addslashes($a["fax"]), addslashes($a["mobile"]),
					addslashes($a["zip_work"]), addslashes($a["country_work"]),
					addslashes($a["city_work"]), addslashes($a["add_work"]),
					addslashes($a["title_work"]), addslashes($a["department_work"]),
					addslashes($a["organization_work"]), addslashes($a["zip_home"]),
					addslashes($a["country_home"]), addslashes($a["city_home"]),
					addslashes($a["add_home"]), addslashes($a["homepage"]),
					addslashes($a["comment"])));

			$retval = $DB->retval;
		}

		if ($retval) {
			$retval = $DB->get_last_insert_id();
		}

		return $retval;
	}

	function remove ($no) {

		$DB = new MySQLdb;
		$DB->query(sprintf($this->SQL_REMOVE_CARD_ITEM, $_SESSION["config_id"], $no));

		$retval = $DB->retval;

		return $retval;
	}

	function edit ($no) {
		global $global, $string;

		$this->Template = new Template;
		$DB = new MySQLdb;

		$o = $DB->fetch_one(sprintf($this->SQL_GET_CARD, $_SESSION["config_id"], $no));

		$main = escapeHTMLCode($o);
		$main["no"] = $no;

		$retval =
			$this->Template->generate("/module/card/template/edit", $main);

		return $retval;
	}

	function info ($no) {
		global $global, $string;

		$DB = new MySQLdb;
		$o = $DB->fetch_one(sprintf($this->SQL_GET_CARD, $_SESSION["config_id"], $no));

		if (! $o["name"]) {
			$a = false;
		} else {
			$author = $o["name"];

			if ($o["mobile"]) {
				$b = $o["mobile"];
			} else if ($o["work_phone"]) {
				$b = $o["work_phone"];
			} else if ($o["home_phone"]) {
				$b = $o["home_phone"];
			} else if ($o["fax"]) {
				$b = $o["fax"];
			}

			if (! $o["email"] and ! $b) {
				$a["title"] = sprintf("<span class=\"read\">%s</span>", $string["card28"]);
			} else {
				$a["title"] = sprintf("%s - %s", htmlspecialchars($b), $o["email"]);
			}

			$a["createdTime"] = $o["date"];

			$a["author"]["short"] = $o["name"];
			$a["author"]["full"] = $o["email"];

			$a["flag"] = ""; // card does not have read/unread state, it's just a card.
		}

		$retval = $a;

		return $retval;
	}

	function print_view ($no) {
		global $global, $string;

		$DB = new MySQLdb;
		$this->Template = new Template;

		$o = $DB->fetch_one(sprintf($this->SQL_GET_CARD, $_SESSION["config_id"], $no));

		$one = $o;
		$main["name"] = $o["name"];
		$main["no"] = $no;
		$main["date"] = print_time($o["date"], "simple");

		//
		if ($one["email"] or $one["homepage"]) {

			if ($o["email"]) {
				$one["email"] =
					sprintf("<a href=\"%s/mail?mode=add&no=1&address=%s\">%s</a>",
						$_SESSION["user_www_url"], $o["email"], $o["email"]);
			}

			if ($o["homepage"]) {
				if (eregi("^http://", trim($o["homepage"]))) {
					$one["homepage"] =
						sprintf("<a href=\"%s\">%s</a>", $o["homepage"], $o["homepage"]);
				} else {
					$one["homepage"] =
						sprintf("<a href=\"http://%s\">%s</a>",
							$o["homepage"], $o["homepage"]);
				}
			}

			$main["card_internet"] =
				$this->Template->generate("/module/card/template/card_internet", $one);
		}

		//
		if ($one["work_phone"] or $one["home_phone"] or $one["fax"] or $one["mobile"]) {
			$main["card_phone"] =
				$this->Template->generate("/module/card/template/card_phone", $one);
		}

		//
		if ($one["zip_work"] or $one["country_work"] or
				$one["city_work"] or $one["add_work"] or
				$one["title_work"] or $one["department_work"] or
				$one["organization_work"]) {
			$main["card_work"] =
				$this->Template->generate("/module/card/template/card_work", $one);
		}

		//
		if ($one["zip_home"] or $one["country_home"] or
				$one["city_home"] or $one["add_home"]) {
			$main["card_home"] =
				$this->Template->generate("/module/card/template/card_home", $one);
		}

		//
		if ($o["comment"]) {
			$main["comment"] = wordwrap(htmlspecialchars($o["comment"]), 90, "\n");
			$main["card_comment"] =
				$this->Template->generate("/module/card/template/card_comment", $one);
		}

		$retval = $this->Template->generate("/module/card/template/print_view", $main);

		return $retval;
	}

	function search ($str, $data, $case="", $all="0") {
		global $global, $string;

		$DB = new MySQLdb;
		$Directory = new myDirectory;
		$this->Template = new Template;

		if ($all != "1") {
			$a = preg_split("/ \t*/", $str);

			$col = array("name", "email", "work_phone", "home_phone", "fax",
						"mobile", "zip_work", "country_work", "city_work",
						"add_work", "title_work", "department_work",
						"organization_work", "zip_home", "country_home",
						"city_home", "add_home", "homepage", "comment");

			if ($case) {
				while (list($i, $j) = each($col)) {
					$c[] = sprintf("%s regexp binary '%s'", $j, $str);
				}
			} else {
				$b = "%" . addslashes(implode("%", $a)) . "%";

				while (list($i, $j) = each($col)) {
					$c[] = sprintf("%s like '%s'", $j, $b);
				}
			}

			$d = implode(" or ", $c);
		}

		while (list($i, $j) = each($data)) {

			if ($all != "1") {
				$o = $DB->fetch_one(
					sprintf($this->SQL_SEARCH_CARD, $_SESSION["config_id"], $i, $d));

				if (! $o["no"]) continue;
			}

			$b = $this->info($i);

			//--------------------------------------------------
			// data handling
			$c["createdTime"] = print_time($b["createdTime"], "simple");

			if ($b["author"]["short"]) {
				$c["author"] = $b["author"]["short"];
			} else {
				$c["author"] = $b["author"]["full"];
			}

			$c["author"] = wordwrap($c["author"], 15, "<br>");

			$c["title"] = sprintf("<a href=\"%s/mail?no=%s&mode=view\">%s</a>",
				$_SESSION["user_www_url"], $j["no"], $b["title"]);

			$c["icon"] = sprintf("<img class=\"mesian\" src=\"%s/module/card/image/content_type-25.png\">",
				$_SESSION["user_www_url"]);

			$Directory->no = $j["directory_num"];

			$c["directory"] =
				sprintf("<a href=\"%s/mail?no=%s\">%s</a>",
					$_SESSION["user_www_url"], $j["directory_num"],
					$Directory->get_name());

			$main["content"] .=
				$this->Template->generate("/module/item/template/search_result_line", $c);
		}

		$main["module_name"] = "Name Card";

		$retval =
			$this->Template->generate("/module/item/template/search_result_module", $main);

		return $retval;

	}

	function size ($no) {

		if (! is_array($no)) {
			$retval = 100;
		} else {
			$retval = 100 * count($no);
		}

		return $retval;
	}

	function view ($no, $item_num) {
		global $global, $string;

		$DB = new MySQLdb;
		$this->Template = new Template;

		$o = $DB->fetch_one(sprintf($this->SQL_GET_CARD, $_SESSION["config_id"], $no));

		$one = $o;
		$main["name"] = $o["name"];
		$main["no"] = $no;
		$main["date"] = print_time($o["date"], "simple");
		$main["item_num"] = $item_num;

		if ($one["email"] or $one["homepage"]) {

			if ($o["email"]) {
				$one["email"] =
					sprintf("<a href=\"%s/mail?mode=add&no=1&address=%s\">%s</a>",
						$_SESSION["user_www_url"], $o["email"], $o["email"]);
			}

			if ($o["homepage"]) {
				if (eregi("^http://", trim($o["homepage"]))) {
					$one["homepage"] =
						sprintf("<a href=\"%s\">%s</a>", $o["homepage"], $o["homepage"]);
				} else {
					$one["homepage"] =
						sprintf("<a href=\"http://%s\">%s</a>",
							$o["homepage"], $o["homepage"]);
				}
			}

			$main["card_internet"] =
				$this->Template->generate("/module/card/template/card_internet", $one);
		}

		if ($one["work_phone"] or $one["home_phone"] or $one["fax"] or $one["mobile"]) {
			$main["card_phone"] =
				$this->Template->generate("/module/card/template/card_phone", $one);
		}

		if ($one["zip_work"] or $one["country_work"] or
				$one["city_work"] or $one["add_work"] or
				$one["title_work"] or $one["department_work"] or
				$one["organization_work"]) {
			$main["card_work"] =
				$this->Template->generate("/module/card/template/card_work", $one);
		}

		//
		if ($one["zip_home"] or $one["country_home"] or
				$one["city_home"] or $one["add_home"]) {
			$main["card_home"] =
				$this->Template->generate("/module/card/template/card_home", $one);
		}

		//
		if ($o["comment"]) {
			$main["comment"] = wordwrap(htmlspecialchars($o["comment"]), 90, "\n");
			$main["card_comment"] =
				$this->Template->generate("/module/card/template/card_comment", $one);
		}

		$retval = $this->Template->generate("/module/card/template/view", $main);

		return $retval;
	}

	function return_list($str=false, $email=false) {

		if (is_string($str)) { // check whether multibyte or not.
			$isHangul = false;

			$a = intval(ord($str[0]));
			if ($a > 127) {
				$isHangul = true;
			} else {
				$isHangul = false;
			}
		}

		$card_key_hangul2 = array_keys($this->card_key_hangul);

		// set character key.
		if ($isHangul) {
			$b = bin2hex($str);

			while (list($i, $j) = each($card_key_hangul2)) {
				if ($b >= $j and $b < $card_key_hangul2[$i + 1]) {
					$ky = $this->card_key_hangul[$j];
					$ky_key = $i;
					break;
				}
			}
			$query_key = "";
		} else {
			$ky = strtoupper($str[0]);
			$query_key = sprintf(" where name rlike '^%s'", strtolower($str[0]));
		}

		// get in trash card, remove it.
		$Item = new Item;
		$items_in_trash = $Item->get_in_trash($_SESSION["user_item_type_rv"]["card"]);

		if (count($items_in_trash) > 0) {
			while (list($i, $j) = each($items_in_trash)) {
				$c[] = sprintf("no != '%s'", $j);
			}

			$add_query = sprintf(" and (%s)", implode(" and ", $c));
		}

		// data handling.
		$DB = new MySQLdb;
		$DB->query(sprintf(
			$this->SQL_GET_CARD_LIST, $_SESSION["config_id"], $query_key, $add_query), true);

		for ($i = 0; $i < $DB->num_rows; $i++) $o[] = $DB->fetch();

		while (list($i, $j) = each($o)) {
			if (! trim($j["name"])) continue;

			// check whether name has key.
			if ($isHangul) {
				$a = bin2hex(substr($j["name"], 0, 2));
				if ($a < $card_key_hangul2[$ky_key] or $a >= $card_key_hangul2[$ky_key + 1]) {
					continue;
				}
			}

			$Item = new Item;
			$var = $j;
			$var["no_item"] = $Item->get_no($j["no"], $_SESSION["user_item_type_rv"]["card"]);

			if (! $var["no_item"]) continue;

			$ret[$i] = $var;

			$ret["email"][$i] = $j["email"];
		}

		$ret["ky"] = $ky;

		return $ret;
	}

	function return_select_form () {
		global $global, $string;

		$o = $this->return_list($_GET["s"], true);

		//-------------------------------------------------- card key list.
		reset($this->card_key_hangul);
		while (list($i, $j) = each($this->card_key_hangul)) {
			$a[] = sprintf("<a href=\"?s=$j\"
				><span class=\"impact1\">%s</span></a>", $j, $j);
		}

		reset($this->card_key_alphabet);
		while (list($i, $j) = each($this->card_key_alphabet)) {
			$b[] = sprintf("<a href=\"?s=$j\"
				><span class=\"impact1\">%s</span></a>", $j, $j);
		}

		$one["keys_hangul"] = sprintf("%s", implode("&nbsp;&nbsp;", $a));
		$one["keys_alphabet"] = sprintf("%s", implode("&nbsp;&nbsp;", $b));

		$one["this_key"] = $o["ky"];
		//--------------------------------------------------

		if (count($o) < 2) {
			$retval =
				$this->Template->generate(
					"/module/card/template/card_select_form_empty", $one);
		} else {
			if (count($o["email"]) > 0) {
				$email_array = array_unique($o["email"]);
			} else {
				$email_array = array();
			}

			$is_empty = true;
			$Address = new Address;

			while (list($i, $j) = each($o)) {
				if ($i === "ky") continue;
				if (! $Address->check_valid($j["email"])) continue;
				if (! array_key_exists($i, $email_array)) continue;

				$var = $j;
				$is_empty = false;

				$one["content"] .= $this->Template->generate(
						"/module/card/template/card_select_form_one", $var);
			}

			if ($is_empty) {
				$retval =
					$this->Template->generate(
						"/module/card/template/card_select_form_empty", $one);
			} else {
				$retval =
					$this->Template->generate("/module/card/template/card_select_form", $one);
			}
		}

		return $retval;
	}

	function return_manage_list ($type="card", $args=false) {

		switch ($type) {
			case ("group") :
				$retval = $this->return_manage_list_group($args);
			break;
			default :
				$retval = $this->return_manage_list_card();
		}

		return $retval;
	}

	var $SQL_GET_GROUP = "select no, name from card_group_%s";

	// argument group is int number.
	function return_manage_list_group () {
		global $global, $string;

		$DB = new MySQLdb;

		// get all list of group.
		$DB->query(sprintf($this->SQL_GET_GROUP, $_SESSION["config_id"]), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();
			$list_group[$o["no"]] = $o["name"];
		}

		// find card list in each group.
		if ($_GET["group_no"]) {
			$DB->query(
				sprintf($this->SQL_GET_CARD_LIST_BY_GROUP,
					$_SESSION["config_id"], $_GET["group_no"]),
				true
			);

			if ($DB->num_rows < 1) {
					$one["content"] =
						$this->Template->generate("/module/card/template/card_list_one_empty");
			} else {
				for ($i = 0; $i < $DB->num_rows; $i++) {
					$o = $DB->fetch();

					$one["content"] .=
						$this->Template->generate("/module/card/template/card_list_one", $o);
				}
			}

			$var["content"] =
				$this->Template->generate("/module/card/template/card_list1", $one);
			$list_card[$_GET["group_no"]] =
				$this->Template->generate("/module/card/template/card_list_in_group", $var);
		}

		if (count($list_group) > 0) {
			while (list($i, $j) = each($list_group)) {
				$var["no"] = $i;
				$var["name"] = $j;
				$var["card_list"] = $list_card[$i];
				$var1["content"] .=
					$this->Template->generate("/module/card/template/group_one", $var);
			}
		}

		$retval =
				$this->Template->generate("/module/card/template/group_list", $var1);

		return $retval;
	}

	function return_manage_list_card () {
		global $global, $string;

		$o = $this->return_list($_GET["s"], true);

		while (list($i, $j) = each($this->card_key_hangul)) {
			$a[] = sprintf(
				"<a href=\"%s/mail?mode=card_list&s=%s\"
					><span class=\"impact1\">%s</span></a>",
					$_SESSION["user_www_url"], $j, $j);
		}

		while (list($i, $j) = each($this->card_key_alphabet)) {
			$b[] = sprintf("<a href=\"%s/mail?mode=card_list&s=%s\"
				><span class=\"impact1\">%s</span></a>", $_SESSION["user_www_url"], $j, $j);
		}

		//-------------------------------------------------- card key list.
		$one["keys_hangul"] = sprintf("%s", implode("&nbsp;&nbsp;", $a));
		$one["keys_alphabet"] = sprintf("%s", implode("&nbsp;&nbsp;", $b));

		if ($_GET["s"]) {
			$one["this_key"] = $o["ky"];
		} else {
			$one["this_key"] = "All";
		}
		//--------------------------------------------------

		if (count($o) < 2) {
			$retval =
				$this->Template->generate("/module/card/template/card_list_empty", $one);
		} else {
			$is_empty = true;
			if (count($o["email"]) > 0) {
				$email_array = array_unique($o["email"]);
			} else {
				$email_array = array();
			}

			while (list($i, $j) = each($o)) {
				if ($i === "ky") continue;
				if ($i === "email") continue;
				if ($j["email"] and ! array_key_exists($i, $email_array)) continue;

				$var = $j;

				//data handling.
				if ($j["work_phone"]) {
					$var["phone"] = $j["work_phone"];
				} else if ($j["mobile"]) {
					$var["phone"] = $j["mobile"];
				} else if ($j["home_phone"]) {
					$var["phone"] = $j["home_phone"];
				}

				$is_empty = false;
				$one["content"] .= $this->Template->generate(
						"/module/card/template/card_list_one", $var);
			}

			if ($is_empty) {
				$retval =
					$this->Template->generate(
						"/module/card/template/card_list_empty", $one);
			} else {
				$retval =
					$this->Template->generate("/module/card/template/card_list", $one);
			}
		}

		return $retval;
	}

	function control ($no="0") {
		global $global, $string;

		if (! $no or $no == "") $no = "0";

		switch ($no) {
			// card select form, ordered by first character.
			case ("0") :
				$retval["label"] =
					sprintf("<span class=\"label2\">%s</span>", $string["card29"]);
				$retval["content"] = $this->return_manage_list();
			break;
		}

		return $retval;
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
