# -*- coding: utf-8 -*-
import os
import config, sql
import myMySQLdb, message, MailFilter

class Save :

	__db = None

	def __init__ (self, **kwd) :

		self.__db = kwd["db"]

	def close (self) :
		pass

	def save (self) :

		# read file list in config.qmail["directory"]["message"]
		try :
			os.chdir(config.qmail["directory"]["message"])
		except OSError :
			raise OSError, \
				"No such file or directory, %s" % config.qmail["directory"]["message"]
		else :
			for i in os.listdir(".") : # read current directory.

				f_path = "%s/%s" % (config.qmail["directory"]["message"], i)

				if os.path.isdir(f_path) : continue
				if os.path.islink(f_path) : continue
				if os.path.isfile(f_path) :

					address = str(i.split("-")[0])

					# check filename is valid or not. If not, remove file.
					if not message.is_valid_address(address) :
						self.remove(f_path)
						continue

					# read message from file
					try :
						msg = "".join(open(f_path, "r").readlines())
					except :
						self.remove(f_path)
						continue

					# apply GLOBAL filter.
					if not self.run_filter(msg) :
						self.remove(f_path)
						continue

					# insert message.
					if not self.insert_message(address, msg) :
						self.remove(f_path)
						continue

					# remove file.
					self.remove(f_path)

	def remove (self, filename) :
		try :
			os.remove(filename)
		except :
			retval = False
		else :
			retval = True

		return retval

	def run_filter (self, msg) :

		F = MailFilter.Filter(self.__db, "global")

		# If message is normal messages, F.apply(..) returns only -2.
		if F.apply(msg) != -2 :
			retval = False
		else :
			retval = True

		return retval

	def insert_message (self, address, msg) :

		DB = myMySQLdb.myMySQLdb(self.__db)
		DB.start_transaction(True)

		DB.query( \
			sql.SQL_INSERT_QUEUE_INCOMING % (address, myMySQLdb.escape_string(msg) )\
		)

		retval = DB.retval
		DB.close()

		return retval



__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Save.py"


# Mesian is Webmail.
#
# Copyright (C) 2003 Spike^ekipS <spike@spikeekips.net>
#
# Adapted from mesian :
#  Copyright (C) 2003  Spike^ekipS <spike@spikeekips.net>
#
# Contact: mailto:spike@spikeekips.net
# Original site: http://mesian-devel.spikeekips.net/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Spike^ekipS
#	mailto:spike@spikeekips.net
#
# Original page :
#	http://mesian-devel.spikeekips.net/
#
# Original mesian :
#	Spike^ekipS
#	spike@spikeekips.net
#	Haman Korea


