import message, sql, myMySQLdb

class Privilege :

	username = None
	domain = None

	user_id = None
	domain_id = None

	db = None

	is_valid_user = False
	is_valid_domain = False

	is_escape_domain = False

	def __init__ (self, db, address) :

		self.db = db

		(self.username, self.domain) = message.parse_address(address)

	def check (self) :

		self.__initializing_value()

		user_no = self.get_user_alias()
		if not user_no :
			self.user_id = self.get_user_id()
		else :
			self.user_id = self.get_user_id(user_no)

		if self.is_valid_user :
			self.domain_id = self.get_domain_id()

	def get_user_alias (self) :

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_CHECK_USER_ALIAS % (self.username, self.domain), True)

		if DB.num_rows < 1 :
			retval = False
		else :
			a = DB.fetch()

			if a["valid"] == "0" :
				retval = False
			else :
				retval = a["user_no"]

		DB.close()

		return retval

	def __initializing_value (self) :
		self.forward = None
		self.is_valid_user = False
		self.is_escape_domain = False

	def get_user_id (self, id=None) :
		""" """

		if id :
			query = sql.SQL_CHECK_USER1 % id
		else :
			query = sql.SQL_CHECK_USER % (self.username, self.domain)

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(query, True)

		if DB.num_rows < 1 :
			self.is_vaild_user = False
			retval = None
		else :
			a = DB.fetch()

			self.username = a["name"]
			self.domain = a["domain"]

			if a["valid"] == "0" :
				self.is_valid_user = False
				retval = None
			else :
				self.is_valid_user = True
				retval = a["id"] # set id.

			if a["escape_filter_domain"] == "1" :
				self.is_escape_domain = True
			else :
				self.is_escape_domain = False

			if a["forward"] == "" :
				self.forward = None
			else :
				self.forward = a["forward"]

		DB.close()

		return retval

	def get_domain_id(self) :
		""" """

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_CHECK_DOMAIN % self.domain, True)

		if DB.num_rows < 1 :
			self.is_vaild = False
			retval = None
		else :
			a = DB.fetch()

			if a["valid"] == "0" :
				self.is_valid_domain = False
				retval = None
			else :
				self.is_valid_domain = True
				retval = a["id"]

		DB.close()

		return retval

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Privileges.py"


# Mesian is Webmail.
#
# Copyright (C) 2003 Spike^ekipS <spike@spikeekips.net>
#
# Adapted from mesian :
#  Copyright (C) 2003  Spike^ekipS <spike@spikeekips.net>
#
# Contact: mailto:spike@spikeekips.net
# Original site: http://mesian-devel.spikeekips.net/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Spike^ekipS
#	mailto:spike@spikeekips.net
#
# Original page :
#	http://mesian-devel.spikeekips.net/
#
# Original mesian :
#	Spike^ekipS
#	spike@spikeekips.net
#	Haman Korea


