import time, os
import sql, config, strings
import message, myMySQLdb, MailFilter
import message_db, Privilege, Quota, Send

class Deliver :

	f = None
	t = None
	entireMessage = None
	msg = None
	STATE = None

	db = None

	direction = None

	def __init__ (self, **kwargs) :
		""" kwargs["direction"] : Incoming/Outgoing """

		self.db = kwargs["db"]

		#-------------------------------------------------- set direction
		self.direction = kwargs["direction"]

	def close (self) :
		pass

	def deliver (self) :
		""" Deliver Message into in / out. """

		if self.direction == "Incoming" :
			retval = self.get()
		elif self.direction == "Outgoing" :
			retval = self.send()
		else :
			retval = False

		return retval

	#-------------------------------------------------- message handling
	def __delete_queue (self, no) :

		DB = myMySQLdb.myMySQLdb(self.db, True)

		DB.query(sql.SQL_DELETE_QUEUE % (self.direction,no))

		DB.close()

	def __delete_queue_all (self, no) :

		DB = myMySQLdb.myMySQLdb(self.db, True)

		DB.query(sql.SQL_DELETE_QUEUE_ALL % self.direction)

		DB.close()

	def __generate_message (self, entireMessage, no) :
		""" Parsing a entireMessage """

		try :
			msg = message.message(entireMessage)
		except :
			self.__delete_queue(no) # if message is not well-formed, delete it.
			retval = False
		else :
			if not msg.isMessage() : # check whether a proper message or not.
				self.__delete_queue(no)
				retval = False
			else :
				retval = msg.getAll()

		return retval

	def __run_filter (self, Privilege, address, entireMessage) :
		"""
		* return value
			-1		: remove this message
			None	: pass this message
			other	: directory number to insert
		"""

		# set default
		directory_num = None
		remove = False

		filtered_globally = False
		filtered_domain = False

		F = MailFilter.Filter(self.db)

		# global filtering
		F.set_name_space("global")
		ret_filter = F.apply(entireMessage)

		if ret_filter == -1 : # check
			remove = True # stop
			filtered_globally = True
		elif ret_filter == -2 :
			pass
		else :
			directory_num = ret_filter
			filtered_globally = True

		# domain filtering
		if not filtered_globally and not remove and \
				Privilege.is_valid_domain and Privilege.domain_id \
				and not Privilege.is_escape_domain :

			F.set_name_space("domain", Privilege.domain_id)
			ret_filter = F.apply(entireMessage)

			if ret_filter == -1 : # check
				remove = True # stop
				filtered_domain = True
			elif ret_filter == -2 :
				pass
			else :
				directory_num = ret_filter
				filtered_domain = True

		# user filtering
		if not (filtered_globally and filtered_domain) and \
				not remove :

			F.set_name_space("user", Privilege.user_id)
			ret_filter = F.apply(entireMessage)

			if ret_filter == -1 : # check
				self.__delete_queue(no)

				remove = True # stop
			elif ret_filter == -2 :
				pass
			else :
				directory_num = ret_filter

		if remove :
			retval = -1
		else :
			retval = directory_num

		return retval

	#-------------------------------------------------- get start
	def get (self) :

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_SELECT_QUEUE_ALL_NO % self.direction)

		#for i in range(0, n) :
		if DB.num_rows > 0 :
			one = True
		else :
			one = False

		retval = False

		if one == True :
			DB.query(sql.SQL_SELECT_QUEUE_ALL % self.direction, True)

			for i in range(DB.num_rows) :

				one = DB.fetch()
				if one == -1 : break

				#-------------------------------------------------- data handling
				(no, To, entireMessage, r) = \
					(int(one["no"]), one["Toaddr"], one["entireMessage"], one["result"])

				if len(To.split("@")) < 1 :
					self.__delete_queue(no)
					continue
				elif len(To.split("@")) < 2 :
					To = "%s@%s" % (To, config.default["domain"])

				address = To
				(username, domain) = message.parse_address(To)

				#-------------------------------------------------- Privilege check
				P = Privilege.Privilege(self.db, address)
				P.check()

				#-------------------------------------------------- FORWARD
				# if forward was set, send a message to forwarding target.
				if P.forward :
					modified_message = message.replace_header("To", P.forward, entireMessage)

					if modified_message :

						del entireMessage

						SS = Send.Send()
						if SS.send( \
								To=P.forward, From=config.default["postmaster"], \
								message=modified_message) :

							self.__delete_queue(no)

					continue

				if not P.is_valid_user :
					unKnown = True
					directory_num = None
				else :
					unKnown = False

					#-------------------------------------------------- QUOTA START
					Q = Quota.Quota(self.db, address)
					Q.check()
					# overquota
					if Q.is_max_overquota :

						SS = Send.Send()
						SS.send( \
								To=address, From=config.default["postmaster"], \
								message=strings.MESSAGE_OVERQUOTA % {"address": address})

						self.__delete_queue(no)
						continue
					#-------------------------------------------------- QUOTA END

					#-------------------------------------------------- FILTER START
					filter_result = self.__run_filter(P, address, entireMessage)

					if filter_result == -1 or filter_result == 0 : # remove
						self.__delete_queue(no)
						continue
					elif filter_result == None : # default operation
						#----------------------------------------- CARD CHECK START
						C = MailFilter.AddressBook(self.db, P.user_id)
						if C.check(entireMessage) :
							directory_num = 1
						#----------------------------------------- CARD CHECK END
						else :
							directory_num = config.default["item"]["default"]

					else : # filtered
						directory_num = filter_result
					#-------------------------------------------------- FILTER END

				# get message
				MSG = self.__generate_message(entireMessage, no)

				if not MSG : # if message is not well-formed, remove it.
					self.__delete_queue(no)
					continue

				MSG["address"] = address
				MSG["username"] = username
				MSG["domain"] = domain
				MSG["date"] = int(time.time())

				# insert message into DB.
				msgDB = message_db.message_db(self.db, unKnown, message = MSG)

				retval = msgDB.insert(directory_num) # insert message

				self.__delete_queue(no) # delete message from queue

		return retval

	#-------------------------------------------------- send start
	def send (self) :

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_SELECT_QUEUE_ALL_NO % self.direction)

		#for i in range(0, n) :
		if DB.num_rows > 0 :
			one = True
		else :
			one = False

		if one == False :
			retval = False
		else :
			DB.query(sql.SQL_SELECT_QUEUE_ALL % self.direction, True)

			SS = Send.Send()

			for i in range(DB.num_rows) :

				one = DB.fetch()
				if one == -1 : break

				#-------------------------------------------------- data handling
				(no, From, To, entireMessage, m, r) = \
					(one["no"], one["Fromaddr"], one["Toaddr"], \
					one["entireMessage"], one["method"], one["result"])

				if not message.is_valid_address(From) :
					From = "%s@%s" % (From, config.default["domain"])

				if not message.is_valid_address(To) :
					To = "%s@%s" % (To, config.default["domain"])

				address = From
				(username, domain) = message.parse_address(From)

				# if sending a message was failed, that message will be
				# checked in result.
				if not SS.send(From=From, To=To, message=entireMessage) :

					DB.start_transaction(True)
					DB.query(sql.SQL_QUEUE_OUTGOING_SET_RESULT_NOTDELETED % no)
					DB.stop_transaction()

					retval = False
				else :
					# parse message
					#MSG = self.__generate_message(entireMessage, no)

					#if not MSG :
					#	self.__delete_queue(no)
					#	continue

					#MSG["address"] = address
					#MSG["username"] = username
					#MSG["domain"] = domain
					#MSG["date"] = int(time.time())

					# insert message into DB.
					#msgDB = message_db.message_db(self.db, message = MSG)

					# If m was checked, insert into DRAFT(2).
					#if msgDB.insert(config.default["item"]["sent"], one["message_id"], "sent") :
					#	self.__delete_queue(no) # delete message from queue

					self.__delete_queue(no) # delete message from queue

					retval = True

		return retval

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Deliver.py"


# Mesian is Webmail.
#
# Copyright (C) 2003 Spike^ekipS <spike@spikeekips.net>
#
# Adapted from mesian :
#  Copyright (C) 2003  Spike^ekipS <spike@spikeekips.net>
#
# Contact: mailto:spike@spikeekips.net
# Original site: http://mesian-devel.spikeekips.net/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Spike^ekipS
#	mailto:spike@spikeekips.net
#
# Original page :
#	http://mesian-devel.spikeekips.net/
#
# Original mesian :
#	Spike^ekipS
#	spike@spikeekips.net
#	Haman Korea


