import MySQLdb
import _mysql, sys

class myMySQLdb :

	#-------------------------------------------------- sql query
	SQL_PASSWORD_GEN = "select password('%s')"
	SQL_START_TRANSACTION = "set autocommit=0"
	SQL_STOP_TRANSACTION = "set autocommit=1"

	connection = None
	cursor = None

	transaction = False
	transactioned = False

	retval = False # query return value

	field_name = []

	def __init__(self, db=None, transaction=False) :

		if db :
			try :
				db.connection.cursor().close()
			except :
				pass

			self.connection = db.connection

			try :
				self.cursor = db.connection.cursor()
			except :
				self.cursor = None
				self.connection = None

			if transaction : self.transaction = True

			self.start_transaction()

	def ping (self) :
		""" Check whether Database Server is live or not. """

		try :
			self.connection.ping()
		except  :
			retval = False
		else :
			retval = True

		return retval

	def connect (self, config) :

		if not isinstance(self.connection, _mysql.connection) :
			if (config.has_key("port") and config.has_key("unix_socket")) :
				if config["unix_port"] and config["host"] in ("localhost", "127.0.0.1") :
					del config["port"]
				else :
					del config["unix_socket"]

			try :
				self.connection = apply(MySQLdb.connect, "", config)
			except :
				self.connection = None

				raise ValueError, "Can not connect to db."
			else :
				self.cursor = self.connection.cursor()

	def quit(self) :
		""" Quit the connection from mysql server. """

		self.close()

		if isinstance(self.connection, _mysql.connection) :
			self.connection.close() # quit server.

			self.cursor = None
			self.connection = None
		else :
			pass

	def close (self) :

		if self.ping() : self.stop_transaction()

	#------------------------------ Transaction
	def start_transaction (self, transaction=False) :

		if self.ping() :
			if transaction : self.transaction = True

			if self.transaction :
				try :
					self.cursor.execute(self.SQL_START_TRANSACTION)
				except :
					self.transaction = False
			else :
				try :
					self.cursor.execute(self.SQL_STOP_TRANSACTION)
				except :
					self.transaction = False

		return self.transaction

	def stop_transaction (self) :

		if self.ping() and self.transaction and not self.transactioned :

			self.transactioned = True

			if self.retval :
				self.connection.commit()
			else :
				self.connection.rollback()

		return True

	#-------------------------------------------------- execute
 	def query_all(self, command) :
 		""" select all data. """

		if not self.ping() :
			retval = False
		else :
			try :
				self.cursor.execute(command)
			except :
				retval = False
				self.retval = False
			else :
				retval = self.cursor.fetchall()
				self.retval = True

 		return retval

	def query(self, command, as_dict=False) :
		""" Execute query. """

		self.field_name = []

		self.num_rows = 0

		if not self.ping() :
			retval = False
		else :

			try :
				self.cursor.execute(command)
			except :
				retval = False
			else :
				retval = True

				# make result as dict.
				try :
					self.num_rows = int(self.connection.affected_rows())
				except :
					self.num_rows = 0
				else :
					if as_dict :
						self.field_name = map(lambda i: i[0], list(self.cursor.description))

			self.retval = retval

		return retval

	def fetch (self) :
		"""
		return value
			-1 : no more data
		"""

		if not self.ping() :
			retval = False
		else :
			try :
				ret = self.cursor.fetchone()
			except :
				ret = False

			if len(self.field_name) > 0 :
				retval = dict(map(lambda i, j : (i, j), self.field_name, ret))
			else :
				retval = ret

		return retval

	def fetch_one (self, command) :
		"""
		return value
			-1 : no more data
		"""

		self.query(command, True)

		try :
			ret = self.cursor.fetchone()
		except :
			ret = False

		if len(self.field_name) > 0 :
			retval = dict(map(lambda i, j : (i, j), self.field_name, ret))
		else :
			retval = ret

		return retval

	#-------------------------------------------------- specific methods
	def set_db(self, database_name) :

		if not self.ping() :
			retval = False
		else :
			try :
				self.cursor.execute("use %s" % database_name)
			except :
				retval = True
			else :
				retval = False

		return retval

	def get_password(self, password) :

		if not self.ping() :
			retval = False
		else :
			try :
				var = self.cursor.execute(self.SQL_PASSWORD_GEN % password)
			except :
				retval = False
			else :
				retval = var[0]

		return retval

#-------------------------------------------------- etc functions
def escape_string (data=None) :

	if not data or data.strip() == "" :
		retval = ""
	else :
		retval = MySQLdb.escape_string(data).replace(";","\\;")

	return retval

"""
MySQL wrapper class.

  host -- string, host to connect
  user -- string, user to connect as
  passwd -- string, password to use
  db -- string, database to use
  port -- integer, TCP/IP port to connect to
  unix_socket -- string, location of unix_socket (UNIX-ish only)
  conv -- mapping, maps MySQL FIELD_TYPE.* to Python functions which
          convert a string to the appropriate Python type
  connect_timeout -- number of seconds to wait before the connection
          attempt fails.
  compress -- if set, gzip compression is enabled
  named_pipe -- if set, connect to server via named pipe (Windows only)
  init_command -- command which is run once the connection is created
  read_default_file -- see the MySQL documentation for mysql_options()
  read_default_group -- see the MySQL documentation for mysql_options()

ChangeLog
----------
Fri Mar  7 04:43:01 KST 2003
- transaction code added.

Thu Jun 12 06:08:54 KST 2003
- new execute query style applied.

Sun Jun 15 03:28:46 KST 2003
- num_rows does not reference the return value of cursor.execute(query) any more. Fix it
  to reference num_rows to connection.affected_rows().

"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

