import config
import email
from email import Header
import sre

#------------------------------------------------------------------ message
class message :

	textBody = ""
	htmlBody = ""

	body = False
	payload = False
	cid = False

	isPayload = False
	isCid = False

	isEgg = False
	egg = None

	reA = sre.compile("=\?")
	reB = sre.compile("^<")
	reC = sre.compile(">$")

	def __init__ (self, message) :
		"message must be one of file descriptor or strings."

		self.entireMessage = message

		self.__loadMessage(message)

		if self.isMessage() :
			self.__generateContent()

	def __loadMessage (self, message) :
		""" Load entire message from string / file """

		if type(message) == str :
			self.msg = email.message_from_string(message)
		elif type(message) == file  :
			self.msg = email.message_from_file(message)
		else :
			raise IOError, "Argument 'message' must be one of file descriptor or strings."

	def __reloadMessage (self, message) :
		""" Re-Load entire message """

		self.__loadMessage(message)

	def isMessage (self) :
		if not self.msg.values() :
			retval = False
		else :
			retval = True

		return retval

	def __decode (self, var, getValue=False) :

		H = Header.decode_header(var)

		if len(H) < 2 :
			if H[0][1] is None :
				retval = H[0][0]
			else :
				retval = unicode(H[0][0], H[0][1]).encode(config.default["encoding"])
		else :
			if getValue :
				retval = unicode(H[1][0], H[1][1]).encode(config.default["encoding"])
			else :
				b = []
				for i in H :
					b.append(unicode(i[0], i[1]).encode(config.default["encoding"]))

				retval = "".join(b)

		return retval

	def __headerItemsDecode (self) :
		"Reassign msg.items() values as a decoded strings."

		a = []

		for i in self.msg.items() :
			h = []
			h.append(i[0])
			h.append(self.__decode(i[1]))

			a.append(tuple(h))

		retval = a

		return retval

	def getHeader (self, type="str") :
		"Returns a full header."

		if self.isEgg and self.egg : self.msg = self.egg

		a = self.__headerItemsDecode()

		if type == "str" :

			b = []
			for i in a :
				d = "%s" % ": ".join(i).replace("\t","")
				b.append(d)

			retval = "\n".join(b)
		elif type == "dict" :
			b = {}
			for i in a :
				d = "%s" % ": ".join(i).replace("\t","")
				b[i[0]] = i[1]

			retval = b
		else :
			retval = a

		return retval

	def getSimpleHeader (self, type="str") :
		"Date, Subject, To, From"

		if self.isEgg and self.egg : self.msg = self.egg

		h = {}

		for i in self.__headerItemsDecode() :
			a = i[0]
			if a == "Subject" : pass
			elif a == "From" : pass
			elif a == "Date" : pass
			elif a == "To" : pass
			else : continue

			if len(i) > 1 :
				b = i[1]
				h[a] = b

		if not h.has_key("From") : # header does not contain "From" field.
			for i in self.msg.items() :
				a = i[0]
				if len(i) > 1 :
					b = i[1]
					if a == "Reply-To" : h["From"] = b

		if type == "str" :
			a = []
			for i in h.keys() :
				a.append("%s: %s" % (i, h[i]))

			retval = "\n".join(a)

		else :
			retval = h

		return retval

	def __generateContent(self) :
		"""
			Generate content of message. This generate {body, payload, cid}

			# The forwarded message using the Mozilla messenger, containes a entire
			# message body as a payload. So self.payload[i][body] has two value :
			# base64 encoded string / email.Message.Message instance.
			#
			# If payload's body is email.Message.Message instance, I consider this as
			# entire message as a whole. Swap original message with this instance.
		"""

		# get default header information.
		DefaultHeader = self.getHeader("dict")

		body = {}
		payload = {}
		cid = {}

		counter = 0
		for i in self.msg.walk():
			if i.get_content_maintype() == 'multipart': # multipart/* are just containers
				continue

			#---------------------------------------------------
			if i.get_content_maintype() == 'message':
				data = i.get_payload()
				self.isEgg = True
				self.egg = data[0]

				body = {}
				payload = {}
				cid = {}

				continue
			#---------------------------------------------------

			filename = i.get_filename()
			data = i.get_payload()
			id = i.get_all("Content-ID")

			if id :
				cid[counter] = {}
				cid[counter]["type"] = i.get_content_type()
				cid[counter]["body"] = data

				cid[counter]["id"] = id[0].replace("<","").replace(">","")

				if filename : cid[counter]["filename"] = filename

			elif not filename : # if it has no filenames, assume it was a part of body.

				body[counter] = {}
				body[counter]["type"] = i.get_content_type()

 				if i.get_content_type() == "text/html" :
 					body[counter]["body"] = i.get_payload(None, 1)
 				else :
					try :
						body[counter]["body"] = i.get_payload(None, 1)
					except KeyError :
						body[counter]["body"] = data

			else :

				a = {}

				if self.reA.search(filename) :
					a["filename"] = \
						self.__decode(i["Content-Disposition"], True)
				else :
					a["filename"] = filename

				a["body"] = data
				a["type"] = i.get_content_type()

				payload[counter] = a

			counter += 1

		self.body = body
		self.payload = payload
		self.cid = cid

	def getContent (self) :
		"""Get the body, payload. It can be decoded or not.
		"""

		retval = (self.body, self.payload, self.cid)

		return retval

	def getFilename (self) :
		"Get the filename of attachment as [list]."

		a = []

		for i in self.msg.walk():
			if i.get_content_maintype() == 'multipart': # multipart/* are just containers
				continue

			filename = i.get_filename()
			if not filename : # if it has no filenames, assume it is not a attachment.
				continue
			else :
				if self.reA.search(filename) :
					a.append(self.__decode(i["Content-Disposition"], True))
				else :
					a.append(filename)

		retval = a

		return retval

	def getBody (self) :

		for i in self.body.keys() :
			if self.body[i]["type"] == "text/html" :
				self.htmlBody = self.body[i]["body"]
			else :
				self.textBody = self.body[i]["body"]

		retval = (self.htmlBody, self.textBody)

		return retval

	def getPayloadHeader (self) :
		d = []
		dHeader = []

		if len(self.payload) > 0 :
			for i in self.payload.keys() :
				d.append(self.payload[i]["body"])
				dHeader.append([self.payload[i]["type"], self.payload[i]["filename"]])

			retval = dHeader

		else :
			retval = None

		return retval

	def getPayload (self) :

		payload = {}

		if len(self.payload) > 0 :
			for i in self.payload.keys() :

				payload[i] = {}

				payload[i]["data"] = self.payload[i]["body"]
				payload[i]["header"] = "%s:%s" % \
					(self.payload[i]["type"], self.payload[i]["filename"])

			isPayload = 1
		else :
			isPayload = 0

		#retval = (retPayload, retHeaderPayload, self.isPayload)
		retval = (payload, isPayload)

		return retval

	def getCid (self) :

		cid = {}
		cidHeader = {}

		if len(self.cid) > 0 :
			for i in self.cid.keys() :
				cid[i] = {}

				cid[i]["data"] = self.cid[i]["body"]

				if self.cid[i].has_key("filename") :
					filename = self.cid[i]["filename"]
				else :
					filename = ""

				cid[i]["header"] = "%s:%s:%s" % \
					(self.cid[i]["type"], filename, self.cid[i]["id"])

			isCid = 1
		else :
			isCid = 0

		retval = (cid, isCid)

		return retval

	def getEntireMessage (self) :

		if self.isEgg :
			self.entireMessage = self.egg.as_string()

		retval = self.entireMessage

		return retval

	def getAll(self) :
		"""
		Get the all data: address, header, body, payload, cid... etc.

		data["header"] = header
		data["headerSimple"] = headerSimple
		data["textBody"] = textBody
		data["htmlBody"] = htmlBody
		data["payload"] = payload
		data["headerPayload"] = headerPayload
		data["cid"] = cid
		data["headerCid"] = headerCid
		data["isPayload"] = isPayload
		data["isCid"] = isCid
		data["entireMessage"] = self.entireMessage
		"""

		header = self.getHeader("str") # header
		headerSimple = self.getSimpleHeader("str")

		(htmlBody, textBody) = self.getBody()
		(payload, isPayload) = self.getPayload()
		(cid, isCid) = self.getCid()

		data = {}

		data["header"] = header
		data["headerSimple"] = headerSimple
		data["textBody"] = textBody
		data["htmlBody"] = htmlBody
		data["payload"] = payload
		data["cid"] = cid
		data["isPayload"] = isPayload
		data["isCid"] = isCid
		data["entireMessage"] = self.getEntireMessage()

		retval = data

		return retval

	def getSummary (self) :
		"""
		Get the some data: address, header, payload_name.

		data["headerSimple"] = headerSimple
		data["headerPayload"] = headerPayload
		data["size"] = message size
		"""

		headerSimple = self.getSimpleHeader("str")
		headerPayload = self.getPayloadHeader()

		data = {}

		data["headerSimple"] = format_header(headerSimple)
		data["headerPayload"] = headerPayload
		data["size"] = len(self.getEntireMessage())

		retval = data

		return retval

	def replace_header (self, field_name, value) :

		if self.isMessage(self.entireMessage) :
			msg = email.message_from_string(self.entireMessage)
			msg.replace_header(field_name, value)

			retval = msg.__str__()
		else :
			retval = False

		return retval

#-------------------------------------------------- functions
def parse_address_header (header) :
	EMAIL_ADDRESS = "<[a-z0-9-][a-z0-9-_]+@[a-z0-9.-][a-z0-9.-]+\.[a-z][a-z]+>"
	EMAIL_ADDRESS2 = "[a-z0-9-][a-z0-9-_]+@[a-z0-9.-][a-z0-9.-]+\.[a-z][a-z]+"

	q = sre.compile(EMAIL_ADDRESS, sre.IGNORECASE)
	p = sre.compile(EMAIL_ADDRESS2, sre.IGNORECASE)

	if q.findall(header) :
		a = q.split(header)

		name = a[0]
		address = p.findall(header)[0]

		retval = (name, address)
	elif p.findall(header) :
		address = p.findall(header)[0]

		retval = (None, address)
	else :
		retval = (None, header)

	return retval

def parse_address (address) :

	a = address.split("@")

	if len(a) > 1 :
		username = a[0]
		domain = a[1]
	else :
		username = a[0]
		domain = None

	return (username, domain)

def is_valid_domain (domain) :

	DOMAIN = "^[a-z0-9.-][a-z0-9.-]+\.[a-z][a-z]+$"

	if sre.compile(DOMAIN, sre.IGNORECASE).match(domain) :
		retval = True
	else :
		retval = False

	return retval

def is_valid_address (address) :

	EMAIL_ADDRESS = "^[a-z0-9-_][a-z0-9-_]+@[a-z0-9.-][a-z0-9.-]+\.[a-z][a-z]+$"

	if sre.compile(EMAIL_ADDRESS, sre.IGNORECASE).match(address) :
		retval = True
	else :
		retval = False

	return retval

def format_header (header) :

	a = header.split("\n")

	H = {}
	for i in a :
		b = i.split(":")
		H[b[0]] = ":".join(b[1:])

	return H

def replace_header (field_name, value, message) :

	msg = email.message_from_string(message)
	msg.replace_header(field_name, value)

	return msg.__str__()

"""
ChangeLog
---------

Mon Feb 17 03:56:49 KST 2003
- created.

Mon Feb 17 23:35:15 KST 2003
- header decoding routin, self.__headerItemsDecode added
- change self.getHeader(), self.getSimpleHeader()

Tue Feb 18 04:18:20 KST 2003
- self.__decode changed, it can handle the encoded header field well.

Wed Feb 26 18:12:49 KST 2003
- remove insert/remove function.

Sat Mar  1 19:22:38 KST 2003
- added MySQLdb.escape_string() for output.

Sat Mar  1 19:22:56 KST 2003
- added getBody(), getPayload(), getCid()

Wed Mar  5 12:31:19 KST 2003
- self.getEntireMessage() added

Wed Mar  5 12:32:20 KST 2003
- self.__loadMessage(), self.__reloadMessage() added

Wed Mar  5 12:31:29 KST 2003
- In self.__generateContent(), added the routine to check whether the content-type is
  "message/rfc822" or not.

Fri Mar  7 04:10:11 KST 2003
- add MySQLdb.escape_string() routine in self.getEntireMessage().

Wed Mar 12 04:16:35 KST 2003
- MySQLdb.escape_string() was removed.

Thu Mar 13 01:06:53 KST 2003
- escape mode erase entirely in entire module.

Tue Jun  3 17:57:35 KST 2003
- microsoft message type fixing.
	: MS outlook send a text message, encoded base64, but it's not STANDARD.

"""

