import sql, myMySQLdb, message, sre

class Filter :

	"""
	Name Space,
		0 : global filter rule set
		1 : domain filter rule set
		2 : user filter rule set

	* Rule set
		0, global
			- global filter rule set was set in mail_filter_global table.

		1, domain
			- domain filter rule set was set in mail_filter_<domain id> table.
			- domain filter rule set was defined with <domain id>, which was set in
			  domain_priv table.

		2, user
			- user filter rule set was set in mail_filter_<user id> table.
			- user filter rule set was defined with <user id>, which was set in
			  user_priv table.
	"""

	T_tablename = "mail_filter_%s"
	filter_table = None
	block_table = None

	db = None
	id = None

	code_filter = None
	code_block = None

	def __init__ (self, db, which="user", id=None) :

		self.db = db

	def set_name_space (self, which="user", id=None) :

		if id : self.id = id

		# set filter table
		if which == "global" :
			filter_table = sql.SQL_TABLE_FILTER % "global"
			block_table = sql.SQL_TABLE_BLOCK % "global"
		elif which == "domain" and self.id :
			filter_table = sql.SQL_TABLE_FILTER % self.id
			block_table = sql.SQL_TABLE_BLOCK % self.id
		elif which == "user" and self.id :
			filter_table = sql.SQL_TABLE_FILTER % self.id
			block_table = sql.SQL_TABLE_BLOCK % self.id
		else :
			filter_table = None
			block_table = None

		# check whether table exists or not.
		if self.__check_is_table(block_table) :
			self.block_table = block_table
		else :
			self.block_table = None

		if self.__check_is_table(filter_table) :
			self.filter_table = filter_table
		else :
			self.filter_table = None

	def __check_is_table (self, tablename) :

		DB = myMySQLdb.myMySQLdb(self.db)

		return DB.query(sql.SQL_TABLE_EXIST % tablename)

	def get_filter (self) :

		if not self.filter_table :
			retval = []
		else :
			DB = myMySQLdb.myMySQLdb(self.db)
			DB.query(sql.SQL_GET_FILTER % self.filter_table, True)

			if not DB.num_rows > 0 :
				DB.close()

				retval = []
			else :
				a = {}
				b = {}
				for i in range(DB.num_rows) :
					a[i] = DB.fetch()

					c = {}
					if a[i][1] != "" : c["From"] = a[i]["f"]
					if a[i][2] != "" : c["To"] = a[i]["t"]
					if a[i][3] != "" : c["Subject"] = a[i]["s"]
					if a[i][4] != "" : c["payload_name"] = a[i]["payload_name"]
					if a[i][5] != "" : c["size"] = int(a[i]["message_size"])
					if a[i][6] != "" : c["directory_num"] = "%s" % a[i]["directory_num"]
					if a[i][8] != "" : c["expression"] = str(a[i]["expression"])

					d = {}
					for j in c.keys() :
						if c[j] : d[j] = c[j]

					b[a[i]["sequence"]] = d

				DB.close()
				retval = b

		return retval

	def get_block (self) :
		"""
		Return value is list.
		"""

		if not self.block_table :
			retval = []
		else :
			DB = myMySQLdb.myMySQLdb(self.db)
			DB.query(sql.SQL_GET_BLOCK % self.block_table, True)

			if not DB.num_rows > 0 :
				DB.close()

				retval = []
			else :
				b = []
				for i in range(DB.num_rows) :
					a = DB.fetch()

					if a["address"] : b.append(a["address"])

				DB.close()
				retval = b

		return retval

	def __format_header (self, dict_header) :

		a = {}

		a["From"] = ""
		a["To"] = ""
		a["Subject"] = ""

		# header
		for i in dict_header["headerSimple"] :
			a[i] = dict_header["headerSimple"][i]

		# payload header
		if dict_header["headerPayload"] < 1 :
			a["payload_name"] = []
		else :
			a["payload_name"] = []

			for i in dict_header["headerPayload"] :
				a["payload_name"].append(i[1])

		a["size"] = dict_header["size"]

		return a

	def run_block (self, msg_info) :

		#---------------------------------------- Block address...
		if message.parse_address_header(msg_info["From"])[1] \
				in self.code_block :

			retval = -3 # is blocked
		else :
			retval = -2 # pass

		return retval

	def run_filter (self, msg_info) :
		"""
		* return value
			-2				: pass this message
			int value	: directory number to insert
		"""

		# apply filter code
		code_key = self.code_filter.keys()
		code_key.sort()

		if len(code_key) < 1 :
			retval = -2
		else :

			for i in code_key :

				ret = {}

				expression = self.code_filter[i]["expression"]

				#---------- from
				if not self.code_filter[i].has_key("From") :
					ret["From"] = False
				else :
					q = sre.compile(self.code_filter[i]["From"])

					if q.findall(msg_info["From"]) :
						ret["From"] = True
					else :
						ret["From"] = False

				#---------- to
				if not self.code_filter[i].has_key("To") :
					ret["To"] = False
				else :
					q = sre.compile(self.code_filter[i]["To"])

					if q.findall(msg_info["To"]) :
						ret["To"] = True
					else :
						ret["To"] = False

				#---------- subject
				if not self.code_filter[i].has_key("Subject") :
					ret["Subject"] = False
				else :
					q = sre.compile(self.code_filter[i]["Subject"])

					if q.findall(msg_info["Subject"]) :
						ret["Subject"] = True
					else :
						ret["Subject"] = False

				#---------- payload name
				if not self.code_filter[i].has_key("payload_name") \
						or msg_info["payload_name"] :
					ret["payload_name"] = False
				else :
					if self.code_filter[i]["payload_name"] \
							in msg_info["payload_name"] :
						ret["payload_name"] = True
					else :
						ret["payload_name"] = False

				#---------- size
				if not self.code_filter[i].has_key("size") :
					ret["size"] = False
				else :
					if int(self.code_filter[i]["size"]) == int(msg_info["size"]) :
						ret["size"] = True
					else :
						ret["size"] = False

				# Check the return value.
				if expression == "0" :				#---------- or
					if True in ret.values() :
						retval = self.code_filter[i]["directory_num"]

						break
					else :
						retval = -2
				else :									#---------- and
					if False in ret.values() :
						retval = -2
					else :
						retval = self.code_filter[i]["directory_num"]
						break

		return retval

	def apply (self, entireMessage) :
		"""
		* msg.getSummary() return value is,
			message["headerSimple"] = headerSimple
			message["headerPayload"] = headerPayload
			message["size"] = message size

		* return value
			int value	: directory number to insert
			-1				: remove this message.
			-2				: pass this message
			-3				: it's blocked
		"""

		# get filter code
		self.code_block = self.get_block()
		self.code_filter = self.get_filter()

		if len(self.code_filter) < 1 and len(self.code_block) < 1 :
			retval = -2
		else :
			# get message information
			try :
				msg = message.message(entireMessage)
			except :
				retval = -1
			else :
				msg_info = self.__format_header(msg.getSummary())

				# blocking
				if len(self.code_block) > 0 :
					retval = self.run_block(msg_info)
				else :
					retval = -2

					# filtering
					if len(self.code_filter) < 1 :
						retval -2
					else :
						retval = self.run_filter(msg_info)

		return retval

class AddressBook :

	db = None
	id = None

	card_pool = []

	def __init__(self, db, id) :
		""" """
		self.db = db
		self.id = id

	def get_card_pool (self) :

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_GET_CARD % self.id, True)

		if DB.num_rows > 0 :
			for i in range(DB.num_rows) :
				a = DB.fetch()
				self.card_pool.append(a["email"])

	def check (self, entireMessage) :
		"""
		Return value
			True : is in address book, it means that we known him(or her)
			False : is unKnown user
		"""

		address = None

		M = message.message(entireMessage)

		L = M.getSimpleHeader("list")
		for i in L.keys() :
			if i == "From" :
				(a, address) = message.parse_address_header(L[i])
				break

		self.get_card_pool()

		if address in self.card_pool :
			retval = True
		else :
			retval = False

		return retval

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "MailFilter.py"


