/***************************************************************************

	Bally/Sente SAC-1 system

    driver by Aaron Giles

	Games supported:
		* Chicken Shift
		* Gimme a Break
		* Goalie Ghost
		* Hat Trick
		* Mini Golf
		* Name that Tune
		* Night Stocker
		* Off the Wall
		* Rescue Raider
		* Sente Diagnostic Cartridge
		* Shrike Avenger
		* Snacks'n Jaxson
		* Snake Pit
		* Spiker
		* Stocker
		* Stompin'
		* Street Football
		* Toggle
		* Trivial Pursuit (Genus I)
		* Trivial Pursuit (Genus II)
		* Trivial Pursuit (All Sports Edition)
		* Trivial Pursuit (Young Player's Edition)
		* Trivial Pursuit (Baby Boomer Series)

	Looking for ROMs for these:
		* Euro Stocker
		* Team Hat Trick
		* Trivial Pursuit (Spanish)
	
	Known bugs:
		* CEM3394 emulation is not perfect
		* Shrike Avenger doesn't work properly

****************************************************************************

	Memory map

****************************************************************************

	========================================================================
	CPU #1
	========================================================================
	0000-007F   R/W   xxxxxxxx    Sprite RAM (32 entries x 4 bytes)
	            R/W   x-------       (0: Vertical flip)
	            R/W   -x------       (0: Horizontal flip)
	            R/W   ------xx       (0: Upper 2 bits of image number)
	            R/W   xxxxxxxx       (1: Lower 8 bits of image number)
	            R/W   xxxxxxxx       (2: Y position, offset by 17 pixels)
	            R/W   xxxxxxxx       (3: X position)
	0080-00DF   R/W   xxxxxxxx    Program RAM
	00E0-00FF   R/W   xxxxxxxx    Additional sprite RAM (8 entries x 4 bytes)
	0100-07FF   R/W   xxxxxxxx    Program RAM
	0800-7FFF   R/W   xxxxxxxx    Video RAM (256x240 pixels)
	            R/W   xxxx----       (left pixel)
	            R/W   ----xxxx       (right pixel)
	8000-8FFF   R/W   ----xxxx    Palette RAM (1024 entries x 4 bytes)
	            R/W   ----xxxx       (0: red entry)
	            R/W   ----xxxx       (1: green entry)
	            R/W   ----xxxx       (2: blue entry)
	9000-9007     W   --------    ADC start trigger, inputs 0-7
	9400        R     xxxxxxxx    ADC data read
	9800-9801     W   x-------    External output #0
	9802-9803     W   x-------    External output #1
	9804-9805     W   x-------    External output #2
	9806-9807     W   x-------    External output #3
	9808-9809     W   x-------    External output #4
	980A-980B     W   x-------    External output #5
	980C-980D     W   x-------    External output #6
	980E-980F     W   x-------    NVRAM recall
	9880          W   --------    Random number generator reset
	98A0          W   -xxx----    A000-DFFF bank select
	98C0          W   ------xx    Palette bank select
	98E0          W   --------    Watchdog reset
	9900        R     xxxxxxxx    DIP switch bank 1 (G) (active low)
	9901        R     xxxxxxxx    DIP switch bank 2 (H) (active low)
	9902        R     x-------    Self test (active low)
	            R     -x------    Left coin (active low)
	            R     --xxxxxx    External inputs (active low)
	9903        R     x-------    VBLANK state (active high)
	            R     -x------    Right coin (active low)
	            R     --xxxx--    External inputs (active low)
	            R     ------x-    Player 2 start (active low)
	            R     -------x    Player 1 start (active low)
	9A00        R     xxxxxxxx    Random number generator
	9A04-9A05   R/W   xxxxxxxx    6850 UART I/O (to sound board)
	9B00-9CFF   R/W   xxxxxxxx    NOVRAM
	9F00          W   --x--xxx    Independent bank select (Night Stocker only?)
	A000-BFFF   R     xxxxxxxx    Banked A/B ROM
	C000-DFFF   R     xxxxxxxx    Banked C/D ROM
	E000-FFFF   R     xxxxxxxx    Fixed program ROM
	========================================================================
	Interrupts:
		NMI not connected
		IRQ generated by 32L
		FIRQ generated by 6850 UART
	========================================================================


	========================================================================
	CPU #2
	========================================================================
	0000-1FFF   R     xxxxxxxx    Program ROM
	2000-3FFF   R/W   xxxxxxxx    Option RAM/ROM (assumed to be RAM for now)
	4000-5FFF   R/W   xxxxxxxx    Program RAM
	6000-6001     W   xxxxxxxx    6850 UART output (to main board)
	E000-E001   R     xxxxxxxx    6850 UART input (from main board)
	========================================================================
    0000-0003   R/W   xxxxxxxx    8253 counter chip I/O
    0008        R     ------xx    Counter state
                R     ------x-    State of counter #0 OUT signal (active high)
                R     -------x    State of flip-flop feeding counter #0 (active low)
    0008          W   --xxxxxx    Counter control
                  W   --x-----    NMI enable (1=enabled, 0=disabled/clear)
                  W   ---x----    CLEAR on flip-flop feeding counter #0 (active low)
                  W   ----x---    Input of flip-flop feeding counter #0
                  W   -----x--    PRESET on flip-flop feeding counter #0 (active low)
                  W   ------x-    GATE signal for counter #0 (active high)
                  W   -------x    Audio enable
    000A          W   --xxxxxx    DAC data latch (upper 6 bits)
    000B          W   xxxxxx--    DAC data latch (lower 6 bits)
    000C          W   -----xxx    CEM3394 register select
    000E          W   --xxxxxx    CEM3394 chip enable (active high)
                  W   --x-----    CEM3394 chip 0 enable
                  W   ---x----    CEM3394 chip 1 enable
                  W   ----x---    CEM3394 chip 2 enable
                  W   -----x--    CEM3394 chip 3 enable
                  W   ------x-    CEM3394 chip 4 enable
                  W   -------x    CEM3394 chip 5 enable
	========================================================================
	Interrupts:
		INT generated by counter #2 OUT signal on 8253
		NMI generated by 6850 UART
	========================================================================

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "balsente.h"



/*************************************
 *
 *	Main CPU memory handlers
 *
 *************************************/

static MEMORY_READ_START( readmem_cpu1 )
	{ 0x0000, 0x8fff, MRA_RAM },
	{ 0x9400, 0x9401, balsente_adc_data_r },
	{ 0x9900, 0x9900, input_port_0_r },
	{ 0x9901, 0x9901, input_port_1_r },
	{ 0x9902, 0x9902, input_port_2_r },
	{ 0x9903, 0x9903, input_port_3_r },
	{ 0x9a00, 0x9a03, balsente_random_num_r },
	{ 0x9a04, 0x9a05, balsente_m6850_r },
	{ 0x9b00, 0x9bff, MRA_RAM },		/* system NOVRAM */
	{ 0x9c00, 0x9cff, MRA_RAM },		/* cart NOVRAM */
	{ 0xa000, 0xbfff, MRA_BANK1 },
	{ 0xc000, 0xffff, MRA_BANK2 },
MEMORY_END


static MEMORY_WRITE_START( writemem_cpu1 )
	{ 0x0000, 0x07ff, MWA_RAM, &spriteram },
	{ 0x0800, 0x7fff, balsente_videoram_w, &videoram, &videoram_size },
	{ 0x8000, 0x8fff, balsente_paletteram_w, &paletteram },
	{ 0x9000, 0x9007, balsente_adc_select_w },
	{ 0x9800, 0x987f, balsente_misc_output_w },
	{ 0x9880, 0x989f, balsente_random_reset_w },
	{ 0x98a0, 0x98bf, balsente_rombank_select_w },
	{ 0x98c0, 0x98df, balsente_palette_select_w },
	{ 0x98e0, 0x98ff, watchdog_reset_w },
	{ 0x9903, 0x9903, MWA_NOP },
	{ 0x9a04, 0x9a05, balsente_m6850_w },
	{ 0x9b00, 0x9cff, MWA_RAM, &generic_nvram, &generic_nvram_size },		/* system NOVRAM + cart NOVRAM */
	{ 0xa000, 0xffff, MWA_ROM },
MEMORY_END



/*************************************
 *
 *	Sound CPU memory handlers
 *
 *************************************/

static MEMORY_READ_START( readmem_cpu2 )
	{ 0x0000, 0x1fff, MRA_ROM },
	{ 0x2000, 0x5fff, MRA_RAM },
	{ 0xe000, 0xffff, balsente_m6850_sound_r },
MEMORY_END


static MEMORY_WRITE_START( writemem_cpu2 )
	{ 0x0000, 0x1fff, MWA_ROM },
	{ 0x2000, 0x5fff, MWA_RAM },
	{ 0x6000, 0x7fff, balsente_m6850_sound_w },
MEMORY_END


static PORT_READ_START( readport_cpu2 )
	{ 0x00, 0x03, balsente_counter_8253_r },
	{ 0x08, 0x0f, balsente_counter_state_r },
PORT_END


static PORT_WRITE_START( writeport_cpu2 )
	{ 0x00, 0x03, balsente_counter_8253_w },
	{ 0x08, 0x09, balsente_counter_control_w },
	{ 0x0a, 0x0b, balsente_dac_data_w },
	{ 0x0c, 0x0d, balsente_register_addr_w },
	{ 0x0e, 0x0f, balsente_chip_select_w },
PORT_END



/*************************************
 *
 *	Shrike Avenger CPU memory handlers
 *
 *************************************/

/* CPU 1 read addresses */
static MEMORY_READ16_START( readmem_shrike68k )
	{ 0x000000, 0x003fff, MRA16_ROM },
	{ 0x010000, 0x01001f, shrike_shared_68k_r },
	{ 0x018000, 0x018fff, MRA16_RAM },
MEMORY_END


/* CPU 1 write addresses */
static MEMORY_WRITE16_START( writemem_shrike68k )
	{ 0x000000, 0x003fff, MWA16_ROM },
	{ 0x010000, 0x01001f, shrike_shared_68k_w, &shrike_shared },
	{ 0x018000, 0x018fff, MWA16_RAM },
MEMORY_END



/*************************************
 *
 *	Port definitions
 *
 *************************************/

#define UNUSED_ANALOG \
	PORT_START\
	PORT_BIT( 0xff, IP_ACTIVE_HIGH, IPT_UNUSED )
#define UNUSED_ANALOG_X2 UNUSED_ANALOG UNUSED_ANALOG
#define UNUSED_ANALOG_X3 UNUSED_ANALOG_X2 UNUSED_ANALOG
#define UNUSED_ANALOG_X4 UNUSED_ANALOG_X2 UNUSED_ANALOG_X2

#define PLAYER1_ANALOG_JOYSTICK \
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_AD_STICK_Y | IPF_PLAYER1, 100, 20, 0x80, 0x7f )\
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_AD_STICK_X | IPF_REVERSE | IPF_PLAYER1, 100, 20, 0x80, 0x7f )

#define PLAYER2_ANALOG_JOYSTICK \
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_AD_STICK_Y | IPF_PLAYER2, 100, 20, 0x80, 0x7f )\
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_AD_STICK_X | IPF_REVERSE | IPF_PLAYER2, 100, 20, 0x80, 0x7f )

#define PLAYER1_TRACKBALL \
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_TRACKBALL_Y | IPF_PLAYER1 | IPF_CENTER, 100, 20, 0, 0 )\
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_TRACKBALL_X | IPF_REVERSE | IPF_PLAYER1 | IPF_CENTER, 100, 20, 0, 0 )

#define PLAYER2_TRACKBALL \
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_TRACKBALL_Y | IPF_PLAYER2 | IPF_CENTER, 100, 20, 0, 0 )\
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_TRACKBALL_X | IPF_REVERSE | IPF_PLAYER2 | IPF_CENTER, 100, 20, 0, 0 )

#define PLAYER1_DIAL \
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_DIAL | IPF_PLAYER1 | IPF_REVERSE | IPF_CENTER, 100, 20, 0, 0 )

#define PLAYER2_DIAL \
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_DIAL | IPF_PLAYER2 | IPF_REVERSE | IPF_CENTER, 100, 20, 0, 0 )

#define PLAYER1_WHEEL \
	PORT_START\
    PORT_ANALOG( 0xff, 0, IPT_DIAL | IPF_PLAYER1 | IPF_CENTER, 100, 20, 0, 0 )

#define PLAYER1_CROSSHAIRS \
	PORT_START				/* fake analog X */\
	PORT_ANALOG( 0xff, 0x80, IPT_AD_STICK_X, 50, 10, 0, 255 )\
	PORT_START				/* fake analog Y */\
	PORT_ANALOG( 0xff, 0x80, IPT_AD_STICK_Y, 70, 10, 0, 255 )


INPUT_PORTS_START( sentetst )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_BIT( 0x7c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x80, "High Scores" )
	PORT_DIPSETTING(    0x80, "Keep Top 5" )
	PORT_DIPSETTING(    0x00, "Keep All" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Bonus_Life ) )
	PORT_DIPSETTING(    0x00, "Every 10,000" )
	PORT_DIPSETTING(    0x01, "Every 15,000" )
	PORT_DIPSETTING(    0x02, "Every 20,000" )
	PORT_DIPSETTING(    0x03, "Every 25,000" )
	PORT_DIPNAME( 0x0c, 0x04, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "2" )
	PORT_DIPSETTING(    0x04, "3" )
	PORT_DIPSETTING(    0x08, "4" )
	PORT_DIPSETTING(    0x0c, "5" )
	PORT_BIT( 0x30, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x40, "Easy" )
	PORT_DIPSETTING(    0x00, "Hard" )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x30, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x38, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X2
	PLAYER1_TRACKBALL
INPUT_PORTS_END


INPUT_PORTS_START( cshift )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_BIT( 0x7c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x80, "High Scores" )
	PORT_DIPSETTING(    0x80, "Keep Top 5" )
	PORT_DIPSETTING(    0x00, "Keep All" )

	PORT_START	/* IN1 */
	PORT_BIT( 0x03, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "2" )
	PORT_DIPSETTING(    0x04, "3" )
	PORT_BIT( 0x70, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X4
INPUT_PORTS_END


INPUT_PORTS_START( gghost )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_DIPNAME( 0x04, 0x04, "Players per Credit" )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x04, "1 or 2" )
	PORT_BIT( 0xf8, IP_ACTIVE_HIGH, IPT_UNUSED )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x07, 0x05, "Game Duration" )
	PORT_DIPSETTING(    0x00, "9 points" )
	PORT_DIPSETTING(    0x02, "11 points" )
	PORT_DIPSETTING(    0x04, "15 points" )
	PORT_DIPSETTING(    0x06, "21 points" )
	PORT_DIPSETTING(    0x01, "timed, 1:15" )
	PORT_DIPSETTING(    0x03, "timed, 1:30" )
	PORT_DIPSETTING(    0x05, "timed, 2:00" )
	PORT_DIPSETTING(    0x07, "timed, 2:30" )
	PORT_BIT( 0x78, IP_ACTIVE_HIGH, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x0f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER1 )
	PORT_BIT( 0x30, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	PLAYER2_TRACKBALL
	PLAYER1_TRACKBALL
INPUT_PORTS_END


INPUT_PORTS_START( hattrick )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_DIPNAME( 0x04, 0x04, "Players Per Credit" )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x04, "1 or 2" )
	PORT_BIT( 0xf8, IP_ACTIVE_HIGH, IPT_UNUSED )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x07, 0x02, "Game Time" )
	PORT_DIPSETTING(    0x00, "1:15" )
	PORT_DIPSETTING(    0x01, "1:30" )
	PORT_DIPSETTING(    0x02, "1:45" )
	PORT_DIPSETTING(    0x03, "2:00" )
	PORT_DIPSETTING(    0x04, "2:15" )
	PORT_DIPSETTING(    0x05, "2:30" )
	PORT_DIPSETTING(    0x06, "2:45" )
	PORT_DIPSETTING(    0x07, "3:00" )
	PORT_BIT( 0x78, IP_ACTIVE_HIGH, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X4
INPUT_PORTS_END


INPUT_PORTS_START( otwalls )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_DIPNAME( 0x04, 0x04, "Players Per Credit" )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x04, "1 or 2" )
	PORT_BIT( 0xf8, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* IN1 */
	PORT_BIT( 0x7f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_LEFT  | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_RIGHT | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x30, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X2
	PLAYER1_DIAL
	PLAYER2_DIAL
INPUT_PORTS_END


INPUT_PORTS_START( snakepit )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_BIT( 0x7c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x80, "High Scores" )
	PORT_DIPSETTING(    0x80, "Keep Top 5" )
	PORT_DIPSETTING(    0x00, "Keep All" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Bonus_Life ) )
	PORT_DIPSETTING(    0x00, "Every 10,000" )
	PORT_DIPSETTING(    0x01, "Every 15,000" )
	PORT_DIPSETTING(    0x02, "Every 20,000" )
	PORT_DIPSETTING(    0x03, "Every 25,000" )
	PORT_DIPNAME( 0x0c, 0x04, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "2" )
	PORT_DIPSETTING(    0x04, "3" )
	PORT_DIPSETTING(    0x08, "4" )
	PORT_DIPSETTING(    0x0c, "5" )
	PORT_BIT( 0x30, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x40, "Easy" )
	PORT_DIPSETTING(    0x00, "Hard" )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x30, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x38, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X2
	PLAYER1_TRACKBALL
INPUT_PORTS_END


INPUT_PORTS_START( snakjack )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_BIT( 0x7c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x80, "High Scores" )
	PORT_DIPSETTING(    0x80, "Keep Top 5" )
	PORT_DIPSETTING(    0x00, "Keep All" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x03, 0x01, DEF_STR( Bonus_Life ) )
	PORT_DIPSETTING(    0x00, "Every 15,000" )
	PORT_DIPSETTING(    0x01, "Every 20,000" )
	PORT_DIPSETTING(    0x02, "Every 25,000" )
	PORT_DIPSETTING(    0x03, "Every 30,000" )
	PORT_DIPNAME( 0x0c, 0x04, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "2" )
	PORT_DIPSETTING(    0x04, "3" )
	PORT_DIPSETTING(    0x08, "4" )
	PORT_DIPSETTING(    0x0c, "5" )
	PORT_BIT( 0x70, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x3f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x38, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X2
	PLAYER1_TRACKBALL
INPUT_PORTS_END


INPUT_PORTS_START( stocker )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x01, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_BIT( 0x3f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x40, 0x40, "End of Game" )
	PORT_DIPSETTING(    0x40, "Normal" )
	PORT_DIPSETTING(    0x00, "3 Tickets" )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x3f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X3
	PLAYER1_WHEEL
INPUT_PORTS_END


INPUT_PORTS_START( triviag1 )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_BIT( 0x1c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x20, 0x00, "Sound" )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x00, "Sound Test" )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, "High Scores" )
	PORT_DIPSETTING(    0x00, "Keep Top 5" )
	PORT_DIPSETTING(    0x80, "Keep Top 10" )

	PORT_START	/* IN1 */
	PORT_BIT( 0x03, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x0c, 0x04, "Guesses" )
	PORT_DIPSETTING(    0x00, "3" )
	PORT_DIPSETTING(    0x04, "4" )
	PORT_DIPSETTING(    0x08, "5" )
	PORT_DIPSETTING(    0x0c, "6" )
	PORT_BIT( 0x70, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_START3 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START4 )
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_BUTTON2, "Red Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON1, "Green Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X4
INPUT_PORTS_END


#define input_ports_triviag2 input_ports_triviag1
#define input_ports_triviasp input_ports_triviag1
#define input_ports_triviayp input_ports_triviag1
#define input_ports_triviabb input_ports_triviag1


INPUT_PORTS_START( gimeabrk )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x01, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x03, 0x01, "Bonus Shot" )
	PORT_DIPSETTING(    0x00, "Every 6 Balls" )
	PORT_DIPSETTING(    0x01, "Every 8 Balls" )
	PORT_DIPSETTING(    0x02, "Every 10 Balls" )
	PORT_DIPSETTING(    0x03, "Every 12 Balls" )
	PORT_DIPNAME( 0x0c, 0x08, "Initial Shots" )
	PORT_DIPSETTING(    0x00, "8" )
	PORT_DIPSETTING(    0x04, "10" )
	PORT_DIPSETTING(    0x08, "12" )
	PORT_DIPSETTING(    0x0c, "14" )
	PORT_DIPNAME( 0x10, 0x00, "Players Per Credit" )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x10, "1 or 2" )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Cabinet ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Upright ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Cocktail ) )
	PORT_DIPNAME( 0x40, 0x40, "High Scores" )
	PORT_DIPSETTING(    0x40, "Keep Top 5" )
	PORT_DIPSETTING(    0x00, "Keep All" )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x3f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x30, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	PLAYER1_TRACKBALL
	UNUSED_ANALOG_X2
INPUT_PORTS_END


INPUT_PORTS_START( minigolf )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x01, 0x01, "Add-A-Coin" )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, "Display Kids" )
	PORT_DIPSETTING(    0x02, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x04, 0x04, "Kid on Left Located" )
	PORT_DIPSETTING(    0x04, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x08, 0x08, "Kid on Right Located" )
	PORT_DIPSETTING(    0x08, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x3f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
#ifdef MAME32JP
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_START3 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START4 )
#else
	PORT_BIT( 0x0c, IP_ACTIVE_LOW, IPT_UNUSED )
#endif
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X2
	PLAYER1_TRACKBALL
INPUT_PORTS_END


INPUT_PORTS_START( minigol2 )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x01, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x01, 0x01, "Add-A-Coin" )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x3f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
#ifdef MAME32JP
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_START3 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START4 )
#else
	PORT_BIT( 0x0c, IP_ACTIVE_LOW, IPT_UNUSED )
#endif
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X2
	PLAYER1_TRACKBALL
INPUT_PORTS_END


INPUT_PORTS_START( toggle )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) )
	PORT_BIT( 0x7c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x80, "High Scores" )
	PORT_DIPSETTING(    0x80, "Keep Top 5" )
	PORT_DIPSETTING(    0x00, "Keep All" )

	PORT_START	/* IN1 */
	PORT_BIT( 0x03, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "2" )
	PORT_DIPSETTING(    0x04, "3" )
	PORT_BIT( 0x78, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X4
INPUT_PORTS_END


INPUT_PORTS_START( nametune )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 3C_2C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x01, 0x01, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BITX(0x01, IP_ACTIVE_LOW, IPT_BUTTON4 | IPF_PLAYER1, "P1 Blue Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BITX(0x02, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_PLAYER1, "P1 Green Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BITX(0x04, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER1, "P1 Yellow Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BITX(0x08, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER1, "P1 Red Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BIT( 0x30, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BITX(0x04, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2, "P2 Red Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BITX(0x08, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER2, "P2 Yellow Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BITX(0x10, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_PLAYER2, "P2 Green Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON4 | IPF_PLAYER2, "P2 Blue Button", IP_KEY_DEFAULT, IP_JOY_DEFAULT )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X4
INPUT_PORTS_END


INPUT_PORTS_START( nstocker )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x01, 0x00, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x01, "Easy" )
	PORT_DIPSETTING(    0x00, "Hard" )
	PORT_BIT( 0x7e, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x3f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X3
	/* cheese alert -- we have to map this to player 2 so that it doesn't interfere with */
	/* the crosshair controls */
	PORT_START
    PORT_ANALOGX( 0xff, 0, IPT_DIAL | IPF_PLAYER2 | IPF_CENTER, 100, 20, 0, 0,
    				KEYCODE_S, KEYCODE_F, JOYCODE_1_LEFT, JOYCODE_1_RIGHT )

	/* extra ports for shooters */
	PLAYER1_CROSSHAIRS
INPUT_PORTS_END


INPUT_PORTS_START( sfootbal )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x07, 0x03, "Game Duration" )
	PORT_DIPSETTING(    0x00, "1:30" )
	PORT_DIPSETTING(    0x01, "1:40" )
	PORT_DIPSETTING(    0x02, "1:50" )
	PORT_DIPSETTING(    0x03, "2:00" )
	PORT_DIPSETTING(    0x04, "2:20" )
	PORT_DIPSETTING(    0x05, "2:40" )
	PORT_DIPSETTING(    0x06, "3:00" )
	PORT_DIPSETTING(    0x07, "3:30" )
	PORT_DIPNAME( 0x08, 0x00, "Players Per Credit" )
	PORT_DIPSETTING(    0x00, "1" )
	PORT_DIPSETTING(    0x08, "1 or 2" )
	PORT_BIT( 0x70, IP_ACTIVE_HIGH, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	PLAYER2_ANALOG_JOYSTICK
	PLAYER1_ANALOG_JOYSTICK
INPUT_PORTS_END


INPUT_PORTS_START( spiker )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x01, 0x00, "Game Duration" )
	PORT_DIPSETTING(    0x00, "11 points" )
	PORT_DIPSETTING(    0x01, "15 points" )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x0f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER1 )
	PORT_BIT( 0x38, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	PLAYER2_TRACKBALL
	PLAYER1_TRACKBALL
INPUT_PORTS_END


INPUT_PORTS_START( stompin )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x01, 0x00, "Display Kids" )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x01, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x02, 0x02, "Kid on Right Located" )
	PORT_DIPSETTING(    0x02, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x04, 0x04, "Kid on Left Located" )
	PORT_DIPSETTING(    0x04, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x20, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x00, "Bee In Game" )
	PORT_DIPSETTING(    0x40, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x80, 0x00, "Bug Generation" )
	PORT_DIPSETTING(    0x00, "Regular" )
	PORT_DIPSETTING(    0x80, "None" )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* "analog" ports */
	PORT_START
	PORT_BIT( 0x1f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER1, "Top-Right", KEYCODE_9_PAD, IP_JOY_DEFAULT )
	PORT_BITX(0x40, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER1, "Top",       KEYCODE_8_PAD, IP_JOY_DEFAULT )
	PORT_BITX(0x80, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_PLAYER1, "Top-Left",  KEYCODE_7_PAD, IP_JOY_DEFAULT )

	PORT_START
	PORT_BIT( 0x1f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON4 | IPF_PLAYER1, "Right",     KEYCODE_6_PAD, IP_JOY_DEFAULT )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX(0x80, IP_ACTIVE_LOW, IPT_BUTTON5 | IPF_PLAYER1, "Left",      KEYCODE_4_PAD, IP_JOY_DEFAULT )

	PORT_START
	PORT_BIT( 0x1f, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX(0x20, IP_ACTIVE_LOW, IPT_BUTTON6 | IPF_PLAYER1, "Bot-Right", KEYCODE_3_PAD, IP_JOY_DEFAULT )
	PORT_BITX(0x40, IP_ACTIVE_LOW, IPT_BUTTON7 | IPF_PLAYER1, "Bottom",    KEYCODE_2_PAD, IP_JOY_DEFAULT )
	PORT_BITX(0x80, IP_ACTIVE_LOW, IPT_BUTTON8 | IPF_PLAYER1, "Bot-Left",  KEYCODE_1_PAD, IP_JOY_DEFAULT )

	UNUSED_ANALOG
INPUT_PORTS_END


INPUT_PORTS_START( rescraid )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Coinage ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 1C_2C ) )
	PORT_DIPNAME( 0x1c, 0x00, "Bonus Coins" )
	PORT_DIPSETTING(    0x00, "None" )
	PORT_DIPSETTING(    0x04, "2 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x08, "3 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x0c, "4 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x10, "4 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x14, "5 Coins = 1 Bonus" )
	PORT_DIPSETTING(    0x18, "5 Coins = 2 Bonus" )
	PORT_DIPSETTING(    0x1c, "5 Coins = 3 Bonus" )
	PORT_DIPNAME( 0x20, 0x00, "Left Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x20, "x2" )
	PORT_DIPNAME( 0xc0, 0x00, "Right Coin Mech" )
	PORT_DIPSETTING(    0x00, "x1" )
	PORT_DIPSETTING(    0x40, "x4" )
	PORT_DIPSETTING(    0x80, "x5" )
	PORT_DIPSETTING(    0xc0, "x6" )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x01, 0x01, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "4" )
	PORT_DIPSETTING(    0x01, "5" )
	PORT_DIPNAME( 0x0c, 0x04, "Minimum Game Time" )
	PORT_DIPSETTING(    0x08, "45" )
	PORT_DIPSETTING(    0x04, "60" )
	PORT_DIPSETTING(    0x00, "90" )
	PORT_DIPSETTING(    0x0c, "120" )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, "Keep High Scores" )
	PORT_DIPSETTING(    0x40, DEF_STR( No ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_UP    | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_DOWN  | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_RIGHT | IPF_PLAYER1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_LEFT  | IPF_PLAYER1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	UNUSED_ANALOG_X4
INPUT_PORTS_END


INPUT_PORTS_START( shrike )
	PORT_START	/* IN0 */
	PORT_DIPNAME( 0x03, 0x00, DEF_STR( Coinage ))
	PORT_DIPSETTING(    0x02, DEF_STR( 4C_1C ))
	PORT_DIPSETTING(    0x01, DEF_STR( 3C_1C ))
	PORT_DIPSETTING(    0x00, DEF_STR( 2C_1C ))
	PORT_DIPSETTING(    0x03, DEF_STR( Free_Play ))
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x40, 0x40, "Reset High Scores" )
	PORT_DIPSETTING(    0x40, DEF_STR( No ))
	PORT_DIPSETTING(    0x00, DEF_STR( Yes ))
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* IN1 */
	PORT_DIPNAME( 0x03, 0x03, "Minimum Game Time" )
	PORT_DIPSETTING(    0x00, "1:00" )
	PORT_DIPSETTING(    0x01, "1:30" )
	PORT_DIPSETTING(    0x02, "2:00" )
	PORT_DIPSETTING(    0x03, "2:30" )
	PORT_BIT( 0x7c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_DIPNAME( 0x80, 0x00, DEF_STR( Demo_Sounds ))
	PORT_DIPSETTING(    0x80, DEF_STR( Off ))
	PORT_DIPSETTING(    0x00, DEF_STR( On ))

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_BUTTON4 | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON5 | IPF_PLAYER1 )
//	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_SERVICE( 0x80, IP_ACTIVE_LOW )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x3c, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	/* analog ports */
	PORT_START
	PORT_ANALOG( 0xff, 0x80, IPT_AD_STICK_X | IPF_REVERSE | IPF_PLAYER1, 100, 20, 0x00, 0xff )
	PORT_START
	PORT_ANALOG( 0xff, 0x80, IPT_AD_STICK_Y | IPF_PLAYER1, 100, 20, 0x00, 0xff )
	UNUSED_ANALOG_X2
INPUT_PORTS_END



/*************************************
 *
 *	Sound definitions
 *
 *************************************/

static struct cem3394_interface cem_interface =
{
	6,
	{ 90, 90, 90, 90, 90, 90 },
	{ 431.894, 431.894, 431.894, 431.894, 431.894, 431.894 },
	{ 1300.0, 1300.0, 1300.0, 1300.0, 1300.0, 1300.0 },
	{ balsente_noise_gen, balsente_noise_gen, balsente_noise_gen, balsente_noise_gen, balsente_noise_gen, balsente_noise_gen }
};



/*************************************
 *
 *	Machine driver
 *
 *************************************/

static MACHINE_DRIVER_START( balsente )

	/* basic machine hardware */
	MDRV_CPU_ADD(M6809, 5000000/4)
	MDRV_CPU_MEMORY(readmem_cpu1,writemem_cpu1)
	MDRV_CPU_VBLANK_INT(balsente_update_analog_inputs,1)
	
	MDRV_CPU_ADD(Z80, 4000000)
	MDRV_CPU_FLAGS(CPU_AUDIO_CPU)
	MDRV_CPU_MEMORY(readmem_cpu2,writemem_cpu2)
	MDRV_CPU_PORTS(readport_cpu2,writeport_cpu2)
	
	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_REAL_60HZ_VBLANK_DURATION)
	MDRV_INTERLEAVE(10)

	MDRV_MACHINE_INIT(balsente)
	MDRV_NVRAM_HANDLER(generic_0fill)
	
	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER | VIDEO_UPDATE_BEFORE_VBLANK)
	MDRV_SCREEN_SIZE(256, 240)
	MDRV_VISIBLE_AREA(0, 255, 0, 239)
	MDRV_PALETTE_LENGTH(1024)
	
	MDRV_VIDEO_START(balsente)
	MDRV_VIDEO_UPDATE(balsente)
	
	/* sound hardware */
	MDRV_SOUND_ADD(CEM3394, cem_interface)
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( shrike )

	/* basic machine hardware */
	MDRV_IMPORT_FROM(balsente)
	
	MDRV_CPU_ADD(M68000, 8000000)
	MDRV_CPU_MEMORY(readmem_shrike68k,writemem_shrike68k)
	
	MDRV_INTERLEAVE(100)
	
	/* video hardware */
	MDRV_PALETTE_LENGTH(1025)
MACHINE_DRIVER_END



/*************************************
 *
 *	ROM definitions
 *
 *************************************/

ROM_START( sentetst )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "sdiagef.bin",  0x2e000, 0x2000, 0x2a39fc53 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",     0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "sdiaggr0.bin", 0x00000, 0x2000, 0x5e0ff62a )
ROM_END


ROM_START( cshift )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "cs-ab0.bin", 0x10000, 0x2000, 0xd2069e75 )
	ROM_LOAD( "cs-ab1.bin", 0x12000, 0x2000, 0x198f25a8 )
	ROM_LOAD( "cs-ab2.bin", 0x14000, 0x2000, 0x2e2b2b82 )
	ROM_LOAD( "cs-ab3.bin", 0x16000, 0x2000, 0xb97fc520 )
	ROM_LOAD( "cs-ab4.bin", 0x18000, 0x2000, 0xb4f0d673 )
	ROM_LOAD( "cs-ab5.bin", 0x1a000, 0x2000, 0xb1f8e589 )
	ROM_LOAD( "cs-cd.bin",  0x2c000, 0x2000, 0xf555a0b2 )
	ROM_LOAD( "cs-ef.bin",  0x2e000, 0x2000, 0x368b1ce3 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",   0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "cs-gr0.bin", 0x00000, 0x2000, 0x67f9d3b3 )
	ROM_LOAD( "cs-gr1.bin", 0x02000, 0x2000, 0x78973d50 )
	ROM_LOAD( "cs-gr2.bin", 0x04000, 0x2000, 0x1784f939 )
	ROM_LOAD( "cs-gr3.bin", 0x06000, 0x2000, 0xb43916a2 )
	ROM_LOAD( "cs-gr4.bin", 0x08000, 0x2000, 0xa94cd35b )
ROM_END


ROM_START( gghost )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ggh-ab0.bin", 0x10000, 0x2000, 0xed0fdeac )
	ROM_LOAD( "ggh-ab1.bin", 0x12000, 0x2000, 0x5bfbae58 )
	ROM_LOAD( "ggh-ab2.bin", 0x14000, 0x2000, 0xf0baf921 )
	ROM_LOAD( "ggh-ab3.bin", 0x16000, 0x2000, 0xed0fdeac )
	ROM_LOAD( "ggh-ab4.bin", 0x18000, 0x2000, 0x5bfbae58 )
	ROM_LOAD( "ggh-ab5.bin", 0x1a000, 0x2000, 0xf0baf921 )
	ROM_LOAD( "ggh-cd.bin",  0x2c000, 0x2000, 0xd3d75f84 )
	ROM_LOAD( "ggh-ef.bin",  0x2e000, 0x2000, 0xa02b4243 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",    0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "ggh-gr0.bin", 0x00000, 0x2000, 0x03515526 )
	ROM_LOAD( "ggh-gr1.bin", 0x02000, 0x2000, 0xb4293435 )
	ROM_LOAD( "ggh-gr2.bin", 0x04000, 0x2000, 0xece0cb97 )
	ROM_LOAD( "ggh-gr3.bin", 0x06000, 0x2000, 0xdd7e25d0 )
	ROM_LOAD( "ggh-gr4.bin", 0x08000, 0x2000, 0xb4293435 )
	ROM_LOAD( "ggh-gr5.bin", 0x0a000, 0x2000, 0xd3da0093 )
ROM_END


ROM_START( hattrick )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "rom-ab0.u9a", 0x10000, 0x2000, 0xf25c1b99 )
	ROM_LOAD( "rom-ab1.u8a", 0x12000, 0x2000, 0xc1df3d1f )
	ROM_LOAD( "rom-ab2.u7a", 0x14000, 0x2000, 0xf6c41257 )
	ROM_LOAD( "rom-cd.u3a",  0x2c000, 0x2000, 0xfc44f36c )
	ROM_LOAD( "rom-ef.u2a",  0x2e000, 0x2000, 0xd8f910fb )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",    0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "rom-gr0.u9b", 0x00000, 0x2000, 0x9f41baba )
	ROM_LOAD( "rom-gr1.u8b", 0x02000, 0x2000, 0x951f08c9 )
ROM_END


ROM_START( otwalls )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "otw-ab0.bin", 0x10000, 0x2000, 0x474441c7 )
	ROM_LOAD( "otw-ab1.bin", 0x12000, 0x2000, 0x2e9e9411 )
	ROM_LOAD( "otw-ab2.bin", 0x14000, 0x2000, 0xba092128 )
	ROM_LOAD( "otw-ab3.bin", 0x16000, 0x2000, 0x74bc479d )
	ROM_LOAD( "otw-ab4.bin", 0x18000, 0x2000, 0xf5f67619 )
	ROM_LOAD( "otw-ab5.bin", 0x1a000, 0x2000, 0xf5f67619 )
	ROM_LOAD( "otw-cd.bin",  0x2c000, 0x2000, 0x8e2d15ab )
	ROM_LOAD( "otw-ef.bin",  0x2e000, 0x2000, 0x57eab299 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",    0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "otw-gr0.bin", 0x00000, 0x2000, 0x210bad3c )
	ROM_LOAD( "otw-gr1.bin", 0x02000, 0x2000, 0x13e6aaa5 )
	ROM_LOAD( "otw-gr2.bin", 0x04000, 0x2000, 0x5cfefee5 )
	ROM_LOAD( "otw-gr3.bin", 0x06000, 0x2000, 0x6b17e4a9 )
	ROM_LOAD( "otw-gr4.bin", 0x08000, 0x2000, 0x15985c8c )
	ROM_LOAD( "otw-gr5.bin", 0x0a000, 0x2000, 0x448f7e3c )
ROM_END


ROM_START( snakepit )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "spit-ab0.bin", 0x10000, 0x2000, 0x5aa86081 )
	ROM_LOAD( "spit-ab1.bin", 0x12000, 0x2000, 0x588228b8 )
	ROM_LOAD( "spit-ab2.bin", 0x14000, 0x2000, 0x60173ab6 )
	ROM_LOAD( "spit-ab3.bin", 0x16000, 0x2000, 0x56cb51a8 )
	ROM_LOAD( "spit-ab4.bin", 0x18000, 0x2000, 0x40ba61e0 )
	ROM_LOAD( "spit-ab5.bin", 0x1a000, 0x2000, 0x2a1d9d8f )
	ROM_LOAD( "spit-cd.bin",  0x2c000, 0x2000, 0x54095cbb )
	ROM_LOAD( "spit-ef.bin",  0x2e000, 0x2000, 0x5f836a66 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",     0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "spit-gr0.bin", 0x00000, 0x2000, 0xf77fd85d )
	ROM_LOAD( "spit-gr1.bin", 0x02000, 0x2000, 0x3ad10334 )
	ROM_LOAD( "spit-gr2.bin", 0x04000, 0x2000, 0x24887703 )
	ROM_LOAD( "spit-gr3.bin", 0x06000, 0x2000, 0xc6703ec2 )
	ROM_LOAD( "spit-gr4.bin", 0x08000, 0x2000, 0xb4293435 )
	ROM_LOAD( "spit-gr5.bin", 0x0a000, 0x2000, 0xdc27c970 )
ROM_END


ROM_START( snakjack )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "rom-ab0.u9a", 0x10000, 0x2000, 0xda2dd119 )
	ROM_LOAD( "rom-ab1.u8a", 0x12000, 0x2000, 0x657ddf26 )
	ROM_LOAD( "rom-ab2.u7a", 0x14000, 0x2000, 0x15333dcf )
	ROM_LOAD( "rom-ab3.u6a", 0x16000, 0x2000, 0x57671f6f )
	ROM_LOAD( "rom-ab4.u5a", 0x18000, 0x2000, 0xc16c5dc0 )
	ROM_LOAD( "rom-ab5.u4a", 0x1a000, 0x2000, 0xd7019747 )
	ROM_LOAD( "rom-cd.u3a",  0x2c000, 0x2000, 0x7b44ca4c )
	ROM_LOAD( "rom-ef.u1a",  0x2e000, 0x2000, 0xf5309b38 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",    0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "rom-gr0.u9b", 0x00000, 0x2000, 0x3e64b5d5 )
	ROM_LOAD( "rom-gr1.u8b", 0x02000, 0x2000, 0xb3b8baee )
	ROM_LOAD( "rom-gr2.u7b", 0x04000, 0x2000, 0xe9d89dac )
	ROM_LOAD( "rom-gr3.u6b", 0x06000, 0x2000, 0xb6602be8 )
	ROM_LOAD( "rom-gr4.u5b", 0x08000, 0x2000, 0x3fbfa686 )
	ROM_LOAD( "rom-gr5.u4b", 0x0a000, 0x2000, 0x345f94fb )
ROM_END


ROM_START( stocker )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "stkr-ab0.bin", 0x10000, 0x2000, 0x784a00ad )
	ROM_LOAD( "stkr-ab1.bin", 0x12000, 0x2000, 0xcdae01dc )
	ROM_LOAD( "stkr-ab2.bin", 0x14000, 0x2000, 0x18527d57 )
	ROM_LOAD( "stkr-ab3.bin", 0x16000, 0x2000, 0x028f6c06 )
	ROM_LOAD( "stkr-cd.bin",  0x2c000, 0x2000, 0x53dbc4e5 )
	ROM_LOAD( "stkr-ef.bin",  0x2e000, 0x2000, 0xcdcf46bc )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",    0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "stkr-gr0.bin", 0x00000, 0x2000, 0x76d5694c )
	ROM_LOAD( "stkr-gr1.bin", 0x02000, 0x2000, 0x4a5cc00b )
	ROM_LOAD( "stkr-gr2.bin", 0x04000, 0x2000, 0x70002382 )
	ROM_LOAD( "stkr-gr3.bin", 0x06000, 0x2000, 0x68c862d8 )
ROM_END


ROM_START( triviag1 )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "tpg1-ab0.bin", 0x10000, 0x2000, 0x79fd3ac3 )
	ROM_LOAD( "tpg1-ab1.bin", 0x12000, 0x2000, 0x0ff677e9 )
	ROM_LOAD( "tpg1-ab2.bin", 0x14000, 0x2000, 0x3b4d03e7 )
	ROM_LOAD( "tpg1-ab3.bin", 0x16000, 0x2000, 0x2c6c0651 )
	ROM_LOAD( "tpg1-ab4.bin", 0x18000, 0x2000, 0x397529e7 )
	ROM_LOAD( "tpg1-ab5.bin", 0x1a000, 0x2000, 0x499773a4 )
	ROM_LOAD( "tpg1-cd.bin",  0x2c000, 0x2000, 0x35c9b9c2 )
	ROM_LOAD( "tpg1-ef.bin",  0x2e000, 0x2000, 0x64878342 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",    0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "tpg1-gr0.bin", 0x00000, 0x2000, 0x20c9217a )
	ROM_LOAD( "tpg1-gr1.bin", 0x02000, 0x2000, 0xd7f44504 )
	ROM_LOAD( "tpg1-gr2.bin", 0x04000, 0x2000, 0x4e59a15d )
	ROM_LOAD( "tpg1-gr3.bin", 0x06000, 0x2000, 0x323a8640 )
	ROM_LOAD( "tpg1-gr4.bin", 0x08000, 0x2000, 0x673acf42 )
	ROM_LOAD( "tpg1-gr5.bin", 0x0a000, 0x2000, 0x067bfd66 )
ROM_END


ROM_START( triviag2 )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.bin",  0x10000, 0x4000, 0x4fca20c5 )
	ROM_LOAD( "ab23.bin",  0x14000, 0x4000, 0x6cf2ddeb )
	ROM_LOAD( "ab45.bin",  0x18000, 0x4000, 0xa7ff789c )
	ROM_LOAD( "ab67.bin",  0x1c000, 0x4000, 0xcc5c68ef )
	ROM_LOAD( "cd45.bin",  0x28000, 0x4000, 0xfc9c752a )
	ROM_LOAD( "cd6ef.bin", 0x2c000, 0x4000, 0x23b56fb8 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.bin",  0x00000, 0x4000, 0x6829de8e )
	ROM_LOAD( "gr23.bin",  0x04000, 0x4000, 0x89398700 )
	ROM_LOAD( "gr45.bin",  0x08000, 0x4000, 0x1e870293 )
ROM_END


ROM_START( triviasp )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "allsport.8a", 0x10000, 0x4000, 0x54b7ff31 )
	ROM_LOAD( "allsport.7a", 0x14000, 0x4000, 0x59fae9d2 )
	ROM_LOAD( "allsport.6a", 0x18000, 0x4000, 0x237b6b95 )
	ROM_LOAD( "allsport.5a", 0x1c000, 0x4000, 0xb64d7f61 )
	ROM_LOAD( "allsport.3a", 0x28000, 0x4000, 0xe45d09d6 )
	ROM_LOAD( "allsport.1a", 0x2c000, 0x4000, 0x8bb3e831 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",     0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.bin",    0x00000, 0x4000, 0x6829de8e )
	ROM_LOAD( "gr23.bin",    0x04000, 0x4000, 0x89398700 )
	ROM_LOAD( "allsport.3b", 0x08000, 0x4000, 0x7415a7fc )
ROM_END


ROM_START( triviayp )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.bin",  0x10000, 0x4000, 0x97d35a85 )
	ROM_LOAD( "ab23.bin",  0x14000, 0x4000, 0x2ff67c70 )
	ROM_LOAD( "ab45.bin",  0x18000, 0x4000, 0x511a0fab )
	ROM_LOAD( "ab67.bin",  0x1c000, 0x4000, 0xdf99d00c )
	ROM_LOAD( "cd45.bin",  0x28000, 0x4000, 0xac45809e )
	ROM_LOAD( "cd6ef.bin", 0x2c000, 0x4000, 0xa008059f )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.bin", 0x00000, 0x4000, 0x6829de8e )
	ROM_LOAD( "gr23.bin", 0x04000, 0x4000, 0x89398700 )
	ROM_LOAD( "gr45.bin", 0x08000, 0x4000, 0x1242033e )
ROM_END


ROM_START( triviabb )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.bin",  0x10000, 0x4000, 0x1b7c439d )
	ROM_LOAD( "ab23.bin",  0x14000, 0x4000, 0xe4f1e704 )
	ROM_LOAD( "ab45.bin",  0x18000, 0x4000, 0xdaa2d8bc )
	ROM_LOAD( "ab67.bin",  0x1c000, 0x4000, 0x3622c4f1 )
	ROM_LOAD( "cd45.bin",  0x28000, 0x4000, 0x07fd88ff )
	ROM_LOAD( "cd6ef.bin", 0x2c000, 0x4000, 0x2d03f241 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.bin", 0x00000, 0x4000, 0x6829de8e )
	ROM_LOAD( "gr23.bin", 0x04000, 0x4000, 0x89398700 )
	ROM_LOAD( "gr45.bin", 0x08000, 0x4000, 0x92fb6fb1 )
ROM_END


ROM_START( gimeabrk )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.u8a",  0x10000, 0x4000, 0x18cc53db )
	ROM_LOAD( "ab23.u7a",  0x14000, 0x4000, 0x6bd4190a )
	ROM_LOAD( "ab45.u6a",  0x18000, 0x4000, 0x5dca4f33 )
	ROM_LOAD( "cd6ef.uia", 0x2c000, 0x4000, 0x5e2b3510 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.u6b", 0x00000, 0x4000, 0xe3cdc476 )
	ROM_LOAD( "gr23.u5b", 0x04000, 0x4000, 0x0555d9c0 )
ROM_END


ROM_START( minigolf )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.u8a",  0x10000, 0x4000, 0x348f827f )
	ROM_LOAD( "ab23.u7a",  0x14000, 0x4000, 0x19a6ff47 )
	ROM_LOAD( "ab45.u6a",  0x18000, 0x4000, 0x925d76eb )
	ROM_LOAD( "ab67.u5a",  0x1c000, 0x4000, 0x6a311c9a )
	ROM_LOAD( "1a-ver2",   0x20000, 0x10000, 0x60b6cd58 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.u6b", 0x00000, 0x4000, 0x8e24d594 )
	ROM_LOAD( "gr23.u5b", 0x04000, 0x4000, 0x3bf355ef )
	ROM_LOAD( "gr45.u4b", 0x08000, 0x4000, 0x8eb14921 )
ROM_END


ROM_START( minigol2 )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.u8a",  0x10000, 0x4000, 0x348f827f )
	ROM_LOAD( "ab23.u7a",  0x14000, 0x4000, 0x19a6ff47 )
	ROM_LOAD( "ab45.u6a",  0x18000, 0x4000, 0x925d76eb )
	ROM_LOAD( "ab67.u5a",  0x1c000, 0x4000, 0x6a311c9a )
	ROM_LOAD( "cd23.u3a",  0x24000, 0x4000, 0x52279801 )
	ROM_LOAD( "cd6ef.u1a", 0x2c000, 0x4000, 0x34c64f4c )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.u6b", 0x00000, 0x4000, 0x8e24d594 )
	ROM_LOAD( "gr23.u5b", 0x04000, 0x4000, 0x3bf355ef )
	ROM_LOAD( "gr45.u4b", 0x08000, 0x4000, 0x8eb14921 )
ROM_END


ROM_START( toggle )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "tgle-ab0.bin", 0x10000, 0x2000, 0x8c7b7fad )
	ROM_LOAD( "tgle-ab1.bin", 0x12000, 0x2000, 0x771e5434 )
	ROM_LOAD( "tgle-ab2.bin", 0x14000, 0x2000, 0x9b4baa3f )
	ROM_LOAD( "tgle-ab3.bin", 0x16000, 0x2000, 0x35308a41 )
	ROM_LOAD( "tgle-ab4.bin", 0x18000, 0x2000, 0xbaf5617b )
	ROM_LOAD( "tgle-ab5.bin", 0x1a000, 0x2000, 0x88077dad )
	ROM_LOAD( "tgle-cd.bin",  0x2c000, 0x2000, 0x0a2bb949 )
	ROM_LOAD( "tgle-ef.bin",  0x2e000, 0x2000, 0x3ec10804 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",    0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "tgle-gr0.bin", 0x00000, 0x2000, 0x0e0e5d0e )
	ROM_LOAD( "tgle-gr1.bin", 0x02000, 0x2000, 0x3b141ad2 )
ROM_END


ROM_START( nametune )
	ROM_REGION( 0x70000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "nttab01.bin",  0x10000, 0x4000, 0xf99054f1 )
	ROM_CONTINUE(             0x40000, 0x4000 )
	ROM_LOAD( "nttab23.bin",  0x14000, 0x4000, 0xf2b8f7fa )
	ROM_CONTINUE(             0x44000, 0x4000 )
	ROM_LOAD( "nttab45.bin",  0x18000, 0x4000, 0x89e1c769 )
	ROM_CONTINUE(             0x48000, 0x4000 )
	ROM_LOAD( "nttab67.bin",  0x1c000, 0x4000, 0x7e5572a1 )
	ROM_CONTINUE(             0x4c000, 0x4000 )
	ROM_LOAD( "nttcd01.bin",  0x20000, 0x4000, 0xdb9d6154 )
	ROM_CONTINUE(             0x50000, 0x4000 )
	ROM_LOAD( "nttcd23.bin",  0x24000, 0x4000, 0x9d2e458f )
	ROM_CONTINUE(             0x54000, 0x4000 )
	ROM_LOAD( "nttcd45.bin",  0x28000, 0x4000, 0x9a4b87aa )
	ROM_CONTINUE(             0x58000, 0x4000 )
	ROM_LOAD( "nttcd6ef.bin", 0x2c000, 0x4000, 0x0459e6f8 )
	ROM_CONTINUE(             0x5c000, 0x4000 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "nttgr0.bin",  0x00000, 0x8000, 0x6b75bb4b )
ROM_END


ROM_START( nstocker )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.u8a",  0x10000, 0x4000, 0xa635f973 )
	ROM_LOAD( "ab23.u7a",  0x14000, 0x4000, 0x223acbb2 )
	ROM_LOAD( "ab45.u6a",  0x18000, 0x4000, 0x27a728b5 )
	ROM_LOAD( "ab67.u5a",  0x1c000, 0x4000, 0x2999cdf2 )
	ROM_LOAD( "cd01.u4a",  0x20000, 0x4000, 0x75e9b51a )
	ROM_LOAD( "cd23.u3a",  0x24000, 0x4000, 0x0a32e0a5 )
	ROM_LOAD( "cd45.u2a",  0x28000, 0x4000, 0x9bb292fe )
	ROM_LOAD( "cd6ef.u1a", 0x2c000, 0x4000, 0xe77c1aea )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.u4c", 0x00000, 0x4000, 0xfd0c38be )
	ROM_LOAD( "gr23.u3c", 0x04000, 0x4000, 0x35d4433e )
	ROM_LOAD( "gr45.u2c", 0x08000, 0x4000, 0x734b858a )
	ROM_LOAD( "gr67.u1c", 0x0c000, 0x4000, 0x3311f9c0 )
ROM_END


ROM_START( sfootbal )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "sfbab01.bin",  0x10000, 0x4000, 0x2a69803f )
	ROM_LOAD( "sfbab23.bin",  0x14000, 0x4000, 0x89f157c2 )
	ROM_LOAD( "sfbab45.bin",  0x18000, 0x4000, 0x91ad42c5 )
	ROM_LOAD( "sfbcd6ef.bin", 0x2c000, 0x4000, 0xbf80bb1a )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "sfbgr01.bin", 0x00000, 0x4000, 0xe3108d35 )
	ROM_LOAD( "sfbgr23.bin", 0x04000, 0x4000, 0x5c5af726 )
	ROM_LOAD( "sfbgr45.bin", 0x08000, 0x4000, 0xe767251e )
	ROM_LOAD( "sfbgr67.bin", 0x0c000, 0x4000, 0x42452a7a )
ROM_END


ROM_START( spiker )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.u8a",  0x10000, 0x4000, 0x2d53d023 )
	ROM_LOAD( "ab23.u7a",  0x14000, 0x4000, 0x3be87edf )
	ROM_LOAD( "cd6ef.u1a", 0x2c000, 0x4000, 0xf2c73ece )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.u4c", 0x00000, 0x4000, 0x0caa6e3e )
	ROM_LOAD( "gr23.u3c", 0x04000, 0x4000, 0x970c81f6 )
	ROM_LOAD( "gr45.u2c", 0x08000, 0x4000, 0x90ddd737 )
ROM_END


ROM_START( stompin )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab01.bin",  0x10000, 0x4000, 0x46f428c6 )
	ROM_LOAD( "ab23.bin",  0x14000, 0x4000, 0x0e13132f )
	ROM_LOAD( "ab45.bin",  0x18000, 0x4000, 0x6ed26069 )
	ROM_LOAD( "ab67.bin",  0x1c000, 0x4000, 0x7f63b516 )
	ROM_LOAD( "cd23.bin",  0x24000, 0x4000, 0x52b29048 )
	ROM_LOAD( "cd6ef.bin", 0x2c000, 0x4000, 0xb880961a )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr01.u4c", 0x00000, 0x4000, 0x14ffdd1e )
	ROM_LOAD( "gr23.u3c", 0x04000, 0x4000, 0x761abb80 )
	ROM_LOAD( "gr45.u2c", 0x08000, 0x4000, 0x0d2cf2e6 )
	ROM_LOAD( "gr67.u2c", 0x0c000, 0x4000, 0x2bab2784 )
ROM_END


ROM_START( rescraid )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab1.a10",   0x10000, 0x8000, 0x33a76b47 )
	ROM_LOAD( "ab12.a12",  0x18000, 0x8000, 0x7c7a9f12 )
	ROM_LOAD( "cd8.a16",   0x20000, 0x8000, 0x90917a43 )
	ROM_LOAD( "cd12.a18",  0x28000, 0x8000, 0x0450e9d7 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr0.a5",    0x00000, 0x8000, 0xe0dfc133 )
	ROM_LOAD( "gr4.a7",    0x08000, 0x8000, 0x952ade30 )
ROM_END


ROM_START( rescrdsa )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "ab1-sa.a10",   0x10000, 0x8000, 0xaa0a9f48 )
	ROM_LOAD( "ab12-sa.a12",  0x18000, 0x8000, 0x16d4da86 )
	ROM_LOAD( "cd8-sa.a16",   0x20000, 0x8000, 0x9dfb50c2 )
	ROM_LOAD( "cd12-sa.a18",  0x28000, 0x8000, 0x18c62613 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",  0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x10000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "gr0.a5",    0x00000, 0x8000, 0xe0dfc133 )
	ROM_LOAD( "gr4.a7",    0x08000, 0x8000, 0x952ade30 )
ROM_END


ROM_START( shrike )
	ROM_REGION( 0x40000, REGION_CPU1, 0 )     /* 64k for code for the first CPU, plus 128k of banked ROMs */
	ROM_LOAD( "savgu35.bin", 0x10000, 0x2000, 0xdd2230a0 )
	ROM_LOAD( "savgu20.bin", 0x12000, 0x2000, 0x3d140edc )
	ROM_LOAD( "savgu34.bin", 0x14000, 0x2000, 0x779eca9d )
	ROM_LOAD( "savgu19.bin", 0x16000, 0x2000, 0x9ec89a80 )
	ROM_LOAD( "savgu33.bin", 0x18000, 0x2000, 0x20596f48 )
	ROM_LOAD( "savgu18.bin", 0x1a000, 0x2000, 0x7abc3f14 )
	ROM_LOAD( "savgu32.bin", 0x1c000, 0x2000, 0x807f0a3b )
	ROM_LOAD( "savgu17.bin", 0x1e000, 0x2000, 0xe0dbf6ad )
	ROM_LOAD( "savgu21.bin", 0x2c000, 0x2000, 0xc22b93e1 )
	ROM_LOAD( "savgu36.bin", 0x2e000, 0x2000, 0x28431c4a )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )		/* 64k for Z80 */
	ROM_LOAD( "sentesnd",    0x00000, 0x2000, 0x4dd0a525 )

	ROM_REGION( 0x4000, REGION_CPU3, 0 )		/* 16k for M68000 */
	ROM_LOAD16_BYTE( "savgu22.bin", 0x00000, 0x2000, 0xc7787162 )
	ROM_LOAD16_BYTE( "savgu24.bin", 0x00001, 0x2000, 0xa9105ca8 )

	ROM_REGION( 0x20000, REGION_GFX1, 0 )		/* up to 64k of sprites */
	ROM_LOAD( "savgu8.bin",  0x00000, 0x2000, 0x499a1d06 )
	ROM_LOAD( "savgu7.bin",  0x02000, 0x2000, 0xce0607f9 )
	ROM_LOAD( "savgu6.bin",  0x04000, 0x2000, 0x01d1b31e )
	ROM_LOAD( "savgu5.bin",  0x06000, 0x2000, 0x8bc6d101 )
	ROM_LOAD( "savgu4.bin",  0x08000, 0x2000, 0x72644753 )
	ROM_LOAD( "savgu3.bin",  0x0a000, 0x2000, 0x606a9cfd )
	ROM_LOAD( "savgu2.bin",  0x0c000, 0x2000, 0x69f600f6 )
	ROM_LOAD( "savgu1.bin",  0x0e000, 0x2000, 0x303b8e7b )
	ROM_LOAD( "savgu16.bin", 0x10000, 0x2000, 0xb8f60607 )
	ROM_LOAD( "savgu15.bin", 0x12000, 0x2000, 0x6b332a5d )
	ROM_LOAD( "savgu14.bin", 0x14000, 0x2000, 0x8d5117aa )
	ROM_LOAD( "savgu13.bin", 0x16000, 0x2000, 0xd3ce645e )
	ROM_LOAD( "savgu12.bin", 0x18000, 0x2000, 0xccdfedb1 )
	ROM_LOAD( "savgu11.bin", 0x1a000, 0x2000, 0xdb11ff4c )
	ROM_LOAD( "savgu10.bin", 0x1c000, 0x2000, 0x6f3d9aa1 )
ROM_END



/*************************************
 *
 *	Driver initialization
 *
 *************************************/

#define EXPAND_ALL		0x00
#define EXPAND_NONE		0x3f
#define SWAP_HALVES		0x80

static void expand_roms(UINT8 cd_rom_mask)
{
	/* load AB bank data from 0x10000-0x20000 */
	/* load CD bank data from 0x20000-0x2e000 */
	/* load EF           from 0x2e000-0x30000 */
	/* ROM region must be 0x40000 total */

	UINT8 *temp = malloc(0x20000);
	if (temp)
	{
		UINT8 *rom = memory_region(REGION_CPU1);
		UINT32 base;

		for (base = 0x10000; base < memory_region_length(REGION_CPU1); base += 0x30000)
		{
			UINT8 *ab_base = &temp[0x00000];
			UINT8 *cd_base = &temp[0x10000];
			UINT8 *cd_common = &temp[0x1c000];
			UINT8 *ef_common = &temp[0x1e000];
			UINT32 dest;

			for (dest = 0x00000; dest < 0x20000; dest += 0x02000)
			{
				if (cd_rom_mask & SWAP_HALVES)
					memcpy(&temp[dest ^ 0x02000], &rom[base + dest], 0x02000);
				else
					memcpy(&temp[dest], &rom[base + dest], 0x02000);
			}

			memcpy(&rom[base + 0x2e000], ef_common, 0x2000);
			memcpy(&rom[base + 0x2c000], cd_common, 0x2000);
			memcpy(&rom[base + 0x2a000], &ab_base[0xe000], 0x2000);

			memcpy(&rom[base + 0x28000], ef_common, 0x2000);
			memcpy(&rom[base + 0x26000], cd_common, 0x2000);
			memcpy(&rom[base + 0x24000], &ab_base[0xc000], 0x2000);

			memcpy(&rom[base + 0x22000], ef_common, 0x2000);
			memcpy(&rom[base + 0x20000], (cd_rom_mask & 0x20) ? &cd_base[0xa000] : cd_common, 0x2000);
			memcpy(&rom[base + 0x1e000], &ab_base[0xa000], 0x2000);

			memcpy(&rom[base + 0x1c000], ef_common, 0x2000);
			memcpy(&rom[base + 0x1a000], (cd_rom_mask & 0x10) ? &cd_base[0x8000] : cd_common, 0x2000);
			memcpy(&rom[base + 0x18000], &ab_base[0x8000], 0x2000);

			memcpy(&rom[base + 0x16000], ef_common, 0x2000);
			memcpy(&rom[base + 0x14000], (cd_rom_mask & 0x08) ? &cd_base[0x6000] : cd_common, 0x2000);
			memcpy(&rom[base + 0x12000], &ab_base[0x6000], 0x2000);

			memcpy(&rom[base + 0x10000], ef_common, 0x2000);
			memcpy(&rom[base + 0x0e000], (cd_rom_mask & 0x04) ? &cd_base[0x4000] : cd_common, 0x2000);
			memcpy(&rom[base + 0x0c000], &ab_base[0x4000], 0x2000);

			memcpy(&rom[base + 0x0a000], ef_common, 0x2000);
			memcpy(&rom[base + 0x08000], (cd_rom_mask & 0x02) ? &cd_base[0x2000] : cd_common, 0x2000);
			memcpy(&rom[base + 0x06000], &ab_base[0x2000], 0x2000);

			memcpy(&rom[base + 0x04000], ef_common, 0x2000);
			memcpy(&rom[base + 0x02000], (cd_rom_mask & 0x01) ? &cd_base[0x0000] : cd_common, 0x2000);
			memcpy(&rom[base + 0x00000], &ab_base[0x0000], 0x2000);
		}

		free(temp);
	}
}

static DRIVER_INIT( sentetst ) { expand_roms(EXPAND_ALL);  balsente_shooter = 0; /* noanalog */ }
static DRIVER_INIT( cshift )   { expand_roms(EXPAND_ALL);  balsente_shooter = 0; /* noanalog */ }
static DRIVER_INIT( gghost )   { expand_roms(EXPAND_ALL);  balsente_shooter = 0; balsente_adc_shift = 1; }
static DRIVER_INIT( hattrick ) { expand_roms(EXPAND_ALL);  balsente_shooter = 0; /* noanalog */ }
static DRIVER_INIT( otwalls )  { expand_roms(EXPAND_ALL);  balsente_shooter = 0; balsente_adc_shift = 0; }
static DRIVER_INIT( snakepit ) { expand_roms(EXPAND_ALL);  balsente_shooter = 0; balsente_adc_shift = 1; }
static DRIVER_INIT( snakjack ) { expand_roms(EXPAND_ALL);  balsente_shooter = 0; balsente_adc_shift = 1; }
static DRIVER_INIT( stocker )  { expand_roms(EXPAND_ALL);  balsente_shooter = 0; balsente_adc_shift = 0; }
static DRIVER_INIT( triviag1 ) { expand_roms(EXPAND_ALL);  balsente_shooter = 0; /* noanalog */ }
static DRIVER_INIT( triviag2 )
{
	memcpy(&memory_region(REGION_CPU1)[0x20000], &memory_region(REGION_CPU1)[0x28000], 0x4000);
	memcpy(&memory_region(REGION_CPU1)[0x24000], &memory_region(REGION_CPU1)[0x28000], 0x4000);
	expand_roms(EXPAND_NONE); balsente_shooter = 0; /* noanalog */
}
static DRIVER_INIT( gimeabrk ) { expand_roms(EXPAND_ALL);  balsente_shooter = 0; balsente_adc_shift = 1; }
static DRIVER_INIT( minigolf ) { expand_roms(EXPAND_NONE); balsente_shooter = 0; balsente_adc_shift = 2; }
static DRIVER_INIT( minigol2 ) { expand_roms(0x0c);        balsente_shooter = 0; balsente_adc_shift = 2; }
static DRIVER_INIT( toggle )   { expand_roms(EXPAND_ALL);  balsente_shooter = 0; /* noanalog */ }
static DRIVER_INIT( nametune )
{
	install_mem_write_handler(0, 0x9f00, 0x9f00, balsente_rombank2_select_w);
	expand_roms(EXPAND_NONE | SWAP_HALVES); balsente_shooter = 0; /* noanalog */
}
static DRIVER_INIT( nstocker )
{
	install_mem_read_handler(0, 0x9902, 0x9902, nstocker_port2_r);
	install_mem_write_handler(0, 0x9f00, 0x9f00, balsente_rombank2_select_w);
	expand_roms(EXPAND_NONE | SWAP_HALVES); balsente_shooter = 1; balsente_adc_shift = 1;
}
static DRIVER_INIT( sfootbal )
{
	install_mem_write_handler(0, 0x9f00, 0x9f00, balsente_rombank2_select_w);
	expand_roms(EXPAND_ALL  | SWAP_HALVES); balsente_shooter = 0; balsente_adc_shift = 0;
}
static DRIVER_INIT( spiker )
{
	install_mem_write_handler(0, 0x9f80, 0x9f8f, spiker_expand_w);
	install_mem_read_handler(0, 0x9f80, 0x9f8f, spiker_expand_r);
	install_mem_write_handler(0, 0x9f00, 0x9f00, balsente_rombank2_select_w);
	expand_roms(EXPAND_ALL  | SWAP_HALVES); balsente_shooter = 0; balsente_adc_shift = 1;
}
static DRIVER_INIT( stompin )
{
	install_mem_write_handler(0, 0x9f00, 0x9f00, balsente_rombank2_select_w);
	expand_roms(0x0c | SWAP_HALVES); balsente_shooter = 0; balsente_adc_shift = 32;
}
static DRIVER_INIT( rescraid ) { expand_roms(EXPAND_NONE); balsente_shooter = 0; /* noanalog */ }
static DRIVER_INIT( shrike )
{
	install_mem_read_handler(0, 0x9e00, 0x9fff, MRA_RAM);
	install_mem_write_handler(0, 0x9e00, 0x9fff, MWA_RAM);
	install_mem_read_handler(0, 0x9e00, 0x9e0f, shrike_shared_6809_r);
	install_mem_write_handler(0, 0x9e00, 0x9e0f, shrike_shared_6809_w);
	expand_roms(EXPAND_ALL);  balsente_shooter = 0; balsente_adc_shift = 32;
}



/*************************************
 *
 *	Game drivers
 *
 *************************************/

GAME( 1984, sentetst, 0,        balsente, sentetst, sentetst, ROT0, "Bally/Sente", "Sente Diagnostic Cartridge" )
GAME( 1984, cshift,   0,        balsente, cshift,   cshift,   ROT0, "Bally/Sente", "Chicken Shift" )
GAME( 1984, gghost,   0,        balsente, gghost,   gghost,   ROT0, "Bally/Sente", "Goalie Ghost" )
GAME( 1984, hattrick, 0,        balsente, hattrick, hattrick, ROT0, "Bally/Sente", "Hat Trick" )
GAME( 1984, otwalls,  0,        balsente, otwalls,  otwalls,  ROT0, "Bally/Sente", "Off the Wall (Sente)" )
GAME( 1984, snakepit, 0,        balsente, snakepit, snakepit, ROT0, "Bally/Sente", "Snake Pit" )
GAME( 1984, snakjack, 0,        balsente, snakjack, snakjack, ROT0, "Bally/Sente", "Snacks'n Jaxson" )
GAME( 1984, stocker,  0,        balsente, stocker,  stocker,  ROT0, "Bally/Sente", "Stocker" )
GAME( 1984, triviag1, 0,        balsente, triviag1, triviag1, ROT0, "Bally/Sente", "Trivial Pursuit (Genus I)" )
GAME( 1984, triviag2, 0,        balsente, triviag2, triviag2, ROT0, "Bally/Sente", "Trivial Pursuit (Genus II)" )
GAME( 1984, triviasp, 0,        balsente, triviasp, triviag2, ROT0, "Bally/Sente", "Trivial Pursuit (All Star Sports Edition)" )
GAME( 1984, triviayp, 0,        balsente, triviayp, triviag2, ROT0, "Bally/Sente", "Trivial Pursuit (Young Players Edition)" )
GAME( 1984, triviabb, 0,        balsente, triviabb, triviag2, ROT0, "Bally/Sente", "Trivial Pursuit (Baby Boomer Edition)" )
GAME( 1985, gimeabrk, 0,        balsente, gimeabrk, gimeabrk, ROT0, "Bally/Sente", "Gimme A Break" )
GAME( 1985, minigolf, 0,        balsente, minigolf, minigolf, ROT0, "Bally/Sente", "Mini Golf (set 1)" )
GAME( 1985, minigol2, minigolf, balsente, minigol2, minigol2, ROT0, "Bally/Sente", "Mini Golf (set 2)" )
GAME( 1985, toggle,   0,        balsente, toggle,   toggle,   ROT0, "Bally/Sente", "Toggle (prototype)" )
GAME( 1986, nametune, 0,        balsente, nametune, nametune, ROT0, "Bally/Sente", "Name That Tune" )
GAME( 1986, nstocker, 0,        balsente, nstocker, nstocker, ROT0, "Bally/Sente", "Night Stocker" )
GAME( 1986, sfootbal, 0,        balsente, sfootbal, sfootbal, ROT0, "Bally/Sente", "Street Football" )
GAME( 1986, spiker,   0,        balsente, spiker,   spiker,   ROT0, "Bally/Sente", "Spiker" )
GAME( 1986, stompin,  0,        balsente, stompin,  stompin,  ROT0, "Bally/Sente", "Stompin'" )
GAME( 1987, rescraid, 0,        balsente, rescraid, rescraid, ROT0, "Bally/Midway", "Rescue Raider" )
GAME( 1987, rescrdsa, rescraid, balsente, rescraid, rescraid, ROT0, "Bally/Midway", "Rescue Raider (Stand-Alone)" )
GAMEX(1987, shrike,   0,        shrike,   shrike,   shrike,   ROT0, "Bally/Sente", "Shrike Avenger (prototype)", GAME_NOT_WORKING )
