/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for Win32
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

/***************************************************************************

  M32Util.c

 ***************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <shellapi.h>
#include <assert.h>
#include <stdio.h>
#include "win32.h"
#include "misc.h"

/***************************************************************************
    function prototypes
 ***************************************************************************/

/***************************************************************************
    External variables
 ***************************************************************************/

/***************************************************************************
    Internal structures
 ***************************************************************************/

/***************************************************************************
    Internal variables
 ***************************************************************************/


/***************************************************************************
    External functions
 ***************************************************************************/

/*
 * Return TRUE if comctl32.dll is version 4.71 or greater
 * otherwise return FALSE.
 */
BOOL GetDllVersion(void)
{
    HMODULE hModule = GetModuleHandle("comctl32");

    if (hModule)
    {
        FARPROC lpfnICCE = GetProcAddress(hModule, "InitCommonControlsEx");

        if (NULL != lpfnICCE)
        {
            FARPROC lpfnDLLI = GetProcAddress(hModule, "DllInstall");

            if (NULL != lpfnDLLI) 
            {
                /* comctl 4.71 or greater */
                return TRUE;
            }
            /* comctl 4.7 - fall through
             * return FALSE;
             */
        }
        /* comctl 4.0 - fall through
         * return FALSE;
         */
    }
    /* DLL not found */
    return FALSE;
}

void DisplayTextFile(HWND hWnd, char *cName)
{
    HINSTANCE hErr;
    char      *msg = 0;

    hErr = ShellExecute(hWnd, NULL, cName, NULL, NULL, SW_SHOWNORMAL);
    if ((int)hErr > 32)
        return;

#ifdef JAPANESE
    switch((int)hErr)
    {
    case 0:
        msg = "޸ Ǵ ҽ մϴ١";
        break;

    case ERROR_FILE_NOT_FOUND:
        msg = "  ϴ١";
        break;

    case SE_ERR_NOASSOC :
        msg = "Ȯڿ  α׷ ϴ١";
        break;

    case SE_ERR_OOM :
        msg = "ó ϱ  ޸𸮰 մϴ١";
        break;

    case SE_ERR_PNF :
        msg = " θ ã ߽ϴ١";
        break;

    case SE_ERR_SHARE :
        msg = " ߻߽ϴ١";
        break;

    default:
        msg = " ˼  ߻߽ϴ١";
    }
#else
    switch((int)hErr)
    {
    case 0:
        msg = "The operating system is out of memory or resources.";
        break;

    case ERROR_FILE_NOT_FOUND:
        msg = "The specified file was not found."; 
        break;

    case SE_ERR_NOASSOC :
        msg = "There is no application associated with the given filename extension.";
        break;

    case SE_ERR_OOM :
        msg = "There was not enough memory to complete the operation.";
        break;

    case SE_ERR_PNF :
        msg = "The specified path was not found.";
        break;

    case SE_ERR_SHARE :
        msg = "A sharing violation occurred.";
        break;

    default:
        msg = "Unknown error.";
    }
#endif
 
    MessageBox(NULL, msg, cName, MB_OK); 
}

char* MyStrStrI(const char* pFirst, const char* pSrch)
{
    char* cp = (char*)pFirst;
    char* s1;
    char* s2;
    
    while (*cp)
    {
        s1 = cp;
        s2 = (char*)pSrch;
        
        while (*s1 && *s2 && !strnicmp(s1, s2, 1))
            s1++, s2++;
        
        if (!*s2)
            return cp;
        
        cp++;
    }
    return NULL;
}

/***************************************************************************
    Internal functions
 ***************************************************************************/

