;
; MagmaTV Installation Script
;
; Created by Hye-Shik Chang <perky@i18n.org>
;
; $Id: MagmaTV.nsi,v 1.2 2004/04/16 14:53:30 perky Exp $
;

;Icons and graphics
!define MUI_ICON "contrib\yi-box_install.ico"
!define MUI_UNICON "contrib\yi-box_uninstall.ico"
!define MUI_CHECKBITMAP "contrib\yi-box_check.bmp"

!include "MUI.nsh"

;--------------------------------
;Version and Basic Scheme

!define PRODUCT_NAME "MagmaTV"
!define VERSION_NAME "1.1"

!define REGISTRY_ROOT HKLM
!define REGISTRY_PATH "Software\SIGMACOM\TV Card\MagmaTV"
!define SMGROUP "SIGMA TV II"
!define SMPATH "$SMPROGRAMS\${SMGROUP}"

XPStyle on

;--------------------------------
;Configuration

  ;General
  Name "${PRODUCT_NAME} ${VERSION_NAME}"
  OutFile "${PRODUCT_NAME}-${VERSION_NAME}.exe"

  ;Folder selection page
  InstallDir "C:\Program Files\SIGMA\MagmaTV"
  
  ;Remember install folder
  InstallDirRegKey "${REGISTRY_ROOT}" "${REGISTRY_PATH}\InstallPath" ""

  ;Show its version
  BrandingText "${PRODUCT_NAME} ${VERSION_NAME}"

;--------------------------------
;Modern UI Configuration

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "License.txt"
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES

  !define MUI_COMPONENTSPAGE_SMALLDESC
  !define MUI_ABORTWARNING

  
;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "Korean"
  !insertmacro MUI_RESERVEFILE_LANGDLL
  ; XXX: LANG

Section Main

  SetOutPath "$INSTDIR"
  File "LICENSE.txt"
  File "..\MagmaDLL\Release\MagmaDLL.dll"
  File "..\MagmaTV\Release\MagmaTV.exe"

  WriteUninstaller "$INSTDIR\Uninstall.exe"
  WriteRegStr ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}" "DisplayName" "${PRODUCT_NAME} ${VERSION_NAME}"
  WriteRegStr ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}" "UninstallString" "$INSTDIR\Uninstall.exe"
  WriteRegStr ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}" "InstallLocation" "$INSTDIR"
  WriteRegStr ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}" "DisplayIcon" "$INSTDIR\MagmaTV.exe,-0"
  WriteRegStr ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}" "DisplayVersion" "${VERSION_NAME}"
  WriteRegStr ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}" "Publisher" "Hye-Shik Chang"
  WriteRegStr ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}" "HelpLink" "http://kldp.net/projects/magmatv"
  WriteRegStr ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}" "URLInfoAbout" "http://kldp.net/projects/magmatv"

  CreateDirectory "${SMPATH}"
  SetOutPath "$INSTDIR"
  CreateShortCut "${SMPATH}\MagmaTV .lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "${SMPATH}\MagmaTV.lnk" "$INSTDIR\MagmaTV.exe" "" "$INSTDIR\MagmaTV.exe" 0

SectionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_FUNCTION_DESCRIPTION_END
 

;Uninstaller Section

Section "Uninstall"

  Delete "$INSTDIR\Uninstall.exe"
  Delete "$INSTDIR\MagmaTV.exe"
  Delete "$INSTDIR\MagmaDLL.dll"
  Delete "$INSTDIR\LICENSE.txt"
  RMDir "$INSTDIR"

  Delete "${SMPATH}\MagmaTV*.*"

  DeleteRegKey ${REGISTRY_ROOT} "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}-${VERSION_NAME}"

SectionEnd
