// $Id: MagmaTVDlg.h,v 1.11 2004/04/28 15:00:06 perky Exp $
//
// Copyright (C) 2004 Hye-Shik Chang. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

#if !defined(AFX_MAGMATVDLG_H__B3F7C9DA_EBA6_4D11_9E8F_5DF9697FE4B0__INCLUDED_)
#define AFX_MAGMATVDLG_H__B3F7C9DA_EBA6_4D11_9E8F_5DF9697FE4B0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "RemoconData.h"
#include "SystemTray.h"
#include "PlaySound.h"

/////////////////////////////////////////////////////////////////////////////
// CMagmaTVDlg dialog

class CMagmaTVDlg : public CDialog
{
// Construction
public:
	void TriggerOff10Sec();
	void TriggerOff5Min(void);
	HWND FindSigmaWindow();
	void UpdateUsage(int nId);
	void UpdateCommand(int nId);
	void ApplyAvailabilities(void);
	afx_msg LRESULT ProcessSigmaMsg(WPARAM wParam, LPARAM lParam);
	CMagmaTVDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CMagmaTVDlg)
	enum { IDD = IDD_MAGMATV_DIALOG };
	BOOL	m_hooked;
	BOOL	m_sigmatv_aot;
	BOOL	m_use_voice;
	int		m_voice_type;
	//}}AFX_DATA
	CString	m_command[N_KEYS];
	int		m_usage[N_KEYS];

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMagmaTVDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	void PlaySound(int nVoiceId);
	CPlaySound m_PlaySound;
	void LoadConfig();
	BOOL m_bTrayMinimized;
	void UpdatePosTimer();
	void SaveConfig(void);
	int ApplyHook(BOOL bHook);
	HICON m_hIcon;
	CSystemTray* m_pTrayIcon;
	int m_nTrayNotificationMsg;
	BOOL m_bOffTriggered;

	// Generated message map functions
	//{{AFX_MSG(CMagmaTVDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnCancel();
	afx_msg void OnToggleHook();
	afx_msg void OnChangeCommand1();
	afx_msg void OnChangeCommand2();
	afx_msg void OnChangeCommand3();
	afx_msg void OnChangeCommand4();
	afx_msg void OnChangeCommand5();
	afx_msg void OnChangeCommand6();
	afx_msg void OnChangeCommand7();
	afx_msg void OnChangeCommand8();
	afx_msg void OnChangeCommand9();
	afx_msg void OnSelchangeUsage1();
	afx_msg void OnSelchangeUsage2();
	afx_msg void OnSelchangeUsage3();
	afx_msg void OnSelchangeUsage4();
	afx_msg void OnSelchangeUsage5();
	afx_msg void OnSelchangeUsage6();
	afx_msg void OnSelchangeUsage7();
	afx_msg void OnSelchangeUsage8();
	afx_msg void OnSelchangeUsage9();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnSigmaTVAOT();
	afx_msg void OnDestroy();
	afx_msg void OnRestore();
	afx_msg void OnExit();
	afx_msg void OnAbout();
	afx_msg void OnUseVoice();
	afx_msg void OnSelchangeVoiceType();
	afx_msg void OnHide();
	afx_msg void OnPlay();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAGMATVDLG_H__B3F7C9DA_EBA6_4D11_9E8F_5DF9697FE4B0__INCLUDED_)
