// $Id: Configuration.cpp,v 1.4 2004/04/19 02:45:40 perky Exp $
//
// Copyright (C) 2004 Hye-Shik Chang. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

#include "stdafx.h"
#include "Configuration.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CConfiguration Config;

const RCKEY_INFO g_keyinfo[N_KEYS] = {
	{WM_USER+74,	_T("STOP"),		KEYBEHAV_NONE,		IDC_USAGE_1,	IDC_COMMAND_1},
	{WM_USER+75,	_T("EJECT"),	KEYBEHAV_NONE,		IDC_USAGE_2,	IDC_COMMAND_2},
	{WM_USER+76,	_T("PREV"),		KEYBEHAV_TURNOFF_AFTER15SEC,
														IDC_USAGE_3,	IDC_COMMAND_3},
	{WM_USER+77,	_T("NEXT"),		KEYBEHAV_TURNOFF_AFTER5MIN,
														IDC_USAGE_4,	IDC_COMMAND_4},
	{WM_USER+78,	_T("REW"),		KEYBEHAV_NONE,		IDC_USAGE_5,	IDC_COMMAND_5},
	{WM_USER+79,	_T("PLAY"),		KEYBEHAV_NONE,		IDC_USAGE_6,	IDC_COMMAND_6},
	{WM_USER+80,	_T("FFW"),		KEYBEHAV_NONE,		IDC_USAGE_7,	IDC_COMMAND_7},
	{WM_USER+81,	_T("MENUUP"),	KEYBEHAV_NONE,		IDC_USAGE_8,	IDC_COMMAND_8},
	{WM_USER+82,	_T("MENU"),		KEYBEHAV_NONE,		IDC_USAGE_9,	IDC_COMMAND_9},
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CConfiguration::CConfiguration() : CRegConfig(HKEY_CURRENT_USER, "Software\\SIGMACOM\\TV Card\\MagmaTV")
{
	bEnabled = TRUE;

	for (int i = 0; i < N_KEYS; i++) {
		eButtonBehavior[i] = g_keyinfo[i].eDefaultBehavior;
		strCommandLine[i] = _T("");
	}

	bSigmaAlwaysOnTop = TRUE;
	bVoiceEnabled = TRUE;
	nVoiceType = 0;

	Load();
}

CConfiguration::~CConfiguration()
{
	Save();
}

void CConfiguration::TransferAllData(BOOL bSave)
{
	Transfer(bSave, "Enabled", bEnabled);

	for (int i = 0; i < N_KEYS; i++) {
		CString strVarName;

		strVarName.Format(_T("ButtonBehavior%d"), i);
		Transfer(bSave, strVarName, eButtonBehavior[i]);

		strVarName.Format(_T("CommandLine%d"), i);
		Transfer(bSave, strVarName, strCommandLine[i]);
	}

	Transfer(bSave, "SigmaTVAOT", bSigmaAlwaysOnTop);
	Transfer(bSave, "VoiceEnabled", bVoiceEnabled);
	Transfer(bSave, "VoiceType", nVoiceType);
}
