// $Id: MagmaDLL.cpp,v 1.6 2004/04/16 03:22:48 perky Exp $
//
// Copyright (C) 2004 Hye-Shik Chang. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

#include "stdafx.h"
#include "MagmaDLL.h"

// Shared data among all instances.
#pragma data_seg(".STATICDATA")
HHOOK sg_hook = NULL;
HWND sg_hWnd = NULL;
#pragma data_seg()

#pragma comment(linker, "/SECTION:.STATICDATA,RWS")

HINSTANCE g_hInstance = NULL;

BOOL APIENTRY DllMain( HANDLE hModule, 
					   DWORD  ul_reason_for_call, 
					   LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }

	g_hInstance = (HINSTANCE)hModule;
	sg_hook = NULL;

    return TRUE;
}

MAGMADLL_API int InstallHook(HWND hWnd, DWORD dwThreadId)
{
	if (sg_hook != NULL)
		RemoveHook();

	sg_hook = SetWindowsHookEx(WH_GETMESSAGE, HookProc, g_hInstance, dwThreadId);
	if (sg_hook == NULL)
		return -1;
	else {
		sg_hWnd = hWnd;
		return 0;
	}
}

MAGMADLL_API int RemoveHook()
{
	if (sg_hook != NULL) {
		UnhookWindowsHookEx(sg_hook);
		sg_hook = NULL;
		sg_hWnd = NULL;
	}
	return 0;
}

MAGMADLL_API LRESULT CALLBACK HookProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	if (nCode >= 0)
	{
		HWND hWnd = NULL;
		MSG *pMsg = (MSG*)lParam;

		if (pMsg->message != WM_TIMER) {
			hWnd = FindWindow("#32770", "MagmaTV");
			if (hWnd != NULL)
				PostMessage(hWnd, WM_USER+755,
							(WPARAM)pMsg->message,
							(LPARAM)pMsg->wParam);
		}
	}
	return CallNextHookEx(sg_hook, nCode, wParam, lParam);
}
