/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.SectionManager;

public class Section {
    protected int sectionNumber;
    protected String packageName;
    protected String serverCursorName;
    int resultSetHoldability_;
    byte[] PKGNAMCBytes;
    boolean isGenerated;
    public String serverCursorNameForPositionedUpdate_ = null;
    protected transient String clientCursorName_;
    protected Agent agent_;

    public Section(Agent agent, String string, int n, String string2, int n2) {
        this.init(agent, string, n, string2, n2, false);
    }

    public Section(Agent agent, String string, int n, String string2, int n2, boolean bl) {
        this.init(agent, string, n, string2, n2, bl);
    }

    private void init(Agent agent, String string, int n, String string2, int n2, boolean bl) {
        this.packageName = string;
        this.sectionNumber = n;
        this.serverCursorName = string2;
        this.resultSetHoldability_ = n2;
        this.agent_ = agent;
        this.isGenerated = bl;
        if (!bl) {
            if (this.resultSetHoldability_ == 1) {
                SectionManager cfr_ignored_0 = this.agent_.sectionManager_;
                this.PKGNAMCBytes = SectionManager.holdPKGNAMCBytes;
            } else if (this.resultSetHoldability_ == 2) {
                SectionManager cfr_ignored_1 = this.agent_.sectionManager_;
                this.PKGNAMCBytes = SectionManager.noHoldPKGNAMCBytes;
            }
        }
    }

    public void setPKGNAMCBytes(byte[] byArray) {
        if (this.isGenerated) {
            this.PKGNAMCBytes = byArray;
        } else {
            this.agent_.sectionManager_.setPKGNAMCBytes(byArray, this.resultSetHoldability_);
        }
    }

    public byte[] getPKGNAMCBytes() {
        return this.PKGNAMCBytes;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getSectionNumber() {
        return this.sectionNumber;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getServerCursorName() {
        return this.serverCursorName;
    }

    public String getServerCursorNameForPositionedUpdate() {
        return this.serverCursorNameForPositionedUpdate_;
    }

    public String getClientCursorName() {
        return this.clientCursorName_;
    }

    public void setClientCursorName(String string) {
        this.clientCursorName_ = string;
    }

    public void free() {
        if (this.resultSetHoldability_ != -1) {
            this.agent_.sectionManager_.freeSection(this, this.resultSetHoldability_);
        }
    }

    public boolean isReservedPositionedUpdate() {
        return false;
    }

    public int getStaticStatementType() {
        return 0;
    }

    public Section getPositionedUpdateSection() throws SQLException {
        return this.agent_.sectionManager_.getPositionedUpdateSection(this);
    }

    public void setCursorName(String string) {
        this.serverCursorName = string;
    }
}

