/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAException;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.DatabaseMetaData;
import org.apache.derby.client.am.ExceptionFormatter;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.Version;
import org.apache.derby.jdbc.ClientDataSource;

public class LogWriter {
    protected PrintWriter printWriter_;
    protected int traceLevel_;
    private boolean driverConfigurationHasBeenWrittenToJdbc1Stream_ = false;
    private boolean driverConfigurationHasBeenWrittenToJdbc2Stream_ = false;
    public boolean printWriterNeedsToBeClosed_;

    public LogWriter(PrintWriter printWriter, int n) {
        this.printWriter_ = printWriter;
        this.traceLevel_ = n;
    }

    protected final boolean loggingEnabled(int n) {
        return this.printWriter_ != null && (n & this.traceLevel_) != 0;
    }

    protected final boolean traceSuspended() {
        return Configuration.traceSuspended__;
    }

    void close() {
        if (this.printWriterNeedsToBeClosed_) {
            this.printWriter_.close();
            this.printWriterNeedsToBeClosed_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dncprintln(String string) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby] " + string);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprint(String string) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] " + string);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprintln(String string, String string2) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby]" + string + " " + string2);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprint(String string, String string2) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby]" + string + " " + string2);
            this.printWriter_.flush();
        }
    }

    public void tracepoint(String string, int n, String string2) {
        if (this.traceSuspended()) {
            return;
        }
        this.dncprintln(string, "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + n + "]" + string2);
    }

    public void tracepoint(String string, int n, String string2, String string3) {
        if (this.traceSuspended()) {
            return;
        }
        String string4 = string + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + n + "]" + "[" + string2 + "." + string3 + "]";
        this.dncprintln(string4);
    }

    public void tracepoint(String string, int n, Object object, String string2, String string3) {
        if (this.traceSuspended()) {
            return;
        }
        String string4 = string + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + n + "]" + "[" + string2 + "@" + Integer.toHexString(object.hashCode()) + "." + string3 + "]";
        this.dncprintln(string4);
    }

    public void tracepoint(String string, int n, String string2, String string3, Map map) {
        if (this.traceSuspended()) {
            return;
        }
        String string4 = string + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + n + "]" + "[" + string2 + "." + string3 + "]";
        this.dncprintln(string4 + this.getMemoryMapDisplay(map));
    }

    public void tracepoint(String string, int n, Object object, String string2, String string3, Map map) {
        if (this.traceSuspended()) {
            return;
        }
        String string4 = string + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + n + "]" + "[" + string2 + "@" + Integer.toHexString(object.hashCode()) + "." + string3 + "]";
        this.dncprintln(string4 + this.getMemoryMapDisplay(map));
    }

    private String getMemoryMapDisplay(Map map) {
        return map.toString();
    }

    private void traceExternalMethod(Object object, String string, String string2) {
        if (this.traceSuspended()) {
            return;
        }
        this.dncprint(this.buildExternalMethodHeader(object, string), string2);
    }

    private void traceExternalDeprecatedMethod(Object object, String string, String string2) {
        if (this.traceSuspended()) {
            return;
        }
        this.dncprint(this.buildExternalMethodHeader(object, string), "Deprecated " + string2);
    }

    private String buildExternalMethodHeader(Object object, String string) {
        return "[Time:" + System.currentTimeMillis() + "]" + "[Thread:" + Thread.currentThread().getName() + "]" + "[" + string + "@" + Integer.toHexString(object.hashCode()) + "]";
    }

    private String getClassNameOfInstanceIfTraced(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Connection && this.loggingEnabled(1)) {
            return "Connection";
        }
        if (object instanceof ResultSet && this.loggingEnabled(4)) {
            return "ResultSet";
        }
        if (object instanceof CallableStatement && this.loggingEnabled(2)) {
            return "CallableStatement";
        }
        if (object instanceof PreparedStatement && this.loggingEnabled(2)) {
            return "PreparedStatement";
        }
        if (object instanceof Statement && this.loggingEnabled(2)) {
            return "Statement";
        }
        if (object instanceof Blob && this.loggingEnabled(-1)) {
            return "Blob";
        }
        if (object instanceof Clob && this.loggingEnabled(-1)) {
            return "Clob";
        }
        if (object instanceof DatabaseMetaData && this.loggingEnabled(-1)) {
            return "DatabaseMetaData";
        }
        if (this.loggingEnabled(2048) && object.getClass().getName().startsWith("org.apache.derby.client.net.NetXAResource")) {
            return "NetXAResource";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.client.ClientPooledConnection")) {
            return "ClientPooledConnection";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.jdbc.ClientConnectionPoolDataSource")) {
            return "ClientConnectionPoolDataSource";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.client.ClientXAConnection")) {
            return "ClientXAConnection";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.jdbc.ClientDataSource")) {
            return "ClientDataSource";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.jdbc.ClientXADataSource")) {
            return "ClientXADataSource";
        }
        return object.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceExit(Object object, String string, Object object2) {
        if (this.traceSuspended()) {
            return;
        }
        String string2 = this.getClassNameOfInstanceIfTraced(object);
        if (string2 == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalMethod(object, string2, string);
            this.printWriter_.println(" () returned " + object2);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDeprecatedExit(Object object, String string, Object object2) {
        if (this.traceSuspended()) {
            return;
        }
        String string2 = this.getClassNameOfInstanceIfTraced(object);
        if (string2 == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalDeprecatedMethod(object, string2, string);
            this.printWriter_.println(" () returned " + object2);
            this.printWriter_.flush();
        }
    }

    public void traceExit(Object object, String string, ResultSet resultSet) {
        if (this.traceSuspended()) {
            return;
        }
        String string2 = resultSet == null ? "ResultSet@null" : "ResultSet@" + Integer.toHexString(resultSet.hashCode());
        this.traceExit(object, string, string2);
    }

    public void traceExit(Object object, String string, CallableStatement callableStatement) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, "CallableStatement@" + Integer.toHexString(callableStatement.hashCode()));
    }

    public void traceExit(Object object, String string, PreparedStatement preparedStatement) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, "PreparedStatement@" + Integer.toHexString(preparedStatement.hashCode()));
    }

    public void traceExit(Object object, String string, Statement statement) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, "Statement@" + Integer.toHexString(statement.hashCode()));
    }

    public void traceExit(Object object, String string, Blob blob) {
        if (this.traceSuspended()) {
            return;
        }
        String string2 = blob == null ? "Blob@null" : "Blob@" + Integer.toHexString(blob.hashCode());
        this.traceExit(object, string, string2);
    }

    public void traceExit(Object object, String string, Clob clob) {
        if (this.traceSuspended()) {
            return;
        }
        String string2 = clob == null ? "Clob@null" : "Clob@" + Integer.toHexString(clob.hashCode());
        this.traceExit(object, string, string2);
    }

    public void traceExit(Object object, String string, DatabaseMetaData databaseMetaData) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, "DatabaseMetaData@" + Integer.toHexString(databaseMetaData.hashCode()));
    }

    public void traceExit(Object object, String string, Connection connection) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, "Connection@" + Integer.toHexString(connection.hashCode()));
    }

    public void traceExit(Object object, String string, ColumnMetaData columnMetaData) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, "MetaData@" + (columnMetaData != null ? Integer.toHexString(columnMetaData.hashCode()) : null));
    }

    public void traceExit(Object object, String string, byte[] byArray) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, Utils.getStringFromBytes(byArray));
    }

    public void traceExit(Object object, String string, int[] nArray) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, Utils.getStringFromInts(nArray));
    }

    public void traceDeprecatedExit(Object object, String string, byte[] byArray) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedExit(object, string, Utils.getStringFromBytes(byArray));
    }

    public void traceExit(Object object, String string, byte by) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, "0x" + Integer.toHexString(by & 0xFF));
    }

    public void traceExit(Object object, String string, int n) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, String.valueOf(n));
    }

    public void traceExit(Object object, String string, boolean bl) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, String.valueOf(bl));
    }

    public void traceExit(Object object, String string, long l) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, String.valueOf(l));
    }

    public void traceExit(Object object, String string, float f) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, String.valueOf(f));
    }

    public void traceExit(Object object, String string, double d) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(object, string, String.valueOf(d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceEntryAllArgs(Object object, String string, String string2) {
        if (this.traceSuspended()) {
            return;
        }
        String string3 = this.getClassNameOfInstanceIfTraced(object);
        if (string3 == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalMethod(object, string3, string);
            this.printWriter_.println(" " + string2 + " called");
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDeprecatedEntryAllArgs(Object object, String string, String string2) {
        if (this.traceSuspended()) {
            return;
        }
        String string3 = this.getClassNameOfInstanceIfTraced(object);
        if (string3 == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalDeprecatedMethod(object, string3, string);
            this.printWriter_.println(" " + string2 + " called");
            this.printWriter_.flush();
        }
    }

    public void traceEntry(Object object, String string) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "()");
    }

    public void traceEntry(Object object, String string, Object object2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ")");
    }

    public void traceEntry(Object object, String string, boolean bl) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + bl + ")");
    }

    public void traceEntry(Object object, String string, int n) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ")");
    }

    public void traceDeprecatedEntry(Object object, String string, int n) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedEntryAllArgs(object, string, "(" + n + ")");
    }

    public void traceDeprecatedEntry(Object object, String string, Object object2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedEntryAllArgs(object, string, "(" + object2 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, Object object3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + object3 + ")");
    }

    public void traceEntry(Object object, String string, int n, Object object2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + object2 + ")");
    }

    public void traceEntry(Object object, String string, int n, byte[] byArray) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + Utils.getStringFromBytes(byArray) + ")");
    }

    public void traceDeprecatedEntry(Object object, String string, int n, int n2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedEntryAllArgs(object, string, "(" + n + ", " + n2 + ")");
    }

    public void traceDeprecatedEntry(Object object, String string, Object object2, int n) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedEntryAllArgs(object, string, "(" + object2 + ", " + n + ")");
    }

    public void traceEntry(Object object, String string, int n, boolean bl) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + bl + ")");
    }

    public void traceEntry(Object object, String string, int n, byte by) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", 0x" + Integer.toHexString(by & 0xFF) + ")");
    }

    public void traceEntry(Object object, String string, int n, short s) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + s + ")");
    }

    public void traceEntry(Object object, String string, int n, int n2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + n2 + ")");
    }

    public void traceEntry(Object object, String string, int n, long l) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + l + ")");
    }

    public void traceEntry(Object object, String string, int n, float f) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + f + ")");
    }

    public void traceEntry(Object object, String string, int n, double d) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + d + ")");
    }

    public void traceEntry(Object object, String string, Object object2, boolean bl) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + bl + ")");
    }

    public void traceEntry(Object object, String string, Object object2, byte by) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", 0x" + Integer.toHexString(by & 0xFF) + ")");
    }

    public void traceEntry(Object object, String string, Object object2, short s) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + s + ")");
    }

    public void traceEntry(Object object, String string, Object object2, int n) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + n + ")");
    }

    public void traceEntry(Object object, String string, Object object2, long l) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + l + ")");
    }

    public void traceEntry(Object object, String string, Object object2, float f) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + f + ")");
    }

    public void traceEntry(Object object, String string, Object object2, double d) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + d + ")");
    }

    public void traceEntry(Object object, String string, Object object2, Object object3, Object object4) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + object3 + ", " + object4 + ")");
    }

    public void traceEntry(Object object, String string, int n, Object object2, Object object3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + object2 + ", " + object3 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, Object object3, int n) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + object3 + ", " + n + ")");
    }

    public void traceEntry(Object object, String string, int n, Object object2, int n2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + object2 + ", " + n2 + ")");
    }

    public void traceDeprecatedEntry(Object object, String string, int n, Object object2, int n2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + object2 + ", " + n2 + ")");
    }

    public void traceEntry(Object object, String string, int n, int n2, Object object2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + n2 + ", " + object2 + ")");
    }

    public void traceEntry(Object object, String string, int n, int n2, int n3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + n2 + ", " + n3 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, int n, int n2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + n + ", " + n2 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, int n, Object object3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + n + ", " + object3 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, boolean bl, boolean bl2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + bl + ", " + bl2 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, boolean bl, int n) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + bl + ", " + n + ")");
    }

    public void traceEntry(Object object, String string, Object object2, Object object3, Object object4, Object object5) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + object3 + ", " + object4 + ", " + object5 + ")");
    }

    public void traceEntry(Object object, String string, int n, Object object2, Object object3, Object object4) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + object2 + ", " + object3 + ", " + object4 + ")");
    }

    public void traceEntry(Object object, String string, int n, Object object2, int n2, int n3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + n + ", " + object2 + ", " + n2 + ", " + n3 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, int n, int n2, int n3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + n + ", " + n2 + ", " + n3 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, Object object3, int n, int n2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + object3 + ", " + n + ", " + n2 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, Object object3, Object object4, int n, boolean bl) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + object3 + ", " + object4 + ", " + n + ", " + bl + ")");
    }

    public void traceEntry(Object object, String string, Object object2, Object object3, Object object4, boolean bl, boolean bl2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + object3 + ", " + object4 + ", " + bl + ", " + bl2 + ")");
    }

    public void traceEntry(Object object, String string, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(object, string, "(" + object2 + ", " + object3 + ", " + object4 + ", " + object5 + ", " + object6 + ", " + object7 + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDiagnosable(SQLException sQLException) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(sQLException, this.printWriter_, "[derby]", true);
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDiagnosable(XAException xAException) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(xAException, this.printWriter_, "[derby]");
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceParameterMetaData(Statement statement, ColumnMetaData columnMetaData) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(256) || columnMetaData == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String string = "[ParameterMetaData@" + Integer.toHexString(columnMetaData.hashCode()) + "]";
            try {
                this.dncprintln(string, "BEGIN TRACE_PARAMETER_META_DATA");
                this.dncprintln(string, "Parameter meta data for statement Statement@" + Integer.toHexString(statement.hashCode()));
                this.dncprintln(string, "Number of parameter columns: " + columnMetaData.getColumnCount());
                this.traceColumnMetaData(string, columnMetaData);
                this.dncprintln(string, "END TRACE_PARAMETER_META_DATA");
            }
            catch (SqlException sqlException) {
                this.dncprintln(string, "Encountered an SQL exception while trying to trace parameter meta data");
                this.dncprintln(string, "END TRACE_PARAMETER_META_DATA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceResultSetMetaData(Statement statement, ColumnMetaData columnMetaData) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(128) || columnMetaData == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String string = "[ResultSetMetaData@" + Integer.toHexString(columnMetaData.hashCode()) + "]";
            try {
                this.dncprintln(string, "BEGIN TRACE_RESULT_SET_META_DATA");
                this.dncprintln(string, "Result set meta data for statement Statement@" + Integer.toHexString(statement.hashCode()));
                this.dncprintln(string, "Number of result set columns: " + columnMetaData.getColumnCount());
                this.traceColumnMetaData(string, columnMetaData);
                this.dncprintln(string, "END TRACE_RESULT_SET_META_DATA");
            }
            catch (SqlException sqlException) {
                this.dncprintln(string, "Encountered an SQL exception while trying to trace result set meta data");
                this.dncprintln(string, "END TRACE_RESULT_SET_META_DATA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceColumnMetaData(String string, ColumnMetaData columnMetaData) {
        if (this.traceSuspended()) {
            return;
        }
        try {
            PrintWriter printWriter = this.printWriter_;
            synchronized (printWriter) {
                for (int i = 1; i <= columnMetaData.getColumnCount(); ++i) {
                    this.dncprint(string, "Column " + i + ": { ");
                    this.printWriter_.print("label=" + columnMetaData.getColumnLabel(i) + ", ");
                    this.printWriter_.print("name=" + columnMetaData.getColumnName(i) + ", ");
                    this.printWriter_.print("type name=" + columnMetaData.getColumnTypeName(i) + ", ");
                    this.printWriter_.print("type=" + columnMetaData.getColumnType(i) + ", ");
                    this.printWriter_.print("nullable=" + columnMetaData.isNullable(i) + ", ");
                    this.printWriter_.print("precision=" + columnMetaData.getPrecision(i) + ", ");
                    this.printWriter_.print("scale=" + columnMetaData.getScale(i) + ", ");
                    this.printWriter_.print("schema name=" + columnMetaData.getSchemaName(i) + ", ");
                    this.printWriter_.print("table name=" + columnMetaData.getTableName(i) + ", ");
                    this.printWriter_.print("writable=" + columnMetaData.isWritable(i) + ", ");
                    this.printWriter_.print("sqlPrecision=" + (columnMetaData.sqlPrecision_ == null ? "<null>" : "" + columnMetaData.sqlPrecision_[i - 1]) + ", ");
                    this.printWriter_.print("sqlScale=" + (columnMetaData.sqlScale_ == null ? "<null>" : "" + columnMetaData.sqlScale_[i - 1]) + ", ");
                    this.printWriter_.print("sqlLength=" + (columnMetaData.sqlLength_ == null ? "<null>" : "" + columnMetaData.sqlLength_[i - 1]) + ", ");
                    this.printWriter_.print("sqlType=" + (columnMetaData.sqlType_ == null ? "<null>" : "" + columnMetaData.sqlType_[i - 1]) + ", ");
                    this.printWriter_.print("sqlCcsid=" + (columnMetaData.sqlCcsid_ == null ? "<null>" : "" + columnMetaData.sqlCcsid_[i - 1]) + ", ");
                    this.printWriter_.print("sqlName=" + (columnMetaData.sqlName_ == null ? "<null>" : columnMetaData.sqlName_[i - 1]) + ", ");
                    this.printWriter_.print("sqlLabel=" + (columnMetaData.sqlLabel_ == null ? "<null>" : columnMetaData.sqlLabel_[i - 1]) + ", ");
                    this.printWriter_.print("sqlUnnamed=" + (columnMetaData.sqlUnnamed_ == null ? "<null>" : "" + columnMetaData.sqlUnnamed_[i - 1]) + ", ");
                    this.printWriter_.print("sqlComment=" + (columnMetaData.sqlComment_ == null ? "<null>" : columnMetaData.sqlComment_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxKeymem=" + (columnMetaData.sqlxKeymem_ == null ? "<null>" : "" + columnMetaData.sqlxKeymem_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxGenerated=" + (columnMetaData.sqlxGenerated_ == null ? "<null>" : "" + columnMetaData.sqlxGenerated_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxParmmode=" + (columnMetaData.sqlxParmmode_ == null ? "<null>" : "" + columnMetaData.sqlxParmmode_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxCorname=" + (columnMetaData.sqlxCorname_ == null ? "<null>" : columnMetaData.sqlxCorname_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxName=" + (columnMetaData.sqlxName_ == null ? "<null>" : columnMetaData.sqlxName_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxBasename=" + (columnMetaData.sqlxBasename_ == null ? "<null>" : columnMetaData.sqlxBasename_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxUpdatable=" + (columnMetaData.sqlxUpdatable_ == null ? "<null>" : "" + columnMetaData.sqlxUpdatable_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxSchema=" + (columnMetaData.sqlxSchema_ == null ? "<null>" : columnMetaData.sqlxSchema_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxRdbnam=" + (columnMetaData.sqlxRdbnam_ == null ? "<null>" : columnMetaData.sqlxRdbnam_[i - 1]) + ", ");
                    this.printWriter_.print("internal type=" + columnMetaData.types_[i - 1] + ", ");
                    this.printWriter_.println(" }");
                }
                this.dncprint(string, "{ ");
                this.printWriter_.print("sqldHold=" + columnMetaData.sqldHold_ + ", ");
                this.printWriter_.print("sqldReturn=" + columnMetaData.sqldReturn_ + ", ");
                this.printWriter_.print("sqldScroll=" + columnMetaData.sqldScroll_ + ", ");
                this.printWriter_.print("sqldSensitive=" + columnMetaData.sqldSensitive_ + ", ");
                this.printWriter_.print("sqldFcode=" + columnMetaData.sqldFcode_ + ", ");
                this.printWriter_.print("sqldKeytype=" + columnMetaData.sqldKeytype_ + ", ");
                this.printWriter_.print("sqldRdbnam=" + columnMetaData.sqldRdbnam_ + ", ");
                this.printWriter_.print("sqldSchema=" + columnMetaData.sqldSchema_);
                this.printWriter_.println(" }");
                this.printWriter_.flush();
            }
        }
        catch (SqlException sqlException) {
            this.dncprintln(string, "Encountered an SQL exception while trying to trace column meta data");
        }
    }

    public void traceConnectEntry(ClientDataSource clientDataSource) {
        if (this.traceSuspended()) {
            return;
        }
        if (this.loggingEnabled(16)) {
            this.traceDriverConfigurationJdbc2();
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsEntry(clientDataSource);
        }
    }

    public void traceConnectEntry(String string, int n, String string2, Properties properties) {
        if (this.traceSuspended()) {
            return;
        }
        if (this.loggingEnabled(16)) {
            this.traceDriverConfigurationJdbc1();
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsEntry(string, n, string2, properties);
        }
    }

    public void traceConnectResetEntry(Object object, LogWriter logWriter, String string, ClientDataSource clientDataSource) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntry(object, "reset", (Object)logWriter, (Object)string, (Object)"<escaped>", (Object)clientDataSource);
        if (this.loggingEnabled(32)) {
            this.traceConnectsResetEntry(clientDataSource);
        }
    }

    public void traceConnectExit(Connection connection) {
        if (this.traceSuspended()) {
            return;
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsExit(connection);
        }
    }

    public void traceConnectResetExit(Connection connection) {
        if (this.traceSuspended()) {
            return;
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsResetExit(connection);
        }
    }

    private void traceConnectsResetEntry(ClientDataSource clientDataSource) {
        if (this.traceSuspended()) {
            return;
        }
        try {
            this.traceConnectsResetEntry(clientDataSource.getServerName(), clientDataSource.getPortNumber(), clientDataSource.getDatabaseName(), clientDataSource.getProperties());
        }
        catch (SQLException sQLException) {
            this.dncprintln("Encountered an SQL exception while trying to trace connection reset entry");
        }
    }

    private void traceConnectsEntry(ClientDataSource clientDataSource) {
        if (this.traceSuspended()) {
            return;
        }
        try {
            this.traceConnectsEntry(clientDataSource.getServerName(), clientDataSource.getPortNumber(), clientDataSource.getDatabaseName(), clientDataSource.getProperties());
        }
        catch (SQLException sQLException) {
            this.dncprintln("Encountered an SQL exception while trying to trace connection entry");
        }
    }

    private void traceConnectsResetEntry(String string, int n, String string2, Properties properties) {
        if (this.traceSuspended()) {
            return;
        }
        this.dncprintln("BEGIN TRACE_CONNECT_RESET");
        this.dncprintln("Connection reset requested for " + string + ":" + n + "/" + string2);
        this.dncprint("Using properties: ");
        this.writeProperties(properties);
        this.dncprintln("END TRACE_CONNECT_RESET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceConnectsEntry(String string, int n, String string2, Properties properties) {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_CONNECTS");
            this.dncprintln("Attempting connection to " + string + ":" + n + "/" + string2);
            this.dncprint("Using properties: ");
            this.writeProperties(properties);
            this.dncprintln("END TRACE_CONNECTS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceConnectsExit(Connection connection) {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String string = "[Connection@" + Integer.toHexString(connection.hashCode()) + "]";
            try {
                this.dncprintln(string, "BEGIN TRACE_CONNECTS");
                this.dncprintln(string, "Successfully connected to server " + connection.databaseMetaData_.getURL());
                this.dncprintln(string, "User: " + connection.databaseMetaData_.getUserName());
                this.dncprintln(string, "Database product name: " + connection.databaseMetaData_.getDatabaseProductName());
                this.dncprintln(string, "Database product version: " + connection.databaseMetaData_.getDatabaseProductVersion());
                this.dncprintln(string, "Driver name: " + connection.databaseMetaData_.getDriverName());
                this.dncprintln(string, "Driver version: " + connection.databaseMetaData_.getDriverVersion());
                this.dncprintln(string, "END TRACE_CONNECTS");
            }
            catch (SQLException sQLException) {
                this.dncprintln(string, "Encountered an SQL exception while trying to trace connection exit");
                this.dncprintln(string, "END TRACE_CONNECTS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceConnectsResetExit(Connection connection) {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String string = "[Connection@" + Integer.toHexString(connection.hashCode()) + "]";
            try {
                this.dncprintln(string, "BEGIN TRACE_CONNECT_RESET");
                this.dncprintln(string, "Successfully reset connection to server " + connection.databaseMetaData_.getURL());
                this.dncprintln(string, "User: " + connection.databaseMetaData_.getUserName());
                this.dncprintln(string, "Database product name: " + connection.databaseMetaData_.getDatabaseProductName());
                this.dncprintln(string, "Database product version: " + connection.databaseMetaData_.getDatabaseProductVersion());
                this.dncprintln(string, "Driver name: " + connection.databaseMetaData_.getDriverName());
                this.dncprintln(string, "Driver version: " + connection.databaseMetaData_.getDriverVersion());
                this.dncprintln(string, "END TRACE_CONNECT_RESET");
            }
            catch (SQLException sQLException) {
                this.dncprintln(string, "Encountered an SQL exception while trying to trace connection reset exit");
                this.dncprintln(string, "END TRACE_CONNECT_RESET");
            }
        }
    }

    private void writeProperties(Properties properties) {
        this.printWriter_.print("{ ");
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if ("password".equals(entry.getKey())) {
                this.printWriter_.print("password=" + this.escapePassword((String)entry.getValue()));
            } else {
                this.printWriter_.print(entry.getKey() + "=" + entry.getValue());
            }
            if (!iterator.hasNext()) continue;
            this.printWriter_.print(", ");
        }
        this.printWriter_.println(" }");
        this.printWriter_.flush();
    }

    private String escapePassword(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.setCharAt(i, '*');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDriverConfigurationJdbc2() {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (!this.driverConfigurationHasBeenWrittenToJdbc2Stream_) {
                this.writeDriverConfiguration();
                this.driverConfigurationHasBeenWrittenToJdbc2Stream_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDriverConfigurationJdbc1() {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (!this.driverConfigurationHasBeenWrittenToJdbc1Stream_) {
                this.writeDriverConfiguration();
                this.driverConfigurationHasBeenWrittenToJdbc1Stream_ = true;
            }
        }
    }

    public void writeDriverConfiguration() {
        Version.writeDriverConfiguration(this.printWriter_);
    }

    public static PrintWriter getPrintWriter(String string, boolean bl) throws SqlException {
        try {
            PrintWriter printWriter = null;
            String string2 = new File(string).getCanonicalPath();
            printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(string2, bl), 4096), true);
            return printWriter;
        }
        catch (IOException iOException) {
            throw new SqlException(null, "Unable to open file " + string);
        }
    }
}

