/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.transaction.xa.XAException;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Diagnosable;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Utils;

public class ExceptionFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTrace(SQLException sQLException, PrintWriter printWriter, String string, boolean bl) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            while (sQLException != null) {
                Object object;
                Object object2;
                String string2;
                if (sQLException instanceof DataTruncation) {
                    string2 = string + "[" + "DataTruncation@" + Integer.toHexString(sQLException.hashCode()) + "]";
                    printWriter.println(string2 + " java.sql.DataTruncation");
                } else if (sQLException instanceof SQLWarning) {
                    string2 = string + "[" + "SQLWarning@" + Integer.toHexString(sQLException.hashCode()) + "]";
                    printWriter.println(string2 + " java.sql.SQLWarning");
                } else if (sQLException instanceof BatchUpdateException) {
                    string2 = string + "[" + "BatchUpdateException@" + Integer.toHexString(sQLException.hashCode()) + "]";
                    printWriter.println(string2 + " java.sql.BatchUpdateException");
                } else {
                    string2 = string + "[" + "SQLException@" + Integer.toHexString(sQLException.hashCode()) + "]";
                    printWriter.println(string2 + " java.sql.SQLException");
                }
                if (sQLException instanceof Diagnosable) {
                    object2 = null;
                    try {
                        object2 = ((Diagnosable)((Object)sQLException)).getThrowable();
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    if (object2 != null) {
                        ExceptionFormatter.printTrace((Throwable)object2, printWriter, string2);
                    }
                    if ((object = ((Diagnosable)((Object)sQLException)).getSqlca()) != null) {
                        ExceptionFormatter.printTrace((Sqlca)object, printWriter, string2);
                        ((Sqlca)object).returnTokensOnlyInMessageText(bl);
                    }
                }
                printWriter.println(string2 + " SQL state  = " + sQLException.getSQLState());
                printWriter.println(string2 + " Error code = " + String.valueOf(sQLException.getErrorCode()));
                if (!(sQLException instanceof Diagnosable)) {
                    printWriter.println(string2 + " Message    = " + sQLException.getMessage());
                } else if (((Diagnosable)((Object)sQLException)).getSqlca() == null) {
                    printWriter.println(string2 + " Message    = " + sQLException.getMessage());
                } else {
                    object2 = ((Diagnosable)((Object)sQLException)).getSqlca();
                    if (bl) {
                        printWriter.println(string2 + " Tokens     = " + ((Sqlca)object2).getSqlErrmc());
                    } else {
                        object = sQLException.getMessage();
                        if (!((Sqlca)object2).messageTextRetrievedContainsTokensOnly_) {
                            printWriter.println(string2 + " Message    = " + (String)object);
                        } else {
                            SQLException sQLException2 = ((Sqlca)object2).exceptionThrownOnStoredProcInvocation_;
                            if (sQLException2 != null && (sQLException2.getErrorCode() == -440 || sQLException2.getErrorCode() == -444)) {
                                printWriter.println(string2 + " Unable to obtain message text from server." + " Only message tokens are available." + " The stored procedure SYSIBM.SQLCAMESSAGE is not installed on server." + " Contact your DBA.");
                            } else {
                                printWriter.println(string2 + " Error occurred while trying to obtain message text from server. " + "Only message tokens are available.");
                            }
                            printWriter.println(string2 + " Tokens     = " + (String)object);
                        }
                    }
                }
                if (sQLException instanceof DataTruncation) {
                    printWriter.println(string2 + " Index         = " + ((DataTruncation)sQLException).getIndex());
                    printWriter.println(string2 + " Parameter     = " + ((DataTruncation)sQLException).getParameter());
                    printWriter.println(string2 + " Read          = " + ((DataTruncation)sQLException).getRead());
                    printWriter.println(string2 + " Data size     = " + ((DataTruncation)sQLException).getDataSize());
                    printWriter.println(string2 + " Transfer size = " + ((DataTruncation)sQLException).getTransferSize());
                }
                if (sQLException instanceof BatchUpdateException) {
                    printWriter.println(string2 + " Update counts = " + Utils.getStringFromInts(((BatchUpdateException)sQLException).getUpdateCounts()));
                }
                printWriter.println(string2 + " Stack trace follows");
                sQLException.printStackTrace(printWriter);
                if (sQLException instanceof Diagnosable && (object2 = ((Diagnosable)((Object)sQLException)).getSqlca()) != null) {
                    ((Sqlca)object2).returnTokensOnlyInMessageText(false);
                }
                sQLException = sQLException.getNextException();
            }
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTrace(Sqlca sqlca, PrintWriter printWriter, String string) {
        String string2 = string + "[" + "Sqlca@" + Integer.toHexString(sqlca.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(string2 + " DERBY SQLCA from server");
            printWriter.println(string2 + " SqlCode        = " + sqlca.getSqlCode());
            printWriter.println(string2 + " SqlErrd        = " + Utils.getStringFromInts(sqlca.getSqlErrd()));
            printWriter.println(string2 + " SqlErrmc       = " + sqlca.getSqlErrmc());
            printWriter.println(string2 + " SqlErrmcTokens = " + Utils.getStringFromStrings(sqlca.getSqlErrmcTokens()));
            printWriter.println(string2 + " SqlErrp        = " + sqlca.getSqlErrp());
            printWriter.println(string2 + " SqlState       = " + sqlca.getSqlState());
            printWriter.println(string2 + " SqlWarn        = " + new String(sqlca.getSqlWarn()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTrace(Throwable throwable, PrintWriter printWriter, String string) {
        String string2 = string + "[" + "Throwable@" + Integer.toHexString(throwable.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(string2 + " " + throwable.getClass().getName());
            printWriter.println(string2 + " Message = " + throwable.getMessage());
            printWriter.println(string2 + " Stack trace follows");
            throwable.printStackTrace(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTrace(XAException xAException, PrintWriter printWriter, String string) {
        String string2 = string + "[" + "XAException@" + Integer.toHexString(xAException.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(string2 + " javax.transaction.xa.XAException");
            printWriter.println(string2 + " Message = " + xAException.getMessage());
            printWriter.println(string2 + " Stack trace follows");
            xAException.printStackTrace(printWriter);
            if ((Configuration.jreLevelMajor != 1 || Configuration.jreLevelMinor < 4 || Configuration.jreLevelMajor > 1) && xAException instanceof Diagnosable) {
                Throwable throwable = null;
                try {
                    throwable = ((Diagnosable)((Object)xAException)).getThrowable();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                if (throwable != null) {
                    printWriter.print("Caused by: ");
                    if (throwable instanceof SQLException) {
                        throwable.printStackTrace(printWriter);
                    } else {
                        ExceptionFormatter.printTrace(throwable, printWriter, string2);
                    }
                }
            }
        }
    }
}

