/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.LossOfPrecisionConversionException;
import org.apache.derby.client.am.SqlException;

final class CrossConverters {
    private static final BigDecimal bdMaxByteValue__ = BigDecimal.valueOf(127L);
    private static final BigDecimal bdMinByteValue__ = BigDecimal.valueOf(-128L);
    private static final BigDecimal bdMaxShortValue__ = BigDecimal.valueOf(32767L);
    private static final BigDecimal bdMinShortValue__ = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bdMaxIntValue__ = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bdMinIntValue__ = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bdMaxLongValue__ = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bdMinLongValue__ = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal bdMaxFloatValue__ = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue__ = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdMaxDoubleValue__ = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue__ = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdZero__ = BigDecimal.valueOf(0L);
    private static final BigDecimal bdOne__ = BigDecimal.valueOf(1L);
    Agent agent_;

    CrossConverters(Agent agent) {
        this.agent_ = agent;
    }

    final Object setObject(int n, boolean bl) throws SqlException {
        return this.setObject(n, (short)(bl ? 1 : 0));
    }

    final Object setObject(int n, byte by) throws SqlException {
        return this.setObject(n, (short)by);
    }

    final Object setObject(int n, short s) throws SqlException {
        switch (n) {
            case 5: {
                return new Short(s);
            }
            case 4: {
                return new Integer(s);
            }
            case -5: {
                return new Long(s);
            }
            case 7: {
                return new Float(s);
            }
            case 8: {
                return new Double(s);
            }
            case 3: {
                return BigDecimal.valueOf(s);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(s);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, int n2) throws SqlException {
        switch (n) {
            case 5: {
                if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(n2));
                }
                return new Short((short)n2);
            }
            case 4: {
                return new Integer(n2);
            }
            case -5: {
                return new Long(n2);
            }
            case 7: {
                return new Float(n2);
            }
            case 8: {
                return new Double(n2);
            }
            case 3: {
                return BigDecimal.valueOf(n2);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(n2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final boolean setBooleanFromObject(Object object, int n) throws SqlException {
        switch (n) {
            case 5: {
                return this.getBooleanFromShort((Short)object);
            }
            case 4: {
                return this.getBooleanFromInt((Integer)object);
            }
            case -5: {
                return this.getBooleanFromLong(((BigInteger)object).longValue());
            }
            case 7: {
                return this.getBooleanFromFloat(((Float)object).floatValue());
            }
            case 8: {
                return this.getBooleanFromDouble((Double)object);
            }
            case 3: {
                return this.getBooleanFromLong(((BigDecimal)object).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getBooleanFromString((String)object);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final byte setByteFromObject(Object object, int n) throws SqlException {
        switch (n) {
            case 5: {
                return this.getByteFromShort((Short)object);
            }
            case 4: {
                return this.getByteFromInt((Integer)object);
            }
            case -5: {
                return this.getByteFromLong(((BigInteger)object).longValue());
            }
            case 7: {
                return this.getByteFromFloat(((Float)object).floatValue());
            }
            case 8: {
                return this.getByteFromDouble((Double)object);
            }
            case 3: {
                return this.getByteFromLong(((BigDecimal)object).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getByteFromString((String)object);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final Object setObject(int n, long l) throws SqlException {
        switch (n) {
            case 5: {
                if (l > 32767L || l < -32768L) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(l));
                }
                return new Short((short)l);
            }
            case 4: {
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(l));
                }
                return new Integer((int)l);
            }
            case -5: {
                return new Long(l);
            }
            case 7: {
                return new Float(l);
            }
            case 8: {
                return new Double(l);
            }
            case 3: {
                return BigDecimal.valueOf(l);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(l);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, float f) throws SqlException {
        switch (n) {
            case 5: {
                if (f > 32767.0f || f < -32768.0f) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
                }
                return new Short((short)f);
            }
            case 4: {
                if (f > 2.1474836E9f || f < -2.1474836E9f) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
                }
                return new Integer((int)f);
            }
            case -5: {
                if (f > 9.223372E18f || f < -9.223372E18f) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
                }
                return new Long((long)f);
            }
            case 7: {
                if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
                }
                return new Float(f);
            }
            case 8: {
                if ((double)f == Double.POSITIVE_INFINITY || (double)f == Double.NEGATIVE_INFINITY) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
                }
                return new Double(String.valueOf(f));
            }
            case 3: {
                return new BigDecimal(String.valueOf(f));
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(f);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, double d) throws SqlException {
        switch (n) {
            case 5: {
                if (d > 32767.0 || d < -32768.0) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
                }
                return new Short((short)d);
            }
            case 4: {
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
                }
                return new Integer((int)d);
            }
            case -5: {
                if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
                }
                return new Long((long)d);
            }
            case 7: {
                if (d > 3.4028234663852886E38 || d < -3.4028234663852886E38) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
                }
                return new Float((float)d);
            }
            case 8: {
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
                }
                return new Double(d);
            }
            case 3: {
                return new BigDecimal(String.valueOf(d));
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(d);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, BigDecimal bigDecimal) throws SqlException {
        switch (n) {
            case 5: {
                if (bigDecimal.compareTo(bdMaxShortValue__) == 1 || bigDecimal.compareTo(bdMinShortValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
                }
                return new Short(bigDecimal.shortValue());
            }
            case 4: {
                if (bigDecimal.compareTo(bdMaxIntValue__) == 1 || bigDecimal.compareTo(bdMinIntValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
                }
                return new Integer(bigDecimal.intValue());
            }
            case -5: {
                if (bigDecimal.compareTo(bdMaxLongValue__) == 1 || bigDecimal.compareTo(bdMinLongValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
                }
                return new Long(bigDecimal.longValue());
            }
            case 7: {
                if (bigDecimal.compareTo(bdMaxFloatValue__) == 1 || bigDecimal.compareTo(bdMinFloatValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
                }
                return new Float(bigDecimal.floatValue());
            }
            case 8: {
                if (bigDecimal.compareTo(bdMaxDoubleValue__) == 1 || bigDecimal.compareTo(bdMinDoubleValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
                }
                return new Double(bigDecimal.doubleValue());
            }
            case 3: {
                return bigDecimal;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(bigDecimal);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, Date date) throws SqlException {
        switch (n) {
            case 91: {
                return date;
            }
            case 93: {
                return new Timestamp(date.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(date);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, Time time) throws SqlException {
        switch (n) {
            case 92: {
                return time;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(time);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, Timestamp timestamp) throws SqlException {
        switch (n) {
            case 93: {
                return timestamp;
            }
            case 92: {
                return new Time(timestamp.getTime());
            }
            case 91: {
                return new Date(timestamp.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(timestamp);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, String string) throws SqlException {
        try {
            switch (n) {
                case 5: {
                    return Short.valueOf(string);
                }
                case 4: {
                    return Integer.valueOf(string);
                }
                case -5: {
                    return Long.valueOf(string);
                }
                case 7: {
                    return Float.valueOf(string);
                }
                case 8: {
                    return Double.valueOf(string);
                }
                case 3: {
                    return new BigDecimal(string);
                }
                case 91: {
                    return this.date_valueOf(string);
                }
                case 92: {
                    return this.time_valueOf(string);
                }
                case 93: {
                    return this.timestamp_valueOf(string);
                }
                case -1: 
                case 1: 
                case 12: {
                    return string;
                }
                case 2005: {
                    return new Clob(this.agent_, string);
                }
            }
            throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, numberFormatException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion.");
        }
    }

    public static int getInputJdbcType(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 8;
            }
        }
        return n;
    }

    final Object setObject(int n, byte[] byArray) throws SqlException {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return byArray;
            }
            case 2004: {
                return new Blob(byArray, this.agent_, 0);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, Reader reader, int n2) throws SqlException {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromReader(reader, n2);
            }
            case 2005: {
                return new Clob(this.agent_, reader, n2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    private final String setStringFromReader(Reader reader, int n) throws SqlException {
        StringWriter stringWriter = new StringWriter();
        try {
            int n2 = reader.read();
            int n3 = 0;
            while (n2 != -1) {
                ++n3;
                stringWriter.write(n2);
                n2 = reader.read();
            }
            if (n != n3) {
                throw new SqlException(this.agent_.logWriter_, "The Reader object does not contain length characters");
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new SqlException(this.agent_.logWriter_, iOException.getMessage());
        }
    }

    final Object setObjectFromCharacterStream(int n, InputStream inputStream, String string, int n2) throws SqlException {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromStream(inputStream, string, n2);
            }
            case 2005: {
                return new Clob(this.agent_, inputStream, string, n2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    private final String setStringFromStream(InputStream inputStream, String string, int n) throws SqlException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            try {
                int n3 = inputStream.read();
                while (n3 != -1) {
                    ++n2;
                    byteArrayOutputStream.write(n3);
                    n3 = inputStream.read();
                }
            }
            catch (IOException iOException) {
                throw new SqlException(this.agent_.logWriter_, iOException.getMessage());
            }
            if (n != n2) {
                throw new SqlException(this.agent_.logWriter_, "The InputStream object does not contain length bytes");
            }
            return new String(byteArrayOutputStream.toByteArray(), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException.getMessage());
        }
    }

    final Object setObject(int n, java.sql.Blob blob) throws SqlException {
        switch (n) {
            case 2004: {
                return blob;
            }
            case -4: 
            case -3: 
            case -2: {
                try {
                    return blob.getBytes(1L, (int)blob.length());
                }
                catch (SQLException sQLException) {
                    throw new SqlException(this.agent_.logWriter_, sQLException.getMessage());
                }
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObjectFromBinaryStream(int n, InputStream inputStream, int n2) throws SqlException {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return this.setBytesFromStream(inputStream, n2);
            }
            case 2004: {
                return new Blob(this.agent_, inputStream, n2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    private final byte[] setBytesFromStream(InputStream inputStream, int n) throws SqlException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        try {
            int n3 = inputStream.read();
            while (n3 != -1) {
                ++n2;
                byteArrayOutputStream.write(n3);
                n3 = inputStream.read();
            }
            if (n != n2) {
                throw new SqlException(this.agent_.logWriter_, "The InputStream object does not contain length bytes");
            }
        }
        catch (IOException iOException) {
            throw new SqlException(this.agent_.logWriter_, iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    final Object setObject(int n, java.sql.Clob clob) throws SqlException {
        switch (n) {
            case 2005: {
                return clob;
            }
            case -1: 
            case 1: 
            case 12: {
                return clob.toString();
            }
        }
        throw new SqlException(this.agent_.logWriter_, "Illegal Conversion");
    }

    final Object setObject(int n, Object object) throws SqlException {
        if (object instanceof Boolean) {
            return this.setObject(n, (Boolean)object);
        }
        if (object instanceof Integer) {
            return this.setObject(n, (Integer)object);
        }
        if (object instanceof Long) {
            return this.setObject(n, (Long)object);
        }
        if (object instanceof Float) {
            return this.setObject(n, ((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.setObject(n, (Double)object);
        }
        if (object instanceof BigDecimal) {
            return this.setObject(n, (BigDecimal)object);
        }
        if (object instanceof Date) {
            return this.setObject(n, (Date)object);
        }
        if (object instanceof Time) {
            return this.setObject(n, (Time)object);
        }
        if (object instanceof Timestamp) {
            return this.setObject(n, (Timestamp)object);
        }
        if (object instanceof String) {
            return this.setObject(n, (String)object);
        }
        if (object instanceof byte[]) {
            return this.setObject(n, (byte[])object);
        }
        if (object instanceof java.sql.Blob) {
            return this.setObject(n, (java.sql.Blob)object);
        }
        if (object instanceof java.sql.Clob) {
            return this.setObject(n, (java.sql.Clob)object);
        }
        if (object instanceof Array) {
            return this.setObject(n, (Array)object);
        }
        if (object instanceof Ref) {
            return this.setObject(n, (Ref)object);
        }
        if (object instanceof Short) {
            return this.setObject(n, (Short)object);
        }
        if (object instanceof Byte) {
            return this.setObject(n, (Byte)object);
        }
        throw new SqlException(this.agent_.logWriter_, "Invalid data conversion: Parameter instance " + object + " is invalid for requested conversion.");
    }

    final boolean getBooleanFromByte(byte by) throws SqlException {
        return by != 0;
    }

    final boolean getBooleanFromShort(short s) throws SqlException {
        return s != 0;
    }

    final boolean getBooleanFromInt(int n) throws SqlException {
        return n != 0;
    }

    final boolean getBooleanFromLong(long l) throws SqlException {
        return l != 0L;
    }

    final boolean getBooleanFromFloat(float f) throws SqlException {
        return f != 0.0f;
    }

    final boolean getBooleanFromDouble(double d) throws SqlException {
        return d != 0.0;
    }

    final boolean getBooleanFromBigDecimal(BigDecimal bigDecimal) throws SqlException {
        return bigDecimal.intValue() != 0;
    }

    final boolean getBooleanFromString(String string) throws SqlException {
        return !string.trim().equals("0") && !string.trim().equals("false");
    }

    final byte getByteFromShort(short s) throws SqlException {
        if (s > 127 || s < -128) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(s));
        }
        return (byte)s;
    }

    final byte getByteFromInt(int n) throws SqlException {
        if (n > 127 || n < -128) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(n));
        }
        return (byte)n;
    }

    final byte getByteFromLong(long l) throws SqlException {
        if (l > 127L || l < -128L) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(l));
        }
        return (byte)l;
    }

    final byte getByteFromFloat(float f) throws SqlException {
        if (f > 127.0f || f < -128.0f) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
        }
        return (byte)f;
    }

    final byte getByteFromDouble(double d) throws SqlException {
        if (d > 127.0 || d < -128.0) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
        }
        return (byte)d;
    }

    final byte getByteFromBigDecimal(BigDecimal bigDecimal) throws SqlException {
        if (bigDecimal.compareTo(bdMaxByteValue__) == 1 || bigDecimal.compareTo(bdMinByteValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
        }
        return (byte)bigDecimal.intValue();
    }

    final byte getByteFromBoolean(boolean bl) throws SqlException {
        return bl ? (byte)1 : 0;
    }

    final byte getByteFromString(String string) throws SqlException {
        try {
            return this.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, numberFormatException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "byte.");
        }
    }

    final short getShortFromInt(int n) throws SqlException {
        if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(n));
        }
        return (short)n;
    }

    final short getShortFromLong(long l) throws SqlException {
        if (l > 32767L || l < -32768L) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(l));
        }
        return (short)l;
    }

    final short getShortFromFloat(float f) throws SqlException {
        if (f > 32767.0f || f < -32768.0f) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
        }
        return (short)f;
    }

    final short getShortFromDouble(double d) throws SqlException {
        if (d > 32767.0 || d < -32768.0) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
        }
        return (short)d;
    }

    final short getShortFromBigDecimal(BigDecimal bigDecimal) throws SqlException {
        if (bigDecimal.compareTo(bdMaxShortValue__) == 1 || bigDecimal.compareTo(bdMinShortValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
        }
        return (short)bigDecimal.intValue();
    }

    final short getShortFromBoolean(boolean bl) throws SqlException {
        return bl ? (short)1 : 0;
    }

    final short getShortFromString(String string) throws SqlException {
        try {
            return this.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, numberFormatException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "short.");
        }
    }

    final int getIntFromLong(long l) throws SqlException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(l));
        }
        return (int)l;
    }

    final int getIntFromFloat(float f) throws SqlException {
        if (f > 2.1474836E9f || f < -2.1474836E9f) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
        }
        return (int)f;
    }

    final int getIntFromDouble(double d) throws SqlException {
        if (d > 2.147483647E9 || d < -2.147483648E9) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
        }
        return (int)d;
    }

    final int getIntFromBigDecimal(BigDecimal bigDecimal) throws SqlException {
        if (bigDecimal.compareTo(bdMaxIntValue__) == 1 || bigDecimal.compareTo(bdMinIntValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
        }
        return bigDecimal.intValue();
    }

    final int getIntFromBoolean(boolean bl) throws SqlException {
        return bl ? 1 : 0;
    }

    final int getIntFromString(String string) throws SqlException {
        try {
            return this.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, numberFormatException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "int.");
        }
    }

    final long getLongFromFloat(float f) throws SqlException {
        if (f > 9.223372E18f || f < -9.223372E18f) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(f));
        }
        return (long)f;
    }

    final long getLongFromDouble(double d) throws SqlException {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
        }
        return (long)d;
    }

    final long getLongFromBigDecimal(BigDecimal bigDecimal) throws SqlException {
        if (bigDecimal.compareTo(bdMaxLongValue__) == 1 || bigDecimal.compareTo(bdMinLongValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
        }
        return bigDecimal.longValue();
    }

    final long getLongFromBoolean(boolean bl) throws SqlException {
        return bl ? 1L : 0L;
    }

    final long getLongFromString(String string) throws SqlException {
        try {
            return this.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, numberFormatException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "long.");
        }
    }

    final float getFloatFromDouble(double d) throws SqlException {
        if (Float.isInfinite((float)d)) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(d));
        }
        return (float)d;
    }

    final float getFloatFromBigDecimal(BigDecimal bigDecimal) throws SqlException {
        if (bigDecimal.compareTo(bdMaxFloatValue__) == 1 || bigDecimal.compareTo(bdMinFloatValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
        }
        return bigDecimal.floatValue();
    }

    final float getFloatFromBoolean(boolean bl) throws SqlException {
        return bl ? 1.0f : 0.0f;
    }

    final float getFloatFromString(String string) throws SqlException {
        try {
            return Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, numberFormatException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "float.");
        }
    }

    final double getDoubleFromBigDecimal(BigDecimal bigDecimal) throws SqlException {
        if (bigDecimal.compareTo(bdMaxDoubleValue__) == 1 || bigDecimal.compareTo(bdMinDoubleValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(bigDecimal));
        }
        return bigDecimal.doubleValue();
    }

    final double getDoubleFromBoolean(boolean bl) throws SqlException {
        return bl ? 1.0 : 0.0;
    }

    final double getDoubleFromString(String string) throws SqlException {
        try {
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, numberFormatException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "double.");
        }
    }

    final BigDecimal getBigDecimalFromBoolean(boolean bl) throws SqlException {
        return bl ? bdOne__ : bdZero__;
    }

    final BigDecimal getBigDecimalFromString(String string) throws SqlException {
        try {
            return new BigDecimal(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, numberFormatException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "java.math.BigDecimal.");
        }
    }

    final String getStringFromBoolean(boolean bl) throws SqlException {
        return bl ? "1" : "0";
    }

    final String getStringFromBytes(byte[] byArray) throws SqlException {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    final Date getDateFromString(String string) throws SqlException {
        try {
            return this.date_valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, illegalArgumentException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "java.sql.Date.");
        }
    }

    final Date getDateFromTime(Time time) throws SqlException {
        return new Date(time.getTime());
    }

    final Date getDateFromTimestamp(Timestamp timestamp) throws SqlException {
        return new Date(timestamp.getTime());
    }

    final Time getTimeFromString(String string) throws SqlException {
        try {
            return this.time_valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, illegalArgumentException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "java.sql.Time.");
        }
    }

    final Time getTimeFromTimestamp(Timestamp timestamp) throws SqlException {
        return new Time(timestamp.getTime());
    }

    final Timestamp getTimestampFromString(String string) throws SqlException {
        try {
            return this.timestamp_valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, illegalArgumentException, "Invalid data conversion: Parameter instance " + string + " is invalid for requested conversion to " + "java.sql.Timestamp.");
        }
    }

    final Timestamp getTimestampFromTime(Time time) throws SqlException {
        return new Timestamp(time.getTime());
    }

    final Timestamp getTimestampFromDate(Date date) throws SqlException {
        return new Timestamp(date.getTime());
    }

    final Date date_valueOf(String string) throws IllegalArgumentException {
        String string2 = "JDBC Date format must be yyyy-mm-dd";
        if (string == null) {
            throw new IllegalArgumentException(string2);
        }
        string = string.trim();
        return Date.valueOf(string);
    }

    final Time time_valueOf(String string) throws IllegalArgumentException, NumberFormatException {
        String string2 = "JDBC Time format must be hh:mm:ss";
        if (string == null) {
            throw new IllegalArgumentException();
        }
        string = string.trim();
        return Time.valueOf(string);
    }

    final Timestamp timestamp_valueOf(String string) throws IllegalArgumentException, NumberFormatException {
        String string2 = "JDBC Timestamp format must be yyyy-mm-dd hh:mm:ss.fffffffff";
        if (string == null) {
            throw new IllegalArgumentException();
        }
        string = string.trim();
        return Timestamp.valueOf(string);
    }

    private final byte parseByte(String string) throws NumberFormatException {
        int n = this.parseInt(string);
        if (n < -128 || n > 127) {
            throw new NumberFormatException();
        }
        return (byte)n;
    }

    private final short parseShort(String string) throws NumberFormatException {
        int n = this.parseInt(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)n;
    }

    private final int parseInt(String string) throws NumberFormatException {
        int n;
        int n2;
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = string.length();
        if (n5 == 0) {
            throw new NumberFormatException(string);
        }
        if (string.charAt(0) == '-') {
            bl = true;
            n2 = Integer.MIN_VALUE;
            ++n4;
        } else {
            n2 = -2147483647;
        }
        int n6 = n2 / 10;
        if (n4 < n5) {
            if ((n = Character.digit(string.charAt(n4++), 10)) < 0) {
                throw new NumberFormatException(string);
            }
            n3 = -n;
        }
        while (n4 < n5) {
            char c;
            if ((c = string.charAt(n4++)) == ' ') {
                this.skipPadding(string, n4, n5);
                break;
            }
            n = Character.digit(c, 10);
            if (n < 0) {
                throw new NumberFormatException(string);
            }
            if (n3 < n6) {
                throw new NumberFormatException(string);
            }
            if ((n3 *= 10) < n2 + n) {
                throw new NumberFormatException(string);
            }
            n3 -= n;
        }
        if (bl) {
            if (n4 > 1) {
                return n3;
            }
            throw new NumberFormatException(string);
        }
        return -n3;
    }

    private final long parseLong(String string) throws NumberFormatException {
        int n;
        long l;
        if (string == null) {
            throw new NumberFormatException("null");
        }
        long l2 = 0L;
        boolean bl = false;
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            throw new NumberFormatException(string);
        }
        if (string.charAt(0) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n2;
        } else {
            l = -9223372036854775807L;
        }
        long l3 = l / 10L;
        if (n2 < n3) {
            if ((n = Character.digit(string.charAt(n2++), 10)) < 0) {
                throw new NumberFormatException(string);
            }
            l2 = -n;
        }
        while (n2 < n3) {
            char c;
            if ((c = string.charAt(n2++)) == ' ') {
                this.skipPadding(string, n2, n3);
                break;
            }
            n = Character.digit(c, 10);
            if (n < 0) {
                throw new NumberFormatException(string);
            }
            if (l2 < l3) {
                throw new NumberFormatException(string);
            }
            if ((l2 *= 10L) < l + (long)n) {
                throw new NumberFormatException(string);
            }
            l2 -= (long)n;
        }
        if (bl) {
            if (n2 > 1) {
                return l2;
            }
            throw new NumberFormatException(string);
        }
        return -l2;
    }

    private final void skipPadding(String string, int n, int n2) throws NumberFormatException {
        while (n < n2) {
            if (string.charAt(n++) == ' ') continue;
            throw new NumberFormatException(string);
        }
    }
}

