/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IInstallConfigurationChangedListener;
import org.eclipse.update.configuration.LocalSystemInfo;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.IDynamicPage;
import org.eclipse.update.internal.ui.wizards.TargetSiteDialog;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class TargetPage
extends BannerPage
implements IDynamicPage {
    private TableViewer jobViewer;
    private IInstallConfiguration config;
    private ConfigListener configListener;
    private Label requiredSpaceLabel;
    private Label availableSpaceLabel;
    private IInstallFeatureOperation[] jobs;
    private Label installLocation;
    private Button changeLocation;
    static HashSet added;

    public TargetPage(IInstallConfiguration config) {
        super("Target");
        this.setTitle(UpdateUIMessages.InstallWizard_TargetPage_title);
        this.setDescription(UpdateUIMessages.InstallWizard_TargetPage_desc);
        this.config = config;
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.configListener = new ConfigListener();
    }

    public void setJobs(IInstallFeatureOperation[] jobs) {
        this.jobs = jobs;
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        Label label = new Label(client, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_jobsLabel);
        this.createJobViewer(client);
        label = new Label(client, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_location);
        GridData gd = new GridData(32);
        label.setLayoutData((Object)gd);
        this.installLocation = new Label(client, 0);
        this.installLocation.setText("foo");
        gd = new GridData(768);
        this.installLocation.setLayoutData((Object)gd);
        this.changeLocation = new Button(client, 8);
        this.changeLocation.setText(UpdateUIMessages.InstallWizard_TargetPage_location_change);
        this.changeLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TargetPage.this.jobViewer.getSelection();
                if (selection == null) {
                    return;
                }
                IInstallFeatureOperation job = (IInstallFeatureOperation)selection.getFirstElement();
                if (job == null) {
                    return;
                }
                TargetSiteDialog dialog = new TargetSiteDialog(TargetPage.this.getShell(), TargetPage.this.config, job, TargetPage.this.configListener);
                dialog.create();
                SWTUtil.setDialogSize(dialog, 400, 300);
                dialog.getShell().setText(UpdateUIMessages.SitePage_new);
                dialog.open();
                TargetPage.this.setTargetLocation(job);
                TargetPage.this.pageChanged();
                TargetPage.this.jobViewer.refresh();
                TargetPage.this.updateStatus(job.getTargetSite());
            }
        });
        Composite status = new Composite(client, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        status.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        status.setLayout((Layout)layout);
        label = new Label(status, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_requiredSpace);
        this.requiredSpaceLabel = new Label(status, 0);
        this.requiredSpaceLabel.setLayoutData((Object)new GridData(768));
        label = new Label(status, 0);
        label.setText(UpdateUIMessages.InstallWizard_TargetPage_availableSpace);
        this.availableSpaceLabel = new Label(status, 0);
        this.availableSpaceLabel.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, "org.eclipse.update.ui.MultiTargetPage2");
        Dialog.applyDialogFont((Control)parent);
        return client;
    }

    private void createJobViewer(Composite parent) {
        this.jobViewer = new TableViewer(parent, 2816);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.widthHint = 150;
        this.jobViewer.getTable().setLayoutData((Object)gd);
        this.jobViewer.setContentProvider((IContentProvider)new JobsContentProvider());
        this.jobViewer.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.jobViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IInstallFeatureOperation job = (IInstallFeatureOperation)selection.getFirstElement();
                TargetPage.this.setTargetLocation(job);
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializeDefaultTargetSites();
            this.jobViewer.setInput((Object)this.jobs);
            if (this.jobViewer.getSelection().isEmpty() && this.jobs.length > 0) {
                this.jobViewer.setSelection((ISelection)new StructuredSelection((Object)this.jobs[0]));
            }
        }
        super.setVisible(visible);
    }

    private void verifyNotEmpty(boolean empty) {
        String errorMessage = null;
        if (empty) {
            errorMessage = UpdateUIMessages.InstallWizard_TargetPage_location_empty;
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(!empty);
    }

    private void updateStatus(Object element) {
        if (element == null) {
            this.requiredSpaceLabel.setText("");
            this.availableSpaceLabel.setText("");
            return;
        }
        IConfiguredSite site = (IConfiguredSite)element;
        File file = new File(site.getSite().getURL().getFile());
        long available = LocalSystemInfo.getFreeSpace((File)file);
        long required = this.computeRequiredSizeFor(site);
        if ((required += this.computeDownloadSizeFor(site)) <= 0L) {
            this.requiredSpaceLabel.setText(UpdateUIMessages.InstallWizard_TargetPage_unknownSize);
        } else {
            this.requiredSpaceLabel.setText(NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_size, (Object)("" + required)));
        }
        if (available == -1L) {
            this.availableSpaceLabel.setText(UpdateUIMessages.InstallWizard_TargetPage_unknownSize);
        } else {
            this.availableSpaceLabel.setText(NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_size, (Object)("" + available)));
        }
        if (available != -1L && required > available) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    private long computeRequiredSizeFor(IConfiguredSite site) {
        long totalSize = 0L;
        int i = 0;
        while (i < this.jobs.length) {
            if (site.equals(this.jobs[i].getTargetSite())) {
                long jobSize = site.getSite().getInstallSizeFor(this.jobs[i].getFeature());
                if (jobSize == -1L) {
                    return -1L;
                }
                totalSize += jobSize;
            }
            ++i;
        }
        return totalSize;
    }

    private long computeDownloadSizeFor(IConfiguredSite site) {
        long totalSize = 0L;
        int i = 0;
        while (i < this.jobs.length) {
            if (site.equals(this.jobs[i].getTargetSite())) {
                long jobSize = site.getSite().getDownloadSizeFor(this.jobs[i].getFeature());
                if (jobSize == -1L) {
                    return -1L;
                }
                totalSize += jobSize;
            }
            ++i;
        }
        return totalSize;
    }

    private void pageChanged() {
        boolean empty = false;
        int i = 0;
        while (this.jobs != null && i < this.jobs.length) {
            if (this.jobs[i].getTargetSite() == null) {
                empty = true;
                break;
            }
            IFeature feature = this.jobs[i].getFeature();
            if (feature.isPatch()) {
                IInstallFeatureOperation patchedFeatureJob = this.findPatchedFeature(feature);
                if (patchedFeatureJob != null && patchedFeatureJob.getTargetSite() != null && !this.jobs[i].getTargetSite().equals(patchedFeatureJob.getTargetSite())) {
                    String msg = NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_patchError, (Object[])new String[]{feature.getLabel(), patchedFeatureJob.getFeature().getLabel()});
                    this.setErrorMessage(msg);
                    this.setPageComplete(false);
                    return;
                }
                IFeature patchedFeature = UpdateUtils.getPatchedFeature((IFeature)feature);
                if (patchedFeature != null && !this.jobs[i].getTargetSite().equals(patchedFeature.getSite().getCurrentConfiguredSite())) {
                    String msg = NLS.bind((String)UpdateUIMessages.InstallWizard_TargetPage_patchError2, (Object[])new String[]{feature.getLabel(), patchedFeature.getLabel(), patchedFeature.getSite().getCurrentConfiguredSite().getSite().getURL().getFile()});
                    this.setErrorMessage(msg);
                    this.setPageComplete(false);
                    return;
                }
            }
            ++i;
        }
        this.verifyNotEmpty(empty);
    }

    private boolean getSiteVisibility(IConfiguredSite site, IInstallFeatureOperation job) {
        if (!site.isUpdatable()) {
            return false;
        }
        IConfiguredSite affinitySite = UpdateUtils.getAffinitySite((IInstallConfiguration)this.config, (IFeature)job.getFeature());
        if (affinitySite != null) {
            return site.getSite().equals(affinitySite.getSite());
        }
        if (job.getOldFeature() != null) {
            IConfiguredSite oldSite = UpdateUtils.getSiteWithFeature((IInstallConfiguration)this.config, (String)job.getOldFeature().getVersionedIdentifier().getIdentifier());
            return site == oldSite;
        }
        return true;
    }

    private void initializeDefaultTargetSites() {
        int i = 0;
        while (i < this.jobs.length) {
            if (this.jobs[i].getTargetSite() == null) {
                IConfiguredSite affinitySite = UpdateUtils.getAffinitySite((IInstallConfiguration)this.config, (IFeature)this.jobs[i].getFeature());
                if (affinitySite != null) {
                    this.jobs[i].setTargetSite(affinitySite);
                } else {
                    IConfiguredSite defaultSite = UpdateUtils.getDefaultTargetSite((IInstallConfiguration)this.config, (IInstallFeatureOperation)this.jobs[i], (boolean)false);
                    if (defaultSite != null) {
                        this.jobs[i].setTargetSite(defaultSite);
                    } else {
                        this.jobs[i].setTargetSite(this.getFirstTargetSite(this.jobs[i]));
                    }
                }
            }
            ++i;
        }
    }

    private IConfiguredSite getFirstTargetSite(IInstallFeatureOperation job) {
        IConfiguredSite[] sites = this.config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IConfiguredSite csite = sites[i];
            if (this.getSiteVisibility(csite, job)) {
                return csite;
            }
            ++i;
        }
        return null;
    }

    public IInstallFeatureOperation findPatchedFeature(IFeature patch) {
        int i = 0;
        while (i < this.jobs.length) {
            IFeature target = this.jobs[i].getFeature();
            if (!target.equals(patch) && UpdateUtils.isPatch((IFeature)target, (IFeature)patch)) {
                return this.jobs[i];
            }
            ++i;
        }
        return null;
    }

    void removeAddedSites() {
        if (added != null) {
            Iterator it = added.iterator();
            while (it.hasNext()) {
                this.config.removeConfiguredSite((IConfiguredSite)it.next());
            }
            added.clear();
        }
    }

    public boolean isPageComplete() {
        int i = 0;
        while (this.jobs != null && i < this.jobs.length) {
            if (this.jobs[i].getTargetSite() == null) {
                return false;
            }
            ++i;
        }
        return super.isPageComplete();
    }

    private void setTargetLocation(IInstallFeatureOperation job) {
        if (job != null && job.getTargetSite() != null) {
            this.installLocation.setText(new File(job.getTargetSite().getSite().getURL().getFile()).toString());
            this.updateStatus(job.getTargetSite());
        }
    }

    class ConfigListener
    implements IInstallConfigurationChangedListener {
        ConfigListener() {
        }

        public void installSiteAdded(IConfiguredSite csite) {
            int i = 0;
            while (TargetPage.this.jobs != null && i < TargetPage.this.jobs.length) {
                if (TargetPage.this.jobs[i].getTargetSite() == null && TargetPage.this.getSiteVisibility(csite, TargetPage.this.jobs[i])) {
                    TargetPage.this.jobs[i].setTargetSite(csite);
                }
                ++i;
            }
            TargetPage.this.jobViewer.refresh();
        }

        public void installSiteRemoved(IConfiguredSite csite) {
            boolean refreshJobs = false;
            int i = 0;
            while (TargetPage.this.jobs != null && i < TargetPage.this.jobs.length) {
                if (TargetPage.this.jobs[i].getTargetSite() == csite) {
                    TargetPage.this.jobs[i].setTargetSite(null);
                    refreshJobs = true;
                }
                ++i;
            }
            TargetPage.this.pageChanged();
            TargetPage.this.jobViewer.refresh();
            if (refreshJobs) {
                TargetPage.this.jobViewer.getControl().setFocus();
            }
        }
    }

    class JobsContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        JobsContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TargetPage.this.jobs;
        }
    }

    class JobsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        JobsLabelProvider() {
        }

        public Image getColumnImage(Object obj, int col) {
            UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
            IInstallFeatureOperation job = (IInstallFeatureOperation)obj;
            ImageDescriptor base = job.getFeature().isPatch() ? UpdateUIImages.DESC_EFIX_OBJ : UpdateUIImages.DESC_FEATURE_OBJ;
            int flags = 0;
            if (job.getTargetSite() == null) {
                flags = 1;
            }
            return provider.get(base, flags);
        }

        public String getColumnText(Object obj, int col) {
            if (col == 0) {
                IFeature feature = ((IInstallFeatureOperation)obj).getFeature();
                return String.valueOf(feature.getLabel()) + " " + feature.getVersionedIdentifier().getVersion().toString();
            }
            return null;
        }
    }
}

