//////////////////////////////////////////////////////
// titlebarshow.c
//
// Lee Juhyun
//
//
#include <panel.h>
#include <menu.h>
#include <stdlib.h>
#include "mainlib.h"
#include "varlib.h"

menu_t	*menudata;

extern int screen_size_cols;

extern WINDOW 	*w_titlebar;
extern MENU		*m_titlebar;
extern PANEL	*p_titlebar;

extern void read_menu_cfg(void);
extern int write_log(char *);
extern int exit_program(void);

void titlebar_show(void) {

	ITEM **my_items;
	int i;

	int size_titlebar_lines	= 3;
	int size_titlebar_cols	= screen_size_cols - 1;
	int size_titlebar_y	= 0;
	int size_titlebar_x	= 0;


	read_menu_cfg();
	
	if ((w_titlebar = newwin(size_titlebar_lines, size_titlebar_cols,
			size_titlebar_y, size_titlebar_x)) == NULL) {
		write_log("Error titlebar_show/newwin");
		exit_program();
	}

	if ((p_titlebar = new_panel(w_titlebar)) == NULL) {
		write_log("Error titlebar_show/new_panel");
		exit_program();
	}

	if ((my_items = (ITEM **)calloc(menudata->n_submenu[0], sizeof(ITEM *))) == NULL) {
		write_log("Error titlebar_show/calloc");
		exit_program();
	}

	for (i=0; i < menudata->n_submenu[0]; ++i)
		my_items[i] = new_item(menudata->submenu[0][i].name, menudata->submenu[0][i].ins);
	
	my_items[menudata->n_submenu[0]] = (ITEM *)NULL;
	
	if ((m_titlebar = new_menu((ITEM **)my_items)) == NULL) {
		write_log("Error titlebar_show/new_menu");
		exit_program();
	}
		
	set_menu_format(m_titlebar, 1, 6);
	set_menu_win(m_titlebar, w_titlebar);
	set_menu_sub(m_titlebar, derwin(w_titlebar, size_titlebar_lines - 2, size_titlebar_cols - 2, 1, 1));
	set_menu_mark(m_titlebar, " ");
		
	box(w_titlebar, 0, 0);

	if ((p_titlebar = new_panel(w_titlebar)) == NULL) {
		write_log("Error titlebar_show/new_panel");
		exit_program();
	}

	post_menu(m_titlebar);
}
