//////////////////////////////////////////////////////
// submenukey.c
//
//  Lee Juhyun
//
#include <menu.h>
#include <panel.h>
#include "keylib.h"
#include "mainlib.h"
#include "varlib.h"

extern 	int 		screen_size_cols;
extern 	int 		screen_size_lines;
extern 	int 		index_menu;

extern 	menu_t 		*menudata;
extern 	MENU 		**m_submenu;
extern 	PANEL 		**p_submenu;
extern 	WINDOW 		**w_submenu;
extern 	PANEL_DATA 	**pd_submenu;
extern 	WINDOW 		*w_fileinfo;
extern	WINDOW		*w_filelist;
extern 	WINDOW 		*w_bottombar;
extern 	MENU 		*m_titlebar;

int submenu_key(int c);
int submenu_info_view(void);

extern int execute_parser(const char *, const char *);
extern int show_w_filelist(char *, int);

extern int write_log(char *);
extern int exit_program();

int submenu_key(int c) {
	
	int i;
	PANEL_DATA *temp_submenu;
	char label[80];

	switch(c) {
	case KEY_NPAGE:
		menu_driver(m_submenu[index_menu], REQ_SCR_DPAGE);
		if (submenu_info_view() == -1) {
			write_log("Error submenu_key/ubmenu_info_view(UP)");
			exit_program();
		}
		break;
	case KEY_PPAGE:
		menu_driver(m_submenu[index_menu], REQ_SCR_UPAGE);
		if (submenu_info_view() == -1) {
			write_log("Error submenu_key/ubmenu_info_view(UP)");
			exit_program();
		}
		break;
	case KEY_UP:
		menu_driver(m_submenu[index_menu], REQ_UP_ITEM);
		
		if (submenu_info_view() == -1) {
			write_log("Error submenu_key/ubmenu_info_view(UP)");
			exit_program();
		}

		break;
	case KEY_DOWN:
		menu_driver(m_submenu[index_menu], REQ_DOWN_ITEM);
		if (submenu_info_view() == -1) {
			write_log("Error submenu_key/submenu_info_view(DOWN)");
			exit_program();
		}
		break;
	case KEY_RIGHT:
		menu_driver(m_titlebar, REQ_RIGHT_ITEM);

		index_menu = item_index(current_item(m_titlebar));

		for (i = 0; i < menudata->n_submenu[0]; i++) {
			if ((temp_submenu = (PANEL_DATA *)panel_userptr(p_submenu[i])) == NULL) {
				write_log("Error submenu_key/panel_userptr(RIGHT)");
				exit_program();
			}
			temp_submenu->hide = TRUE;
			hide_panel(p_submenu[i]);
		}
		show_panel(p_submenu[index_menu]);

		if ((temp_submenu = (PANEL_DATA *)panel_userptr(p_submenu[index_menu])) == NULL) {
			write_log("Error submenu_key/panel_userptr(RIGHT)");
			exit_program();
		}
		temp_submenu = FALSE;
		
		update_panels();

		doupdate();
		
		if (submenu_info_view() == -1) {
			write_log("Error submenu_key/ubmenu_info_view(RIGHT)");
			exit_program();
		}
		break;
	case KEY_LEFT:
		menu_driver(m_titlebar, REQ_LEFT_ITEM);

		index_menu = item_index(current_item(m_titlebar));

		for (i = 0; i < menudata->n_submenu[0]; i++) {
			if ((temp_submenu = (PANEL_DATA *)panel_userptr(p_submenu[i])) == NULL) {
				write_log("Error submenu_key/panel_userptr(LEFT)");
				exit_program();
			}
			temp_submenu->hide = TRUE;
			hide_panel(p_submenu[i]);
		}
		show_panel(p_submenu[index_menu]);

		if ((temp_submenu = (PANEL_DATA *)panel_userptr(p_submenu[index_menu])) == NULL) {
			write_log("Error submenu_key/panel_userptr(LEFT)");
			exit_program();
		}
		temp_submenu = FALSE;

		update_panels();

		doupdate();
		
		break;
	case KEY_USER_ENTER:
		if (execute_parser(menudata->submenu[index_menu+1][item_index(current_item(m_submenu[index_menu]))].desc,
				menudata->submenu[index_menu+1][item_index(current_item(m_submenu[index_menu]))].ins) == -1) {
			write_log("Error submenu_key/execute_parser(ENTER)");
			exit_program();
		}
		index_menu = -1;
		
		if (sprintf(label, "                                      ") < 0) {
			write_log("Error submenu_key/sprintf(ENTER)");
			exit_program();
		}

		if (show_w_filelist(label, 1) == -1) {
			write_log("Error submenu_key/show_w_filelist(ENTER)");
			exit_program();
		}
		wrefresh(w_filelist);

		if (sprintf(label, "Push TAB, U can use menu") < 0) {
			write_log("Error submenu_key/sprintf(ENTER)");
			exit_program();
		}

		if (show_w_filelist(label, 1) == -1) {
			write_log("Error submenu_key/show_w_filelist(ENTER)");
			exit_program();
		}
		wrefresh(w_filelist);
		break;
	case KEY_USER_TAB:
		index_menu = -1;
		
		if (sprintf(label, "                                      ") < 0) {
			write_log("Error submenu_key/sprintf(TAB)");
			exit_program();
		}

		if (show_w_filelist(label, 1) == -1) {
			write_log("Error submenu_key/show_w_filelist(TAB)");
			exit_program();
		}
		wrefresh(w_filelist);

		if (sprintf(label, "Push TAB, U can use menu") <0) {
			write_log("Error submenu_key/sprintf(TAB)");
			exit_program();
		}
		if (show_w_filelist(label, 1) == -1) {
			write_log("Error submenu_key/show_w_filelist(TAB)");
			exit_program();
		}
		wrefresh(w_filelist);
		break;
	}
	return 0;
}

int submenu_info_view() {
	char string[STRING_MAX];

	if (sprintf(string, "name:\"%s\"   description:\"%s\"  instruction:\"%s\"\n", menudata->submenu[index_menu+1][item_index(current_item(m_submenu[index_menu]))].name, menudata->submenu[index_menu+1][item_index(current_item(m_submenu[index_menu]))].desc2, menudata->submenu[index_menu+1][item_index(current_item(m_submenu[index_menu]))].ins) < 0) {
		write_log("Error submenu_info_view/sprintf");
		return -1;
	}


        if (wattron(w_fileinfo, COLOR_PAIR(1)) == ERR) {
		write_log("Error submenu_info_view/wattron");
		return -1;
	}

	mvwprintw(w_fileinfo, 0, 1, string);
        
	if (wattroff(w_fileinfo, COLOR_PAIR(1)) == ERR) {
		write_log("Error submenu_info_view/wattron");
		return -1;
	}
	wrefresh(w_fileinfo);
	
	return 0;
}
