//////////////////////////////////////////////////////
// readfile.c
//
//  Lee Juhyun
//
#include <stdio.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include "mainlib.h"
#include "varlib.h"

extern filepath_t *filepath;
extern char current_path[STRING_MAX];

int read_file(void);
int set_current_path(void);

extern int write_log(char *);
extern int exit_program();

int set_current_path() {
	
	char temp[STRING_MAX];

	if (getcwd(temp, STRING_MAX) == NULL) {
		write_log("Error set_current_path/getcwd");
		return -1;
	}

	strcpy(current_path, temp);

	return 0;
}

int read_file() {

	struct stat info;
	
	char getstring[PATH_MAX];
	char prefix[STRING_MAX];
	FILE *fp;
	char filekind[12];
	char filename[PATH_MAX];
	int count = 0;
	int n_filelists;
	char temppath[255];

	if(chdir(current_path) == -1) {
		write_log("Error read_file/chdir");
		return -1;
	}
	
	strcpy(temppath, getenv("HOME"));
	strcat(temppath, "/");
	strcat(temppath, ".temp_filelist");
	
	if (access(temppath, R_OK) == 0 ) {
		system("rm ~/.temp_filelist");
		write_log("Error read_file/system");
		return -1;
	}

	if (system("ls -a | wc -l >> ~/.temp_filelist;ls -1 -a >> ~/.temp_filelist") != 0) {
		write_log("Error read_file/system");
		return -1;
	}
	

	if ((fp = fopen(temppath, "r")) == NULL) {
		write_log("Error read_file/fopen");
		return -1;
	}


	if ((filepath = (filepath_t *)malloc(sizeof(filepath))) == NULL) {
		write_log("Error read_file/malloc");
		return -1;
	}

	fgets(getstring,sizeof(getstring),fp);
	
	sscanf(getstring, "%d\n", &n_filelists);
	
	filepath->filecount = n_filelists;

	if ((filepath->path = (char **)calloc(n_filelists, sizeof(char *))) == NULL || 
			(filepath->statpath = (char **)calloc(n_filelists, sizeof(char *))) == NULL) {
		write_log("Error read_file/calloc");
		return -1;
	}
	
	while (count < n_filelists) {

		fgets(getstring, sizeof(getstring), fp);

		sscanf(getstring, "%s/n", filename);

		if (strcmp(filename, ".temp_filelist") == 0) {
			n_filelists--;
			continue;
		}
		if ((*(filepath->path + count) = (char *)malloc(sizeof(char) * PATH_MAX)) == NULL) {
			write_log("Error read_file/calloc");
			return -1;
		}
		
		strcpy(*(filepath->path + count), filename);
		
		if (stat(filename, &info) == -1) {
			write_log("Error read_file/stat");
			return -1;
		}

		strcpy(prefix, "       ");

		if (S_ISDIR(info.st_mode)) strcpy(prefix, "[ DIR] ");
		if (S_ISCHR(info.st_mode)) strcpy(prefix, "[ CHR] ");
		if (S_ISBLK(info.st_mode)) strcpy(prefix, "[ BLK] ");
		if (S_ISFIFO(info.st_mode)) strcpy(prefix, "[FIFO] ");
		if (S_ISSOCK(info.st_mode)) strcpy(prefix, "[SOCK] ");

		strcat(prefix, filename);
		
		if ((*(filepath->statpath + count) = (char *)malloc(sizeof(char) * PATH_MAX)) == NULL) {
			write_log("Error read_file/malloc");
			return -1;
		}

		strcpy(*(filepath->statpath + count), prefix);
		
		count++;
	}

	if (system("rm ~/.temp_filelist") == -1) {
		write_log("Error read_file/system");
		return -1;
	}

	fclose(fp);

	return 0;
}
