#include <panel.h>
#include <ncurses.h>
#include <stdio.h>
#include <string.h>
#include "keylib.h"
#include "mainlib.h"

extern WINDOW				*w_fileview;
extern PANEL				*p_fileview;
extern WINDOW				*w_filelist;
extern int					is_vimode;
extern int					flag;
extern int 					index_menu;
extern int					print_y;			
extern int					print_x;
extern char					file_path[512];
extern int 				size_fileview_lines;
extern file_line_pointer	print;

extern int command_exec(char* ins, int boolin);
extern void print_line();
extern int	show_w_filelist(char *, int);

void fileview_key(int c)
{
	char temp[256];
	char label[80];
	int i;
	int lines = size_fileview_lines -6;

	switch(c)                                                                        
		{   			
			case KEY_NPAGE:
				for(i=0; print && print->next && i < lines;i++)
					print = print->next;
				print_line(1);
				break;
				
			case KEY_DOWN:
				if(print && print->next)
				{
					print = print->next;
					print_line(1);
				}				
				break;                                               
			case KEY_PPAGE:
				for(i = 0; print && print->pre && i< lines; i++)
					print = print->pre;
				print_line(1);
				break;
			case KEY_UP:
			
				if(print && print->pre)
				{
					print = print->pre;
					print_line(1);
				}
				break;
			case KEY_USER_TAB :
			case 'c':
				print_line(2);
				keypad(w_filelist, TRUE);

				flag = FI_MODE;

				index_menu = -1;

				sprintf(label, "                                      ");
				show_w_filelist(label, 1);
				wrefresh(w_filelist);

				sprintf(label, "Push TAB, U can use menu");
				show_w_filelist(label, 1);
				
				keypad(w_filelist, TRUE);
			
				wrefresh(w_filelist);
				is_vimode = FALSE;
				

				refresh();
				break;
			case 'e':
				//strcpy(temp, "vim ");
				//strcat(temp, file_path);
				sprintf(temp, "vim %s", file_path);
				command_exec(temp, FALSE);
				break;
			default:                                
				break;     					
		} 
}
