//////////////////////////////////////////////////////
// filelistshow.c
//
// Lee Juhyun
//
#include <curses.h>
#include <panel.h>
#include <menu.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include "mainlib.h"
#include "varlib.h"

filepath_t 	*filepath;
ITEM 		**my_items;
int		size_filelist_lines;
int		size_filelist_cols;
int 		size_filelist_y;
int 		size_filelist_x;

extern 	int 	screen_size_cols;
extern 	int 	screen_size_lines;

extern 	WINDOW 	*w_filelist;
extern 	PANEL 	*p_filelist;
extern 	MENU	*m_filelist;

int filelist_show(void);
int filelist_refresh(void);
int filelist_free(void);
int init_w_filelist(void);
int show_w_filelist(char *, int);
int print_in_middle_filelist(int, int, int, char *, chtype);
int print_in_left_filelist(int, int, int, char *, chtype);
int print_in_right_filelist(int, int, int, char *, chtype);

extern int read_file(void);
extern int set_current_path(void);

extern int write_log(char *);
extern int exit_program();

int filelist_show() {

	size_filelist_lines	= screen_size_lines - 15;
	size_filelist_cols	= screen_size_cols/2 - 1;
	size_filelist_y		= 3;
	size_filelist_x		= 0;

	int i;

	if (set_current_path() == -1) {
		write_log("Error filelist_show/set_current_path");
		exit_program();
	}
	if (read_file() == -1) {
		write_log("Error filelist_show/read_file");
		exit_program();
	}

	if (init_w_filelist() == -1) {
		write_log("Error filelist_show/init_w_filelist");
		exit_program();
	}

	if ((my_items = (ITEM **)calloc(filepath->filecount + 1, sizeof(ITEM *))) == NULL) {
		write_log("Error filelist_show/calloc");
		exit_program();
	}
	for (i =0; i < filepath->filecount; i++) {
		while ( size_filelist_cols - 4 > (strlen(*(filepath->statpath)) ))
			strcat(*(filepath->statpath), "             ");
		my_items[i] = new_item(*(filepath->statpath + i), *(filepath->path + i));
	}
	my_items[filepath->filecount] = (ITEM *)NULL;

	if ((m_filelist = new_menu((ITEM **)my_items)) == NULL) {
		write_log("Error filelist_show/new_menu");
		exit_program();
	}
        
	menu_opts_off(m_filelist, O_SHOWDESC);	                          
    menu_opts_off(m_filelist, O_ONEVALUE);	
	set_menu_format(m_filelist, size_filelist_lines-7, 1);
	set_menu_win(m_filelist, w_filelist);
	set_menu_sub(m_filelist, derwin(w_filelist, size_filelist_lines - 7, size_filelist_cols - 2, 3, 1));
	set_menu_mark(m_filelist, " ");
	
	post_menu(m_filelist);
	
	if ((p_filelist = new_panel(w_filelist)) == NULL) {
		write_log("Error filelist_show/new_panel");
		exit_program();
	}

	return 0;
}

int filelist_refresh() {
        
	free_menu(m_filelist);                                                              
	
	if(filelist_free() == -1) {
		write_log("Error filelist_refresh/filelist_free");
		return -1;
	}

	if(filelist_show() == -1) {
		write_log("Error filelist_refresh/filelist_show");
		return -1;
	}

	wrefresh(w_filelist);
	refresh();

	return 0;
}

int filelist_free() {

	int i;

	for(i = 0; i < filepath->filecount; ++i) {
		free(*(filepath->path + i));
		free(*(filepath->statpath + i));
	}
	for(i = 0; i < filepath->filecount + 1; ++i) {
		free_item(my_items[i]);
	}
	free(my_items);
	free(filepath->path);
	free(filepath->statpath);
	free(filepath);

	return 0;
}

int init_w_filelist() {

	int i;
	char label[80];

	if ((w_filelist = newwin(size_filelist_lines, size_filelist_cols,
			size_filelist_y, size_filelist_x)) == NULL) {
		write_log("Error init_w_filelist/newwin");
		return -1;
	}

	if (sprintf(label, "Push TAB, U can use menu") < 0) {
		write_log("Error init_w_filelist/sprintf");
		return -1;
	}

	if (show_w_filelist(label, 1) == -1) {
		write_log("Error init_w_filelist/show_w_filelist");
		return -1;
	}

	return 0;
}

int show_w_filelist(char *label, int label_color) {
	int startx, starty, height, width;
	char temp[80];

	startx = size_filelist_cols;
       	starty = 3;
	width = size_filelist_cols;
	height = 3; 

	box(w_filelist, 0, 0);
	mvwaddch(w_filelist, 2, 0, ACS_LTEE);
	mvwhline(w_filelist, 2, 1, ACS_HLINE, width - 2);
	mvwaddch(w_filelist, 2, width - 1, ACS_RTEE);
	
	mvwaddch(w_filelist, size_filelist_lines - 3, 0, ACS_LTEE);
	mvwhline(w_filelist, size_filelist_lines - 3, 1, ACS_HLINE, width - 2);
	mvwaddch(w_filelist, size_filelist_lines - 3, width - 1, ACS_RTEE);
	
	if (sprintf(temp, "files : %d", filepath->filecount) < 0) {
		write_log("Error show_w_filelist/sprintf");
		return -1;
	}

	if (print_in_middle_filelist(1, 0, width, label, COLOR_PAIR(label_color)) == -1) {
		write_log("Error show_w_filelist/print_in_middle_filelist");
		return -1;
	}
	if (print_in_left_filelist(size_filelist_lines - 2, 0, width, current_path, COLOR_PAIR(label_color)) == -1) {
		write_log("Error show_w_filelist/print_in_left_filelist");
		return -1;
	}
	if (print_in_right_filelist(size_filelist_lines - 2, 0, width, temp, COLOR_PAIR(label_color)) == -1) {
		write_log("Error show_w_filelist/print_in_right_filelist");
		return -1;
	}
	
	return 0;
}
int print_in_middle_filelist(int starty, int startx, int width, char *string, chtype color) {
	int length, x, y;
	float temp;

	if(w_filelist == NULL)
		w_filelist = stdscr;
	getyx(w_filelist, y, x);
	if(startx != 0)
		x = startx;
	if(starty != 0)
		y = starty;
	if(width == 0)
		width = 80;

	length = strlen(string);
	temp = (width - length)/2;
	x = startx + (int)temp;
	if (wattron(w_filelist, color) == ERR) {
		write_log("Error print_in_middle_filelist/wattron");
		return -1;
	}

	mvwprintw(w_filelist, y, x, "%s", string);
	if (wattroff(w_filelist, color) == ERR) {
		write_log("Error print_in_middle_filelist/wattroff");
		return -1;
	}
	refresh();
	
	return 0;
}

int print_in_left_filelist(int starty, int startx, int width, char *string, chtype color) {
	int length, x, y;
	float temp;

	if(w_filelist == NULL)
		w_filelist = stdscr;
	getyx(w_filelist, y, x);
	if(startx != 0)
		x = startx;
	if(starty != 0)
		y = starty;
	if(width == 0)
		width = 80;

	length = strlen(string);
	temp = 2;
	x = startx + (int)temp;
	if (wattron(w_filelist, color) == ERR) {
		write_log("Error print_in_left_filelist/wattron");
		return -1;
	}
	mvwprintw(w_filelist, y, x, "%s", string);
	if (wattroff(w_filelist, color) == ERR) {
		write_log("Error print_in_left_filelist/wattroff");
		return -1;
	}
	refresh();

	return 0;
}

int print_in_right_filelist(int starty, int startx, int width, char *string, chtype color) {
	int length, x, y;
	float temp;

	if(w_filelist == NULL)
		w_filelist = stdscr;
	getyx(w_filelist, y, x);
	if(startx != 0)
		x = startx;
	if(starty != 0)
		y = starty;
	if(width == 0)
		width = 80;

	length = strlen(string);
	temp = size_filelist_cols - length -2;
	x = startx + (int)temp;
	if (wattron(w_filelist, color) == ERR) {
		write_log("Error print_in_right_filelist/wattron");
		return -1;
	}
	mvwprintw(w_filelist, y, x, "%s", string);
	if (wattroff(w_filelist, color) == ERR) {
		write_log("Error print_in_right_filelist/wattroff");
		return -1;
	}
	refresh();
	
	return 0;
}


