//////////////////////////////////////////////////////
// filelistkey.c
//
// Lee Juhyun
//
#include <menu.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "keylib.h"
#include "mainlib.h"

extern 	int 	screen_size_cols;
extern 	char 	current_path[1024];
extern	int	flag;

extern 	MENU 	*m_filelist;
extern 	WINDOW 	*w_fileinfo;
extern	WINDOW	*w_filelist;
extern	WINDOW	*w_bottombar;
extern	MENU	*m_titlebar;
extern	WINDOW	*w_titlebar;
extern	WINDOW	*w_fileview;

int filelist_key(int);
int filelist_info_view(char*);

extern int set_current_path(void);
extern int filelist_refresh(void);
extern int execute_shortcut(int);

extern int write_log(char *);
extern int exit_program();


int filelist_key(int c) {
	
	int i;
	char temp[PATH_MAX];
	char temp2[STRING_MAX];
	char label[80];

	switch(c) {
	case KEY_DOWN:
		menu_driver(m_filelist, REQ_DOWN_ITEM);
		if (filelist_info_view((char *)item_description(current_item(m_filelist))) == -1) {
			write_log("Error filelist_key/filelist_info_view(DOWN)");
			exit_program();
		}
		break;
	case KEY_UP:
		menu_driver(m_filelist, REQ_UP_ITEM);
		if (filelist_info_view((char *)item_description(current_item(m_filelist))) == -1) {
			write_log("Error filelist_key/filelist_info_view(UP)");
			exit_program();
		}
		break;
	case KEY_NPAGE:
		menu_driver(m_filelist, REQ_SCR_DPAGE);
		if (filelist_info_view((char *)item_description(current_item(m_filelist))) == -1) {
			write_log("Error filelist_key/filelist_info_view(NPAGE)");
			exit_program();
		}
		break;
	case KEY_PPAGE:
		menu_driver(m_filelist, REQ_SCR_UPAGE);
		if (filelist_info_view((char *)item_description(current_item(m_filelist))) == -1) {
			write_log("Error filelist_key/filelist_info_view(PPAGE)");
			exit_program();
		}
		break;
	case KEY_USER_SPACE:	
		menu_driver(m_filelist, REQ_TOGGLE_ITEM);
		break;
	case KEY_USER_ENTER:
		strcpy(temp, item_name(current_item(m_filelist)));
	
		if (strncmp(temp, "[ DIR]", 6) == 0) {
			strcpy(temp2, current_path);
			strcat(temp2, "/");
			strcat(temp2, item_description(current_item(m_filelist)));
			if (chdir(temp2) == -1) {
				write_log("Error filelist_key/chdir(ENTER)");
				exit_program();
			}
			if (set_current_path() == -1) {
				write_log("Error filelist_key/set_current_path(ENTER)");
				exit_program();
			}
			if (filelist_refresh() == -1) {
				write_log("Error filelist_key/filelist_refresh(ENTER)");
				exit_program();
			}

		}

		break;
	case  KEY_USER_TAB :
		flag = TT_MODE;

		if (sprintf(label, "                                      ") < 0) {
			write_log("Error filelist_key/sprintf(TAB)");
			exit_program();
		}
		if (show_w_filelist(label, 2) == -1) {
			write_log("Error filelist_key/show_w_filelist(TAB)");
			exit_program();
		}

		wrefresh(w_filelist);
		//
		if (sprintf(label, "FILE LIST") < 0) {
			write_log("Error filelist_key/sprintf(TAB)");
			exit_program();
		}

		if (show_w_filelist(label, 2) == -1) {
			write_log("Error filelist_key/show_w_filelist(TAB)");
			exit_program();
		}
		
		set_menu_fore(m_titlebar, COLOR_PAIR(1) | A_REVERSE);
		set_menu_back(m_titlebar, COLOR_PAIR(1) );
		
		wrefresh(w_titlebar);
		wrefresh(w_filelist);
		//refresh();
		break;
	case 'v' :
	case 'V' :
		flag = VI_MODE;

		if (sprintf(label, "                                      ") < 0) {
			write_log("Error filelist_key/sprintf(TAB)");
			exit_program();
		}
		if (show_w_filelist(label, 2) == -1) {
			write_log("Error filelist_key/show_w_filelist(TAB)");
			exit_program();
		}

		wrefresh(w_filelist);
		//
		if (sprintf(label, "FILE LIST") < 0) {
			write_log("Error filelist_key/sprintf(TAB)");
			exit_program();
		}

		if (show_w_filelist(label, 2) == -1) {
			write_log("Error filelist_key/show_w_filelist(TAB)");
			exit_program();
		}
		
		wrefresh(w_fileview);
		wrefresh(w_filelist);
		refresh();
		break;
	default:
		if (execute_shortcut(c) == -1) {
			write_log("Error filelist_key/execute_shortcut(DEFAULT)");
			exit_program();
		}
		break;
	}
	wrefresh(w_filelist);
	refresh();
	return 0;
}

int filelist_info_view(char *filename) {
	
	struct stat info;
	char *uid_to_name(), *ctime(), *gid_to_name(), *filemode();
	int mode_to_letters();
	char modestr[11];
	char string[1024];

	if (stat(filename, &info) == -1) {
		write_log("Error filelist_info_view/stat");
		return -1;
	}

	if (mode_to_letters( info.st_mode, modestr ) == -1) {
		write_log("Error filelist_info_viea/mode_to_letters");
		return -1;
	}

	if (sprintf(string, "%s %4d %-8s %-8s %8ld %.12s %s\n", modestr, (int)info.st_nlink, uid_to_name(info.st_uid) , gid_to_name(info.st_gid), (long)info.st_size, 4+ctime(&info.st_mtime), filename) < 0) {
		write_log("Error filelist_info_viea/sprintf");
		return -1;
	}
        if (wattron(w_fileinfo, COLOR_PAIR(1)) == ERR) {
		write_log("Error filelist_info_viea/wattron");
		return -1;
	}
	mvwprintw(w_fileinfo, 0, 1, string);
        if (wattroff(w_fileinfo, COLOR_PAIR(1)) == ERR) {
		write_log("Error filelist_info_viea/wattron");
		return -1;
	}
	wrefresh(w_fileinfo);
	return 0;
}

int mode_to_letters( int mode, char str[] ) {
	strcpy( str, "----------" ); 
	if ( S_ISDIR(mode) ) str[0] = 'd'; 
	if ( S_ISCHR(mode) ) str[0] = 'c';
	if ( S_ISBLK(mode) ) str[0] = 'b'; 
	if ( mode & S_IRUSR ) str[1] = 'r';
	if ( mode & S_IWUSR ) str[2] = 'w';
	if ( mode & S_IXUSR ) str[3] = 'x';
	if ( mode & S_IRGRP ) str[4] = 'r';
	if ( mode & S_IWGRP ) str[5] = 'w';
	if ( mode & S_IXGRP ) str[6] = 'x';
	if ( mode & S_IROTH ) str[7] = 'r';
	if ( mode & S_IWOTH ) str[8] = 'w';
	if ( mode & S_IXOTH ) str[9] = 'x';
	return 0;
}


#include <pwd.h>

char *uid_to_name(uid_t uid) {
	struct passwd *getpwuid(), *pw_ptr;
	static char numstr[10];

	if ( ( pw_ptr = getpwuid(uid)) == NULL) {
		sprintf(numstr, "%d", uid);
		return numstr;
	}
	else 
		return pw_ptr->pw_name;
}

#include <grp.h>

char *gid_to_name( gid_t gid) {
	struct group *getgrgid(), *grp_ptr;
	static char numstr[10];

	if ((grp_ptr = getgrgid(gid)) == NULL) {
		sprintf(numstr, "%d", gid);
		return numstr;
	}
	else
		return grp_ptr->gr_name;
}
