//////////////////////////////////////////////////////
// executeparser.c
//
//  Lee Juhyun
//
#include <ncurses.h>
#include <string.h>
#include <menu.h>
#include <stdlib.h>
#include <dirent.h>
#include <signal.h>
#include "mainlib.h"
#include "varlib.h"
extern 	int 		flag;
extern 	char 		target_directory[STRING_MAX];
extern 	shortkey_t 	*shortkey;

extern 	WINDOW 		*w_bottombar;
extern 	MENU		*m_filelist;
extern	WINDOW		*w_filelist;
extern	WINDOW		*w_fileview;

int 	execute_parser	(const char *, const char *);
int 	execute_shortcut(int);

extern 	int 	exitprocess	(void);
extern 	int 	logo_show	(void);
extern 	int 	command_exec	(char* , int);
extern 	int	dirtree_show	(void);
extern	int	filelist_refresh(void);
extern	char	*userInputBox	(char *);
extern 	int 	fileview_show	(char *);
extern	int	messageBox	(char *);

extern int write_log(char *);
extern int exit_program();

extern int start_timer();
extern int stop_timer();


int execute_parser(const char *flagstring, const char *ins_original) {

	char *lasts;
	char ins[1024] = "";
	char *token[255];
	char **cpy_ins;
	char ins_complete[1024] = "";
	int i = 1, j;
	char temp[255] ="";
	ITEM **items;
	int n_token;
	int refresh_flag = FALSE;
	int select = TRUE;
	

	strcpy(ins, ins_original);

	if (strcmp(flagstring, "VIEW") == 0) {
		

		if (fileview_show(ins) == -1) {
			write_log("Error execute_parser/fileview_show");
			return -1;
		}
		
		wrefresh(w_fileview);
	}
	else if (strcmp(flagstring, "EXIT") == 0) {
		if (exitprocess() == -1) {
			write_log("Error execute_parser/exitprocess");
			return -1;
		}

	}
	else if (strcmp(flagstring, "PANEL") == 0) {
		stop_timer();
		if (logo_show() == -1) {
			write_log("Error execute_parser/logo_show");
			return -1;
		}
		start_timer();
	}
	else if ((strcmp(flagstring, "RUN") == 0) || (strcmp(flagstring, "RUNP") == 0)) {
		token[0] = strtok_r(ins, " ", &lasts);
		while((token[i] = strtok_r(NULL, " ", &lasts)) != NULL) {
			i++;
		}

		if ((cpy_ins = (char **)malloc(sizeof(char *) * i)) == NULL) {
			write_log("Error execute_parser/malloc");
			return -1;
		}

		n_token = i;

		j = 0;
		while(token[j] != NULL) {
			if (strcmp(token[j], "^d") == 0) {
				if (dirtree_show() == -1) {
					write_log("Error execute_parser/dirtree_show");
					return -1;
				}
				if ((cpy_ins[j] = (char *)malloc(sizeof(char) * strlen(target_path) + 1)) == NULL) {
					write_log("Error execute_parser/malloc");
					return -1;
				}
				
				strcpy(cpy_ins[j], target_path);
			}
			else if (strcmp(token[j], "^f") == 0) {
				if ((items = menu_items(m_filelist)) == NULL) {
					write_log("Error execute_parser/menu_items");
					return -1;
				}

				if ((cpy_ins[j] = (char *)malloc(sizeof(char) * STRING_MAX)) == NULL) {
					write_log("Error execute_parser/malloc");
					return -1;
				}
				
				strcpy(cpy_ins[j], " ");
				
				for(i = 0; i < item_count(m_filelist); ++i)
					if(item_value(items[i]) == TRUE) {
						strcat(cpy_ins[j], (char *)item_description(items[i]));
						strcat(cpy_ins[j], " ");
					}
				
				if (strcmp(cpy_ins[j], " ") == 0)
					strcat(cpy_ins[j], (char *)item_description(current_item(m_filelist)));

				//
			
			}
			else if (strcmp(token[j], "^q") == 0) {
				stop_timer();

				if ((cpy_ins[j] = (char *)malloc(sizeof(char) * (PATH_MAX + 1))) == NULL) {
					write_log("Error execute_parser/malloc");
					return -1;
				}

				strcpy(cpy_ins[j], userInputBox("Input String"));
				start_timer();
			}
			else if (strcmp(token[j], "^r") == 0) {
				refresh_flag = TRUE;
				//filelist_refresh();
				if ((cpy_ins[j] = (char *)malloc(sizeof(char) * 1)) == NULL) {
					write_log("Error execute_parser/malloc");
					return -1;
				}
				strcpy(cpy_ins[j], "");
			}
			else if (strcmp(token[j], "^c") == 0) {
				chdir(target_path);
				if ((cpy_ins[j] = (char *)malloc(sizeof(char) * 1)) == NULL) {
					write_log("Error execute_parser/malloc");
					return -1;
				}
				strcpy(cpy_ins[j], "");
			}
			else if (strcmp(token[j], "^y") == 0) {
				stop_timer();
				select = messageBox("Yes or No");
				if ((cpy_ins[j] = (char *)malloc(sizeof(char) * 1)) == NULL) {
					write_log("Error execute_parser/malloc");
					return -1;
				}
				strcpy(cpy_ins[j], "");
				start_timer();
			}
			else {
				if ((cpy_ins[j] = (char *)malloc(sizeof(char) * strlen(token[j]) + 1)) == NULL) {
					write_log("Error execute_parser/malloc");
					return -1;
				}
				strcpy(cpy_ins[j], token[j]);
			}
			j++;
		}
		strcpy(ins_complete, token[0]);
		for (j =1; j < n_token; j++) {
			strcat(ins_complete, " ");
			strcat(ins_complete, cpy_ins[j]);
		}
		if (select == TRUE) {
			if (strcmp(flagstring, "RUNP") == 0) {
				if (command_exec(ins_complete , TRUE) == -1) {
					write_log("Error execute_parser/command_exec");
					return -1;
				}
			}
			else {
				if (command_exec(ins_complete , FALSE) == -1) {
					write_log("Error execute_parser/command_exec");
					return -1;
				}
			}
			if (refresh_flag == TRUE) {
				if (filelist_refresh() == -1) {
					write_log("Error execute_parser/filelist_refresh");
					return -1;
				}
			}
		}

	}
	if (keypad(w_filelist, TRUE) == ERR) {
		write_log("Error execute_parser/keypad");	
		return -1;

	}

	return 0;
}

int execute_shortcut(int c) {
	int count = 0;

	while(shortkey[count].shortkey != 0) {
		if (shortkey[count].shortkey == c) {
			if (execute_parser(shortkey[count].flag, shortkey[count].ins) == -1) {
				write_log("Error execute_shortcut/execute_parser");	
				return -1;
			}
			break;
		}
		count++;
	}
	return 0;
}
