#ifndef __FLAG_SERIAL
#define __FLAG_SERIAL
#endif //__FLAG_SERIAL


/*
 * ø 
 * 8 Data bits, 1 Stop bit, No Parity bit, Asynchronous ⺻ Ѵ.(8N1, 񵿱)
 *
 * initSerial# ؼ ϰ ϴ Ʈ Ѵ.
 *
 */
//#define BR_110	0
//#define BR_300	1
//#define BR_600	2
//#define BR_1200	3	//   ʴ ӵ  Ѵ.
#define BR_2400	4
#define BR_4800	5
#define BR_9600	6
#define BR_14400	7
#define BR_19200	8
#define BR_38400	9
#define BR_56000	10
#define BR_57600	11
#define BR_76800	12
#define BR_115200	13
#define BR_230400	14
#define BR_250K	15
#define BR_500K	16
#define BR_1M	17

#ifdef	_AVR_ATMEGA128

//Ϸ  ǥ ̺귯 ȣ
#ifdef _CODEVISION
#ifndef _STDIO_INCLUDED_
#include <stdio.h>
#endif //_STDIO_INCLUDED_
#endif //_CODEVISION

#include "mega128/setUsart.h"

void initSerial (void);
void initSerial0(void);
void initSerial1(void);
char getchar0(void);
char getchar1(void);
void putchar0(char );
void putchar1(char );

//ͷƮ ڵ
//TODO
//̰ ϱ  Լ ؾ  ?
//׸ Լ ͷƮ ڵ带 ϱ⿡ ռ ͷƮ ο̺ ڵ带 ִ°  ?
//
//USART ͷƮ  (mega128 ͽƮ 60 )
//19 : USART0 Rx Complete
//20 : USART0 Data Register Empty
//21 : USART0 Tx Complete	//Tx ͷƮ   ?
//31 : USART0 Rx Complete
//32 : USART0 Data Register Empty
//33 : USART0 Tx Complete	//Tx ͷƮ   ?
interrupt [19] void interruptSerial0Rx(void)
{
}

interrupt [31] void interruptSerial1Rx(void)
{
}

void initSerial (void)
{
	initSerial0();
	//initSerial1();
}

void initSerial0(void)
{
	UCSR0C=0x06;	//иƼ,  Ʈ , ۸  ϴ ̴.
	setSerial0TxEnable();
    setSerial0RxEnable();
	setSerial0Baudrate_16MHz(BR_115200);
}


void initSerial1(void)
{
	UCSR1C=0x06;	//иƼ,  Ʈ , ۸  ϴ ̴.
}

char getchar0(void)
{
	return getSerial0RxData();
}

char getchar1(void)
{
	return getSerial1RxData();
}

void putchar0(char data)
{
	putSerial0(data);
}

void putchar1(char data)
{
	putSerial1(data);
}

#endif	//_AVR_ATMEGA128



#ifdef	_AVR_ATMEGA8

#ifdef _CODEVISION
#ifndef _STDIO_INCLUDED_
#include <stdio.h>
#endif //_STDIO_INCLUDED_
#endif //_CODEVISION


void initSerial (void);
void setSerialRxEnable(void);
void setSerialTxEnable(void);
void setSerialBaudrate_16MHz(int );
void setSerialRxDisable(void);
void setSerialTxDisable(void);
void setSerialRxInterruptEnable(void);
char getSerialRxData(void);
void setSerialRxInterruptDisable(void);
void putSerial(char );


/*
//ͷƮ ڵ
//TODO
//̰ ϱ  Լ ؾ  ?
//׸ Լ ͷƮ ڵ带 ϱ⿡ ռ ͷƮ ο̺ ڵ带 ִ°  ?
//
//USART ͷƮ  (mega128 ͽƮ 60 )
//19 : USART0 Rx Complete
//20 : USART0 Data Register Empty
//21 : USART0 Tx Complete	//Tx ͷƮ   ?
//31 : USART1 Rx Complete
//32 : USART1 Data Register Empty
//33 : USART1 Tx Complete	//Tx ͷƮ   ?
interrupt [19] void interruptSerial0Rx(void)
{
}

interrupt [31] void interruptSerial1Rx(void)
{
}
*/

void initSerial (void)
{
	UCSRC=0x86;	//иƼ,  Ʈ , ۸  ϴ ̴.
	setSerialRxEnable();
	setSerialTxEnable();
	setSerialBaudrate_16MHz(BR_57600);
}


void setSerialRxInterruptEnable(void)
{
	//ͷƮ ɸ , ŵ 1Ʈ ڰ UDR ִ ̴.
	setSerialRxEnable();
	UCSRB |= BM_1000_0000;
}

char getSerialRxData(void)
{
	return UDR;
}


void setSerialRxInterruptDisable(void)
{
	UCSRB &= BM_0111_1111;
}


void setSerialRxEnable(void)
{
	UCSRB |= BM_0001_0000;
}

void setSerialTxEnable(void)
{
	UCSRB |= BM_0000_1000;
}


void setSerialRxDisable(void)
{
	UCSRB &= BM_1110_1111;
}

void setSerialTxDisable(void)
{
	UCSRB &= BM_1111_0111;
}

void putSerial(char data)
{
	//   ٸ.
	// Ʈũ : UDRE(UCSRA 5° Ʈ), USART Transmmit Complete Flag,    Ŭ ȴ.(0 ȴ.)
	while ( (UCSRA & BM_0010_0000) == 0 );	
	// Ϳ ø Tx Shift Register ö󰡰,  ۵ȴ.
	UDR = data;
}

void setSerialBaudrate_16MHz(int baudrate)
{
	switch (baudrate)
	{
		case BR_2400:
			UBRRH = BM_0000_0001;
			UBRRL = BM_1010_0000;
			break;
		case BR_4800:
			UBRRH = BM_0000_0000;
			UBRRL = BM_1100_1111;
			break;
		case BR_9600:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0110_0111;
			break;
		case BR_14400:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0100_0100;
			break;
		case BR_19200:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0011_0011;
			break;
		case BR_38400:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0001_1001;
			break;
		case BR_56000:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0001_0001;
			break;
		case BR_57600:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0001_0000;
			break;
		case BR_76800:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0000_1100;
			break;
		case BR_115200:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0000_1000;
			break;
		case BR_230400:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0000_0011;
			break;
		case BR_250K:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0000_0011;
			break;
		case BR_500K:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0000_0001;
			break;
		case BR_1M:
			UBRRH = BM_0000_0000;
			UBRRL = BM_0000_0000;
			break;
defalut:
			break;
	}

}



#endif	//_AVR_ATMEGA8




#ifdef	_AVR_ATMEGA2560

//Ϸ  ǥ ̺귯 ȣ
#ifdef _CODEVISION
#ifndef _STDIO_INCLUDED_
#include <stdio.h>
#endif //_STDIO_INCLUDED_
#endif	//_CODEVISION

#include "mega2560/setUsart.h"

void initSerial0(void);
void initSerial1(void);
void initSerial2(void);
void initSerial3(void);
char getchar0(void);
char getchar1(void);
char getchar2(void);
char getchar3(void);
void putchar0(char );
void putchar1(char );
void putchar2(char );
void putchar3(char );

void initSerial (void)
{
	initSerial0();
	initSerial1();
	initSerial2();
	//initSerial3();
}

void initSerial0(void)
{
	UCSR0C=0x06;	//иƼ,  Ʈ , ۸  ϴ ̴.
	setSerial0Baudrate_16MHz(BR_57600);
	setSerial0RxEnable();
	setSerial0TxEnable();
	setSerial0RxInterruptEnable();
}

void initSerial1(void)
{
	UCSR1C=0x06;	//иƼ,  Ʈ , ۸  ϴ ̴.
	setSerial1Baudrate_16MHz(BR_115200);
	setSerial1RxEnable();
	setSerial1TxEnable();
}

void initSerial2(void)
{
	UCSR2C=0x06;	//иƼ,  Ʈ , ۸  ϴ ̴.
	setSerial2Baudrate_16MHz(BR_38400);
	setSerial2RxEnable();
	setSerial2RxInterruptEnable();
}

void initSerial3(void)
{
	UCSR3C=0x06;	//иƼ,  Ʈ , ۸  ϴ ̴.
	//setSerial3TxEnable();
	//setSerial3Baudrate_16MHz(BR_115200);
}

//Լ
// ڵ ҽ ϰ ϱ  ̸ Ѵ.
char getchar0(void)
{
	return getSerial0RxData();
}

char getchar1(void)
{
	return getSerial1RxData();
}

char getchar2(void)
{
	return getSerial2RxData();
}

char getchar3(void)
{
	return getSerial3RxData();
}

void putchar0(char data)
{
	putSerial0(data);
}

void putchar1(char data)
{
	putSerial1(data);
}

void putchar2(char data)
{
	putSerial2(data);
}

void putchar3(char data)
{
	putSerial3(data);
}

//ͷƮ ڵ
//TODO
//̰ ϱ  Լ ؾ  ?
//׸ Լ ͷƮ ڵ带 ϱ⿡ ռ ͷƮ ο̺ ڵ带 ִ°  ?
//
//USART ͷƮ  (ͽƮ )
//26 : USART0 Rx Complete
//27 : USART0 Data Register Empty
//28 : USART0 Tx Complete	//Tx ͷƮ   ?
//37 : USART1 Rx Complete
//38 : USART1 Data Register Empty
//39 : USART1 Tx Complete	//Tx ͷƮ   ?
//52 : USART2 Rx Complete
//53 : USART2 Data Register Empty
//54 : USART2 Tx Complete	//Tx ͷƮ   ?
//55 : USART3 Rx Complete
//56 : USART3 Data Register Empty
//57 : USART3 Tx Complete	//Tx ͷƮ   ?

/*
interrupt [26] void interruptSerial0Rx(void)
{
}

interrupt [37] void interruptSerial1Rx(void)
{
}

interrupt [52] void interruptSerial2Rx(void)
{
}

interrupt [55] void interruptSerial3Rx(void)
{
}
*/

#endif	//_AVR_ATMEGA2560

