#ifndef __FLAG_PORT
#define __FLAG_PORT
#endif //__FLAG_PORT


#ifdef	_AVR_ATMEGA8

void initPort(void)
{
	// Input/Output Ports initialization
	// Port B initialization
	// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTB=0x00;
	DDRB=0x00;

	// Port C initialization
	// Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTC=0x00;
	DDRC=0x00;

	// Port D initialization
	// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTD=0x00;
	DDRD=0x00;


}

#endif



#ifdef	_AVR_ATMEGA128
void initPort(void)
{
	// Input/Output Ports initialization
	// Port A initialization
	// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTA=0x00;
	DDRA=0x00;

	// Port B initialization
	// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTB=0x00;
	DDRB=0x00;

	// Port C initialization
	// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTC=0x00;
	DDRC=0x00;

	// Port D initialization
	// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTD=0x00;
	DDRD=0x00;

	// Port E initialization
	// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTE=0x00;
	DDRE=0x00;

	// Port F initialization
	// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
	PORTF=0x00;
	DDRF=0x00;

	// Port G initialization
	// Func4=In Func3=In Func2=In Func1=In Func0=In 
	// State4=T State3=T State2=T State1=T State0=T 
	PORTG=0x00;
	DDRG=0x00;

}

#endif



#ifdef	_AVR_ATMEGA2560
#include "mega2560/setPort.h"

void initPort(void)
{
	setPortA(0x00);
	setDDRA(0x00);

	setPortB(0x00);
	setDDRB(0xE0);

	setPortC(0x00);
	setDDRC(0x00);

	setPortD(0x00);
	setDDRD(0x00);

	setPortE(0x00);
	setDDRE(0x38);

	setPortF(0x00);
	setDDRF(0x00);

	setPortG(0x00);
	setDDRG(0x00);

	setPortH(0x00);
	setDDRH(0x00);

	setPortJ(0x00);
	setDDRJ(0x00);

	setPortK(0x00);
	setDDRK(0x00);

	setPortL(0x00);
	setDDRL(0x00);
}

#endif	//_AVR_ATMEGA2560
