#ifndef __FLAG_SETTIMER
#define __FLAG_SETTIMER
#endif //__FLAG_SETTIMER

void initTimer(void);
void initTimer0(void);
void initTimer1(void);
void initTimer2(void);
void initTimer3(void);

//Timer0 ÿ Ǵ Լ
void setTimer0ModeNormal(void);
void setTimer0ModePCPwm(void);
void setTimer0ModeCTC(void);
void setTimer0ModeFastPwm(void);
void setTimer0OutputDisable(void);
void setTimer0OutputNormalHigh(void);
void setTimer0OutputNormalLow(void);
void setTimer0OutputToggle(void);
void setTimer0ClockUseInternal(void);
void setTimer0ClockUseExtern(void);
void setTimer0ClockTo0(void);
void setTimer0ClockTo1(void);
void setTimer0ClockTo8(void);
void setTimer0ClockTo32(void);
void setTimer0ClockTo64(void);
void setTimer0ClockTo128(void);
void setTimer0ClockTo256(void);
void setTimer0ClockTo1024(void);
void setTimer0OCR(char value);
void setTimer0InterruptOverflow(void);
void setTimer0InterruptCompare(void);
void _setTimer0OutputSet(void);		//setTimer0OutputNormalHigh  ϵ Ѵ.
void _setTimer0OutputClear(void);	//setTimer0OutputNormalLow  ϵ Ѵ.

//Timer2 ÿ Ǵ Լ
void setTimer2ModeNormal(void);
void setTimer2ModePCPwm(void);
void setTimer2ModeCTC(void);
void setTimer2ModeFastPwm(void);
void setTimer2OutputDisable(void);
void setTimer2OutputNormalHigh(void);
void setTimer2OutputNormalLow(void);
void setTimer2OutputToggle(void);
void setTimer2ClockExternFallingEdge(void);
void setTimer2ClockExternRisingEdge(void);
void setTimer2ClockTo0(void);
void setTimer2ClockTo1(void);
void setTimer2ClockTo8(void);
void setTimer2ClockTo64(void);
void setTimer2ClockTo256(void);
void setTimer2ClockTo1024(void);
void setTimer2OCR(char value);
void setTimer2InterruptOverflow(void);
void setTimer2InterruptCompare(void);
void _setTimer2OutputSet(void);		//setTimer0OutputNormalHigh  ϵ Ѵ.
void _setTimer2OutputClear(void);	//setTimer0OutputNormalLow  ϵ Ѵ.

//Timer1 ÿ Ǵ Լ
void setTimer1ModeNormal(void);
void setTimer1ModePCPwm8Bits(void);
void setTimer1ModePCPwm9Bits(void);
void setTimer1ModePCPwm10Bits(void);
void setTimer1ModePCPwmwithICR1(void);
void setTimer1ModePCPwmwithOCR1A(void);
void setTimer1ModePFCPwmwithICR1(void);
void setTimer1ModePFCPwmwithOCR1A(void);
void setTimer1ModeCTC(void);
void setTimer1ModeCTCwithICR1(void);
void setTimer1ModeFastPwm8Bits(void);
void setTimer1ModeFastPwm9Bits(void);
void setTimer1ModeFastPwm10Bits(void);
void setTimer1ModeFastPwmwithICR1(void);
void setTimer1ModeFastPwmwithOCR1A(void);
void setTimer1AOutputNormalHigh(void);
void setTimer1AOutputNormalLow(void);
void setTimer1AOutputToggle(void);
void setTimer1AOutputDisable(void);
void setTimer1BOutputNormalHigh(void);
void setTimer1BOutputNormalLow(void);
void setTimer1BOutputToggle(void);
void setTimer1BOutputDisable(void);
void setTimer1COutputNormalHigh(void);
void setTimer1COutputNormalLow(void);
void setTimer1COutputToggle(void);
void setTimer1COutputDisable(void);
void setTimer1ClockExternFallingEdge(void);
void setTimer1ClockExternRisingEdge(void);
void setTimer1ClockTo0(void);
void setTimer1ClockTo1(void);
void setTimer1ClockTo8(void);
void setTimer1ClockTo64(void);
void setTimer1ClockTo256(void);
void setTimer1ClockTo1024(void);
void setTimer1ICR1(unsigned long int value);
void setTimer1AOCR(unsigned long int value);
void setTimer1BOCR(unsigned long int value);
void setTimer1COCR(unsigned long int value);
void setTimer1InterruptInputCaptureRisingEdge(void);
void setTimer1InterruptInputCaptureFallingEdge(void);
unsigned int getTimer1InterruptInputCapture(void);	//TODO: ׽Ʈ  غ
void setTimer1InterruptOverflow(void);
void setTimer1AInterruptCompare(void);
void setTimer1BInterruptCompare(void);
void setTimer1CInterruptCompare(void);
void _setTimer1AOutputClear(void);
void _setTimer1AOutputSet(void);
void _setTimer1BOutputClear(void);
void _setTimer1BOutputSet(void);
void _setTimer1COutputClear(void);
void _setTimer1COutputSet(void);

//Timer3 ÿ Ǵ Լ
void setTimer3ModeNormal(void);
void setTimer3ModePCPwm8Bits(void);
void setTimer3ModePCPwm9Bits(void);
void setTimer3ModePCPwm10Bits(void);
void setTimer3ModePCPwmwithICR3(void);
void setTimer3ModePCPwmwithOCR3A(void);
void setTimer3ModePFCPwmwithICR3(void);
void setTimer3ModePFCPwmwithOCR3A(void);
void setTimer3ModeCTC(void);
void setTimer3ModeCTCwithICR3(void);
void setTimer3ModeFastPwm8Bits(void);
void setTimer3ModeFastPwm9Bits(void);
void setTimer3ModeFastPwm10Bits(void);
void setTimer3ModeFastPwmwithICR3(void);
void setTimer3ModeFastPwmwithOCR3A(void);
void setTimer3AOutputNormalHigh(void);
void setTimer3AOutputNormalLow(void);
void setTimer3AOutputToggle(void);
void setTimer3AOutputDisable(void);
void setTimer3BOutputNormalHigh(void);
void setTimer3BOutputNormalLow(void);
void setTimer3BOutputToggle(void);
void setTimer3BOutputDisable(void);
void setTimer3COutputNormalHigh(void);
void setTimer3COutputNormalLow(void);
void setTimer3COutputToggle(void);
void setTimer3COutputDisable(void);
void setTimer3ClockExternFallingEdge(void);
void setTimer3ClockExternRisingEdge(void);
void setTimer3ClockTo0(void);
void setTimer3ClockTo1(void);
void setTimer3ClockTo8(void);
void setTimer3ClockTo64(void);
void setTimer3ClockTo256(void);
void setTimer3ClockTo1024(void);
void setTimer3ICR3(unsigned long int value);
void setTimer3AOCR(unsigned long int value);
void setTimer3BOCR(unsigned long int value);
void setTimer3COCR(unsigned long int value);
void setTimer3InterruptInputCaptureRisingEdge(void);
void setTimer3InterruptInputCaptureFallingEdge(void);
unsigned int getTimer3InterruptInputCapture(void);	//TODO: ׽Ʈ  غ
void setTimer3InterruptOverflow(void);
void setTimer3AInterruptCompare(void);
void setTimer3BInterruptCompare(void);
void setTimer3CInterruptCompare(void);
void _setTimer3AOutputClear(void);
void _setTimer3AOutputSet(void);
void _setTimer3BOutputClear(void);
void _setTimer3BOutputSet(void);
void _setTimer3COutputClear(void);
void _setTimer3COutputSet(void);

/////////////////////////////////////////////////////////////////////////////////////
//Ÿ̸ ʱȭ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////

void initTimer(void)
{
	initTimer0();
	initTimer1();
	initTimer2();
	initTimer3();
}

void initTimer0(void)
{
	//ܺũŻ ̿ؼ Ŭ   ִ.
	ASSR=0x00;
	TCCR0=0x00;
	TCNT0=0x00;
	OCR0=0x00;
}

void initTimer1(void)
{
	// Timer/Counter 1 initialization
	TCCR1A=0x00;
	TCCR1B=0x00;
	TCNT1H=0x00;
	TCNT1L=0x00;
	ICR1H=0x00;
	ICR1L=0x00;
	OCR1AH=0x00;
	OCR1AL=0x00;
	OCR1BH=0x00;
	OCR1BL=0x00;
	OCR1CH=0x00;
	OCR1CL=0x00;
}


void initTimer2(void)
{
	//ܺο ΰ Ŭ   ִ.
	TCCR2=0x00;
	TCNT2=0x00;
	OCR2=0x00;
}

void initTimer3(void)
{
	TCCR3A=0x00;
	TCCR3B=0x00;
	TCNT3H=0x00;
	TCNT3L=0x00;
	ICR3H=0x00;
	ICR3L=0x00;
	OCR3AH=0x00;
	OCR3AL=0x00;
	OCR3BH=0x00;
	OCR3BL=0x00;
	OCR3CH=0x00;
	OCR3CL=0x00;
}
/////////////////////////////////////////////////////////////////////////////////////
//Ÿ̸ ʱȭ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////
//Timer0 ÿ Ǵ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////
void setTimer0ClockUseInternal(void)
{
	//Ŭ ϰ Ѵ.()
	char tmp = TIMSK;

	//1. ͷƮ Ų.
	TIMSK &= (
			BM_1111_1101 &
			BM_1111_1110
			);	

	//2. 񵿱 
	ASSR &= BM_1111_0111;
	ASSR |= BM_0000_0000;	//Ŭ 

	//3. TCNT0 ۵Ϸ 
	while( ASSR & BM_0000_0100 == BM_0000_0000 );	//TCN0UB 0϶ 
	while( ASSR & BM_0000_0010 == BM_0000_0000 );	//OCR0UB 0϶ 
	while( ASSR & BM_0000_0001 == BM_0000_0000 );	//TCR0UB 0϶ 

	//4. ͷƮ û ʱȭ
	TIFR &= (
			BM_1111_1101 &	//OCF0 ʱȭ
			BM_1111_1110	//TOV0 ʱȭ
			);

	//5. ͷƮ  
	TIMSK = tmp;	//ͷƮ ¸ 󺹱Ѵ.
}

void setTimer0ClockUseExtern(void)
{
	//TOSC1 ɰ TOSC2 ɿ ũŻ ־ ܺ Ŭ ΰѴ.
	//  񵿱  ؾ Ѵ.
	//ܺ Ŭ ýŬ 1/4 ̸ ԷѴ.
	//
	//, 1ʸ Ȯ Ϸ,   Ѵ.
	//(ũŻ 32.768KHz Ѵ.)
	//setTimer0ClockUseExtern();
	//setTimer0ModeNormal();
	//setTimer0OutputToggle();
	//setTimer0ClockTo128();

	char tmp = TIMSK;

	//1. ͷƮ Ų.
	TIMSK &= (
			BM_1111_1101 &
			BM_1111_1110
			);	

	//2. 񵿱 
	ASSR &= BM_1111_0111;
	ASSR |= BM_0000_1000;	//ܺŬ 

	//3. TCNT0 ۵Ϸ 
	while( ASSR & BM_0000_0100 == BM_0000_0000 );	//TCN0UB 0϶ 
	while( ASSR & BM_0000_0010 == BM_0000_0000 );	//OCR0UB 0϶ 
	while( ASSR & BM_0000_0001 == BM_0000_0000 );	//TCR0UB 0϶ 

	//4. ͷƮ û ʱȭ
	TIFR &= (
			BM_1111_1101 &	//OCF0 ʱȭ
			BM_1111_1110	//TOV0 ʱȭ
			);

	//5. ͷƮ  
	TIMSK = tmp;	//ͷƮ ¸ 󺹱Ѵ.
}


void setTimer0OutputNormalHigh(void)
{
	//OC0 ⺻ High Ѵ.
	//OC0   PB4   ٲ۴.
	_setTimer0OutputSet();
}

void setTimer0OutputNormalLow(void)
{
	//OC0 ⺻ Low Ѵ.
	//OC0   PB4   ٲ۴.
	_setTimer0OutputClear();
}

void setTimer0InterruptOverflow(void)
{
	TIMSK &= BM_1111_1110;	//Bit 0, TOIE0
	TIMSK |= BM_0000_0001;
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer0InterruptCompare(void)
{
	TIMSK &= BM_1111_1101;	//Bit 1, OCIE0
	TIMSK |= BM_0000_0010;
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer0ClockTo0(void)
{
	//ŬԷ Ǹ鼭 Ÿ̸/ī  ȴ.
	TCCR0 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR0 |= (
			BM_0000_0000
			|BM_0000_0000
			|BM_0000_0000
			);
}

void setTimer0ClockTo1(void)
{
	TCCR0 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR0 |= (
			BM_0000_0001
			|BM_0000_0000
			|BM_0000_0000
			);
}

void setTimer0ClockTo8(void)
{
	TCCR0 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR0 |= (
			BM_0000_0000
			|BM_0000_0010
			|BM_0000_0000
			);
}

void setTimer0ClockTo32(void)
{
	TCCR0 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR0 |= (
			BM_0000_0001
			|BM_0000_0010
			|BM_0000_0000
			);
}

void setTimer0ClockTo64(void)
{
	TCCR0 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR0 |= (
			BM_0000_0000
			|BM_0000_0000
			|BM_0000_0100
			);
}

void setTimer0ClockTo128(void)
{
	TCCR0 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR0 |= (
			BM_0000_0001
			|BM_0000_0000
			|BM_0000_0100
			);
}

void setTimer0ClockTo256(void)
{
	//16MHz
	//16us/1clk
	//4.096ms/256clk
	TCCR0 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR0 |= (
			BM_0000_0000
			|BM_0000_0010
			|BM_0000_0100
			);
}

void setTimer0ClockTo1024(void)
{
	//16MHz
	//64us/1clk
	//16.384ms/256clk
	TCCR0 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR0 |= (
			BM_0000_0001
			|BM_0000_0010
			|BM_0000_0100
			);
}

void setTimer0ModeNormal(void)
{
	//TCNT0  0x00 0xFF  ī ȴ.
	TCCR0 &= (
			BM_1111_0111	//Bit 3, WGM01
			&BM_1011_1111	//Bit 6, WGM00
			);

	TCCR0 |= (
			BM_0000_0000
			|BM_0000_0000
			);
}

void setTimer0ModePCPwm(void)
{
	//TCNT0 0x00 0xFF Ͽٰ ٽ 0x00 Ѵ.
	// ֱⰡ FastPwm  2̴. (ū ֱⰡ 512 ī̶ ϸ ȴ.)
	//TCNT0 OCR0   ȴ.
	// ū ֱ      ̷.
	TCCR0 &= (
			BM_1111_0111	//Bit 3,
			&BM_1011_1111	//Bit 6
			);

	TCCR0 |= (
			BM_0000_0000
			|BM_0100_0000
			);
}

void setTimer0ModeCTC(void)
{
	//TCNT0 0x00 OCR0  ī ȴ.
	TCCR0 &= (
			BM_1111_0111	//Bit 3,
			&BM_1011_1111	//Bit 6
			);

	TCCR0 |= (
			BM_0000_1000
			|BM_0000_0000
			);
}

void setTimer0ModeFastPwm(void)
{
	//TCNT0  0x00 0xFF ī ȴ.
	//TCNT0 ÷εɶ OC0 · ư.(ū ֱ ϸ )
	//TCNT0 OCR0   .(ū ֱ ȿ  ֱ ϸ )
	TCCR0 &= (
			BM_1111_0111	//Bit 3,
			&BM_1011_1111	//Bit 6
			);

	TCCR0 |= (
			BM_0000_1000
			|BM_0100_0000
			);
}


void setTimer0OutputToggle(void)
{
	//÷ζ ǵ Ѵ.
	TCCR0 &= (
			BM_1101_1111	//Bit 5,
			&BM_1110_1111	//Bit 4
			);

	TCCR0 |= (
			BM_0000_0000
			|BM_0001_0000
			);

	DDRB |= BM_0001_0000;	//PortB 4, OC0
}

void _setTimer0OutputClear(void)
{
	TCCR0 &= (
			BM_1101_1111	//Bit 5,
			&BM_1110_1111	//Bit 4
			);

	TCCR0 |= (
			BM_0010_0000
			|BM_0000_0000
			);

	DDRB |= BM_0001_0000;	//PortB 4, OC0
}

void _setTimer0OutputSet(void)
{
	TCCR0 &= (
			BM_1101_1111	//Bit 5,
			&BM_1110_1111	//Bit 4
			);

	TCCR0 |= (
			BM_0010_0000
			|BM_0001_0000
			);

	DDRB |= BM_0001_0000;	//PortB 4, OC0
}

void setTimer0OutputDisable(void)
{
	TCCR0 &= (
			BM_1101_1111	//Bit 5,
			&BM_1110_1111	//Bit 4
			);

	TCCR0 |= (
			BM_0000_0000
			|BM_0000_0000
			);
}

void setTimer0OCR(char value)
{
	OCR0 = value;
}
/////////////////////////////////////////////////////////////////////////////////////
//Timer0 ÿ Ǵ Լ
//	-.
/////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////
//Timer2 ÿ Ǵ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////

void setTimer2OutputNormalHigh(void)
{
	//OC0 ⺻ High Ѵ.
	//OC0   PB4   ٲ۴.
	_setTimer2OutputSet();
}

void setTimer2OutputNormalLow(void)
{
	//OC0 ⺻ Low Ѵ.
	//OC0   PB4   ٲ۴.
	_setTimer2OutputClear();
}

void setTimer2InterruptOverflow(void)
{
	TIMSK &= BM_1011_1111;	//Bit 6, TOIE2
	TIMSK |= BM_0100_0000;
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer2InterruptCompare(void)
{
	TIMSK &= BM_0111_1111;	//Bit 7, OCIE2
	TIMSK |= BM_1000_0000;
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer2ClockTo0(void)
{
	//ŬԷ Ǹ鼭 Ÿ̸/ī  ȴ.
	TCCR2 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR2 |= (
			BM_0000_0000
			|BM_0000_0000
			|BM_0000_0000
			);
}

void setTimer2ClockTo1(void)
{
	TCCR2 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR2 |= (
			BM_0000_0001
			|BM_0000_0000
			|BM_0000_0000
			);
}

void setTimer2ClockTo8(void)
{
	TCCR2 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR2 |= (
			BM_0000_0000
			|BM_0000_0010
			|BM_0000_0000
			);
}

void setTimer2ClockTo64(void)
{
	TCCR2 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR2 |= (
			BM_0000_0001
			|BM_0000_0010
			|BM_0000_0000
			);
}

void setTimer2ClockTo256(void)
{
	//16MHz
	//16us/1clk
	//4.096ms/256clk
	TCCR2 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR2 |= (
			BM_0000_0000
			|BM_0000_0000
			|BM_0000_0100
			);
}

void setTimer2ClockTo1024(void)
{
	//16MHz
	//64us/1clk
	//16.384ms/256clk
	TCCR2 &= (
			BM_1111_1110	//Bit 0
			&BM_1111_1101	//Bit 1
			&BM_1111_1011	//Bit 2
			);

	TCCR2 |= (
			BM_0000_0001
			|BM_0000_0000
			|BM_0000_0100
			);
}

void setTimer2ModeNormal(void)
{
	//TCNT2  0x00 0xFF  ī ȴ.
	TCCR2 &= (
			BM_1111_0111	//Bit 3, WGM01
			&BM_1011_1111	//Bit 6, WGM00
			);

	TCCR2 |= (
			BM_0000_0000
			|BM_0000_0000
			);
}

void setTimer2ModePCPwm(void)
{
	//TCNT2 0x00 0xFF Ͽٰ ٽ 0x00 Ѵ.
	// ֱⰡ FastPwm  2̴. (ū ֱⰡ 512 ī̶ ϸ ȴ.)
	//TCNT2 OCR2   ȴ.
	// ū ֱ      ̷.
	TCCR2 &= (
			BM_1111_0111	//Bit 3,
			&BM_1011_1111	//Bit 6
			);

	TCCR2 |= (
			BM_0000_0000
			|BM_0100_0000
			);
}

void setTimer2ModeCTC(void)
{
	//TCNT2 0x00 OCR2  ī ȴ.
	TCCR2 &= (
			BM_1111_0111	//Bit 3,
			&BM_1011_1111	//Bit 6
			);

	TCCR2 |= (
			BM_0000_1000
			|BM_0000_0000
			);
}

void setTimer2ModeFastPwm(void)
{
	//TCNT2  0x00 0xFF ī ȴ.
	//TCNT2 ÷εɶ OC0 · ư.(ū ֱ ϸ )
	//TCNT2 OCR2   .(ū ֱ ȿ  ֱ ϸ )
	TCCR2 &= (
			BM_1111_0111	//Bit 3,
			&BM_1011_1111	//Bit 6
			);

	TCCR2 |= (
			BM_0000_1000
			|BM_0100_0000
			);
}


void setTimer2OutputToggle(void)
{
	//÷ζ ǵ Ѵ.
	TCCR2 &= (
			BM_1101_1111	//Bit 5,
			&BM_1110_1111	//Bit 4
			);

	TCCR2 |= (
			BM_0000_0000
			|BM_0001_0000
			);

	DDRB |= BM_1000_0000;	//PortB 7, OC2
}

void _setTimer2OutputClear(void)
{
	TCCR2 &= (
			BM_1101_1111	//Bit 5,
			&BM_1110_1111	//Bit 4
			);

	TCCR2 |= (
			BM_0010_0000
			|BM_0000_0000
			);

	DDRB |= BM_1000_0000;	//PortB 7, OC2
}

void _setTimer2OutputSet(void)
{
	TCCR2 &= (
			BM_1101_1111	//Bit 5,
			&BM_1110_1111	//Bit 4
			);

	TCCR2 |= (
			BM_0010_0000
			|BM_0001_0000
			);

	DDRB |= BM_1000_0000;	//PortB 7, OC2
}

void setTimer2OutputDisable(void)
{
	TCCR2 &= (
			BM_1101_1111	//Bit 5,
			&BM_1110_1111	//Bit 4
			);

	TCCR2 |= (
			BM_0000_0000
			|BM_0000_0000
			);
}

void setTimer2OCR(char value)
{
	OCR2 = value;
}

void setTimer2ClockExternFallingEdge(void)
{
	//T2 (PD7 ) ΰ Ŭ ϰ ϰ Ѵ.
	TCCR2 &= (
			BM_1111_1110 &	//Bit 0
			BM_1111_1101 &	//Bit 1
			BM_1111_1011	//Bit 2
			);

	TCCR2 |= (
			BM_0000_0000 |
			BM_0000_0010 |
			BM_0000_0100
			);

	DDRD &= BM_0111_1111;	//PD7 input 
}

void setTimer2ClockExternRisingEdge(void)
{
	//T2 (PD7 ) ΰ Ŭ ¿ ϰ Ѵ.
	TCCR2 &= (
			BM_1111_1110 &	//Bit 0
			BM_1111_1101 &	//Bit 1
			BM_1111_1011	//Bit 2
			);

	TCCR2 |= (
			BM_0000_0001 |
			BM_0000_0010 |
			BM_0000_0100
			);

	DDRD &= BM_0111_1111;	//PD7 input 
}
/////////////////////////////////////////////////////////////////////////////////////
//Timer2 ÿ Ǵ Լ
//	-.
/////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////
//Timer1 ÿ Ǵ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////

void setTimer1AOutputNormalHigh(void)
{
	_setTimer1AOutputSet();
}

void setTimer1AOutputNormalLow(void)
{
	_setTimer1AOutputClear();
}

void setTimer1BOutputNormalHigh(void)
{
	_setTimer1BOutputSet();
}

void setTimer1BOutputNormalLow(void)
{
	_setTimer1BOutputClear();
}

void setTimer1COutputNormalHigh(void)
{
	_setTimer1COutputSet();
}

void setTimer1COutputNormalLow(void)
{
	_setTimer1COutputClear();
}

void setTimer1ClockTo0(void)
{
	//ŬԷ Ǹ鼭 Ÿ̸/ī  ȴ.
	TCCR1B &= (
			BM_1111_1110 &	//CS10
			BM_1111_1101 &	//CS11
			BM_1111_1011	//CS12
			);

	TCCR1B |= (
			BM_0000_0000 |
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer1ClockTo1(void)
{
	TCCR1B &= (
			BM_1111_1110 &	//CS10
			BM_1111_1101 &	//CS11
			BM_1111_1011	//CS12
			);

	TCCR1B |= (
			BM_0000_0001 |
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer1ClockTo8(void)
{
	TCCR1B &= (
			BM_1111_1110 &	//CS10
			BM_1111_1101 &	//CS11
			BM_1111_1011	//CS12
			);

	TCCR1B |= (
			BM_0000_0000 |
			BM_0000_0010 |
			BM_0000_0000
			);
}

void setTimer1ClockTo64(void)
{
	TCCR1B &= (
			BM_1111_1110 &	//CS10
			BM_1111_1101 &	//CS11
			BM_1111_1011	//CS12
			);

	TCCR1B |= (
			BM_0000_0001 |
			BM_0000_0010 |
			BM_0000_0000
			);
}

void setTimer1ClockTo256(void)
{
	TCCR1B &= (
			BM_1111_1110 &	//CS10
			BM_1111_1101 &	//CS11
			BM_1111_1011	//CS12
			);

	TCCR1B |= (
			BM_0000_0000 |
			BM_0000_0000 |
			BM_0000_0100
			);
}

void setTimer1ClockTo1024(void)
{
	TCCR1B &= (
			BM_1111_1110 &	//CS10
			BM_1111_1101 &	//CS11
			BM_1111_1011	//CS12
			);

	TCCR1B |= (
			BM_0000_0001 |
			BM_0000_0000 |
			BM_0000_0100
			);
}

void setTimer1ModeNormal(void)
{
	//TCNT1  0x0000 0xFFFF  ī ȴ.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer1ModePCPwm8Bits(void)
{
	//TCNT1 0x0000 0x00FF Ͽٰ ٽ 0x0000 Ѵ.
	//(0x00FF TOP̱  8Bits PCPwm ̶ Ѵ.)
	//TCNT1 OCR1x   ȴ.
	// ū ֱ      ̷.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0001 |
			BM_0000_0000
			);
	TCCR1B |= (
			BM_0000_0000 |
			BM_0000_0000
			);

}

void setTimer1ModePCPwm9Bits(void)
{
	//TCNT1 0x0000 0x01FF Ͽٰ ٽ 0x0000 Ѵ.
	//(0x01FF TOP̱  9Bits PCPwm ̶ Ѵ.)
	//TCNT1 OCR1x   ȴ. 
	// ū ֱ      ̷.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0010
			);
	TCCR1B |= (
			BM_0000_0000 |
			BM_0000_0000
			);

}

void setTimer1ModePCPwm10Bits(void)
{
	//TCNT1 0x0000 0x03FF Ͽٰ ٽ 0x0000 Ѵ.
	//(0x03FF TOP̱  10bits PCPwm ̶ Ѵ.)
	//TCNT1 OCR1x   ȴ.
	// ū ֱ      ̷.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0001 |
			BM_0000_0010
			);
	TCCR1B |= (
			BM_0000_0000 |
			BM_0000_0000
			);

}

void setTimer1ModeCTC(void)
{
	//TCNT1 0x0000 OCR1A  ī ȴ.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
	TCCR1B |= (
			BM_0000_1000 |
			BM_0000_0000
			);
}

void setTimer1ModeFastPwm8Bits(void)
{
	//TCNT1  0x0000 0x00FF ī ȴ.
	//(0x00FF TOP̱  8bits FastPwm ̶ Ѵ.)
	//TCNT1 ÷εɶ OC1x · ư.(ū ֱ ϸ )
	//TCNT1 OCR1x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0001 |
			BM_0000_0000
			);
	TCCR1B |= (
			BM_0000_1000 |
			BM_0000_0000
			);
}

void setTimer1ModeFastPwm9Bits(void)
{
	//TCNT1  0x0000 0x01FF ī ȴ.
	//(0x01FF TOP̱  9bits FastPwm ̶ Ѵ.)
	//TCNT1 ÷εɶ OC1x · ư.(ū ֱ ϸ )
	//TCNT1 OCR1x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0010
			);
	TCCR1B |= (
			BM_0000_1000 |
			BM_0000_0000
			);
}

void setTimer1ModeFastPwm10Bits(void)
{
	//TCNT1  0x0000 0x03FF ī ȴ.
	//(0x03FF TOP̱  10bits FastPwm ̶ Ѵ.)
	//TCNT1 ÷εɶ OC1x · ư.(ū ֱ ϸ )
	//TCNT1 OCR1x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0001 |
			BM_0000_0010
			);
	TCCR1B |= (
			BM_0000_1000 |
			BM_0000_0000
			);
}

void setTimer1ModePFCPwmwithICR1(void)
{
	//TCNT1 0x0000 ICR1 Ͽٰ ٽ 0x0000 Ѵ.
	//TCNT1 OCR1x   ȴ. 
	//PCPwm  ٸ TCNT1 0  ICRn Ѵ.  0϶     Ϻ Ī̴.
	//PCPwm  ū ֱ      ̷.
	//PCPwm  FastPwm  ϸ ֱⰡ 2̴.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
	TCCR1B |= (
			BM_0000_0000 |
			BM_0001_0000
			);
}

void setTimer1ModePFCPwmwithOCR1A(void)
{
	//TCNT1 0x0000 OCR1A Ͽٰ ٽ 0x0000 Ѵ.
	//TCNT1 OCR1x   ȴ. (  OCR1A  Ÿ̸ӷ   .)
	//PCPwm  ٸ TCNT1 0  OCR1A Ѵ.  0϶     Ϻ Ī̴.
	//PCPwm  ū ֱ      ̷.
	//PCPwm  FastPwm  ϸ ֱⰡ 2̴.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0001 |
			BM_0000_0000
			);
	TCCR1B |= (
			BM_0000_0000 |
			BM_0001_0000
			);
}

void setTimer1ModePCPwmwithICR1(void)
{
	//TCNT1 0x0000 ICR1 Ͽٰ ٽ 0x0000 Ѵ.
	//TCNT1 OCR1x   ȴ.
	// ū ֱ      ̷.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0010
			);
	TCCR1B |= (
			BM_0000_0000 |
			BM_0001_0000
			);
}

void setTimer1ModePCPwmwithOCR1A(void)
{
	//TCNT1 0x0000 OCR1A Ͽٰ ٽ 0x0000 Ѵ.
	//TCNT1 OCR1x   ȴ. (翬 OCR1A   .)
	// ū ֱ      ̷.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0001 |
			BM_0000_0010
			);
	TCCR1B |= (
			BM_0000_0000 |
			BM_0001_0000
			);
}

void setTimer1ModeCTCwithICR1(void)
{
	//TCNT1 0x0000 ICR1  ī ȴ.
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
	TCCR1B |= (
			BM_0000_1000 |
			BM_0001_0000
			);
}

void setTimer1ModeFastPwmwithICR1(void)
{
	//TCNT1  0x0000 ICR1 ī ȴ.
	//TCNT1 ÷εɶ OC1x · ư.(ū ֱ ϸ )
	//TCNT1 OCR1x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0010
			);
	TCCR1B |= (
			BM_0000_1000 |
			BM_0001_0000
			);
}

void setTimer1ModeFastPwmwithOCR1A(void)
{
	//TCNT1  0x0000 OCR1A ī ȴ. (翬 OCR1A   .)
	//TCNT1 ÷εɶ OC1x · ư.(ū ֱ ϸ )
	//TCNT1 OCR1x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR1A &= (
			BM_1111_1110 &	//WGM10
			BM_1111_1101	//WGM11
			);
	TCCR1B &= (
			BM_1111_0111 &	//WGM12
			BM_1110_1111	//WGM13
			);

	TCCR1A |= (
			BM_0000_0001 |
			BM_0000_0010
			);
	TCCR1B |= (
			BM_0000_1000 |
			BM_0001_0000
			);
}

void setTimer1AOutputToggle(void)
{
	//÷ζ ǵ Ѵ.
	//Pwm 
	//OCRnA TOP ϸ OC1A  ۵ϰ,
	// ܿ OC1A  Ѵ.
	TCCR1A &= (
			BM_1011_1111 &	//COM1A0
			BM_0111_1111	//COM1A1
			);

	TCCR1A |= (
			BM_0100_0000 |
			BM_0000_0000
			);

	DDRB |= BM_0010_0000;	//PortB 5, OC1A
}

void setTimer1BOutputToggle(void)
{
	//÷ζ ǵ Ѵ.
	//Pwm 
	//OCRnB TOP ϸ OC1B  ۵ϰ,
	// ܿ OC1B  Ѵ.
	TCCR1A &= (
			BM_1110_1111 &	//COM1B0
			BM_1101_1111	//COM1B1
			);

	TCCR1A |= (
			BM_0001_0000 |
			BM_0000_0000
			);

	DDRB |= BM_0100_0000;	//PortB 6, OC1B
}

void setTimer1COutputToggle(void)
{
	//÷ζ ǵ Ѵ.
	//Pwm 
	//OCRnC TOP ϸ OC1C  ۵ϰ,
	// ܿ OC1C  Ѵ.
	TCCR1A &= (
			BM_1111_1011 &	//COM1C0
			BM_1111_0111	//COM1C1
			);

	TCCR1A |= (
			BM_0000_0100 |
			BM_0000_0000
			);

	DDRB |= BM_1000_0000;	//PortB 7, OC1C
}


void _setTimer1AOutputClear(void)
{
	TCCR1A &= (
			BM_1011_1111 &	//COM1A0
			BM_0111_1111	//COM1A1
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_1000_0000
			);

	DDRB |= BM_0010_0000;	//PortB 5, OC1A

}

void _setTimer1AOutputSet(void)
{
	TCCR1A &= (
			BM_1011_1111 &	//COM1A0
			BM_0111_1111	//COM1A1
			);

	TCCR1A |= (
			BM_0100_0000 |
			BM_1000_0000
			);

	DDRB |= BM_0010_0000;	//PortB 5, OC1A
}

void _setTimer1BOutputClear(void)
{
	TCCR1A &= (
			BM_1110_1111 &	//COM1B0
			BM_1101_1111	//COM1B1
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0010_0000
			);

	DDRB |= BM_0100_0000;	//PortB 6, OC1B

}

void _setTimer1BOutputSet(void)
{
	TCCR1A &= (
			BM_1110_1111 &	//COM1A0
			BM_1101_1111	//COM1A1
			);

	TCCR1A |= (
			BM_0001_0000 |
			BM_0010_0000
			);

	DDRB |= BM_0100_0000;	//PortB 6, OC1B
}

void _setTimer1COutputClear(void)
{
	TCCR1A &= (
			BM_1111_1011 &	//COM1C0
			BM_1111_0111	//COM1C1
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_1000
			);

	DDRB |= BM_1000_0000;	//PortB 7, OC1C

}

void _setTimer1COutputSet(void)
{
	TCCR1A &= (
			BM_1111_1011 &	//COM1A0
			BM_1111_0111	//COM1A1
			);

	TCCR1A |= (
			BM_0000_0100 |
			BM_0000_1000
			);

	DDRB |= BM_1000_0000;	//PortB 7, OC1C
}


void setTimer1AOutputDisable(void)
{
	TCCR1A &= (
			BM_1011_1111 &	//COM1A0
			BM_0111_1111	//COM1A1
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer1BOutputDisable(void)
{
	TCCR1A &= (
			BM_1110_1111 &	//COM1B0
			BM_1101_1111	//COM1B1
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer1COutputDisable(void)
{
	TCCR1A &= (
			BM_1111_1011 &	//COM1C0
			BM_1111_0111	//COM1C1
			);

	TCCR1A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer1AOCR(unsigned long int value)
{
	OCR1AH = value >> 8;
	OCR1AL = value & 0x00FF;
}

void setTimer1BOCR(unsigned long int value)
{
	OCR1BH = value >> 8;
	OCR1BL = value & 0x00FF;
}

void setTimer1COCR(unsigned long int value)
{
	OCR1CH = value >> 8;
	OCR1CL = value & 0x00FF;
}

void setTimer1ICR1(unsigned long int value)
{
	ICR1H = value >> 8;
	ICR1L = value & 0x00FF;
}

void setTimer1InterruptInputCaptureRisingEdge(void)
{
	//Timer1 Էĸ ͷƮ Ѵ.
	TIMSK &= BM_1101_1111;	//TICE1
	TIMSK |= BM_0010_0000;

	TCCR1B &= (
			BM_0111_1111 &	//ICNC1, Է³ȸ
			BM_1011_1111	//ICES1, Է ĸ  
			);

	TCCR1B |= (
			BM_1000_0000 |	//Է  
			BM_0100_0000	//¿ ĸ 
			);
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer1InterruptInputCaptureFallingEdge(void)
{
	//Timer1 Էĸ ͷƮ Ѵ.
	TIMSK &= BM_1101_1111;	//TICE1
	TIMSK |= BM_0010_0000;

	TCCR1B &= (
			BM_0111_1111 &	//ICNC1, Է³ȸ
			BM_1011_1111	//ICES1, Է ĸ  
			);

	TCCR1B |= (
			BM_1000_0000 |	//Է  
			BM_0000_0000	//ϰ ĸ 
			);
#ifdef _CODEVISION
#asm("sei")
#endif
}

unsigned int getTimer1InterruptInputCapture(void)
{
	return ( (ICR1L & 0x00FF) & (ICR1H * 256) );
}

void setTimer1InterruptOverflow(void)
{
	TIMSK &= BM_1111_1011;	//TOIE1
	TIMSK |= BM_0000_0100;	//TOIE1
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer1AInterruptCompare(void)
{
	TIMSK &= BM_1110_1111;	//OCIE1A
	TIMSK |= BM_0001_0000;	//OCIE1A
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer1BInterruptCompare(void)
{
	TIMSK &= BM_1111_0111;	//OCIE1B
	TIMSK |= BM_0000_1000;	//OCIE1B
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer1CInterruptCompare(void)
{
	ETIMSK &= BM_1111_1110;	//OCIE1C
	ETIMSK |= BM_0000_0001;	//OCIE1C
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer1ClockExternFallingEdge(void)
{
	//T1 (PD6 ) ΰ Ŭ ϰ ϰ Ѵ.
	//ý Ŭ 1/2.5  ļ ϴ  ȴ.
	TCCR1B &= (
			BM_1111_1110 &	//Bit 0
			BM_1111_1101 &	//Bit 1
			BM_1111_1011	//Bit 2
			);

	TCCR1B |= (
			BM_0000_0000 |
			BM_0000_0010 |
			BM_0000_0100
			);

	DDRD &= BM_1011_1111;	//PD6 input 
}

void setTimer1ClockExternRisingEdge(void)
{
	//T1 (PD6 ) ΰ Ŭ ¿ ϰ Ѵ.
	//ý Ŭ 1/2.5  ļ ϴ  ȴ.
	TCCR1B &= (
			BM_1111_1110 &	//Bit 0
			BM_1111_1101 &	//Bit 1
			BM_1111_1011	//Bit 2
			);

	TCCR1B |= (
			BM_0000_0001 |
			BM_0000_0010 |
			BM_0000_0100
			);

	DDRD &= BM_1011_1111;	//PD6 input 
}
/////////////////////////////////////////////////////////////////////////////////////
//Timer1 ÿ Ǵ Լ
//	-.
/////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////
//Timer3 ÿ Ǵ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////

void setTimer3AOutputNormalHigh(void)
{
	_setTimer3AOutputSet();
}

void setTimer3AOutputNormalLow(void)
{
	_setTimer3AOutputClear();
}

void setTimer3BOutputNormalHigh(void)
{
	_setTimer3BOutputSet();
}

void setTimer3BOutputNormalLow(void)
{
	_setTimer3BOutputClear();
}

void setTimer3COutputNormalHigh(void)
{
	_setTimer3COutputSet();
}

void setTimer3COutputNormalLow(void)
{
	_setTimer3COutputClear();
}

void setTimer3ClockTo0(void)
{
	//ŬԷ Ǹ鼭 Ÿ̸/ī  ȴ.
	TCCR3B &= (
			BM_1111_1110 &	//CS30
			BM_1111_1101 &	//CS31
			BM_1111_1011	//CS32
			);

	TCCR3B |= (
			BM_0000_0000 |
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer3ClockTo1(void)
{
	TCCR3B &= (
			BM_1111_1110 &	//CS30
			BM_1111_1101 &	//CS31
			BM_1111_1011	//CS32
			);

	TCCR3B |= (
			BM_0000_0001 |
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer3ClockTo8(void)
{
	TCCR3B &= (
			BM_1111_1110 &	//CS30
			BM_1111_1101 &	//CS31
			BM_1111_1011	//CS32
			);

	TCCR3B |= (
			BM_0000_0000 |
			BM_0000_0010 |
			BM_0000_0000
			);
}

void setTimer3ClockTo64(void)
{
	TCCR3B &= (
			BM_1111_1110 &	//CS30
			BM_1111_1101 &	//CS31
			BM_1111_1011	//CS32
			);

	TCCR3B |= (
			BM_0000_0001 |
			BM_0000_0010 |
			BM_0000_0000
			);
}

void setTimer3ClockTo256(void)
{
	TCCR3B &= (
			BM_1111_1110 &	//CS30
			BM_1111_1101 &	//CS31
			BM_1111_1011	//CS32
			);

	TCCR3B |= (
			BM_0000_0000 |
			BM_0000_0000 |
			BM_0000_0100
			);
}

void setTimer3ClockTo1024(void)
{
	TCCR3B &= (
			BM_1111_1110 &	//CS30
			BM_1111_1101 &	//CS31
			BM_1111_1011	//CS32
			);

	TCCR3B |= (
			BM_0000_0001 |
			BM_0000_0000 |
			BM_0000_0100
			);
}

void setTimer3ModeNormal(void)
{
	//TCNT3  0x0000 0xFFFF  ī ȴ.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer3ModePCPwm8Bits(void)
{
	//TCNT3 0x0000 0x00FF Ͽٰ ٽ 0x0000 Ѵ.
	//(0x00FF TOP̱  8Bits PCPwm ̶ Ѵ.)
	//TCNT3 OCR3x   ȴ.
	// ū ֱ      ̷.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0001 |
			BM_0000_0000
			);
	TCCR3B |= (
			BM_0000_0000 |
			BM_0000_0000
			);

}

void setTimer3ModePCPwm9Bits(void)
{
	//TCNT3 0x0000 0x01FF Ͽٰ ٽ 0x0000 Ѵ.
	//(0x01FF TOP̱  9Bits PCPwm ̶ Ѵ.)
	//TCNT3 OCR3x   ȴ. 
	// ū ֱ      ̷.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0010
			);
	TCCR3B |= (
			BM_0000_0000 |
			BM_0000_0000
			);

}

void setTimer3ModePCPwm10Bits(void)
{
	//TCNT3 0x0000 0x03FF Ͽٰ ٽ 0x0000 Ѵ.
	//(0x03FF TOP̱  10bits PCPwm ̶ Ѵ.)
	//TCNT3 OCR3x   ȴ.
	// ū ֱ      ̷.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0001 |
			BM_0000_0010
			);
	TCCR3B |= (
			BM_0000_0000 |
			BM_0000_0000
			);

}

void setTimer3ModeCTC(void)
{
	//TCNT3 0x0000 OCR3A  ī ȴ.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
	TCCR3B |= (
			BM_0000_1000 |
			BM_0000_0000
			);
}

void setTimer3ModeFastPwm8Bits(void)
{
	//TCNT3  0x0000 0x00FF ī ȴ.
	//(0x00FF TOP̱  8bits FastPwm ̶ Ѵ.)
	//TCNT3 ÷εɶ OC3x · ư.(ū ֱ ϸ )
	//TCNT3 OCR3x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0001 |
			BM_0000_0000
			);
	TCCR3B |= (
			BM_0000_1000 |
			BM_0000_0000
			);
}

void setTimer3ModeFastPwm9Bits(void)
{
	//TCNT3  0x0000 0x01FF ī ȴ.
	//(0x01FF TOP̱  9bits FastPwm ̶ Ѵ.)
	//TCNT3 ÷εɶ OC3x · ư.(ū ֱ ϸ )
	//TCNT3 OCR3x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0010
			);
	TCCR3B |= (
			BM_0000_1000 |
			BM_0000_0000
			);
}

void setTimer3ModeFastPwm10Bits(void)
{
	//TCNT3  0x0000 0x03FF ī ȴ.
	//(0x03FF TOP̱  10bits FastPwm ̶ Ѵ.)
	//TCNT3 ÷εɶ OC3x · ư.(ū ֱ ϸ )
	//TCNT3 OCR3x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0001 |
			BM_0000_0010
			);
	TCCR3B |= (
			BM_0000_1000 |
			BM_0000_0000
			);
}

void setTimer3ModePFCPwmwithICR3(void)
{
	//TCNT3 0x0000 ICR3 Ͽٰ ٽ 0x0000 Ѵ.
	//TCNT3 OCR3x   ȴ. 
	//PCPwm  ٸ TCNT3 0  ICRn Ѵ.  0϶     Ϻ Ī̴.
	//PCPwm  ū ֱ      ̷.
	//PCPwm  FastPwm  ϸ ֱⰡ 2̴.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
	TCCR3B |= (
			BM_0000_0000 |
			BM_0001_0000
			);
}

void setTimer3ModePFCPwmwithOCR3A(void)
{
	//TCNT3 0x0000 OCR3A Ͽٰ ٽ 0x0000 Ѵ.
	//TCNT3 OCR3x   ȴ. (  OCR3A  Ÿ̸ӷ   .)
	//PCPwm  ٸ TCNT3 0  OCR3A Ѵ.  0϶     Ϻ Ī̴.
	//PCPwm  ū ֱ      ̷.
	//PCPwm  FastPwm  ϸ ֱⰡ 2̴.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0001 |
			BM_0000_0000
			);
	TCCR3B |= (
			BM_0000_0000 |
			BM_0001_0000
			);
}

void setTimer3ModePCPwmwithICR3(void)
{
	//TCNT3 0x0000 ICR3 Ͽٰ ٽ 0x0000 Ѵ.
	//TCNT3 OCR3x   ȴ.
	// ū ֱ      ̷.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0010
			);
	TCCR3B |= (
			BM_0000_0000 |
			BM_0001_0000
			);
}

void setTimer3ModePCPwmwithOCR3A(void)
{
	//TCNT3 0x0000 OCR3A Ͽٰ ٽ 0x0000 Ѵ.
	//TCNT3 OCR3x   ȴ. (翬 OCR3A   .)
	// ū ֱ      ̷.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0001 |
			BM_0000_0010
			);
	TCCR3B |= (
			BM_0000_0000 |
			BM_0001_0000
			);
}

void setTimer3ModeCTCwithICR3(void)
{
	//TCNT3 0x0000 ICR3  ī ȴ.
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
	TCCR3B |= (
			BM_0000_1000 |
			BM_0001_0000
			);
}

void setTimer3ModeFastPwmwithICR3(void)
{
	//TCNT3  0x0000 ICR3 ī ȴ.
	//TCNT3 ÷εɶ OC3x · ư.(ū ֱ ϸ )
	//TCNT3 OCR3x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0010
			);
	TCCR3B |= (
			BM_0000_1000 |
			BM_0001_0000
			);
}

void setTimer3ModeFastPwmwithOCR3A(void)
{
	//TCNT3  0x0000 OCR3A ī ȴ. (翬 OCR3A   .)
	//TCNT3 ÷εɶ OC3x · ư.(ū ֱ ϸ )
	//TCNT3 OCR3x   .(ū ֱ ȿ  ֱ ϸ )
	TCCR3A &= (
			BM_1111_1110 &	//WGM30
			BM_1111_1101	//WGM31
			);
	TCCR3B &= (
			BM_1111_0111 &	//WGM32
			BM_1110_1111	//WGM33
			);

	TCCR3A |= (
			BM_0000_0001 |
			BM_0000_0010
			);
	TCCR3B |= (
			BM_0000_1000 |
			BM_0001_0000
			);
}

void setTimer3AOutputToggle(void)
{
	//÷ζ ǵ Ѵ.
	//Pwm 
	//OCRnA TOP ϸ OC3A  ۵ϰ,
	// ܿ OC3A  Ѵ.
	TCCR3A &= (
			BM_1011_1111 &	//COM3A0
			BM_0111_1111	//COM3A1
			);

	TCCR3A |= (
			BM_0100_0000 |
			BM_0000_0000
			);

	DDRE |= BM_0000_1000;	//PortE 3, OC3A
}

void setTimer3BOutputToggle(void)
{
	//÷ζ ǵ Ѵ.
	//Pwm 
	//OCRnB TOP ϸ OC3B  ۵ϰ,
	// ܿ OC3B  Ѵ.
	TCCR3A &= (
			BM_1110_1111 &	//COM3B0
			BM_1101_1111	//COM3B1
			);

	TCCR3A |= (
			BM_0001_0000 |
			BM_0000_0000
			);

	DDRE |= BM_0001_0000;	//PortE 4, OC3B
}

void setTimer3COutputToggle(void)
{
	//÷ζ ǵ Ѵ.
	//Pwm 
	//OCRnC TOP ϸ OC3C  ۵ϰ,
	// ܿ OC3C  Ѵ.
	TCCR3A &= (
			BM_1111_1011 &	//COM3C0
			BM_1111_0111	//COM3C1
			);

	TCCR3A |= (
			BM_0000_0100 |
			BM_0000_0000
			);

	DDRE |= BM_0010_0000;	//PortE 5, OC3C
}


void _setTimer3AOutputClear(void)
{
	TCCR3A &= (
			BM_1011_1111 &	//COM3A0
			BM_0111_1111	//COM3A1
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_1000_0000
			);

	DDRE |= BM_0000_1000;	//PortE 3, OC3A

}

void _setTimer3AOutputSet(void)
{
	TCCR3A &= (
			BM_1011_1111 &	//COM3A0
			BM_0111_1111	//COM3A1
			);

	TCCR3A |= (
			BM_0100_0000 |
			BM_1000_0000
			);

	DDRE |= BM_0000_1000;	//PortE 3, OC3A
}

void _setTimer3BOutputClear(void)
{
	TCCR3A &= (
			BM_1110_1111 &	//COM3B0
			BM_1101_1111	//COM3B1
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0010_0000
			);

	DDRE |= BM_0001_0000;	//PortE 4, OC3B

}

void _setTimer3BOutputSet(void)
{
	TCCR3A &= (
			BM_1110_1111 &	//COM3A0
			BM_1101_1111	//COM3A1
			);

	TCCR3A |= (
			BM_0001_0000 |
			BM_0010_0000
			);

	DDRE |= BM_0001_0000;	//PortE 4, OC3B
}

void _setTimer3COutputClear(void)
{
	TCCR3A &= (
			BM_1111_1011 &	//COM3C0
			BM_1111_0111	//COM3C1
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_1000
			);

	DDRE |= BM_0010_0000;	//PortE 5, OC3C

}

void _setTimer3COutputSet(void)
{
	TCCR3A &= (
			BM_1111_1011 &	//COM3A0
			BM_1111_0111	//COM3A1
			);

	TCCR3A |= (
			BM_0000_0100 |
			BM_0000_1000
			);

	DDRE |= BM_0010_0000;	//PortE 5, OC3C
}


void setTimer3AOutputDisable(void)
{
	TCCR3A &= (
			BM_1011_1111 &	//COM3A0
			BM_0111_1111	//COM3A1
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer3BOutputDisable(void)
{
	TCCR3A &= (
			BM_1110_1111 &	//COM3B0
			BM_1101_1111	//COM3B1
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer3COutputDisable(void)
{
	TCCR3A &= (
			BM_1111_1011 &	//COM3C0
			BM_1111_0111	//COM3C1
			);

	TCCR3A |= (
			BM_0000_0000 |
			BM_0000_0000
			);
}

void setTimer3AOCR(unsigned long int value)
{
	OCR3AH = value >> 8;
	OCR3AL = value & 0x00FF;
}

void setTimer3BOCR(unsigned long int value)
{
	OCR3BH = value >> 8;
	OCR3BL = value & 0x00FF;
}

void setTimer3COCR(unsigned long int value)
{
	OCR3CH = value >> 8;
	OCR3CL = value & 0x00FF;
}

void setTimer3ICR3(unsigned long int value)
{
	ICR3H = value >> 8;
	ICR3L = value & 0x00FF;
}

void setTimer3InterruptInputCaptureRisingEdge(void)
{
	//Timer3 Էĸ ͷƮ Ѵ.
	ETIMSK &= BM_1101_1111;	//TICE3
	ETIMSK |= BM_0010_0000;

	TCCR3B &= (
			BM_0111_1111 &	//ICNC3, Է³ȸ
			BM_1011_1111	//ICES3, Է ĸ  
			);

	TCCR3B |= (
			BM_1000_0000 |	//Է  
			BM_0100_0000	//¿ ĸ 
			);
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer3InterruptInputCaptureFallingEdge(void)
{
	//Timer3 Էĸ ͷƮ Ѵ.
	ETIMSK &= BM_1101_1111;	//TICE3
	ETIMSK |= BM_0010_0000;

	TCCR3B &= (
			BM_0111_1111 &	//ICNC3, Է³ȸ
			BM_1011_1111	//ICES3, Է ĸ  
			);

	TCCR3B |= (
			BM_1000_0000 |	//Է  
			BM_0000_0000	//ϰ ĸ 
			);
#ifdef _CODEVISION
#asm("sei")
#endif
}

unsigned int getTimer3InterruptInputCapture(void)
{
	return ( (ICR3L & 0x00FF) & (ICR3H * 256) );
}

void setTimer3InterruptOverflow(void)
{
	ETIMSK &= BM_1111_1011;	//TOIE3
	ETIMSK |= BM_0000_0100;	//TOIE3
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer3AInterruptCompare(void)
{
	ETIMSK &= BM_1110_1111;	//OCIE3A
	ETIMSK |= BM_0001_0000;	//OCIE3A
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer3BInterruptCompare(void)
{
	ETIMSK &= BM_1111_0111;	//OCIE3B
	ETIMSK |= BM_0000_1000;	//OCIE3B
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer3CInterruptCompare(void)
{
	ETIMSK &= BM_1111_1101;	//OCIE3C
	ETIMSK |= BM_0000_0010;	//OCIE3C
#ifdef _CODEVISION
#asm("sei")
#endif
}

void setTimer3ClockExternFallingEdge(void)
{
	//T1 (PE6 ) ΰ Ŭ ϰ ϰ Ѵ.
	//ý Ŭ 1/2.5  ļ ϴ  ȴ.
	TCCR3B &= (
			BM_1111_1110 &	//Bit 0
			BM_1111_1101 &	//Bit 1
			BM_1111_1011	//Bit 2
			);

	TCCR3B |= (
			BM_0000_0000 |
			BM_0000_0010 |
			BM_0000_0100
			);

	DDRE &= BM_1011_1111;	//PE6 input 
}

void setTimer3ClockExternRisingEdge(void)
{
	//T1 (PE6 ) ΰ Ŭ ¿ ϰ Ѵ.
	//ý Ŭ 1/2.5  ļ ϴ  ȴ.
	TCCR3B &= (
			BM_1111_1110 &	//Bit 0
			BM_1111_1101 &	//Bit 1
			BM_1111_1011	//Bit 2
			);

	TCCR3B |= (
			BM_0000_0001 |
			BM_0000_0010 |
			BM_0000_0100
			);

	DDRE &= BM_1011_1111;	//PE6 input 
}
/////////////////////////////////////////////////////////////////////////////////////
//Timer3 ÿ Ǵ Լ
//	-.
/////////////////////////////////////////////////////////////////////////////////////

