#ifndef __FLAG_SETUSART
#define __FLAG_SETUSART
#endif //__FLAG_SETUSART

void setSerial0RxEnable(void);
void setSerial0TxEnable(void);
void setSerial1RxEnable(void);
void setSerial1TxEnable(void);
void setSerial0Baudrate_16MHz(int );
void setSerial1Baudrate_16MHz(int );
void setSerial0RxDisable(void);
void setSerial0TxDisable(void);
void setSerial1RxDisable(void);
void setSerial1TxDisable(void);
void setSerial0RxInterruptEnable(void);
void setSerial1RxInterruptEnable(void);
char getSerial0RxData(void);
char getSerial1RxData(void);
void setSerial0RxInterruptDisable(void);
void setSerial1RxInterruptDisable(void);
void putSerial0(char );
void putSerial1(char );
char checkSerial0RXComplete(void);
char checkSerial1RXComplete(void);


void putSerial0(char data)
{
	//   ٸ.
	// Ʈũ : UDRE(UCSRA 5° Ʈ), USART Transmmit Complete Flag,    Ŭ ȴ.(0 ȴ.)
	while ( (UCSR0A & BM_0010_0000) == 0 );	
	// Ϳ ø Tx Shift Register ö󰡰,  ۵ȴ.
	UDR0 = data;
}

void putSerial1(char data)
{
	//   ٸ.
	// Ʈũ : UDRE(UCSRA 5° Ʈ), USART Transmmit Complete Flag,    Ŭ ȴ.(0 ȴ.)
	while ( (UCSR1A & BM_0010_0000) == 0 );	
	// Ϳ ø Tx Shift Register ö󰡰,  ۵ȴ.
	UDR1 = data;
}

void setSerial0RxInterruptEnable(void)
{
	//ͷƮ ɸ , ŵ 1Ʈ ڰ UDR0 ִ ̴.
	setSerial0RxEnable();
	UCSR0B |= BM_1000_0000;
}

char getSerial0RxData(void)
{
	return UDR0;
}

void setSerial1RxInterruptEnable(void)
{
	//ͷƮ ɸ , ŵ 1Ʈ ڰ UDR1 ִ ̴.
	setSerial1RxEnable();
	UCSR1B |= BM_1000_0000;
}

char getSerial1RxData(void)
{
	return UDR1;
}

void setSerial0RxInterruptDisable(void)
{
	UCSR0B &= BM_0111_1111;
}

void setSerial1RxInterruptDisable(void)
{
	UCSR1B &= BM_0111_1111;
}

void setSerial0RxEnable(void)
{
	UCSR0B |= BM_0001_0000;
}

void setSerial0TxEnable(void)
{
	UCSR0B |= BM_0000_1000;
}

void setSerial1RxEnable(void)
{
	UCSR1B |= BM_0001_0000;
}

void setSerial1TxEnable(void)
{
	UCSR1B |= BM_0000_1000;
}

void setSerial0RxDisable(void)
{
	UCSR0B &= BM_1110_1111;
}

void setSerial0TxDisable(void)
{
	UCSR0B &= BM_1111_0111;
}

void setSerial1RxDisable(void)
{
	UCSR1B &= BM_1110_1111;
}

void setSerial1TxDisable(void)
{
	UCSR1B &= BM_1111_0111;
}

void setSerial0Baudrate_16MHz(int baudrate)
{
	switch (baudrate)
	{
		case BR_2400:
			UBRR0H = BM_0000_0001;
			UBRR0L = BM_1010_0000;
			break;
		case BR_4800:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_1100_1111;
			break;
		case BR_9600:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0110_0111;
			break;
		case BR_14400:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0100_0100;
			break;
		case BR_19200:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0011_0011;
			break;
		case BR_38400:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0001_1001;
			break;
		case BR_56000:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0001_0001;
			break;
		case BR_57600:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0001_0000;
			break;
		case BR_76800:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_1100;
			break;
		case BR_115200:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_1000;
			break;
		case BR_230400:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_0011;
			break;
		case BR_250K:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_0011;
			break;
		case BR_500K:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_0001;
			break;
		case BR_1M:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_0000;
			break;
defalut:
			break;
	}

}

void setSerial1Baudrate_16MHz(int baudrate)
{
	switch (baudrate)
	{
		case BR_2400:
			UBRR1H = BM_0000_0001;
			UBRR1L = BM_1010_0000;
			break;
		case BR_4800:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_1100_1111;
			break;
		case BR_9600:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0110_0111;
			break;
		case BR_14400:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0100_0100;
			break;
		case BR_19200:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0011_0011;
			break;
		case BR_38400:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0001_1001;
			break;
		case BR_56000:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0001_0001;
			break;
		case BR_57600:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0001_0000;
			break;
		case BR_76800:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_1100;
			break;
		case BR_115200:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_1000;
			break;
		case BR_230400:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_0011;
			break;
		case BR_250K:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_0011;
			break;
		case BR_500K:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_0001;
			break;
		case BR_1M:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_0000;
			break;
defalut:
			break;
	}

}

char checkSerial0RXComplete(void)
{
	return UCSR0A & BM_1000_0000;
}

char checkSerial1RXComplete(void)
{
	return UCSR1A & BM_1000_0000;
}

