#ifndef __FLAG_INIT
#define __FLAG_INIT
#endif //__FLAG_INIT


/*
 *  AVR ϴ   ϴ  ʱȭ Ѵ.
 */


#include "bitmask.h"
#ifdef DEBUG
void initCommon(void);
#endif

////////////////////////////////////////////////////////////////
// ATmega8
////////////////////////////////////////////////////////////////

#ifdef	_AVR_ATMEGA8

#ifdef	_CODEVISION
#ifndef _MEGA8_INCLUDED_
#include <mega8.h>
#endif //_MEGA8_INCLUDED_
#endif	//_CODEVISION

#include "serial.h"
#include "adc.h"
#include "port.h"
#include "ads1100.h"

void initAVR(void)
{
	initPort();
	initSerial();
	initAdc();
	initADS1100();
}
#endif	// _AVR_ATMEGA8


////////////////////////////////////////////////////////////////
// ATmega2560
////////////////////////////////////////////////////////////////

#ifdef	_AVR_ATMEGA2560

#ifdef	_CODEVISION
#ifndef _MEGA2560_INCLUDED_
#include <mega2560.h>
#endif //_MEGA2560_INCLUDED_
#endif	//_CODEVISION

#ifdef	_WINAVR
#endif	//_WINAVR

#include "clock.h"
#include "port.h"
#include "serial.h"
#include "servo.h"

void initAVR(void)
{
	initClock();
	initPort();
	initSerial();
	initServo();

	//////////////////////     κ. ׷  κ.
	// External Interrupt(s) initialization
	// INT0: Off
	// INT1: Off
	// INT2: Off
	// INT3: Off
	// INT4: Off
	// INT5: Off
	// INT6: Off
	// INT7: Off
	EICRA=0x00;
	EICRB=0x00;
	EIMSK=0x00;
	// PCINT0 interrupt: Off
	// PCINT1 interrupt: Off
	// PCINT2 interrupt: Off
	// PCINT3 interrupt: Off
	// PCINT4 interrupt: Off
	// PCINT5 interrupt: Off
	// PCINT6 interrupt: Off
	// PCINT7 interrupt: Off
	// PCINT8 interrupt: Off
	// PCINT9 interrupt: Off
	// PCINT10 interrupt: Off
	// PCINT11 interrupt: Off
	// PCINT12 interrupt: Off
	// PCINT13 interrupt: Off
	// PCINT14 interrupt: Off
	// PCINT15 interrupt: Off
	// PCINT16 interrupt: Off
	// PCINT17 interrupt: Off
	// PCINT18 interrupt: Off
	// PCINT19 interrupt: Off
	// PCINT20 interrupt: Off
	// PCINT21 interrupt: Off
	// PCINT22 interrupt: Off
	// PCINT23 interrupt: Off
	PCMSK0=0x00;
	PCMSK1=0x00;
	PCMSK2=0x00;
	PCICR=0x00;

	// Analog Comparator initialization
	// Analog Comparator: Off
	// Analog Comparator Input Capture by Timer/Counter 1: Off
	ACSR=0x80;
	ADCSRB=0x00;


#ifdef	DEBUG
	initCommon();
#endif	//DEBUG

#asm("sei")
}



#endif	//_AVR_ATMEGA2560

////////////////////////////////////////////////////////////////
// ATmega128
////////////////////////////////////////////////////////////////

#ifdef	_AVR_ATMEGA128

#ifdef	_CODEVISION
#ifndef _MEGA128_INCLUDED_
#include <mega128.h>
#endif //_MEGA128_INCLUDED_
#endif
#ifdef	_WINAVR
#endif

#include "serial.h"
#include "servo.h"
#include "adc.h"
#include "port.h"
#include "at24c16.h"
#include "random.h"

void initAVR(void)
{
    initSerial();
	initRandom();
}

#endif



////////////////////////////////////////////////////////////////
// ATmega32
////////////////////////////////////////////////////////////////

#ifdef	_AVR_ATMEGA32
#endif




////////////////////////////////////////////////////////////////
// Debugging Code
////////////////////////////////////////////////////////////////

#ifdef	DEBUG
#include "debug.h"
#ifdef _AVR_ATMEGA2560
void initCommon(void)
{
	// Timer/Counter 5 initialization
	// Clock source: System Clock
	// Clock value: 250.000 kHz
	// Mode: Normal top=FFFFh
	// OC5A output: Discon.
	// OC5B output: Discon.
	// OC5C output: Discon.
	// Noise Canceler: Off
	// Input Capture on Falling Edge
	// Timer 5 Overflow Interrupt: Off
	// Input Capture Interrupt: Off
	// Compare A Match Interrupt: Off
	// Compare B Match Interrupt: Off
	// Compare C Match Interrupt: Off
	TCCR5A=0x00;
	TCCR5B=0x03;
	TCNT5H=0x00;
	TCNT5L=0x00;
	ICR5H=0x00;
	ICR5L=0x00;
	OCR5AH=0x00;
	OCR5AL=0x00;
	OCR5BH=0x00;
	OCR5BL=0x00;
	OCR5CH=0x00;
	OCR5CL=0x00;
}

long int counter;
void startCounter(void)
{
	counter = 0;
	counter = TCNT5L | (TCNT5H << 8) ;
}
void endCounter(void)
{
	//īͰ 1  뷫 3us
	counter = (TCNT5L | (TCNT5H << 8)) - counter ;
	putSerial2('w');
	putSerial2Hex1Byte(counter>>8);
	putSerial2('_');
	putSerial2Hex1Byte(counter&0x00FF);
	counter = 0;
}
#endif
#endif	//DEBUG


