#ifndef __FLAG_AT24C16
#define __FLAG_AT24C16
#endif //__FLAG_AT24C16

#ifdef _CODEVISION
#ifndef _DELAY_INCLUDED_
#include <delay.h>      
#endif //_DELAY_INCLUDED_
#endif //_CODEVISION

#ifdef _AVR_ATMEGA128
#ifndef __FLAG_SETTWI
#include "mega128/setTWI.h"
#endif //__FLAG_SETTWI

void initAT24C16(void);
void AT24C16_Write(unsigned int address, unsigned char byte); 
unsigned char AT24C16_Read(unsigned int address);

void initAT24C16(void)
{
	initTWI();
}
 
//Read a byte
unsigned char AT24C16_Read(unsigned int address)
{
	unsigned char byte;
	
        
	TWCR = 0xA4;	//Start condition
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x08));	//Start complete??

	TWDR = (char)(0xA0 + ((address >> 7) & 0x000E));	//SLA+W
	TWCR = 0x84;
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x18));	//SLA+W complete??

	TWDR = (address & 0x00FF);	//word address
	TWCR = 0x84;
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x28));	//address complete??

	TWCR = 0xA4;	//Repeated Start Condition
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x10));	//Start complete??

	TWDR = (char)(0xA0 + ((address >> 7) & 0x000E) + 0x01);	//SLA+R
	TWCR = 0x84;
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x40));	//SLA+W complete??

	TWCR = 0x84;	//read data with no acknowledge
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x58));	//data complete??
	byte = TWDR;

	TWCR = 0x94;	//STOP Condition

	return byte;	//return data
}


//Write a byte
void AT24C16_Write(unsigned int address, unsigned char byte)
{


	//write process
	TWCR = 0xA4;	//Start Condition
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x08));	//Start complete??

	TWDR = (char)(0xA0 + ((address >> 7) & 0x000E));	//SLA+W
    //delay_us(50);
	TWCR = 0x84;
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x18));	//SLA+W complete??

	TWDR = (address & 0x00FF);	//word address
	TWCR = 0x84;
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x28));	//address complete??

	TWDR = byte;	//write data
	TWCR = 0x84;
	while(((TWCR & 0x80) == 0x00) || ((TWSR & 0xF8) != 0x28));	//data complete??

	TWCR = 0x94;	//STOP Condition

	delay_ms(1);	//delay for TWR TIME
}

#endif //_AVR_ATMEGA128

#ifdef _AVR_ATMEGA8
#ifndef __FLAG_SETTWI
#include "mega128/setTWI.h"
#endif //__FLAG_SETTWI
#endif //_AVR_ATMEGA8


