#ifndef __FLAG_ADS1100
#define __FLAG_ADS1100
#endif //__FLAG_ADS1100

#ifdef _AVR_ATMEGA8
#ifndef __FLAG_SETTWI
#include "mega8/setTWI.h"
#endif //__FLAG_SETTWI

void initADS1100(void)
{
    setTWIPrescaler(1);
	setTWIBitRate(400.0);
	setTWIEnable();
}

unsigned char translateADS1100(int address)
{
	// AD0 : 0
	// AD1 : 2
	return (BM_1001_0000 | address);
}

unsigned long int getADS1100Value(int addressADS1100)
{
	unsigned char address;
	unsigned long int data = 0;    
	address = translateADS1100(addressADS1100);

	//TWI 
	TWCR = 0xA4;    //ŸƮ ȣ ־
	while( ((TWCR&0x80) == 0x00) || ((TWSR & 0xF8) != 0x08) );      //տ TWINTȮ, ڿ TWSR Ȯ
	////////////////////////////////////////////////////////////////////// 1 .
	//ADS(̺ ġ) νѴ.
	TWDR = address + 0x01;    //ּҰ ־ ( SLA + R )
	delay_us(50);
	TWCR = 0x84;    //ּҰ . Ȯ Ǹ Ackȣ .                                        
	while( ((TWCR&0x80) == 0x00) || ((TWSR&0xF8) != 0x40) );  
	////////////////////////////////////////////////////////////////////// 2 .
	//ù°  Ʈ ޴´.
	TWCR = 0xC4;    //ù°  . 1Ʈ  Ackȣ ̾ .
	while( ((TWCR&0x80) == 0x00) || ((TWSR&0xF8) != 0x50) );                             
	data = TWDR;    
	data = data << 8;       
	////////////////////////////////////////////////////////////////////// 3 .
	//ι°  Ʈ ޴´.
	TWCR = 0xC4;    //ι°  . 1Ʈ  Ackȣ ̾ .
	while( ((TWCR&0x80) == 0x00) || ((TWSR&0xF8) != 0x50) );                             
	data = data + TWDR;
	//////////////////////////////////////////////////////////////////////ٽ ѹ 3 .
	//° Configuration Ʈ ޴´.
	TWCR = 0x84;    //ι°  . 1Ʈ ޾Ƶ Ackȣ   .
	while( ((TWCR&0x80) == 0x00) || ((TWSR&0xF8) != 0x58) );    
	//////////////////////////////////////////////////////////////////////ٽ ѹ 3 .
	// 
	TWCR = 0x94;    // .
	////////////////////////////////////////////////////////////////////// 4 .   

	return data;
}


#endif //_AVR_ATMEGA8


#ifdef _AVR_ATMEGA2560
#ifndef __FLAG_SETTWI
#include "mega2560/setTWI.h"
#endif //__FLAG_SETTWI

unsigned char translateADS1100(int address)
{
	// AD0 : 0
	// AD1 : 2
	return (BM_1001_0000 | address);
}

unsigned long int getADS1100Value(int addressADS1100)
{
	unsigned char address;
	unsigned long int data = 0;    
	address = translateADS1100(addressADS1100);

	//TWI 
	TWCR = 0xA4;    //ŸƮ ȣ ־
	while( ((TWCR&0x80) == 0x00) || ((TWSR & 0xF8) != 0x08) );      //տ TWINTȮ, ڿ TWSR Ȯ
	////////////////////////////////////////////////////////////////////// 1 .
	//ADS(̺ ġ) νѴ.
	TWDR = address + 0x01;    //ּҰ ־ ( SLA + R )
	delay_us(50);
	TWCR = 0x84;    //ּҰ . Ȯ Ǹ Ackȣ .                                        
	while( ((TWCR&0x80) == 0x00) || ((TWSR&0xF8) != 0x40) );  
	////////////////////////////////////////////////////////////////////// 2 .
	//ù°  Ʈ ޴´.
	TWCR = 0xC4;    //ù°  . 1Ʈ  Ackȣ ̾ .
	while( ((TWCR&0x80) == 0x00) || ((TWSR&0xF8) != 0x50) );                             
	data = TWDR;    
	data = data << 8;       
	////////////////////////////////////////////////////////////////////// 3 .
	//ι°  Ʈ ޴´.
	TWCR = 0xC4;    //ι°  . 1Ʈ  Ackȣ ̾ .
	while( ((TWCR&0x80) == 0x00) || ((TWSR&0xF8) != 0x50) );                             
	data = data + TWDR;
	//////////////////////////////////////////////////////////////////////ٽ ѹ 3 .
	//° Configuration Ʈ ޴´.
	TWCR = 0x84;    //ι°  . 1Ʈ ޾Ƶ Ackȣ   .
	while( ((TWCR&0x80) == 0x00) || ((TWSR&0xF8) != 0x58) );    
	//////////////////////////////////////////////////////////////////////ٽ ѹ 3 .
	// 
	TWCR = 0x94;    // .
	////////////////////////////////////////////////////////////////////// 4 .   

	return data;
}


#endif //_AVR_ATMEGA2560
