/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BasicMultiPropertiesConfig
extends MultiPropertiesConfig {
    String[] rps;
    Map propsByResourcePaths = new HashMap();
    Map propsByPrefixes;
    Properties propsByKey;

    public BasicMultiPropertiesConfig(String[] resourcePaths) {
        this(resourcePaths, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicMultiPropertiesConfig(String[] resourcePaths, MLogger logger) {
        ArrayList<String> goodPaths = new ArrayList<String>();
        for (String rp : resourcePaths) {
            Properties p = new Properties();
            InputStream pis = MultiPropertiesConfig.class.getResourceAsStream(rp);
            if (pis != null) {
                try {
                    p.load(pis);
                    this.propsByResourcePaths.put(rp, p);
                    goodPaths.add(rp);
                    continue;
                }
                catch (IOException e) {
                    if (logger != null) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, "An IOException occurred while loading configuration properties from resource path '" + rp + "'.", e);
                        continue;
                    }
                    e.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        if (pis != null) {
                            pis.close();
                        }
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + rp + "'.", e);
                            }
                        }
                        e.printStackTrace();
                    }
                }
            }
            if (logger == null || !logger.isLoggable(MLevel.FINE)) continue;
            logger.fine("Configuration properties not found at ResourcePath '" + rp + "'. [logger name: " + logger.getName() + ']');
        }
        this.rps = goodPaths.toArray(new String[goodPaths.size()]);
        this.propsByPrefixes = Collections.unmodifiableMap(BasicMultiPropertiesConfig.extractPrefixMapFromRsrcPathMap(this.rps, this.propsByResourcePaths));
        this.propsByResourcePaths = Collections.unmodifiableMap(this.propsByResourcePaths);
        this.propsByKey = BasicMultiPropertiesConfig.extractPropsByKey(this.rps, this.propsByResourcePaths);
    }

    private static String extractPrefix(String s) {
        int lastdot = s.lastIndexOf(46);
        if (lastdot < 0) {
            return null;
        }
        return s.substring(0, lastdot);
    }

    private static Properties findProps(String rp, Map pbrp) {
        Properties p;
        if ("/".equals(rp)) {
            try {
                p = System.getProperties();
            }
            catch (SecurityException e) {
                System.err.println(BasicMultiPropertiesConfig.class.getName() + " Read of system Properties blocked -- ignoring any configuration via System properties, and using Empty Properties! " + "(But any configuration via a resource properties files is still okay!)");
                p = new Properties();
            }
        } else {
            p = (Properties)pbrp.get(rp);
        }
        return p;
    }

    private static Properties extractPropsByKey(String[] resourcePaths, Map pbrp) {
        Properties out = new Properties();
        for (String rp : resourcePaths) {
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                System.err.println("Could not find loaded properties for resource path: " + rp);
                continue;
            }
            for (String string : p.keySet()) {
                String val = (String)p.get(string);
                out.put(string, val);
            }
        }
        return out;
    }

    private static Map extractPrefixMapFromRsrcPathMap(String[] resourcePaths, Map pbrp) {
        HashMap<String, Properties> out = new HashMap<String, Properties>();
        for (String rp : resourcePaths) {
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                System.err.println(BasicMultiPropertiesConfig.class.getName() + " -- Could not find loaded properties for resource path: " + rp);
                continue;
            }
            for (String string : p.keySet()) {
                String prefix = BasicMultiPropertiesConfig.extractPrefix(string);
                while (prefix != null) {
                    Properties byPfx = (Properties)out.get(prefix);
                    if (byPfx == null) {
                        byPfx = new Properties();
                        out.put(prefix, byPfx);
                    }
                    byPfx.put(string, p.get(string));
                    prefix = BasicMultiPropertiesConfig.extractPrefix(prefix);
                }
            }
        }
        return out;
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.rps.clone();
    }

    public Properties getPropertiesByResourcePath(String path) {
        return (Properties)this.propsByResourcePaths.get(path);
    }

    public Properties getPropertiesByPrefix(String pfx) {
        return (Properties)this.propsByPrefixes.get(pfx);
    }

    public String getProperty(String key) {
        return this.propsByKey.getProperty(key);
    }
}

