/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

public final class C3P0ImplUtils {
    static final MLogger logger = MLog.getLogger(C3P0ImplUtils.class);
    public static final DbAuth NULL_AUTH = new DbAuth(null, null);
    public static final Object[] NOARGS = new Object[0];
    static String connectionTesterClassName = null;
    static ConnectionTester cachedTester = null;

    public static String identityToken(Object o) {
        return o != null ? Integer.toString(System.identityHashCode(o), 16) : null;
    }

    public static DbAuth findAuth(Object o) throws SQLException {
        if (o == null) {
            return NULL_AUTH;
        }
        String user = null;
        String password = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                Method readMethod;
                Class<?> propCl = pd.getPropertyType();
                String propName = pd.getName();
                if (propCl != String.class || (readMethod = pd.getReadMethod()) == null) continue;
                Object propVal = readMethod.invoke(o, NOARGS);
                String value = (String)propVal;
                if ("user".equals(propName)) {
                    user = value;
                    continue;
                }
                if (!"password".equals(propName)) continue;
                password = value;
            }
            if (user == null) {
                return NULL_AUTH;
            }
            return new DbAuth(user, password);
        }
        catch (Exception e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    static void resetTxnState(Connection pCon, boolean forceIgnoreUnresolvedTransactions, boolean autoCommitOnClose, boolean txnKnownResolved) throws SQLException {
        if (!forceIgnoreUnresolvedTransactions && !pCon.getAutoCommit()) {
            if (!autoCommitOnClose && !txnKnownResolved) {
                pCon.rollback();
            }
            pCon.setAutoCommit(true);
        }
    }

    public static synchronized ConnectionTester defaultConnectionTester() {
        String dfltCxnTesterClassName = PoolConfig.defaultConnectionTesterClassName();
        if (connectionTesterClassName != null && connectionTesterClassName.equals(dfltCxnTesterClassName)) {
            return cachedTester;
        }
        try {
            cachedTester = (ConnectionTester)Class.forName(dfltCxnTesterClassName).newInstance();
            connectionTesterClassName = cachedTester.getClass().getName();
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not load ConnectionTester " + dfltCxnTesterClassName + ", using built in default.", e);
            }
            cachedTester = C3P0Defaults.connectionTester();
            connectionTesterClassName = cachedTester.getClass().getName();
        }
        return cachedTester;
    }

    public static boolean supportsMethod(Object target, String mname, Class[] argTypes) {
        try {
            return target.getClass().getMethod(mname, argTypes) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "We were denied access in a check of whether " + target + " supports method " + mname + ". Prob means external clients have no access, returning false.", e);
            }
            return false;
        }
    }

    private C3P0ImplUtils() {
    }
}

