/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigInteger;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.StringFormatter;
import org.python.core.StringFuncs;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.ucnhashAPI;

public class PyString
extends PySequence
implements ClassDictInit {
    private String string;
    private transient int cached_hashcode = 0;
    private transient boolean interned = false;
    private static char[] hexdigit = "0123456789ABCDEF".toCharArray();
    private static ucnhashAPI pucnHash = null;

    public PyString() {
        this.string = "";
    }

    public PyString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create PyString from null!");
        }
        this.string = string;
    }

    public PyString(char c) {
        this(String.valueOf(c));
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__str__", (PyObject)new StringFuncs("__str__", 1, 0));
        dict.__setitem__("__len__", (PyObject)new StringFuncs("__len__", 2, 0));
        dict.__setitem__("__repr__", (PyObject)new StringFuncs("__repr__", 3, 0));
        dict.__setitem__("islower", (PyObject)new StringFuncs("islower", 4, 0));
        dict.__setitem__("isalpha", (PyObject)new StringFuncs("isalpha", 5, 0));
        dict.__setitem__("isdigit", (PyObject)new StringFuncs("isdigit", 6, 0));
        dict.__setitem__("isupper", (PyObject)new StringFuncs("isupper", 7, 0));
        dict.__setitem__("isspace", (PyObject)new StringFuncs("isspace", 8, 0));
        dict.__setitem__("istitle", (PyObject)new StringFuncs("istitle", 9, 0));
        dict.__setitem__("isnumeric", (PyObject)new StringFuncs("isnumeric", 10, 0));
        dict.__setitem__("__cmp__", (PyObject)new StringFuncs("__cmp__", 11, 1));
        dict.__setitem__("__add__", (PyObject)new StringFuncs("__add__", 12, 1));
        dict.__setitem__("__mod__", (PyObject)new StringFuncs("__mod__", 13, 1));
        dict.__setitem__("lower", (PyObject)new StringFuncs("lower", 101, 0));
        dict.__setitem__("upper", (PyObject)new StringFuncs("upper", 102, 0));
        dict.__setitem__("swapcase", (PyObject)new StringFuncs("swapcase", 103, 0));
        dict.__setitem__("strip", (PyObject)new StringFuncs("strip", 104, 0, 1));
        dict.__setitem__("lstrip", (PyObject)new StringFuncs("lstrip", 105, 0, 1));
        dict.__setitem__("rstrip", (PyObject)new StringFuncs("rstrip", 106, 0, 1));
        dict.__setitem__("split", (PyObject)new StringFuncs("split", 107, 0, 2));
        dict.__setitem__("index", (PyObject)new StringFuncs("index", 108, 1, 3));
        dict.__setitem__("rindex", (PyObject)new StringFuncs("rindex", 109, 1, 3));
        dict.__setitem__("count", (PyObject)new StringFuncs("count", 110, 1, 3));
        dict.__setitem__("find", (PyObject)new StringFuncs("find", 111, 1, 3));
        dict.__setitem__("rfind", (PyObject)new StringFuncs("rfind", 112, 1, 3));
        dict.__setitem__("capitalize", (PyObject)new StringFuncs("capitalize", 113, 0));
        dict.__setitem__("endswith", (PyObject)new StringFuncs("endswith", 114, 1, 3));
        dict.__setitem__("join", (PyObject)new StringFuncs("join", 115, 1));
        dict.__setitem__("replace", (PyObject)new StringFuncs("replace", 116, 2, 3));
        dict.__setitem__("startswith", (PyObject)new StringFuncs("startswith", 117, 1, 3));
        dict.__setitem__("translate", (PyObject)new StringFuncs("translate", 118, 1, 2));
        dict.__setitem__("toString", null);
        dict.__setitem__("internedString", null);
        dict.__setitem__("hashCode", null);
        dict.__setitem__("equals", null);
        dict.__setitem__("__int__", null);
        dict.__setitem__("__long__", null);
        dict.__setitem__("__float__", null);
        dict.__setitem__("__tojava__", null);
        dict.__setitem__("atof", null);
        dict.__setitem__("atoi", null);
        dict.__setitem__("atol", null);
        dict.__setitem__("encode_UnicodeEscape", null);
        dict.__setitem__("decode_UnicodeEscape", null);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'string' object";
    }

    public PyString __str__() {
        return this;
    }

    public int __len__() {
        return this.string.length();
    }

    public String toString() {
        return this.string;
    }

    public String internedString() {
        if (this.interned) {
            return this.string;
        }
        this.string = this.string.intern();
        this.interned = true;
        return this.string;
    }

    public PyString __repr__() {
        return new PyString(PyString.encode_UnicodeEscape(this.string, true));
    }

    public static String encode_UnicodeEscape(String str, boolean use_quotes) {
        int size = str.length();
        StringBuffer v = new StringBuffer(str.length());
        char quote = '\u0000';
        boolean unicode = false;
        if (use_quotes) {
            quote = str.indexOf(39) >= 0 && str.indexOf(34) == -1 ? (char)'\"' : '\'';
            v.append(quote);
        }
        int i = 0;
        while (size-- > 0) {
            char ch = str.charAt(i++);
            if (use_quotes && (ch == quote || ch == '\\')) {
                v.append('\\');
                v.append(ch);
                continue;
            }
            if (ch >= '\u0100') {
                if (use_quotes && !unicode) {
                    v.insert(0, 'u');
                    unicode = true;
                }
                v.append('\\');
                v.append('u');
                v.append(hexdigit[ch >> 12 & 0xF]);
                v.append(hexdigit[ch >> 8 & 0xF]);
                v.append(hexdigit[ch >> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            if (use_quotes && ch == '\n') {
                v.append("\\n");
                continue;
            }
            if (use_quotes && ch == '\t') {
                v.append("\\t");
                continue;
            }
            if (use_quotes && ch == '\b') {
                v.append("\\b");
                continue;
            }
            if (use_quotes && ch == '\f') {
                v.append("\\f");
                continue;
            }
            if (use_quotes && ch == '\r') {
                v.append("\\r");
                continue;
            }
            if (ch < ' ' || ch >= '\u007f') {
                v.append("\\x");
                v.append(hexdigit[ch >> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            v.append(ch);
        }
        if (use_quotes) {
            v.append(quote);
        }
        return v.toString();
    }

    public static String decode_UnicodeEscape(String str, int start, int end, String errors, boolean unicode) {
        StringBuffer v = new StringBuffer(end - start);
        int s = start;
        block17: while (s < end) {
            char ch = str.charAt(s);
            if (ch != '\\') {
                v.append(ch);
                ++s;
                continue;
            }
            int n = ++s;
            ++s;
            ch = str.charAt(n);
            switch (ch) {
                case '\n': {
                    continue block17;
                }
                case '\\': {
                    v.append('\\');
                    continue block17;
                }
                case '\'': {
                    v.append('\'');
                    continue block17;
                }
                case '\"': {
                    v.append('\"');
                    continue block17;
                }
                case 'b': {
                    v.append('\b');
                    continue block17;
                }
                case 'f': {
                    v.append('\f');
                    continue block17;
                }
                case 't': {
                    v.append('\t');
                    continue block17;
                }
                case 'n': {
                    v.append('\n');
                    continue block17;
                }
                case 'r': {
                    v.append('\r');
                    continue block17;
                }
                case 'v': {
                    v.append('\u000b');
                    continue block17;
                }
                case 'a': {
                    v.append('\u0007');
                    continue block17;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int x = Character.digit(ch, 8);
                    for (int j = 0; j < 2 && s < end && (ch = str.charAt(s)) >= '0' && ch <= '7'; ++j, ++s) {
                        x = (x << 3) + Character.digit(ch, 8);
                    }
                    v.append((char)x);
                    continue block17;
                }
                case 'x': {
                    int i;
                    int x = 0;
                    for (i = 0; i < 2 && s < end; ++i) {
                        ch = str.charAt(s + i);
                        int d = Character.digit(ch, 16);
                        if (d == -1) {
                            codecs.decoding_error("unicode escape", v, errors, "truncated \\xXX");
                            ++i;
                            break;
                        }
                        x = (x << 4 & 0xFFFFFFF0) + d;
                    }
                    s += i;
                    v.append((char)x);
                    continue block17;
                }
                case 'u': {
                    int i;
                    if (!unicode) {
                        v.append('\\');
                        v.append('u');
                        continue block17;
                    }
                    if (s + 4 > end) {
                        codecs.decoding_error("unicode escape", v, errors, "truncated \\uXXXX");
                        continue block17;
                    }
                    int x = 0;
                    for (i = 0; i < 4; ++i) {
                        ch = str.charAt(s + i);
                        int d = Character.digit(ch, 16);
                        if (d == -1) {
                            codecs.decoding_error("unicode escape", v, errors, "truncated \\uXXXX");
                            break;
                        }
                        x = (x << 4 & 0xFFFFFFF0) + d;
                    }
                    s += i;
                    v.append((char)x);
                    continue block17;
                }
                case 'N': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('N');
                        continue block17;
                    }
                    if (pucnHash == null) {
                        PyObject mod = imp.importName("ucnhash", true);
                        pucnHash = (ucnhashAPI)(mod = mod.__call__()).__tojava__(Object.class);
                        if (pucnHash.getCchMax() < 0) {
                            codecs.decoding_error("unicode escape", v, errors, "Unicode names not loaded");
                        }
                    }
                    if (str.charAt(s) == '{') {
                        int startName;
                        int endBrace;
                        int maxLen = pucnHash.getCchMax();
                        for (endBrace = startName = s + 1; endBrace < end && str.charAt(endBrace) != '}' && endBrace - startName <= maxLen; ++endBrace) {
                        }
                        if (endBrace != end && str.charAt(endBrace) == '}') {
                            int value = pucnHash.getValue(str, startName, endBrace);
                            if (value < 0) {
                                codecs.decoding_error("unicode escape", v, errors, "Invalid Unicode Character Name");
                                v.append('\\');
                                v.append(str.charAt(s - 1));
                                continue block17;
                            }
                            if (value < 65536) {
                                v.append((char)value);
                            } else {
                                v.append((char)(55296 + ((value -= 65536) >> 10)));
                                v.append((char)(56320 + (value & 0xFFFF03FF)));
                            }
                            s = endBrace + 1;
                            continue block17;
                        }
                        codecs.decoding_error("unicode escape", v, errors, "Unicode name missing closing brace");
                        v.append('\\');
                        v.append(str.charAt(s - 1));
                        continue block17;
                    }
                    codecs.decoding_error("unicode escape", v, errors, "Missing opening brace for Unicode Character Name escape");
                }
            }
            v.append('\\');
            v.append(str.charAt(s - 1));
        }
        return v.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PyString)) {
            return false;
        }
        PyString o = (PyString)other;
        if (this.interned && o.interned) {
            return this.string == o.string;
        }
        return this.string.equals(o.string);
    }

    public int __cmp__(PyObject other) {
        if (!(other instanceof PyString)) {
            return -2;
        }
        int c = this.string.compareTo(((PyString)other).string);
        return c < 0 ? -1 : (c > 0 ? 1 : 0);
    }

    public PyObject __eq__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.equals(s) ? Py.One : Py.Zero;
    }

    public PyObject __ne__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.equals(s) ? Py.Zero : Py.One;
    }

    public PyObject __lt__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.compareTo(s) < 0 ? Py.One : Py.Zero;
    }

    public PyObject __le__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.compareTo(s) <= 0 ? Py.One : Py.Zero;
    }

    public PyObject __gt__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.compareTo(s) > 0 ? Py.One : Py.Zero;
    }

    public PyObject __ge__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.compareTo(s) >= 0 ? Py.One : Py.Zero;
    }

    private static String coerce(PyObject o) {
        if (o instanceof PyString) {
            return o.toString();
        }
        return null;
    }

    public int hashCode() {
        if (this.cached_hashcode == 0) {
            this.cached_hashcode = this.string.hashCode();
        }
        return this.cached_hashcode;
    }

    private byte[] getBytes() {
        byte[] buf = new byte[this.string.length()];
        this.string.getBytes(0, this.string.length(), buf, 0);
        return buf;
    }

    public Object __tojava__(Class c) {
        if (c.isAssignableFrom(String.class)) {
            return this.string;
        }
        if ((c == Character.TYPE || c == Character.class) && this.string.length() == 1) {
            return new Character(this.string.charAt(0));
        }
        if (c.isArray()) {
            if (c.getComponentType() == Byte.TYPE) {
                return this.getBytes();
            }
            if (c.getComponentType() == Character.TYPE) {
                return this.string.toCharArray();
            }
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    protected PyObject get(int i) {
        return Py.newString(this.string.charAt(i));
    }

    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        if (step == 1) {
            return new PyString(this.string.substring(start, stop));
        }
        int n = PyString.sliceLength(start, stop, step);
        char[] new_chars = new char[n];
        int j = 0;
        int i = start;
        while (j < n) {
            new_chars[j++] = this.string.charAt(i);
            i += step;
        }
        return new PyString(new String(new_chars));
    }

    public boolean __contains__(PyObject o) {
        if (!(o instanceof PyString) || o.__len__() != 1) {
            throw Py.TypeError("string member test needs char left operand");
        }
        PyString other = (PyString)o;
        return this.string.indexOf(other.string) >= 0;
    }

    protected PyObject repeat(int count) {
        if (count < 0) {
            count = 0;
        }
        int s = this.string.length();
        char[] new_chars = new char[s * count];
        for (int i = 0; i < count; ++i) {
            this.string.getChars(0, s, new_chars, i * s);
        }
        return new PyString(new String(new_chars));
    }

    public PyObject __add__(PyObject generic_other) {
        if (generic_other instanceof PyString) {
            PyString other = (PyString)generic_other;
            return new PyString(this.string.concat(other.string));
        }
        return null;
    }

    public PyObject __mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.string);
        return new PyString(fmt.format(other));
    }

    public PyInteger __int__() {
        return Py.newInteger(this.atoi(10));
    }

    public PyLong __long__() {
        return this.atol(10);
    }

    public PyFloat __float__() {
        return new PyFloat(this.atof());
    }

    public PyComplex __complex__() {
        int s;
        boolean got_re = false;
        boolean got_im = false;
        boolean done = false;
        boolean sw_error = false;
        int n = this.string.length();
        for (s = 0; s < n && Character.isSpaceChar(this.string.charAt(s)); ++s) {
        }
        if (s == n) {
            throw Py.ValueError("empty string for complex()");
        }
        double z = -1.0;
        double x = 0.0;
        double y = 0.0;
        int sign = 1;
        block7: do {
            char c = this.string.charAt(s);
            switch (c) {
                case '-': {
                    sign = -1;
                }
                case '+': {
                    if (done || s + 1 == n) {
                        sw_error = true;
                        break;
                    }
                    if (Character.isDigit(c = this.string.charAt(++s)) || c == 'J' || c == 'j') continue block7;
                    sw_error = true;
                    break;
                }
                case 'J': 
                case 'j': {
                    if (got_im || done) {
                        sw_error = true;
                        break;
                    }
                    y = z < 0.0 ? (double)sign : (double)sign * z;
                    got_im = true;
                    done = got_re;
                    sign = 1;
                    ++s;
                    break;
                }
                case ' ': {
                    while (s < n && Character.isSpaceChar(this.string.charAt(s))) {
                        ++s;
                    }
                    if (s == n) continue block7;
                    sw_error = true;
                    break;
                }
                default: {
                    boolean digit_or_dot;
                    boolean bl = digit_or_dot = c == '.' || Character.isDigit(c);
                    if (!digit_or_dot) {
                        sw_error = true;
                        break;
                    }
                    int end = this.endDouble(this.string, s);
                    z = Double.valueOf(this.string.substring(s, end));
                    s = end;
                    if (s < n && ((c = this.string.charAt(s)) == 'J' || c == 'j')) continue block7;
                    if (got_re) {
                        sw_error = true;
                        break;
                    }
                    x = (double)sign * z;
                    got_re = true;
                    done = got_im;
                    z = -1.0;
                    sign = 1;
                }
            }
        } while (s < n && !sw_error);
        if (sw_error) {
            throw Py.ValueError("malformed string for complex() " + this.string.substring(s));
        }
        return new PyComplex(x, y);
    }

    private int endDouble(String string, int s) {
        int n = string.length();
        while (s < n) {
            char c;
            if (Character.isDigit(c = string.charAt(s++)) || c == '.') continue;
            if ((c == 'e' || c == 'E') && s < n) {
                c = string.charAt(s);
                if (c != '+' && c != '-') continue;
                ++s;
                continue;
            }
            return s - 1;
        }
        return s;
    }

    public String lower() {
        return this.string.toLowerCase();
    }

    public String upper() {
        return this.string.toUpperCase();
    }

    public String title() {
        char[] chars = this.string.toCharArray();
        int n = chars.length;
        boolean previous_is_cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = chars[i];
            chars[i] = previous_is_cased ? Character.toLowerCase(ch) : Character.toTitleCase(ch);
            previous_is_cased = Character.isLowerCase(ch) || Character.isUpperCase(ch) || Character.isTitleCase(ch);
        }
        return new String(chars);
    }

    public String swapcase() {
        char[] chars = this.string.toCharArray();
        int n = chars.length;
        for (int i = 0; i < n; ++i) {
            char c = chars[i];
            if (Character.isUpperCase(c)) {
                chars[i] = Character.toLowerCase(c);
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            chars[i] = Character.toUpperCase(c);
        }
        return new String(chars);
    }

    public String strip() {
        return this.strip(null);
    }

    public String strip(String sep) {
        int end;
        int start;
        char[] chars = this.string.toCharArray();
        int n = chars.length;
        if (sep == null) {
            for (start = 0; start < n && Character.isWhitespace(chars[start]); ++start) {
            }
        } else {
            while (start < n && sep.indexOf(chars[start]) >= 0) {
                ++start;
            }
        }
        if (sep == null) {
            for (end = n - 1; end >= 0 && Character.isWhitespace(chars[end]); --end) {
            }
        } else {
            while (end >= 0 && sep.indexOf(chars[end]) >= 0) {
                --end;
            }
        }
        if (end >= start) {
            return end < n - 1 || start > 0 ? this.string.substring(start, end + 1) : this.string;
        }
        return "";
    }

    public String lstrip() {
        return this.lstrip(null);
    }

    public String lstrip(String sep) {
        int start;
        char[] chars = this.string.toCharArray();
        int n = chars.length;
        if (sep == null) {
            for (start = 0; start < n && Character.isWhitespace(chars[start]); ++start) {
            }
        } else {
            while (start < n && sep.indexOf(chars[start]) >= 0) {
                ++start;
            }
        }
        return start > 0 ? this.string.substring(start, n) : this.string;
    }

    public String rstrip() {
        return this.rstrip(null);
    }

    public String rstrip(String sep) {
        int end;
        char[] chars = this.string.toCharArray();
        int n = chars.length;
        if (sep == null) {
            for (end = n - 1; end >= 0 && Character.isWhitespace(chars[end]); --end) {
            }
        } else {
            while (end >= 0 && sep.indexOf(chars[end]) >= 0) {
                --end;
            }
        }
        return end < n - 1 ? this.string.substring(0, end + 1) : this.string;
    }

    public PyList split() {
        return this.split(null, -1);
    }

    public PyList split(String sep) {
        return this.split(sep, -1);
    }

    public PyList split(String sep, int maxsplit) {
        if (sep != null) {
            return this.splitfields(sep, maxsplit);
        }
        PyList list = new PyList();
        char[] chars = this.string.toCharArray();
        int n = chars.length;
        if (maxsplit < 0) {
            maxsplit = n;
        }
        int index = 0;
        for (int splits = 0; index < n && splits < maxsplit; ++splits) {
            while (index < n && Character.isWhitespace(chars[index])) {
                ++index;
            }
            if (index == n) break;
            int start = index;
            while (index < n && !Character.isWhitespace(chars[index])) {
                ++index;
            }
            list.append(new PyString(this.string.substring(start, index)));
        }
        while (index < n && Character.isWhitespace(chars[index])) {
            ++index;
        }
        if (index < n) {
            list.append(new PyString(this.string.substring(index, n)));
        }
        return list;
    }

    private PyList splitfields(String sep, int maxsplit) {
        int index;
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        PyList list = new PyList();
        int length = this.string.length();
        if (maxsplit < 0) {
            maxsplit = length;
        }
        int lastbreak = 0;
        int sepLength = sep.length();
        for (int splits = 0; splits < maxsplit && (index = this.string.indexOf(sep, lastbreak)) != -1; ++splits) {
            list.append(new PyString(this.string.substring(lastbreak, index)));
            lastbreak = index + sepLength;
        }
        if (lastbreak <= length) {
            list.append(new PyString(this.string.substring(lastbreak, length)));
        }
        return list;
    }

    public PyList splitlines() {
        return this.splitlines(false);
    }

    public PyList splitlines(boolean keepends) {
        PyList list = new PyList();
        char[] chars = this.string.toCharArray();
        int n = chars.length;
        int j = 0;
        int i = 0;
        while (i < n) {
            while (i < n && chars[i] != '\n' && chars[i] != '\r' && Character.getType(chars[i]) != 13) {
                ++i;
            }
            int eol = i;
            if (i < n) {
                i = chars[i] == '\r' && i + 1 < n && chars[i + 1] == '\n' ? (i += 2) : ++i;
                if (keepends) {
                    eol = i;
                }
            }
            list.append(new PyString(this.string.substring(j, eol)));
            j = i;
        }
        if (j < n) {
            list.append(new PyString(this.string.substring(j, n)));
        }
        return list;
    }

    public int index(String sub) {
        return this.index(sub, 0, this.string.length());
    }

    public int index(String sub, int start) {
        return this.index(sub, start, this.string.length());
    }

    public int index(String sub, int start, int end) {
        int index;
        int n = this.string.length();
        if (start < 0) {
            start = n + start;
        }
        if (end < 0) {
            end = n + end;
        }
        if ((index = end < n ? this.string.substring(start, end).indexOf(sub) : this.string.indexOf(sub, start)) == -1) {
            throw Py.ValueError("substring not found in string.index");
        }
        return index;
    }

    public int rindex(String sub) {
        return this.rindex(sub, 0, this.string.length());
    }

    public int rindex(String sub, int start) {
        return this.rindex(sub, start, this.string.length());
    }

    public int rindex(String sub, int start, int end) {
        int index;
        int n = this.string.length();
        if (start < 0) {
            start = n + start;
        }
        if (end < 0) {
            end = n + end;
        }
        if ((index = start > 0 ? this.string.substring(start, end).lastIndexOf(sub) : this.string.lastIndexOf(sub, end)) == -1) {
            throw Py.ValueError("substring not found in string.rindex");
        }
        return index;
    }

    public int count(String sub) {
        return this.count(sub, 0, this.string.length());
    }

    public int count(String sub, int start) {
        return this.count(sub, start, this.string.length());
    }

    public int count(String sub, int start, int end) {
        int index;
        int len = this.string.length();
        if (end > len) {
            end = len;
        }
        if (end < 0) {
            end += len;
        }
        if (end < 0) {
            end = 0;
        }
        if (start < 0) {
            start += len;
        }
        if (start < 0) {
            start = 0;
        }
        int n = sub.length();
        end = end + 1 - n;
        if (n == 0) {
            return end - start;
        }
        int count = 0;
        while (start < end && (index = this.string.indexOf(sub, start)) < end && index != -1) {
            ++count;
            start = index + n;
        }
        return count;
    }

    public int find(String sub) {
        return this.find(sub, 0, this.string.length());
    }

    public int find(String sub, int start) {
        return this.find(sub, start, this.string.length());
    }

    public int find(String sub, int start, int end) {
        int n = this.string.length();
        if (start < 0) {
            start = n + start;
        }
        if (end < 0) {
            end = n + end;
        }
        if (end > n) {
            end = n;
        }
        if (start > end) {
            start = end;
        }
        int slen = sub.length();
        int index = this.string.indexOf(sub, start);
        if (index > (end -= slen)) {
            return -1;
        }
        return index;
    }

    public int rfind(String sub) {
        return this.rfind(sub, 0, this.string.length());
    }

    public int rfind(String sub, int start) {
        return this.rfind(sub, start, this.string.length());
    }

    public int rfind(String sub, int start, int end) {
        int slen;
        int index;
        int n = this.string.length();
        if (start < 0) {
            start = n + start;
        }
        if (end < 0) {
            end = n + end;
        }
        if (end > n) {
            end = n;
        }
        if (start > end) {
            start = end;
        }
        if ((index = this.string.lastIndexOf(sub, end -= (slen = sub.length()))) < start) {
            return -1;
        }
        return index;
    }

    public double atof() {
        StringBuffer s = null;
        int n = this.string.length();
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (!Character.isDigit(ch)) continue;
            if (s == null) {
                s = new StringBuffer(this.string);
            }
            int val = Character.digit(ch, 10);
            s.setCharAt(i, Character.forDigit(val, 10));
        }
        String sval = this.string;
        if (s != null) {
            sval = s.toString();
        }
        try {
            return Double.valueOf(sval);
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for __float__: " + this.string);
        }
    }

    public int atoi() {
        return this.atoi(10);
    }

    public int atoi(int base) {
        int b;
        if (base != 0 && base < 2 || base > 36) {
            throw Py.ValueError("invalid base for atoi()");
        }
        int e = this.string.length();
        for (b = 0; b < e && Character.isWhitespace(this.string.charAt(b)); ++b) {
        }
        while (e > b && Character.isWhitespace(this.string.charAt(e - 1))) {
            --e;
        }
        char sign = '\u0000';
        if (b < e) {
            sign = this.string.charAt(b);
            if (sign == '-' || sign == '+') {
                ++b;
                while (b < e && Character.isWhitespace(this.string.charAt(b))) {
                    ++b;
                }
            }
            if ((base == 0 || base == 16) && this.string.charAt(b) == '0') {
                if (b < e - 1 && Character.toUpperCase(this.string.charAt(b + 1)) == 'X') {
                    base = 16;
                    b += 2;
                } else if (base == 0) {
                    base = 8;
                }
            }
        }
        if (base == 0) {
            base = 10;
        }
        String s = this.string;
        if (b > 0 || e < this.string.length()) {
            s = this.string.substring(b, e);
        }
        try {
            long result = Long.parseLong(s, base);
            if (result < 0L && (sign != '-' || result != -result)) {
                throw Py.ValueError("invalid literal for __int__: " + this.string);
            }
            if (sign == '-') {
                result = -result;
            }
            if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
                throw Py.ValueError("invalid literal for __int__: " + this.string);
            }
            return (int)result;
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for __int__: " + this.string);
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for __int__: " + this.string);
        }
    }

    public PyLong atol() {
        return this.atol(10);
    }

    public PyLong atol(int base) {
        int b;
        String str = this.string;
        int e = str.length();
        for (b = 0; b < e && Character.isWhitespace(str.charAt(b)); ++b) {
        }
        while (e > b && Character.isWhitespace(str.charAt(e - 1))) {
            --e;
        }
        if (e > b && (str.charAt(e - 1) == 'L' || str.charAt(e - 1) == 'l')) {
            --e;
        }
        char sign = '\u0000';
        if (b < e) {
            sign = this.string.charAt(b);
            if (sign == '-' || sign == '+') {
                ++b;
                while (b < e && Character.isWhitespace(str.charAt(b))) {
                    ++b;
                }
            }
            if ((base == 0 || base == 16) && this.string.charAt(b) == '0') {
                if (b < e - 1 && Character.toUpperCase(this.string.charAt(b + 1)) == 'X') {
                    base = 16;
                    b += 2;
                } else if (base == 0) {
                    base = 8;
                }
            }
        }
        if (base == 0) {
            base = 10;
        }
        if (base < 2 || base > 36) {
            throw Py.ValueError("invalid base for long literal:" + base);
        }
        if (b > 0 || e < str.length()) {
            str = str.substring(b, e);
        }
        try {
            BigInteger bi = null;
            bi = sign == '-' ? new BigInteger("-" + str, base) : new BigInteger(str, base);
            return new PyLong(bi);
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for __long__: " + str);
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for __long__: " + str);
        }
    }

    private static String spaces(int n) {
        char[] chars = new char[n];
        for (int i = 0; i < n; ++i) {
            chars[i] = 32;
        }
        return new String(chars);
    }

    public String ljust(int width) {
        int n = width - this.string.length();
        if (n <= 0) {
            return this.string;
        }
        return this.string + PyString.spaces(n);
    }

    public String rjust(int width) {
        int n = width - this.string.length();
        if (n <= 0) {
            return this.string;
        }
        return PyString.spaces(n) + this.string;
    }

    public String center(int width) {
        int n = width - this.string.length();
        if (n <= 0) {
            return this.string;
        }
        int half = n / 2;
        if (n % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        return PyString.spaces(half) + this.string + PyString.spaces(n - half);
    }

    public String zfill(int width) {
        char start;
        String s = this.string;
        int n = s.length();
        if (n >= width) {
            return s;
        }
        char[] chars = new char[width];
        int nzeros = width - n;
        int i = 0;
        int sStart = 0;
        if (n > 0 && ((start = s.charAt(0)) == '+' || start == '-')) {
            chars[0] = start;
            ++i;
            ++nzeros;
            sStart = 1;
        }
        while (i < nzeros) {
            chars[i] = 48;
            ++i;
        }
        s.getChars(sStart, s.length(), chars, i);
        return new String(chars);
    }

    public String expandtabs() {
        return this.expandtabs(8);
    }

    public String expandtabs(int tabsize) {
        String s = this.string;
        StringBuffer buf = new StringBuffer((int)((double)s.length() * 1.5));
        char[] chars = s.toCharArray();
        int n = chars.length;
        int position = 0;
        for (int i = 0; i < n; ++i) {
            char c = chars[i];
            if (c == '\t') {
                int spaces = tabsize - position % tabsize;
                position += spaces;
                while (spaces-- > 0) {
                    buf.append(' ');
                }
                continue;
            }
            if (c == '\n' || c == '\r') {
                position = -1;
            }
            buf.append(c);
            ++position;
        }
        return buf.toString();
    }

    public String capitalize() {
        if (this.string.length() == 0) {
            return this.string;
        }
        String first = this.string.substring(0, 1).toUpperCase();
        return first.concat(this.string.substring(1).toLowerCase());
    }

    public String replace(String oldPiece, String newPiece) {
        return this.replace(oldPiece, newPiece, this.string.length());
    }

    public String replace(String oldPiece, String newPiece, int maxsplit) {
        PyString newstr = new PyString(newPiece);
        return newstr.join(this.split(oldPiece, maxsplit));
    }

    public String join(PyObject seq) {
        StringBuffer buf = new StringBuffer();
        PyObject iter = seq.__iter__();
        PyObject obj = null;
        int i = 0;
        while ((obj = iter.__iternext__()) != null) {
            if (!(obj instanceof PyString)) {
                throw Py.TypeError("sequence item " + i + ": expected string, " + obj.safeRepr() + " found");
            }
            if (i > 0) {
                buf.append(this.string);
            }
            buf.append(obj.__str__());
            ++i;
        }
        return buf.toString();
    }

    public boolean startswith(String prefix) {
        return this.string.startsWith(prefix);
    }

    public boolean startswith(String prefix, int offset) {
        return this.string.startsWith(prefix, offset);
    }

    public boolean startswith(String prefix, int start, int end) {
        if (start < 0 || start + prefix.length() > this.string.length()) {
            return false;
        }
        if (end > this.string.length()) {
            end = this.string.length();
        }
        String substr = this.string.substring(start, end);
        return substr.startsWith(prefix);
    }

    public boolean endswith(String suffix) {
        return this.string.endsWith(suffix);
    }

    public boolean endswith(String suffix, int start) {
        return this.endswith(suffix, start, this.string.length());
    }

    public boolean endswith(String suffix, int start, int end) {
        int len = this.string.length();
        if (start < 0 || start > len || suffix.length() > len) {
            return false;
        }
        int n = end = end <= len ? end : len;
        if (end < start) {
            return false;
        }
        String substr = this.string.substring(start, end);
        return substr.endsWith(suffix);
    }

    public String translate(String table) {
        return this.translate(table, null);
    }

    public String translate(String table, String deletechars) {
        if (table.length() != 256) {
            throw Py.ValueError("translation table must be 256 characters long");
        }
        StringBuffer buf = new StringBuffer(this.string.length());
        for (int i = 0; i < this.string.length(); ++i) {
            char c = this.string.charAt(i);
            if (deletechars != null && deletechars.indexOf(c) >= 0) continue;
            try {
                buf.append(table.charAt(c));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw Py.TypeError("translate() only works for 8-bit character strings");
            }
        }
        return buf.toString();
    }

    public String translate(PyObject table) {
        StringBuffer v = new StringBuffer(this.string.length());
        for (int i = 0; i < this.string.length(); ++i) {
            char ch = this.string.charAt(i);
            PyInteger w = Py.newInteger(ch);
            PyObject x = table.__finditem__(w);
            if (x == null) {
                v.append(ch);
                continue;
            }
            if (x instanceof PyInteger) {
                int value = ((PyInteger)x).getValue();
                v.append((char)value);
                continue;
            }
            if (x == Py.None) continue;
            if (x instanceof PyString) {
                if (x.__len__() != 1) {
                    throw new PyException(Py.NotImplementedError, "1-n mappings are currently not implemented");
                }
                v.append(x.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return v.toString();
    }

    public boolean islower() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isLowerCase(this.string.charAt(0));
        }
        boolean cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                return false;
            }
            if (cased || !Character.isLowerCase(ch)) continue;
            cased = true;
        }
        return cased;
    }

    public boolean isupper() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isUpperCase(this.string.charAt(0));
        }
        boolean cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (Character.isLowerCase(ch) || Character.isTitleCase(ch)) {
                return false;
            }
            if (cased || !Character.isUpperCase(ch)) continue;
            cased = true;
        }
        return cased;
    }

    public boolean isalpha() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isLetter(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (Character.isLetter(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isalnum() {
        int n = this.string.length();
        if (n == 1) {
            return this._isalnum(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (this._isalnum(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isalnum(char ch) {
        return Character.isLetterOrDigit(ch) || Character.getType(ch) == 10;
    }

    public boolean isdecimal() {
        int n = this.string.length();
        if (n == 1) {
            char ch = this.string.charAt(0);
            return this._isdecimal(ch);
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (this._isdecimal(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isdecimal(char ch) {
        return Character.getType(ch) == 9;
    }

    public boolean isdigit() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isDigit(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isnumeric() {
        int n = this.string.length();
        if (n == 1) {
            return this._isnumeric(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (this._isnumeric(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isnumeric(char ch) {
        int type = Character.getType(ch);
        return type == 9 || type == 10 || type == 11;
    }

    public boolean istitle() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isTitleCase(this.string.charAt(0)) || Character.isUpperCase(this.string.charAt(0));
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(ch)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    public boolean isspace() {
        int n = this.string.length();
        if (n == 1) {
            return Character.isWhitespace(this.string.charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isunicode() {
        int n = this.string.length();
        for (int i = 0; i < n; ++i) {
            char ch = this.string.charAt(i);
            if (ch <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public PyString encode() {
        return this.encode(null, null);
    }

    public PyString encode(String encoding) {
        return this.encode(encoding, null);
    }

    public PyString encode(String encoding, String errors) {
        return codecs.encode(this, encoding, errors);
    }

    public PyString decode() {
        return this.encode(null, null);
    }

    public PyString decode(String encoding) {
        return this.decode(encoding, null);
    }

    public PyString decode(String encoding, String errors) {
        return codecs.decode(this, encoding, errors);
    }

    public String asString(int index) throws PyObject.ConversionException {
        return this.string;
    }

    public String asName(int index) throws PyObject.ConversionException {
        return this.internedString();
    }
}

