/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PyLong
extends PyObject {
    private static final BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger maxULong = BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.valueOf(1L));
    public static final String exposed_name = "long";
    private BigInteger value;

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        class Exposed___abs__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___abs__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___abs__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___abs__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___abs__();
            }
        }
        dict.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyLong.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___float__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___float__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___float__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___float__();
            }
        }
        dict.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyLong.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___hex__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___hex__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___hex__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___hex__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___hex__();
            }
        }
        dict.__setitem__("__hex__", (PyObject)new PyMethodDescr("__hex__", PyLong.class, 0, 0, new Exposed___hex__(null, null)));
        class Exposed___int__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___int__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___int__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___int__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___int__();
            }
        }
        dict.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyLong.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___invert__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___invert__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___invert__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___invert__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___invert__();
            }
        }
        dict.__setitem__("__invert__", (PyObject)new PyMethodDescr("__invert__", PyLong.class, 0, 0, new Exposed___invert__(null, null)));
        class Exposed___long__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___long__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___long__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___long__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___long__();
            }
        }
        dict.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyLong.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___neg__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___neg__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___neg__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___neg__();
            }
        }
        dict.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyLong.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___oct__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___oct__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___oct__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___oct__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___oct__();
            }
        }
        dict.__setitem__("__oct__", (PyObject)new PyMethodDescr("__oct__", PyLong.class, 0, 0, new Exposed___oct__(null, null)));
        class Exposed___pos__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pos__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___pos__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return this.self.long___pos__();
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return self.long___pos__();
            }
        }
        dict.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyLong.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___add__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___add__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___add__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___add__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyLong.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___and__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___and__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___and__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___and__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___and__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__and__", (PyObject)new PyMethodDescr("__and__", PyLong.class, 1, 1, new Exposed___and__(null, null)));
        class Exposed___div__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___div__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___div__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___div__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___div__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyLong.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___divmod__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___divmod__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___divmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___divmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyLong.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___floordiv__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___floordiv__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___floordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___floordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyLong.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___lshift__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___lshift__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___lshift__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___lshift__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___lshift__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__lshift__", (PyObject)new PyMethodDescr("__lshift__", PyLong.class, 1, 1, new Exposed___lshift__(null, null)));
        class Exposed___mod__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mod__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___mod__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___mod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___mod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyLong.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mul__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___mul__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___mul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___mul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyLong.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___or__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___or__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___or__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___or__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___or__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__or__", (PyObject)new PyMethodDescr("__or__", PyLong.class, 1, 1, new Exposed___or__(null, null)));
        class Exposed___radd__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___radd__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___radd__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___radd__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___radd__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyLong.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rdiv__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rdiv__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___rdiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___rdiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyLong.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rfloordiv__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rfloordiv__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___rfloordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___rfloordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyLong.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmod__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rmod__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___rmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___rmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyLong.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmul__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rmul__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___rmul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___rmul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyLong.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rshift__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rshift__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rshift__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___rshift__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___rshift__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rshift__", (PyObject)new PyMethodDescr("__rshift__", PyLong.class, 1, 1, new Exposed___rshift__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rsub__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rsub__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___rsub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___rsub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyLong.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rtruediv__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___rtruediv__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___rtruediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___rtruediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyLong.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___sub__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___sub__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___sub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___sub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyLong.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___truediv__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___truediv__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___truediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___truediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyLong.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___xor__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___xor__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___xor__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___xor__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___xor__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__xor__", (PyObject)new PyMethodDescr("__xor__", PyLong.class, 1, 1, new Exposed___xor__(null, null)));
        class Exposed___cmp__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___cmp__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___cmp__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                int ret = this.self.long___cmp__(arg0);
                if (ret == -2) {
                    throw Py.TypeError("long.__cmp__(x,y) requires y to be 'long', not a '" + arg0.getType().fastGetName() + "'");
                }
                return Py.newInteger(ret);
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                int ret = self.long___cmp__(arg0);
                if (ret == -2) {
                    throw Py.TypeError("long.__cmp__(x,y) requires y to be 'long', not a '" + arg0.getType().fastGetName() + "'");
                }
                return Py.newInteger(ret);
            }
        }
        dict.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", PyLong.class, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___pow__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pow__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___pow__((PyLong)self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                PyObject ret = this.self.long___pow__(arg0, arg1);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0, PyObject arg1) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___pow__(arg0, arg1);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = this.self.long___pow__(arg0, null);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject inst_call(PyObject gself, PyObject arg0) {
                PyLong self = (PyLong)gself;
                PyObject ret = self.long___pow__(arg0, null);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyLong.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed___repr__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___repr__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___repr__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.long_toString());
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return new PyString(self.long_toString());
            }
        }
        dict.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyLong.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___str__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___str__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.long_toString());
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return new PyString(self.long_toString());
            }
        }
        dict.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyLong.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___hash__(PyLong self, PyBuiltinFunction.Info info) {
                super(info);
                this.self = self;
            }

            public PyBuiltinFunction makeBound(PyObject self) {
                return new Exposed___hash__((PyLong)self, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(this.self.long_hashCode());
            }

            public PyObject inst_call(PyObject gself) {
                PyLong self = (PyLong)gself;
                return Py.newInteger(self.long_hashCode());
            }
        }
        dict.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyLong.class, 0, 0, new Exposed___hash__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyLong.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                return PyLong.long_new(this, init, subtype, args, keywords);
            }
        });
    }

    public static PyObject long_new(PyObject new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser(exposed_name, args, keywords, new String[]{"x", "base"}, 0);
        PyObject x = ap.getPyObject(0, null);
        int base = ap.getInt(1, -909);
        if (x == null) {
            return Py.Zero;
        }
        Object o = x.__tojava__(BigInteger.class);
        if (o != Py.NoConversion) {
            return new PyLong((BigInteger)o);
        }
        if (base == -909) {
            return x.__long__();
        }
        if (!(x instanceof PyString)) {
            throw Py.TypeError("long: can't convert non-string with explicit base");
        }
        return ((PyString)x).atol(base);
    }

    public PyLong(BigInteger v) {
        this.value = v;
    }

    public PyLong(double v) {
        this(new BigDecimal(v).toBigInteger());
    }

    public PyLong(long v) {
        this(BigInteger.valueOf(v));
    }

    public PyLong(String s) {
        this(new BigInteger(s));
    }

    public String toString() {
        return this.long_toString();
    }

    final String long_toString() {
        return this.value.toString() + "L";
    }

    public int hashCode() {
        return this.long_hashCode();
    }

    final int long_hashCode() {
        return this.value.intValue();
    }

    public boolean __nonzero__() {
        return !this.value.equals(BigInteger.valueOf(0L));
    }

    public double doubleValue() {
        double v = this.value.doubleValue();
        if (v == Double.NEGATIVE_INFINITY || v == Double.POSITIVE_INFINITY) {
            throw Py.OverflowError("long int too long to convert");
        }
        return v;
    }

    private static final double scaledDoubleValue(BigInteger val, int[] exp) {
        double x = 0.0;
        int signum = val.signum();
        byte[] digits = signum >= 0 ? val.toByteArray() : val.negate().toByteArray();
        int count = 8;
        int i = 0;
        if (digits[0] == 0) {
            ++i;
            ++count;
        }
        int n = count = count <= digits.length ? count : digits.length;
        while (i < count) {
            x = x * 256.0 + (double)(digits[i] & 0xFF);
            ++i;
        }
        exp[0] = digits.length - i;
        return (double)signum * x;
    }

    public double scaledDoubleValue(int[] exp) {
        return PyLong.scaledDoubleValue(this.value, exp);
    }

    private long getLong(long min, long max) {
        long v;
        if (this.value.compareTo(maxLong) <= 0 && this.value.compareTo(minLong) >= 0 && (v = this.value.longValue()) >= min && v <= max) {
            return v;
        }
        throw Py.OverflowError("long int too long to convert");
    }

    public Object __tojava__(Class c) {
        try {
            if (c == Byte.TYPE || c == Byte.class) {
                return new Byte((byte)this.getLong(-128L, 127L));
            }
            if (c == Short.TYPE || c == Short.class) {
                return new Short((short)this.getLong(-32768L, 32767L));
            }
            if (c == Integer.TYPE || c == Integer.class) {
                return new Integer((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
            }
            if (c == Long.TYPE || c == Long.class) {
                return new Long(this.getLong(Long.MIN_VALUE, Long.MAX_VALUE));
            }
            if (c == Float.TYPE || c == Double.TYPE || c == Float.class || c == Double.class) {
                return this.__float__().__tojava__(c);
            }
            if (c == BigInteger.class || c == Number.class || c == Object.class || c == Serializable.class) {
                return this.value;
            }
        }
        catch (PyException e) {
            return Py.NoConversion;
        }
        return super.__tojava__(c);
    }

    public int __cmp__(PyObject other) {
        return this.long___cmp__(other);
    }

    final int long___cmp__(PyObject other) {
        if (!PyLong.canCoerce(other)) {
            return -2;
        }
        return this.value.compareTo(PyLong.coerce(other));
    }

    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyLong) {
            return other;
        }
        if (other instanceof PyInteger) {
            return new PyLong(((PyInteger)other).getValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyLong || other instanceof PyInteger;
    }

    private static final BigInteger coerce(PyObject other) {
        if (other instanceof PyLong) {
            return ((PyLong)other).value;
        }
        if (other instanceof PyInteger) {
            return BigInteger.valueOf(((PyInteger)other).getValue());
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        return this.long___add__(right);
    }

    final PyObject long___add__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.add(PyLong.coerce(right)));
    }

    public PyObject __radd__(PyObject left) {
        return this.long___radd__(left);
    }

    final PyObject long___radd__(PyObject left) {
        return this.__add__(left);
    }

    public PyObject __sub__(PyObject right) {
        return this.long___sub__(right);
    }

    final PyObject long___sub__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.subtract(PyLong.coerce(right)));
    }

    public PyObject __rsub__(PyObject left) {
        return this.long___rsub__(left);
    }

    final PyObject long___rsub__(PyObject left) {
        return new PyLong(PyLong.coerce(left).subtract(this.value));
    }

    public PyObject __mul__(PyObject right) {
        return this.long___mul__(right);
    }

    final PyObject long___mul__(PyObject right) {
        if (right instanceof PySequence) {
            return ((PySequence)right).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.multiply(PyLong.coerce(right)));
    }

    public PyObject __rmul__(PyObject left) {
        return this.long___rmul__(left);
    }

    final PyObject long___rmul__(PyObject left) {
        if (left instanceof PySequence) {
            return ((PySequence)left).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(PyLong.coerce(left).multiply(this.value));
    }

    private BigInteger divide(BigInteger x, BigInteger y) {
        BigInteger zero = BigInteger.valueOf(0L);
        if (y.equals(zero)) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        if (y.compareTo(zero) < 0) {
            if (x.compareTo(zero) > 0) {
                return x.subtract(y).subtract(BigInteger.valueOf(1L)).divide(y);
            }
        } else if (x.compareTo(zero) < 0) {
            return x.subtract(y).add(BigInteger.valueOf(1L)).divide(y);
        }
        return x.divide(y);
    }

    public PyObject __div__(PyObject right) {
        return this.long___div__(right);
    }

    final PyObject long___div__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic long division");
        }
        return new PyLong(this.divide(this.value, PyLong.coerce(right)));
    }

    public PyObject __rdiv__(PyObject left) {
        return this.long___rdiv__(left);
    }

    final PyObject long___rdiv__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic long division");
        }
        return new PyLong(this.divide(PyLong.coerce(left), this.value));
    }

    public PyObject __floordiv__(PyObject right) {
        return this.long___floordiv__(right);
    }

    final PyObject long___floordiv__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.divide(this.value, PyLong.coerce(right)));
    }

    public PyObject __rfloordiv__(PyObject left) {
        return this.long___rfloordiv__(left);
    }

    final PyObject long___rfloordiv__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(this.divide(PyLong.coerce(left), this.value));
    }

    private static final PyFloat true_divide(BigInteger a, BigInteger b) {
        int[] ae = new int[1];
        int[] be = new int[1];
        double ad = PyLong.scaledDoubleValue(a, ae);
        double bd = PyLong.scaledDoubleValue(b, be);
        if (bd == 0.0) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        ad /= bd;
        int aexp = ae[0] - be[0];
        if (aexp > 0xFFFFFFF) {
            throw Py.OverflowError("long/long too large for a float");
        }
        if (aexp < -268435455) {
            return new PyFloat(0.0);
        }
        if (Double.isInfinite(ad *= Math.pow(2.0, aexp * 8))) {
            throw Py.OverflowError("long/long too large for a float");
        }
        return new PyFloat(ad);
    }

    public PyObject __truediv__(PyObject right) {
        return this.long___truediv__(right);
    }

    final PyObject long___truediv__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return PyLong.true_divide(this.value, PyLong.coerce(right));
    }

    public PyObject __rtruediv__(PyObject left) {
        return this.long___rtruediv__(left);
    }

    final PyObject long___rtruediv__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return PyLong.true_divide(PyLong.coerce(left), this.value);
    }

    private BigInteger modulo(BigInteger x, BigInteger y, BigInteger xdivy) {
        return x.subtract(xdivy.multiply(y));
    }

    public PyObject __mod__(PyObject right) {
        return this.long___mod__(right);
    }

    final PyObject long___mod__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        BigInteger rightv = PyLong.coerce(right);
        return new PyLong(this.modulo(this.value, rightv, this.divide(this.value, rightv)));
    }

    public PyObject __rmod__(PyObject left) {
        return this.long___rmod__(left);
    }

    final PyObject long___rmod__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        BigInteger leftv = PyLong.coerce(left);
        return new PyLong(this.modulo(leftv, this.value, this.divide(leftv, this.value)));
    }

    public PyObject __divmod__(PyObject right) {
        return this.long___divmod__(right);
    }

    final PyObject long___divmod__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        BigInteger rightv = PyLong.coerce(right);
        BigInteger xdivy = this.divide(this.value, rightv);
        return new PyTuple(new PyObject[]{new PyLong(xdivy), new PyLong(this.modulo(this.value, rightv, xdivy))});
    }

    public PyObject __rdivmod__(PyObject left) {
        return this.long___rdivmod__(left);
    }

    final PyObject long___rdivmod__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        BigInteger leftv = PyLong.coerce(left);
        BigInteger xdivy = this.divide(leftv, this.value);
        return new PyTuple(new PyObject[]{new PyLong(xdivy), new PyLong(this.modulo(leftv, this.value, xdivy))});
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.long___pow__(right, modulo);
    }

    final PyObject long___pow__(PyObject right, PyObject modulo) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyLong.canCoerce(right)) {
            return null;
        }
        return PyLong._pow(this.value, PyLong.coerce(right), modulo, this, right);
    }

    public PyObject __rpow__(PyObject left) {
        return this.long___rpow__(left);
    }

    final PyObject long___rpow__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return PyLong._pow(PyLong.coerce(left), this.value, null, left, this);
    }

    public static PyObject _pow(BigInteger value, BigInteger y, PyObject modulo, PyObject left, PyObject right) {
        if (y.compareTo(BigInteger.valueOf(0L)) < 0) {
            if (value.compareTo(BigInteger.valueOf(0L)) != 0) {
                return left.__float__().__pow__(right, modulo);
            }
            throw Py.ZeroDivisionError("zero to a negative power");
        }
        if (modulo == null) {
            return new PyLong(value.pow(y.intValue()));
        }
        BigInteger z = PyLong.coerce(modulo);
        int zi = z.intValue();
        if (zi == 0) {
            throw Py.ValueError("pow(x, y, z) with z == 0");
        }
        if (zi == 1 || zi == -1) {
            return new PyLong(0L);
        }
        if (z.compareTo(BigInteger.valueOf(0L)) <= 0) {
            if ((y = value.modPow(y, z.negate())).compareTo(BigInteger.valueOf(0L)) > 0) {
                return new PyLong(z.add(y));
            }
            return new PyLong(y);
        }
        return new PyLong(value.modPow(y, z));
    }

    private static final int coerceInt(PyObject other) {
        if (other instanceof PyLong) {
            return (int)((PyLong)other).getLong(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __lshift__(PyObject right) {
        return this.long___lshift__(right);
    }

    final PyObject long___lshift__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        int rightv = PyLong.coerceInt(right);
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        return new PyLong(this.value.shiftLeft(rightv));
    }

    public PyObject __rshift__(PyObject right) {
        return this.long___rshift__(right);
    }

    final PyObject long___rshift__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        int rightv = PyLong.coerceInt(right);
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        return new PyLong(this.value.shiftRight(rightv));
    }

    public PyObject __and__(PyObject right) {
        return this.long___and__(right);
    }

    final PyObject long___and__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.and(PyLong.coerce(right)));
    }

    public PyObject __rand__(PyObject left) {
        return this.long___rand__(left);
    }

    final PyObject long___rand__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(PyLong.coerce(left).and(this.value));
    }

    public PyObject __xor__(PyObject right) {
        return this.long___xor__(right);
    }

    final PyObject long___xor__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.xor(PyLong.coerce(right)));
    }

    public PyObject __rxor__(PyObject left) {
        return this.long___rxor__(left);
    }

    final PyObject long___rxor__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(PyLong.coerce(left).xor(this.value));
    }

    public PyObject __or__(PyObject right) {
        return this.long___or__(right);
    }

    final PyObject long___or__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.or(PyLong.coerce(right)));
    }

    public PyObject __ror__(PyObject left) {
        return this.long___ror__(left);
    }

    final PyObject long___ror__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(PyLong.coerce(left).or(this.value));
    }

    public PyObject __neg__() {
        return this.long___neg__();
    }

    final PyObject long___neg__() {
        return new PyLong(this.value.negate());
    }

    public PyObject __pos__() {
        return this.long___pos__();
    }

    final PyObject long___pos__() {
        return this;
    }

    public PyObject __abs__() {
        return this.long___abs__();
    }

    final PyObject long___abs__() {
        return new PyLong(this.value.abs());
    }

    public PyObject __invert__() {
        return this.long___invert__();
    }

    final PyObject long___invert__() {
        return new PyLong(this.value.not());
    }

    public PyInteger __int__() {
        return this.long___int__();
    }

    final PyInteger long___int__() {
        return new PyInteger((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public PyLong __long__() {
        return this.long___long__();
    }

    final PyLong long___long__() {
        return this;
    }

    public PyFloat __float__() {
        return this.long___float__();
    }

    final PyFloat long___float__() {
        return new PyFloat(this.doubleValue());
    }

    public PyComplex __complex__() {
        return this.long___complex__();
    }

    final PyComplex long___complex__() {
        return new PyComplex(this.doubleValue(), 0.0);
    }

    public PyString __oct__() {
        return this.long___oct__();
    }

    final PyString long___oct__() {
        String s = this.value.toString(8);
        if (s.startsWith("-")) {
            return new PyString("-0" + s.substring(1, s.length()) + "L");
        }
        if (s.startsWith("0")) {
            return new PyString(s + "L");
        }
        return new PyString("0" + s + "L");
    }

    public PyString __hex__() {
        return this.long___hex__();
    }

    final PyString long___hex__() {
        String s = this.value.toString(16).toUpperCase();
        if (s.startsWith("-")) {
            return new PyString("-0x" + s.substring(1, s.length()) + "L");
        }
        return new PyString("0x" + s + "L");
    }

    public PyString __str__() {
        return Py.newString(this.value.toString());
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }
}

