/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Modifier;
import org.python.core.Py;
import org.python.core.PyInstance;
import org.python.core.PyJavaClass;
import org.python.core.PyObject;
import org.python.core.PyReflectedConstructor;
import org.python.core.PyString;

public class PyJavaInstance
extends PyInstance
implements Externalizable {
    public PyJavaInstance() {
    }

    public PyJavaInstance(PyJavaClass iclass) {
        super(iclass, null);
    }

    public PyJavaInstance(Object proxy) {
        super(PyJavaClass.lookup(proxy.getClass()), null);
        this.javaProxy = proxy;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object o;
        this.javaProxy = o = in.readObject();
        this.instclass = PyJavaClass.lookup(o.getClass());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.javaProxy);
    }

    public void __init__(PyObject[] args, String[] keywords) {
        PyReflectedConstructor init;
        Class pc = this.instclass.proxyClass;
        if (pc != null) {
            int mods = pc.getModifiers();
            if (Modifier.isInterface(mods)) {
                throw Py.TypeError("can't instantiate interface (" + this.instclass.__name__ + ")");
            }
            if (Modifier.isAbstract(mods)) {
                throw Py.TypeError("can't instantiate abstract class (" + this.instclass.__name__ + ")");
            }
        }
        if ((init = ((PyJavaClass)this.instclass).__init__) == null) {
            throw Py.TypeError("no public constructors for " + this.instclass.__name__);
        }
        init.__call__((PyObject)this, args, keywords);
    }

    protected void noField(String name, PyObject value) {
        throw Py.TypeError("can't set arbitrary attribute in java instance: " + name);
    }

    protected void unassignableField(String name, PyObject value) {
        throw Py.TypeError("can't assign to this attribute in java instance: " + name);
    }

    public int hashCode() {
        if (this.javaProxy != null) {
            return this.javaProxy.hashCode();
        }
        return super.hashCode();
    }

    public PyObject _is(PyObject o) {
        if (o instanceof PyJavaInstance) {
            return this.javaProxy == ((PyJavaInstance)o).javaProxy ? Py.One : Py.Zero;
        }
        return Py.Zero;
    }

    public PyObject _isnot(PyObject o) {
        return this._is(o).__not__();
    }

    public int __cmp__(PyObject o) {
        if (!(o instanceof PyJavaInstance)) {
            return -2;
        }
        PyJavaInstance i = (PyJavaInstance)o;
        if (this.javaProxy.equals(i.javaProxy)) {
            return 0;
        }
        return -2;
    }

    public PyString __str__() {
        return new PyString(this.javaProxy.toString());
    }

    public PyString __repr__() {
        return this.__str__();
    }

    public void __delattr__(String attr) {
        throw Py.TypeError("can't delete attr from java instance: " + attr);
    }
}

