/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import org.python.core.AbstractArray;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;

public class PyArray
extends PySequence
implements Cloneable,
ClassDictInit {
    protected Object data;
    protected Class type;
    protected String typecode;
    protected ArrayDelegate delegate;

    private PyArray() {
    }

    public PyArray(PyArray toCopy) {
        this.data = toCopy.delegate.copyArray();
        this.delegate = new ArrayDelegate(this);
        this.type = toCopy.type;
    }

    public PyArray(Class type, Object data) {
        this.type = type;
        this.data = data;
        this.delegate = new ArrayDelegate(this);
    }

    public PyArray(Class type, int n) {
        this(type, Array.newInstance(type, n));
    }

    public static PyArray zeros(int n, char typecode) {
        PyArray array = PyArray.zeros(n, PyArray.char2class(typecode));
        array.typecode = Character.toString(typecode);
        return array;
    }

    public static PyArray zeros(int n, Class ctype) {
        PyArray array = new PyArray(ctype, n);
        array.typecode = ctype.getName();
        return array;
    }

    public static PyArray array(PyObject seq, char typecode) {
        PyArray array = PyArray.array(seq, PyArray.char2class(typecode));
        array.typecode = Character.toString(typecode);
        return array;
    }

    public static PyArray array(PyObject seq, Class ctype) {
        PyArray array = new PyArray(ctype, seq.__len__());
        array.typecode = ctype.getName();
        PyObject iter = seq.__iter__();
        PyObject item = null;
        int i = 0;
        while ((item = iter.__iternext__()) != null) {
            array.set(i, item);
            ++i;
        }
        return array;
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public PyObject __findattr__(String name) {
        if ("typecode".equals(name)) {
            return new PyString(this.getTypecode());
        }
        return super.__findattr__(name);
    }

    public static void classDictInit(PyObject dict) throws PyIgnoreMethodTag {
        PySequence.classDictInit(dict);
        dict.__setitem__("clone", null);
        dict.__setitem__("classDictInit", null);
    }

    public static Class char2class(char type) throws PyIgnoreMethodTag {
        switch (type) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("typecode must be in [zcbhilfd]");
    }

    public Object __tojava__(Class c) {
        if (c == Object.class || c.isArray() && c.getComponentType().isAssignableFrom(this.type)) {
            return this.data;
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public int __len__() {
        return this.delegate.getSize();
    }

    protected PyObject get(int i) {
        return Py.java2py(Array.get(this.data, i));
    }

    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyArray.sliceLength(start, stop, step);
        PyArray ret = new PyArray(this.type, n);
        if (step == 1) {
            System.arraycopy(this.data, start, ret.data, 0, n);
            return ret;
        }
        int i = start;
        for (int j = 0; j < n; ++j) {
            Array.set(ret.data, j, Array.get(this.data, i));
            i += step;
        }
        return ret;
    }

    protected PyObject repeat(int count) {
        throw Py.TypeError("can't apply '*' to arrays");
    }

    protected void del(int i) {
        this.delegate.remove(i);
    }

    public PyObject count(PyObject value) {
        int iCount = 0;
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!value.equals(Py.java2py(Array.get(this.data, i)))) continue;
            ++iCount;
        }
        return new PyInteger(iCount);
    }

    private int indexInternal(PyObject value) {
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!value.equals(Py.java2py(Array.get(this.data, i)))) continue;
            return i;
        }
        return -1;
    }

    public PyObject index(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            return new PyInteger(index);
        }
        throw Py.ValueError("array.index(" + value + "): " + value + " not found in array");
    }

    public void remove(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            this.delegate.remove(index);
            return;
        }
        throw Py.ValueError("array.remove(" + value + "): " + value + " not found in array");
    }

    public PyObject __add__(PyObject other) {
        PyArray otherArr = null;
        if (!(other instanceof PyArray)) {
            throw Py.TypeError("can only append another array to an array");
        }
        otherArr = (PyArray)other;
        if (!otherArr.type.equals(this.type)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + otherArr.type);
        }
        PyArray ret = new PyArray(this);
        ret.delegate.appendArray(otherArr.delegate.copyArray());
        return ret;
    }

    public void append(PyObject value) {
        Object o = Py.tojava(value, this.type);
        int afterLast = this.delegate.getSize();
        this.delegate.makeInsertSpace(afterLast);
        Array.set(this.data, afterLast, o);
    }

    public void extend(PyObject array) {
        PyArray otherArr = null;
        if (!(array instanceof PyArray)) {
            throw Py.TypeError("can only extend an array witn another array");
        }
        otherArr = (PyArray)array;
        if (!otherArr.type.equals(this.type)) {
            throw Py.TypeError("can only extend with an array of the same type, expected '" + this.type + ", found " + otherArr.type);
        }
        this.delegate.appendArray(otherArr.delegate.copyArray());
    }

    public void insert(int index, PyObject value) {
        this.delegate.makeInsertSpace(index);
        Array.set(this.data, index, Py.tojava(value, this.type));
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int index) {
        index = index < 0 ? this.delegate.getSize() + index : index;
        PyObject ret = Py.java2py(Array.get(this.data, index));
        this.delegate.remove(index);
        return ret;
    }

    protected void delRange(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        if (step == 1) {
            this.delegate.remove(start, stop);
        } else {
            int n = PyArray.sliceLength(start, stop, step);
            int i = start;
            for (int j = 0; j < n; ++j) {
                this.delegate.remove(i);
                i += step;
            }
        }
    }

    protected void set(int i, PyObject value) {
        Object o = Py.tojava(value, this.type);
        Array.set(this.data, i, o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (this.type == Character.TYPE && value instanceof PyString) {
            char[] chars = null;
            if (step != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            chars = value.toString().toCharArray();
            int insertSpace = chars.length - (stop - start);
            if (insertSpace > 0) {
                this.delegate.makeInsertSpace(start, insertSpace);
            } else if (insertSpace < 0) {
                this.delegate.remove(start, -insertSpace + start - 1);
            }
            this.delegate.replaceSubArray(chars, start);
            return;
        }
        if (value instanceof PyString && this.type == Byte.TYPE) {
            byte[] chars = value.toString().getBytes();
            if (chars.length != stop - start || step != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(chars, 0, this.data, start, chars.length);
            return;
        }
        if (!(value instanceof PyArray)) return;
        PyArray array = (PyArray)value;
        int insertSpace = array.delegate.getSize() - (stop - start);
        Object arrayCopy = array.delegate.copyArray();
        if (insertSpace > 0) {
            this.delegate.makeInsertSpace(start, insertSpace);
        } else if (insertSpace < 0) {
            this.delegate.remove(start, -insertSpace + start - 1);
        }
        try {
            this.delegate.replaceSubArray(arrayCopy, start);
            return;
        }
        catch (IllegalArgumentException e) {
            throw Py.TypeError("Slice typecode '" + array.typecode + "' is not compatible with this array (typecode '" + this.typecode + "')");
        }
    }

    public void reverse() {
        Object array = Array.newInstance(this.type, Array.getLength(this.data));
        int lastIndex = this.delegate.getSize() - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            Array.set(array, lastIndex - i, Array.get(this.data, i));
        }
        this.data = array;
    }

    public String tostring() {
        if (this.type == Character.TYPE) {
            return new String((char[])this.data);
        }
        if (this.type == Byte.TYPE) {
            return new String((byte[])this.data, 0);
        }
        throw Py.TypeError("can only convert arrays of byte and char to string");
    }

    public Object clone() {
        return new PyArray(this);
    }

    public PyString __repr__() {
        StringBuffer buf = new StringBuffer("array([");
        for (int i = 0; i < this.__len__() - 1; ++i) {
            buf.append(this.get(i).__repr__().toString());
            buf.append(", ");
        }
        if (this.__len__() > 0) {
            buf.append(this.get(this.__len__() - 1).__repr__().toString());
        }
        buf.append("], ");
        buf.append(this.type.getName());
        buf.append(")");
        return new PyString(buf.toString());
    }

    public String getTypecode() throws PyIgnoreMethodTag {
        return this.typecode;
    }

    private class ArrayDelegate
    extends AbstractArray {
        final PyArray pyArray;

        private ArrayDelegate(PyArray pyArray2) {
            super(pyArray2.data == null ? 0 : Array.getLength(pyArray2.data));
            this.pyArray = pyArray2;
        }

        protected Object getArray() {
            return this.pyArray.data;
        }

        protected void setArray(Object array) {
            this.pyArray.data = array;
        }

        protected void makeInsertSpace(int index) {
            super.makeInsertSpace(index, 1);
        }

        protected void makeInsertSpace(int index, int length) {
            super.makeInsertSpace(index, length);
        }

        public void remove(int index) {
            super.remove(index);
        }
    }
}

