/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.python.compiler.APIVersion;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Constant;
import org.python.compiler.Future;
import org.python.compiler.Label;
import org.python.compiler.PyCodeConstant;
import org.python.compiler.PyComplexConstant;
import org.python.compiler.PyFloatConstant;
import org.python.compiler.PyIntegerConstant;
import org.python.compiler.PyLongConstant;
import org.python.compiler.PyStringConstant;
import org.python.compiler.ScopeInfo;
import org.python.compiler.ScopesCompiler;
import org.python.compiler.SourceFile;
import org.python.compiler.SymInfo;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Suite;
import org.python.parser.ast.modType;

public class Module
implements ClassConstants,
CompilationContext {
    ClassFile classfile;
    Constant filename;
    String sfilename;
    public Constant mainCode;
    public boolean linenumbers;
    public boolean setFile = true;
    Future futures;
    Hashtable scopes;
    Hashtable constants;
    Vector codes;
    private static final String[] emptyStringAr = new String[0];
    private int to_cell;

    public Module(String name, String filename, boolean linenumbers) {
        this.linenumbers = linenumbers;
        this.classfile = new ClassFile(name, "org/python/core/PyFunctionTable", 33);
        this.constants = new Hashtable();
        this.sfilename = filename;
        this.filename = filename != null ? this.PyString(filename) : null;
        this.codes = new Vector();
        this.futures = new Future();
        this.scopes = new Hashtable();
    }

    public Module(String name) {
        this(name, name + ".py", true);
    }

    private Constant findConstant(Constant c) {
        Constant ret = (Constant)this.constants.get(c);
        if (ret != null) {
            return ret;
        }
        ret = c;
        c.module = this;
        c.name = "_" + this.constants.size();
        this.constants.put(ret, ret);
        return ret;
    }

    public Constant PyInteger(int value) {
        return this.findConstant(new PyIntegerConstant(value));
    }

    public Constant PyFloat(double value) {
        return this.findConstant(new PyFloatConstant(value));
    }

    public Constant PyComplex(double value) {
        return this.findConstant(new PyComplexConstant(value));
    }

    public Constant PyString(String value) {
        return this.findConstant(new PyStringConstant(value));
    }

    public Constant PyLong(String value) {
        return this.findConstant(new PyLongConstant(value));
    }

    private boolean isJavaIdentifier(String s) {
        char[] chars = s.toCharArray();
        if (chars.length == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return true;
    }

    private String[] toNameAr(Vector names, boolean nullok) {
        int sz = names.size();
        if (sz == 0 && nullok) {
            return null;
        }
        Object[] nameArray = new String[sz];
        names.copyInto(nameArray);
        return nameArray;
    }

    public PyCodeConstant PyCode(modType tree, String name, boolean fast_locals, String className, boolean classBody, boolean printResults, int firstlineno, ScopeInfo scope) throws Exception {
        return this.PyCode(tree, name, fast_locals, className, classBody, printResults, firstlineno, scope, null);
    }

    public PyCodeConstant PyCode(modType tree, String name, boolean fast_locals, String className, boolean classBody, boolean printResults, int firstlineno, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        int nparamcell;
        ArgListCompiler ac;
        PyCodeConstant code = new PyCodeConstant();
        ArgListCompiler argListCompiler = ac = scope != null ? scope.ac : null;
        if (ac != null) {
            code.arglist = ac.arglist;
            code.keywordlist = ac.keywordlist;
            code.argcount = ac.names.size();
        }
        code.co_name = name;
        code.co_firstlineno = firstlineno;
        code.id = this.codes.size();
        code.fname = this.isJavaIdentifier(name) ? name + "$" + code.id : "f$" + code.id;
        this.codes.addElement(code);
        Code c = this.classfile.addMethod(code.fname, "(Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;", 1);
        CodeCompiler compiler = new CodeCompiler(this, printResults);
        Label genswitch = c.getLabel();
        if (scope.generator) {
            c.goto_(genswitch);
        }
        Label start = c.getLabel();
        start.setPosition();
        if (ac != null && ac.init_code.size() > 0) {
            ac.appendInitCode((Suite)tree);
        }
        if (scope != null && (nparamcell = scope.jy_paramcells.size()) > 0) {
            if (this.to_cell == 0) {
                this.to_cell = this.classfile.pool.Methodref("org/python/core/PyFrame", "to_cell", "(II)V");
            }
            Hashtable tbl = scope.tbl;
            Vector paramcells = scope.jy_paramcells;
            for (int i = 0; i < nparamcell; ++i) {
                c.aload(1);
                SymInfo syminf = (SymInfo)tbl.get(paramcells.elementAt(i));
                c.iconst(syminf.locals_index);
                c.iconst(syminf.env_index);
                c.invokevirtual(this.to_cell);
            }
        }
        compiler.parse(tree, c, fast_locals, className, classBody, scope, cflags);
        if (scope.generator) {
            genswitch.setPosition();
            c.aload(1);
            if (compiler.f_lasti == 0) {
                compiler.f_lasti = c.pool.Fieldref("org/python/core/PyFrame", "f_lasti", "I");
            }
            c.getfield(compiler.f_lasti);
            Label[] yields = new Label[compiler.yields.size() + 1];
            yields[0] = start;
            for (int i = 1; i < yields.length; ++i) {
                yields[i] = (Label)compiler.yields.elementAt(i - 1);
            }
            c.tableswitch(start, 0, yields);
        }
        if (!classBody) {
            code.names = this.toNameAr(compiler.names, false);
        }
        if (scope != null) {
            code.cellvars = this.toNameAr(scope.cellvars, true);
            code.freevars = this.toNameAr(scope.freevars, true);
            code.jy_npurecell = scope.jy_npurecell;
        }
        if (compiler.optimizeGlobals) {
            code.moreflags |= 1;
        }
        if (compiler.my_scope.generator) {
            code.moreflags |= 0x20;
        }
        if (cflags != null && cflags.generator_allowed) {
            code.moreflags |= 0x1000;
        }
        code.module = this;
        code.name = code.fname;
        return code;
    }

    public void addInit() throws IOException {
        Code c = this.classfile.addMethod("<init>", "()V", 1);
        c.aload(0);
        c.invokespecial(c.pool.Methodref("org/python/core/PyFunctionTable", "<init>", "()V"));
        c.return_();
    }

    public void addRunnable() throws IOException {
        Code c = this.classfile.addMethod("getMain", "()Lorg/python/core/PyCode;", 1);
        this.mainCode.get(c);
        c.areturn();
    }

    public void addMain() throws IOException {
        Code c = this.classfile.addMethod("main", "(Ljava/lang/String;)V", 9);
        int mref_self = c.pool.Fieldref(this.classfile.name, "self", "L" + this.classfile.name + ";");
        c.getstatic(mref_self);
        c.aload(0);
        c.invokestatic(c.pool.Methodref("org/python/core/Py", "do_main", "(Lorg/python/core/PyRunnable;[Ljava/lang/String;)V"));
        c.return_();
    }

    public void addConstants() throws IOException {
        Code c = this.classfile.addMethod("<clinit>", "()V", 8);
        this.classfile.addField("self", "L" + this.classfile.name + ";", 24);
        c.new_(c.pool.Class(this.classfile.name));
        c.dup();
        c.invokespecial(c.pool.Methodref(this.classfile.name, "<init>", "()V"));
        c.putstatic(c.pool.Fieldref(this.classfile.name, "self", "L" + this.classfile.name + ";"));
        Enumeration e = this.constants.elements();
        while (e.hasMoreElements()) {
            Constant constant = (Constant)e.nextElement();
            constant.put(c);
        }
        for (int i = 0; i < this.codes.size(); ++i) {
            PyCodeConstant pyc = (PyCodeConstant)this.codes.elementAt(i);
            pyc.put(c);
        }
        c.return_();
    }

    public void addFunctions() throws IOException {
        int i;
        Code code = this.classfile.addMethod("call_function", "(ILorg/python/core/PyFrame;)Lorg/python/core/PyObject;", 1);
        Label def = code.getLabel();
        Label[] labels = new Label[this.codes.size()];
        for (i = 0; i < labels.length; ++i) {
            labels[i] = code.getLabel();
        }
        code.iload(1);
        code.tableswitch(def, 0, labels);
        for (i = 0; i < labels.length; ++i) {
            labels[i].setPosition();
            code.aload(0);
            code.aload(2);
            code.invokevirtual(this.classfile.name, ((PyCodeConstant)this.codes.elementAt((int)i)).fname, "(Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
            code.areturn();
        }
        def.setPosition();
        code.aconst_null();
        code.areturn();
    }

    public void write(OutputStream stream) throws IOException {
        this.addInit();
        this.addRunnable();
        this.addConstants();
        this.addFunctions();
        this.classfile.addInterface("org/python/core/PyRunnable");
        if (this.sfilename != null) {
            this.classfile.addAttribute(new SourceFile(this.sfilename, this.classfile.pool));
        }
        this.classfile.addAttribute(new APIVersion(12, this.classfile.pool));
        this.classfile.write(stream);
    }

    public Future getFutures() {
        return this.futures;
    }

    public String getFilename() {
        return this.sfilename;
    }

    public ScopeInfo getScopeInfo(SimpleNode node) {
        return (ScopeInfo)this.scopes.get(node);
    }

    public void error(String msg, boolean err, SimpleNode node) throws Exception {
        block3: {
            if (!err) {
                try {
                    Py.warning(Py.SyntaxWarning, msg, this.sfilename != null ? this.sfilename : "?", node.beginLine, null, Py.None);
                    return;
                }
                catch (PyException e) {
                    if (Py.matchException(e, Py.SyntaxWarning)) break block3;
                    throw e;
                }
            }
        }
        throw new ParseException(msg, node);
    }

    public static void compile(modType node, OutputStream ostream, String name, String filename, boolean linenumbers, boolean printResults, boolean setFile, CompilerFlags cflags) throws Exception {
        Module module = new Module(name, filename, linenumbers);
        module.setFile = setFile;
        module.futures.preprocessFutures(node, cflags);
        new ScopesCompiler(module, module.scopes).parse(node);
        PyCodeConstant main = module.PyCode(node, "?", false, null, false, printResults, 0, module.getScopeInfo(node), cflags);
        module.mainCode = main;
        module.write(ostream);
    }
}

