/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.loginserver;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.Base64;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.lib.Log;
import net.sf.l2j.loginserver.HackingException;

public class Logins {
    private static final String SHA = "SHA";
    private static final String UTF_8 = "UTF-8";
    private static Logger _log = Logger.getLogger(Logins.class.getName());
    private HashMap<String, byte[]> _logPass = new HashMap();
    private HashMap<String, Integer> _hackProtection = new HashMap();
    private HashMap<String, String> _lastPassword = new HashMap();
    private boolean _autoCreate;

    public Logins(boolean autoCreate) {
        this._autoCreate = autoCreate;
        _log.config("Automatically creating new accounts: " + this._autoCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginValid(String user2, String password, InetAddress address) throws HackingException {
        boolean ok = false;
        Integer failedConnects = this._hackProtection.get(address.getHostAddress());
        String lastPassword = this._lastPassword.get(address.getHostAddress());
        Log.add("'" + user2 + "' " + address.getHostAddress(), "logins_ip");
        if (failedConnects != null && failedConnects > Config.LOGIN_TRY_BEFORE_BAN) {
            _log.warning("hacking detected from ip:" + address.getHostAddress() + " .. adding IP to banlist");
            Integer n = failedConnects;
            Integer n2 = failedConnects = Integer.valueOf(failedConnects + 1);
            throw new HackingException(address.getHostAddress(), failedConnects);
        }
        Connection con = null;
        try {
            MessageDigest md = MessageDigest.getInstance(SHA);
            byte[] raw = password.getBytes(UTF_8);
            byte[] hash = md.digest(raw);
            byte[] expected = null;
            int busy = L2DatabaseFactory.getInstance().getBusyConnectionCount();
            int idle = L2DatabaseFactory.getInstance().getIdleConnectionCount();
            _log.info("DB connections busy:" + busy + " idle:" + idle);
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT password FROM accounts WHERE login=?");
            statement.setString(1, user2);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                expected = Base64.decode(rset.getString(1));
                if (Config.DEBUG) {
                    _log.fine("account exists");
                }
            }
            rset.close();
            statement.close();
            if (expected == null) {
                if (this._autoCreate) {
                    statement = con.prepareStatement("INSERT INTO accounts (login,password,lastactive,access_level,lastIP) values(?,?,?,?,?)");
                    statement.setString(1, user2);
                    statement.setString(2, Base64.encodeBytes(hash));
                    statement.setLong(3, System.currentTimeMillis());
                    statement.setInt(4, 0);
                    statement.setString(5, address.getHostAddress());
                    statement.execute();
                    statement.close();
                    this._logPass.put(user2, hash);
                    _log.info("created new account for " + user2);
                    boolean bl = true;
                    return bl;
                }
                _log.warning("account missing for user " + user2);
                boolean bl = false;
                return bl;
            }
            ok = true;
            for (int i = 0; i < expected.length; ++i) {
                if (hash[i] == expected[i]) continue;
                ok = false;
                break;
            }
            if (ok) {
                statement = con.prepareStatement("UPDATE accounts SET lastactive=?, lastIP=? WHERE login=?");
                statement.setLong(1, System.currentTimeMillis());
                statement.setString(2, address.getHostAddress());
                statement.setString(3, user2);
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.warning("could not check password:" + e);
            ok = false;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        if (!ok) {
            int failedCount = 1;
            if (failedConnects != null) {
                failedCount = failedConnects + 1;
            }
            if (password != lastPassword) {
                this._hackProtection.put(address.getHostAddress(), new Integer(failedCount));
                this._lastPassword.put(address.getHostAddress(), password);
            }
        } else {
            this._hackProtection.remove(address.getHostAddress());
            this._lastPassword.remove(address.getHostAddress());
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginBanned(String user2) {
        boolean ok = false;
        Connection con = null;
        try {
            int accessLevel;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT access_level FROM accounts WHERE login=?");
            statement.setString(1, user2);
            ResultSet rset = statement.executeQuery();
            if (rset.next() && (accessLevel = rset.getInt(1)) < 0) {
                ok = true;
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("could not check ban state:" + e);
            ok = false;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return ok;
    }
}

