/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.loginserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.loginserver.ClientThread;
import net.sf.l2j.loginserver.GameServerListener;
import net.sf.l2j.loginserver.LoginController;
import net.sf.l2j.loginserver.Logins;

public class LoginServer
extends Thread {
    private LoginController loginController;
    private ServerSocket clientServerSocket;
    private Logins loginManager;
    private InetAddress clientListeningIP;
    private int clientListeningPort;
    private int clientGameServerPort;
    private String _externalHostname;
    private String _internalHostname;
    private boolean _forwardLocalClient;
    static Logger _log = Logger.getLogger(LoginServer.class.getName());

    public static void main(String[] args) throws IOException {
        LoginServer server = new LoginServer("Stand Alone LoginServer.");
        _log.config("Stand Alone LoginServer Listening on port " + Config.PORT_LOGIN);
        server.start();
    }

    public void close() {
        this.interrupt();
        try {
            this.clientServerSocket.close();
        }
        catch (IOException e) {
            _log.log(Level.INFO, "", e);
        }
    }

    public void run() {
        while (true) {
            try {
                do {
                    String connectedIp;
                    if (Config.DEBUG) {
                        _log.fine("waiting for client connection...");
                    }
                    Socket connection = this.clientServerSocket.accept();
                    if (Config.DEBUG) {
                        _log.fine("connection from " + connection.getInetAddress());
                    }
                    if ((connectedIp = connection.getInetAddress().getHostAddress()).startsWith("192.168.") || connectedIp.startsWith("10.") || connectedIp.startsWith("172.16.") || connectedIp.startsWith("127.0.0.1")) {
                        if (Config.DEBUG) {
                            _log.fine("using internal ip as server ip " + this._internalHostname);
                        }
                        new ClientThread(connection, this.loginManager, this._internalHostname, this.clientGameServerPort);
                        continue;
                    }
                    if (Config.DEBUG) {
                        _log.fine("using external ip as server ip " + this._externalHostname);
                    }
                    new ClientThread(connection, this.loginManager, this._externalHostname, this.clientGameServerPort);
                } while (!this.isInterrupted());
                try {
                    this.clientServerSocket.close();
                }
                catch (IOException io) {
                    _log.log(Level.INFO, "", io);
                }
            }
            catch (IOException e) {
                if (!this.isInterrupted()) continue;
                try {
                    this.clientServerSocket.close();
                }
                catch (IOException io) {
                    _log.log(Level.INFO, "", io);
                }
            }
            break;
        }
    }

    public LoginServer(String threadName) {
        super(threadName);
        this.clientListeningPort = Config.PORT_LOGIN;
        new GameServerListener().start();
    }

    public LoginServer() throws IOException {
        super("LoginServer");
        Properties serverSettings = new Properties();
        InputStream is = this.getClass().getResourceAsStream("/config/server.properties");
        serverSettings.load(is);
        is.close();
        String loginIp = serverSettings.getProperty("LoginserverHostname");
        this._externalHostname = serverSettings.getProperty("ExternalHostname");
        if (this._externalHostname == null) {
            this._externalHostname = "localhost";
        }
        this._internalHostname = serverSettings.getProperty("InternalHostname");
        if (this._internalHostname == null) {
            this._internalHostname = "localhost";
        }
        String createAccounts = serverSettings.getProperty("AutoCreateAccounts");
        if (!"*".equals(loginIp)) {
            this.clientListeningIP = InetAddress.getByName(loginIp);
            _log.config("LoginServer listening on IP:" + this.clientListeningIP.getHostAddress() + " Port " + Config.PORT_LOGIN);
            this.clientServerSocket = new ServerSocket(Config.PORT_LOGIN, 50, this.clientListeningIP);
        } else {
            _log.config("LoginServer listening on all available IPs on Port " + Config.PORT_LOGIN);
            this.clientServerSocket = new ServerSocket(Config.PORT_LOGIN);
        }
        _log.config("Hostname for external connections is: " + this._externalHostname);
        _log.config("Hostname for internal connections is: " + this._internalHostname);
        this.loginManager = new Logins(Boolean.valueOf(createAccounts));
        this.clientGameServerPort = Config.PORT_GAME;
        try {
            InputStream bannedFile = this.getClass().getResourceAsStream("/banned_ip.cfg");
            if (bannedFile != null) {
                int count = 0;
                InputStreamReader reader = new InputStreamReader(bannedFile);
                LineNumberReader lnr = new LineNumberReader(reader);
                String line = null;
                while ((line = lnr.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    ++count;
                    ClientThread.addBannedIP(line);
                }
                _log.info(count + " banned IPs defined");
            } else {
                _log.info("banned_ip.cfg not found");
            }
        }
        catch (Exception e) {
            _log.warning("error while reading banned file:" + e);
        }
    }
}

